;! " Ship "
;? " Scale: "=SML_Scale
;? " Heading [HDG]: "=SML_Heading
;? " Color1: "=SML_Colora
;? " Color2: "=SML_Colorb
;? " Color3: "=SML_Colorc
;? " Scenery density required to show on (0-4): "=SML_Comp


MACRO _Ship1

Area( SML_Lat, SML_Lon, 22 Km, ObjEnd )
		GoIfOut( ObjEnd, 0x0346, SML_Comp,  4  ) 
    PerspectiveCall( Pcall )
    ShadowCall( Scall )
    Jump( ObjEnd )

Pcall:
    Perspective

Scall:    
		ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    PointsList( 0,  39 )
        Point(      0,    0,     0     ) ; 0
        Point(      0,    0,    16     ) ; 1
        Point(      5,    0,     8     ) ; 2
        Point(      4,    0,    -6     ) ; 3
        Point(      5,    0,   -20     ) ; 4
        Point(     -5,    0,   -20     ) ; 5
        Point(     -4,    0,    -6     ) ; 6
        Point(     -5,    0,     8     ) ; 7
        Point(      0,    2,    20     ) ; 8
        Point(     -7,    2,     8     ) ; 9
        Point(     -7,    2,   -20     ) ; 10
        Point(      7,    2,   -20     ) ; 11
        Point(      7,    2,     8     ) ; 12
        Point(     -4,    2,     8     ) ; 13
        Point(     -4,    2,    -6     ) ; 14
        Point(      4,    2,    -6     ) ; 15
        Point(      4,    2,     8     ) ; 16
        Point(     -4,    4,     8     ) ; 17
        Point(     -4,    4,    -6     ) ; 18
        Point(      4,    4,    -6     ) ; 19
        Point(      4,    4,     8     ) ; 20
        Point(      4,    2,   -20     ) ; 21
        Point(     -4,    2,   -20     ) ; 22
        Point(     -3,    4,     7     ) ; 23
        Point(     -3,    4,    -1     ) ; 24
        Point(      3,    4,    -1     ) ; 25
        Point(      3,    4,     7     ) ; 26
        Point(     -3,    5,     7     ) ; 27
        Point(     -3,    5,    -1     ) ; 28
        Point(      3,    5,    -1     ) ; 29
        Point(      3,    5,     7     ) ; 30
        Point(     -2,    5,     6     ) ; 31
        Point(     -2,    9,     6     ) ; 32
        Point(      2,    5,     6     ) ; 33
        Point(      2,    8,     6     ) ; 34
        Point(      0,    2,   -20     ) ; 35
        Point(      0,    5,   -22     ) ; 36
        Point(     -2,    5,     0     ) ; 37
        Point(      2,    5,     0     ) ; 38
								  								  
    Call( Dessin )
    Call( Cabine )
    Call( Roof )
    Call( Pavillon )
    Call( Rampe )
    Return


Dessin:
    SurfaceColor( ColorA )
    		Polygon_4(  1,  8,  9,  7 ) ;flanc avG
    		Polygon_4(  9, 10,  5,  7 ) ;flanc G
    		Polygon_4(  2,  4, 11, 12 ) ;flanc D
    		Polygon_4(  1,  2, 12,  8 ) ;flanc avD
    		Polygon_4(  4,  5, 10, 11 )  ;ar

    SurfaceColor( ColorB )
    		Polygon_3(  8,  9, 12 ) ;pont av
    		Polygon_3(  9, 10, 22, 13 ) ;pont G
    		Polygon_3( 11, 12, 16, 21 ) ;pont D
    
    Texture( "airpt006", "oav" )
		AdjustTexture
		TexturePolygon( 4 )
				TexturePt(	21,  0, 198 )
				TexturePt(	22,  0, 239	)
				TexturePt(	14, 50, 239	)
				TexturePt(	15, 50, 198	)
    
    SurfaceColor( ColorC )
    		Polygon_4(  16, 20, 17, 13 ) ;av cabine
    		Polygon_4(  18, 19, 15, 14 ) ;ar cabine
    Return                

Cabine:
    GoIfNot( Jour, 0x28C, 6 )

Night:
  	;flancs cabine de nuit
		RepeatBitmap
	Inst_7D
	TexPoly( a  
		13  0 240
		17  0 247
		18 51 247
		14 51 240
		)
	Inst_7D
	TexPoly( a
		16  0 240
		20  0 247
		19 51 247
		15 51 240
		)
	Return

    :jour
	;flancs cabine de jour
	RepeatBitmap( 0 0 0 )
	Inst_7D
	TexPoly( a
		13  0 248
		17  0 255
		18 51 255
		14 51 248
		)
	Inst_7D
	TexPoly( a
		16  0 248
		20  0 255
		19 51 255
		15 51 248
		)
	Return


    
:roof
	SurfaceColor( %8 F0 )
	Poly( a 17 18 19 20 ) ;toit cabine

	RepeatBitmap( 0 0 0 )
	Inst_7D
	TexPoly( a
	    23 0 190
	    27 0 196
	    28 26 196
	    24 26 190
	    )
	Inst_7D
	TexPoly( a
	    24 0 190
	    28 0 196
	    29 26 196  
	    25 26 190  
	    )
	Inst_7D
	TexPoly( a
	    25 0 190
	    29 0 196
	    30 26 196  
	    26 26 190  
	    )
	Inst_7D
	TexPoly( a
	    26 0 190
	    30 0 196
	    27 26 196  
	    23 26 190  
	    )
	Return


:pavillon    
    SurfaceColor( %8 F0 )
    Poly( a 27 28 29 30 ) ;roof toit

    ;antennes et pavillon
    LineColor( 04 F0 )
    MoveToPt( 31 )
    DrawToPt( 32 )
    MoveToPt( 33 )
    DrawToPt( 34 )
    MoveToPt( 35 )
    DrawToPt( 36 )

   ;dessin toit
    LineColor( 0B F0 )  
    MoveToPt( 37 )
    DrawToPt( 31 33 38 )
    
    Return
    
:rampe
    IfVarAnd( :non 28C 6 )
	; this is executed only during dusk and night ..
	; environ 1 ampoule tous les mtres
	LineColor( 14 F0 )
	DotLine(  -2 9 6     0  2  20   15  )
	DotLine(  -2 9 6     0  5 -22   30  ) 
	DotLine(  2 9 6     0  2  20   15  ) 
	DotLine(  2 9 6     0  5 -22   30  ) 
	Return

    :non
	Return
    
EndA

