;! " Fuel-pomp building "
;? " Heading [HDG] "=SML_Heading
;? " Smooth texture (0-1) "=SML_Smooth
; converted by A. Antonini (with permission)

MACRO _Pompes
Local ObjEnd, Pcall1, Scall1, ObjReturn, nocrash, Dwg, loin, pres

Area( SML_Lat, SML_Lon, 22 km, ObjEnd )
    PerspectiveCall( Pcall1 )
    ShadowCall( Scall1  )
    Jump( ObjEnd )

Pcall1:
    Perspective

Scall1:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    _FS5SCALE = 8
    GoIfOutCube( nocrash,  -70,  70,   0,  20,   -30,  30 )
    SetVar( Crash_Flag, 14 )

nocrash:
    Rotate( Dwg, 0, 0, SML_Heading  )

ObjReturn:
    Return


Dwg:
    PointsList( 0, 12 )
    Point(     -50,      0,      -10 )    ;0
    Point(     -50,      0,       10 )    ;1
    Point(      50,      0,       10 )    ;2
    Point(      50,      0,      -10 )    ;3
    Point(     -50,     20,      -10 )    ;4
    Point(     -50,     20,       10 )    ;5
    Point(      50,     20,       10 )    ;6
    Point(      50,     20,      -10 )    ;7
    Point(     -70,      0,      -30 )    ;8
    Point(     -70,      0,       30 )    ;9
    Point(      70,      0,       30 )    ;10
    Point(      70,      0,      -30 )    ;11
  

    SurfaceColor(  LightGrey )   
    Polygon_4(  8,  9, 10, 11 )

    SurfaceColor(  White )   
    Polygon_4(  4,  5,  6,  7 )

    SurfaceColor(  0x30  )   
    Polygon_4(  0,  1,  5,  4 )
    Polygon_4(  2,  3,  7,  6 )
  
    GoIfOutCube( loin,  -1200, 1200, -1200, 1200, -1200, 1200 )

    Texture( "airpt003", "oav" )

    If (Sml_Smooth == 1)
        TextureSmoothOn
    Else
        ; reset smoothing if needed
        Db 0x81, 0x00, 0x00, 0x00 
    EndIf

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 2,   0, 230 )
        TexturePt( 6,   0, 255 )
        TexturePt( 5,  77, 255 )
        TexturePt( 1,  77, 230 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 0,   0, 230 )
        TexturePt( 4,   0, 255 )
        TexturePt( 7,  77, 255 )
        TexturePt( 3,  77, 230 )
    If (Sml_Smooth == 1)
        TextureSmoothOff
    EndIf    
    Return

loin:
    SurfaceColor(  White  )   
    Polygon_4(  2,  6,  5,  1 )
    Polygon_4(  0,  4,  7,  3 )
    Return


ObjEnd:
    ENDMACRO
