;! " Type-1 LightHouse "
;? " Scenery density required to show on (1-4): "=SML_Comp
;? " Color 1: "=SML_Color1
;? " Color 2: "=SML_Color2
; converted by A. Antonini, with permission fro Airport author

MACRO _Phare1
Local ObjEnd, ObjReturn, NoCrash, Far, Pcall, Scall, ColorA, ColorB, Ftest,
      Lamp, EndObj, PmAb, Raf, ReturnObj, Ctest

ColorA = 0x02
ColorB = 0x03

If ( SML_Color1 == 0 )
    ColorA = 0x00
EndIf
If ( SML_Color1 == 1 )
    ColorA = 0x01
EndIf
If ( SML_Color1 == 2 )
    ColorA = 0x02
EndIf
If ( SML_Color1 == 3 )
    ColorA = 0x03
EndIf
If ( SML_Color1 == 4 )
    ColorA = 0x04
EndIf
If ( SML_Color1 == 5 )
    ColorA = 0x05
EndIf
If ( SML_Color1 == 6 )
    ColorA = 0x06
EndIf
If ( SML_Color1 == 7 )
    ColorA = 0x07
EndIf
If ( SML_Color1 == 8 )
    ColorA = 0x08
EndIf
If ( SML_Color1 == 9 )
    ColorA = 0x09
EndIf

If ( SML_Color2 == 0 )
    ColorB = 0x00
EndIf
If ( SML_Color2 == 1 )
    ColorB = 0x01
EndIf
If ( SML_Color2 == 2 )
    ColorB = 0x02
EndIf
If ( SML_Color2 == 3 )
    Color3 = 0x03
EndIf
If ( SML_Color2 == 4 )
    Color4 = 0x04
EndIf
If ( SML_Color2 == 5 )
    Color5 = 0x05
EndIf
If ( SML_Color2 == 6 )
    Color6 = 0x06
EndIf
If ( SML_Color2 == 7 )
    Color7 = 0x07
EndIf
If ( SML_Color2 == 8 )
    Color8 = 0x08
EndIf
If ( SML_Color2 == 9 )
    Color9 = 0x09
EndIf

Area( SML_Lat, SML_Lon, 22 km, ObjEnd )
    GoIfOut(  ObjEnd,  0x0346, SML_Comp,  4  ) 
    PerspectiveCall( Pcall )
    ShadowCall( Scall )
    Jump( ObjEnd )

Pcall:
    Perspective
    
Scall:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    _FS5SCALE = 1.5
    PointsListVect( 0, 67 )
        PointVect(    -16,     0,     0    )  ;0
        PointVect(    -11,     0,    11    )  ;1
        PointVect(      0,     0,    16    )  ;2
        PointVect(     11,     0,    11    )  ;3
        PointVect(     16,     0,     0    )  ;4
        PointVect(     11,     0,   -11    )  ;5
        PointVect(      0,     0,   -16    )  ;6
        PointVect(    -11,     0,   -11    )  ;7
        PointVect(    -16,    16,     0    )  ;8
        PointVect(    -11,    16,    11    )  ;9
        PointVect(      0,    16,    16    )  ;10
        PointVect(     11,    16,    11    )  ;11
        PointVect(     16,    16,     0    )  ;12
        PointVect(     11,    16,   -11    )  ;13
        PointVect(      0,    16,   -16    )  ;14
        PointVect(    -11,    16,   -11    )  ;15
        PointVect(    -13,    52,     0    )  ;16
        PointVect(     -9,    52,     9    )  ;17
        PointVect(      0,    52,    13    )  ;18
        PointVect(      9,    52,     9    )  ;19
        PointVect(     13,    52,     0    )  ;20
        PointVect(      9,    52,    -9    )  ;21
        PointVect(      0,    52,   -13    )  ;22
        PointVect(     -9,    52,    -9    )  ;23
        PointVect(    -11,    72,     0    )  ;24
        PointVect(     -8,    72,     8    )  ;25
        PointVect(      0,    72,    11    )  ;26
        PointVect(      8,    72,     8    )  ;27
        PointVect(     11,    72,     0    )  ;28
        PointVect(      8,    72,    -8    )  ;29
        PointVect(      0,    72,   -11    )  ;30
        PointVect(     -8,    72,    -8    )  ;31
        PointVect(     -8,   108,     0    )  ;32
        PointVect(     -6,   108,     6    )  ;33
        PointVect(      0,   108,     8    )  ;34
        PointVect(      6,   108,     6    )  ;35
        PointVect(      8,   108,     0    )  ;36
        PointVect(      6,   108,    -6    )  ;37
        PointVect(      0,   108,    -8    )  ;38
        PointVect(     -6,   108,    -6    )  ;39
        PointVect(    -12,   108,     0    )  ;40
        PointVect(     -9,   108,     9    )  ;41
        PointVect(      0,   108,    12    )  ;42
        PointVect(      9,   108,     9    )  ;43
        PointVect(     12,   108,     0    )  ;44
        PointVect(      9,   108,    -9    )  ;45
        PointVect(      0,   108,   -12    )  ;46
        PointVect(     -9,   108,    -9    )  ;47
        PointVect(     -8,   108,     0    )  ;48
        PointVect(     -4,   108,     7    )  ;49 
        PointVect(      4,   108,     7    )  ;50
        PointVect(      8,   108,     0    )  ;51
        PointVect(      4,   108,    -7    )  ;52
        PointVect(     -4,   108,    -7    )  ;53
        PointVect(     -8,   120,     0    )  ;54
        PointVect(     -4,   120,     7    )  ;55
        PointVect(      4,   120,     7    )  ;56
        PointVect(      8,   120,     0    )  ;57
        PointVect(      4,   120,    -7    )  ;58
        PointVect(     -4,   120,    -7    )  ;59
        PointVect(     -8,   128,     0    )  ;60
        PointVect(     -4,   128,     7    )  ;61
        PointVect(      4,   128,     7    )  ;62
        PointVect(      8,   128,     0    )  ;63
        PointVect(      4,   128,    -7    )  ;64
        PointVect(     -4,   128,    -7    )  ;65
        PointVect(      0,   136,     0    )  ;66

    GoIfOutCube( NoCrash, -3, 3, 0, 34, -3, 3 )
    SetVar( 0x284, 14 )

NoCrash:
    GoIfOut( Far, 0x37E, -2000, 2000 )
    GoIfOut( Far, 0x386, -2000, 2000 )

    ; platform bottom view
    SurfaceColor( 0x01 )
        Polygon_8( 47, 46, 45, 44, 43, 42, 41, 40 )

    GradColor( ColorA ) 
        GradPolygon_4(  0,  1,  9,  8 )
        GradPolygon_4(  1,  2, 10,  9 )
        GradPolygon_4(  2,  3, 11, 10 )
        GradPolygon_4(  3,  4, 12, 11 )
        GradPolygon_4(  4,  5, 13, 12 )
        GradPolygon_4(  5,  6, 14, 13 )
        GradPolygon_4(  6,  7, 15, 14 )
        GradPolygon_4(  7,  0,  8, 15 )
    GradColor( ColorB ) 
        GradPolygon_4(  8,  9, 17, 16 ) 
        GradPolygon_4(  9, 10, 18, 17 ) 
        GradPolygon_4( 10, 11, 19, 18 ) 
        GradPolygon_4( 11, 12, 20, 19 ) 
        GradPolygon_4( 12, 13, 21, 20 ) 
        GradPolygon_4( 13, 14, 22, 21 ) 
        GradPolygon_4( 14, 15, 23, 22 ) 
        GradPolygon_4( 15,  8, 16, 23 ) 
    GradColor( ColorA ) 
        GradPolygon_4( 16, 17, 25, 24 ) 
        GradPolygon_4( 17, 18, 26, 25 ) 
        GradPolygon_4( 18, 19, 27, 26 ) 
        GradPolygon_4( 19, 20, 28, 27 ) 
        GradPolygon_4( 20, 21, 29, 28 ) 
        GradPolygon_4( 21, 22, 30, 29 ) 
        GradPolygon_4( 22, 23, 31, 30 ) 
        GradPolygon_4( 23, 16, 24, 31 ) 
    GradColor( ColorB ) 
        GradPolygon_4( 24, 25, 33, 32 ) 
        GradPolygon_4( 25, 26, 34, 33 ) 
        GradPolygon_4( 26, 27, 35, 34 ) 
        GradPolygon_4( 27, 28, 36, 35 ) 
        GradPolygon_4( 28, 29, 37, 36 ) 
        GradPolygon_4( 29, 30, 38, 37 ) 
        GradPolygon_4( 30, 31, 39, 38 ) 
        GradPolygon_4( 31, 24, 32, 39 ) 

    ; plattform top view
    SurfaceColor( 0x01 )
        Polygon_8( 40, 41, 42, 43, 44, 45, 46, 47 )

    ; lamp housing, bottom
    GradColor( 0x02 )
        GradPolygon_4( 48, 49, 55, 54 )
        GradPolygon_4( 49, 50, 56, 55 )
        GradPolygon_4( 50, 51, 57, 56 )
        GradPolygon_4( 51, 52, 58, 57 )
        GradPolygon_4( 52, 53, 59, 58 )
        GradPolygon_4( 53, 48, 54, 59 )

    ; lamp
    SurfaceColor( 0x13 )        ; color, lamp off
    GoIfNot( Ctest, 0x282, 0x00FF )
    SurfaceColor( 0x15 )        ; color, lamp on

Ctest:
    Polygon_4( 54, 55, 61, 60 )
    Polygon_4( 55, 56, 62, 61 )
    Polygon_4( 56, 57, 63, 62 )
    Polygon_4( 57, 58, 64, 63 )
    Polygon_4( 58, 59, 65, 64 )
    Polygon_4( 59, 54, 60, 65 )

    ; roof
    GradColor( ColorA ) 
        GradPolygon_3( 66, 60, 61 )
        GradPolygon_3( 66, 61, 62 )
        GradPolygon_3( 66, 62, 63 )
        GradPolygon_3( 66, 63, 64 )
        GradPolygon_3( 66, 64, 65 )
        GradPolygon_3( 66, 65, 60 )

ObjReturn:
    Return

Far:
    SurfaceColor( ColorA )   
    Intensity( 32768 )
    StartSurface
        MoveToPoint(  0 )
        LineToPoint(  8 )
        LineToPoint( 12 )
        LineToPoint(  4 )
    CloseSurface
    StartSurface
        MoveToPoint(  2 )
        LineToPoint( 10 )
        LineToPoint( 14 )
        LineToPoint(  6 )
    CloseSurface

    SurfaceColor( ColorB )  
    Intensity( 32768 )
    StartSurface
        MoveToPoint(  8 )
        LineToPoint( 16 )
        LineToPoint( 20 )
        LineToPoint( 12 )
    CloseSurface
    StartSurface
        MoveToPoint( 10 )
        LineToPoint( 18 )
        LineToPoint( 22 )
        LineToPoint( 14 )
    CloseSurface

    SurfaceColor( ColorA )  
    Intensity( 32768 )
    StartSurface
        MoveToPoint( 16 )
        LineToPoint( 24 )
        LineToPoint( 28 )
        LineToPoint( 20 )
    CloseSurface
    StartSurface
        MoveToPoint( 18 )
        LineToPoint( 26 )
        LineToPoint( 30 )
        LineToPoint( 22 )
    CloseSurface

    SurfaceColor( ColorB )  
    Intensity( 32768 )
    StartSurface
        MoveToPoint( 24 )
        LineToPoint( 32 )
        LineToPoint( 36 )
        LineToPoint( 28 )
    CloseSurface
    StartSurface
        MoveToPoint( 26 )
        LineToPoint( 34 )
        LineToPoint( 38 )
        LineToPoint( 30 )
    CloseSurface

    SurfaceColor( 0x02 )  
    Intensity( 32768 )
    StartSurface
        MoveToPoint( 48 )
        LineToPoint( 54 )
        LineToPoint( 57 )
        LineToPoint( 51 )
    CloseSurface
    StartSurface
        MoveToPoint( 50 )
        LineToPoint( 56 )
        LineToPoint( 59 )
        LineToPoint( 63 )
    CloseSurface

    ;  lamp housing
    ;
    SurfaceColor( 0x03 )
    Intensity( 32768 )
    SurfaceColor( 0x10 )
    GoIfNot( Ftest, 0x282, 0x00FF )
    SurfaceColor( 0x15 )

Ftest:
    StartSurface
        MoveToPoint( 48 )
        LineToPoint( 60 )
        LineToPoint( 63 )
        LineToPoint( 57 )
    CloseSurface
    StartSurface
        MoveToPoint( 55 )
        LineToPoint( 61 )
        LineToPoint( 64 )
        LineToPoint( 58 )
    CloseSurface
    StartSurface
        MoveToPoint( 56 )
        LineToPoint( 62 )
        LineToPoint( 65 )
        LineToPoint( 59 )
    CloseSurface
    Return

ObjEnd:

;
;       Far away view, lamp only !
;
Area( SML_Lat, SML_Lon, 140 km, EndObj )
    GoIfNot( EndObj, 0x28C, 0xFFFE )
    PerspectiveCall( Lamp )
    Jump( EndObj )

Lamp:
    Perspective
    ReferencePoint( SML_Lat, SML_Lon, ReturnObj, 1, 0 )
    GoIfOut( Raf, 0x37E, -3000, 3000 )
    GoIfOut( Raf, 0x386, -3000, 3000 )
    Jump( EndObj )

Raf:
    Db 0x39, 0x00, 0x10, 0x00, 0x82, 0x02, 0x03, 0x00
    LineColor( NightGreen )
    SurfaceColor( NightGreen )

    Jump( PmAb )
    Db 0x39, 0x00, 0x14, 0x00, 0x82, 0x02, 0x00, 0x03 
    LineColor( NightRed )
    SurfaceColor( NightRed )

PmAb:
    Intensity( 65536 )
    Dot( 0, 31, 0 )
    ;Dw 0x0028, 0x2000, 0x0000, 0x001F, 0x0000
    Return
    
ReturnObj:
    Return

EndObj:
    ENDMACRO

