;! " Civil ABN Antenna "
;? " Heading "=SML_Heading
;? " Altitude"=SML_Alt
; by Alessandro Antonini



MACRO MilAbn

Local Pcall1, Scall1, ObjReturn, Dwg, ObjEnd, Ntest, Itest

    Area( SML_Lat, SML_Lon, 20 km, ObjEnd ) 
    PerspectiveCall( Pcall1 )
    ShadowCall( Scall1 )
    Goto( ObjEnd )


PCall1:
    Perspective

Scall1:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    _FS5SCALE = 1.5
    Rotate( Dwg, 0, 0, SML_Heading )
    Call( Ntest )
    Return


Dwg:
    PointsList( 0, 54 )
    Point(    -1,     0,    -1   )                    ; 0
    Point(    -1,     0,     1   )                    ; 1
    Point(     1,     0,     1   )                    ; 2
    Point(     1,     0,    -1   )                    ; 3
    Point(    -1,     7,    -1   )                    ; 4
    Point(    -1,     7,     1   )                    ; 5
    Point(     1,     7,     1   )                    ; 6
    Point(     1,     7,    -1   )                    ; 7
    Point(    -1,    14,    -1   )                    ; 8
    Point(    -1,    14,     1   )                    ; 9
    Point(     1,    14,     1   )                    ; 10
    Point(     1,    14,    -1   )                    ; 11
    Point(    -1,    21,    -1   )                    ; 12
    Point(    -1,    21,     1   )                    ; 13
    Point(     1,    21,     1   )                    ; 14
    Point(     1,    21,    -1   )                    ; 15
    Point(    -1,    28,    -1   )                    ; 16
    Point(    -1,    28,     1   )                    ; 17
    Point(     1,    28,     1   )                    ; 18
    Point(     1,    28,    -1   )                    ; 19
    Point(    -1,    35,    -1   )                    ; 20
    Point(    -1,    35,     1   )                    ; 21
    Point(     1,    35,     1   )                    ; 22
    Point(     1,    35,    -1   )                    ; 23
    Point(    -1,    42,    -1   )                    ; 24
    Point(    -1,    42,     1   )                    ; 25
    Point(     1,    42,     1   )                    ; 26
    Point(     1,    42,    -1   )                    ; 27
    Point(    -1,    49,    -1   )                    ; 28
    Point(    -1,    49,     1   )                    ; 29
    Point(     1,    49,     1   )                    ; 30
    Point(     1,    49,    -1   )                    ; 31

    Point(    -1,    56,    -1   )                    ; 32
    Point(    -1,    56,     1   )                    ; 33
    Point(     1,    56,     1   )                    ; 34
    Point(     1,    56,    -1   )                    ; 35

    Point(    13,     0,    13   )                    ; 36
    Point(   -11,     0,    11   )                    ; 37
    Point(   -13,     0,   -13   )                    ; 38
    Point(    11,     0,   -11   )                    ; 39
    Point(     1,    18,     1   )                    ; 40
    Point(     1,    18,    -1   )                    ; 41
    Point(    -1,    18,    -1   )                    ; 42
    Point(    -1,    18,     1   )                    ; 43
    Point(    19,     0,    19   )                    ; 44
    Point(   -17,     0,    17   )                    ; 45
    Point(   -19,     0,   -19   )                    ; 46
    Point(    17,     0,   -17   )                    ; 47
    Point(     1,    38,     1   )                    ; 48
    Point(     1,    38,    -1   )                    ; 49
    Point(    -1,    38,    -1   )                    ; 50
    Point(    -1,    38,     1   )                    ; 51
    Point(     0,    64,     0   )                    ; 52
    Point(     0,    68,     0   )                    ; 53


    SurfaceColor( 0x04 )
        Polygon_4( 2, 6, 5, 1 )          ; #1
        Polygon_4( 3, 7, 6, 1 )       
        Polygon_4( 0, 4, 7, 3 )       
        Polygon_4( 1, 5, 4, 0 )       

    SurfaceColor( Red )
        Polygon_4( 6, 10,  9, 5 )        ; #2
        Polygon_4( 7, 11, 10, 6 )       
        Polygon_4( 4,  8, 11, 7 )       
        Polygon_4( 5,  9,  8, 4 )       
  
    SurfaceColor( 0x04 )
        Polygon_4( 10, 14, 13,  9 )      ; #3
        Polygon_4( 11, 15, 14, 10 )       
        Polygon_4(  8, 12, 15, 11 )       
        Polygon_4(  9, 13, 12,  8 )       

    SurfaceColor( Red )
        Polygon_4( 14, 18, 17, 13 )      ; #4
        Polygon_4( 15, 19, 18, 14 )       
        Polygon_4( 12, 16, 19, 15 )       
        Polygon_4( 13, 17, 16, 12 )       

    SurfaceColor( 0x04 )
        Polygon_4( 18, 22, 21, 17 )      ; #5
        Polygon_4( 19, 23, 22, 18 )       
        Polygon_4( 16, 20, 23, 19 )       
        Polygon_4( 17, 21, 20, 16 )       

    SurfaceColor( Red )
        Polygon_4( 22, 26, 25, 21 )      ; #6
        Polygon_4( 23, 27, 26, 22 )       
        Polygon_4( 20, 24, 27, 23 )       
        Polygon_4( 21, 25, 24, 20 )       

    SurfaceColor( 0x04 )
        Polygon_4( 26, 30, 29, 25 )      ; #7
        Polygon_4( 27, 31, 30, 26 )       
        Polygon_4( 24, 28, 31, 27 )       
        Polygon_4( 25, 29, 28, 24 )       

    SurfaceColor( Red )
        Polygon_4( 30, 34, 33, 29 )         ; #8
        Polygon_4( 31, 35, 34, 30 )       
        Polygon_4( 28, 32, 35, 31 )       
        Polygon_4( 29, 33, 32, 28 )       


    SurfaceColor( Red )
        Polygon_3( 33, 34, 52 )         ; Top
        Polygon_3( 35, 32, 52 )         

    SurfaceColor( 0x04 )
        Polygon_3( 32, 33, 52 )         
        Polygon_3( 34, 35, 52 )         

    LineColor( DarkGrey )  ; Lower cable
        MoveToPoint (  36 )
        LineToPoint (  40 )
        MoveToPoint (  37 )
        LineToPoint (  41 )
        MoveToPoint (  38 )
        LineToPoint (  42 )
        MoveToPoint (  39 )
        LineToPoint (  43 )

    LineColor(  DarkGrey  )  ; Upper cable
        MoveToPoint (  44 )
        LineToPoint (  48 )
        MoveToPoint (  45 )
        LineToPoint (  49 )
        MoveToPoint (  46 )
        LineToPoint (  50 )
        MoveToPoint (  47 )
        LineToPoint (  51 )

		LineColor( 0x03 )
				MoveToPoint( 52 )
				LineToPoint( 53 )
    Return

Ntest:
    Db 0x39, 0x00, 0x10, 0x00, 0x82, 0x02, 0x05, 0x00
    LineColor( NightGreen )

    Jump( Itest )
    Db 0x39, 0x00, 0x14, 0x00, 0x82, 0x02, 0x00, 0x05
    LineColor( NightWhite )

Itest:
    Dot( 0, 68, 0 )
    Return


ObjReturn:
    Return

ObjEnd:
    ENDMACRO
