;! " 20 mts. High Street-Lamp "
;? " Scenery density required to show on (0-4): "=SML_Comp
;? " Lamp Color (10-16): "=SML_Lamp
;? " Heading [HDG]: "=SML_Heading
;? " Highlighted area by night color (10-16) :"=SML_Nite

; converted by A. Antonini, with permission from Airport authour

MACRO _Lampad4

Local ObjEnd, Pcall, Scall, ObjReturn, NiteC, Nite, Lampc, Day,
      NiteGnd, Column, Dwg

; color 1 = lamp
; color 2 = highlighted area by night

; setup default
NiteC = 0x16
Lampc = 0x14

If ( SML_Lamp == 10 )
    Lampc = 0x10
EndIf
If ( SML_Lamp == 11 )
    Lampc = 0x11
EndIf
If ( SML_Lamp == 12 )
    Lampc = 0x12
EndIf
If ( SML_Lamp == 13 )
    Lampc = 0x13
EndIf
If ( SML_Lamp == 14 )
    Lampc = 0x14
EndIf
If ( SML_Lamp == 15 )
    Lampc = 0x15
EndIf
If ( SML_Lamp == 16 )
    Lampc = 0x16
EndIf

If ( SML_Nite == 10 )
    NiteC = 0x10
EndIf
If ( SML_Nite == 11 )
    NiteC = 0x11
EndIf
If ( SML_Nite == 12 )
    NiteC = 0x12
EndIf
If ( SML_Nite == 13 )
    NiteC = 0x13
EndIf
If ( SML_Nite == 14 )
    NiteC = 0x14
EndIf
If ( SML_Nite == 15 )
    NiteC = 0x15
EndIf
If ( SML_Nite == 16 )
    NiteC = 0x16
EndIf


_Area( 0x05, SML_Lat, SML_Lon, 22 km, ObjEnd  )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
    PerspectiveCall( Pcall )
    Jump( ObjEnd )

Pcall:
    Perspective
    CondRefPoint( ObjReturn, 3000, 27, 0, 1, SML_Lat, SML_Lon, 0 )
    Rotate(  Dwg,  0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    PointsList(  0, 27 )
        Point(       0,      0,      0  )    ;0     
        Point(       0,     16,      0  )    ;1     
        Point(       0,     16,     -1  )    ;2     
        Point(       0,     16,      1  )    ;3     
        Point(      -1,     15,      1  )    ;4     
        Point(      -1,     15,      2  )    ;5     
        Point(       1,     15,      2  )    ;6     
        Point(       1,     15,      1  )    ;7     
        Point(      -1,     16,      1  )    ;8     
        Point(      -1,     16,      2  )    ;9     
        Point(       1,     16,      2  )    ;10    
        Point(       1,     16,      1  )    ;11    
        Point(      -3,     42,      2  )    ;12    
        Point(     -30,      0,      3  )    ;13     
        Point(     -30,      0,     24  )    ;14    
        Point(      30,      0,     24  )    ;15    
        Point(      30,      0,      3  )    ;16    
        Point(       0,      0,      0  )    ;17    
        Point(     -30,      0,     -3  )    ;18    
        Point(     -30,      0,    -24  )    ;19    
        Point(      30,      0,    -24  )    ;20    
        Point(      30,      0,     -3  )    ;21    
        Point(      45,      0,     30  )    ;22    
        Point(      15,      0,     10  )    ;23    
        Point(      15,      0,     50  )    ;24    
        Point(      14,      0,     20  )    ;25    
        Point(      12,      0,      0  )    ;26    
                                    
    LineColor(  0x03  )
        MoveToPoint(   0  )
        LineToPoint(   1  )
    LineColor(  0x03  )
        MoveToPoint(   1  )
        LineToPoint(   3  )
    GoIfOut(  Day, 0x028C, 2, 4  )
    Jump(  Nite  )

Day:
    SurfaceColor(  0x03  )   
        Polygon_4(  8,  9, 10, 11  )
    SurfaceColor(  0x03  )   
        Polygon_4(  9,  8,  4,  5  )
    SurfaceColor(  0x03  )   
        Polygon_4(  7,  6,  5,  4  )
    SurfaceColor(  0x03  )   
        Polygon_4( 11, 10,  6,  7  )
    SurfaceColor(  0x03  )   
        Polygon_4(  4,  8,  9,  5  )
    SurfaceColor(  0x03  )   
        Polygon_4(  8,  9, 10, 11  )
    SurfaceColor(  0x03  )   
    Jump(  Column  )

Nite:
    SurfaceColor(  0x04  )   
        Polygon_4(  8,  9, 10, 11  )
    SurfaceColor(  0x04  )   
        Polygon_4(  9,  8,  4,  5  )
    SurfaceColor(  LampC )   
        Polygon_4(  7,  6,  5,  4  )
    SurfaceColor(  0x15  )   
        Polygon_4( 11, 10,  6,  7  )
    SurfaceColor(  0x04  )   
        Polygon_4(  4,  8,  9,  5  )
    SurfaceColor(  0x15  )   
        Polygon_4(  8,  9, 10, 11  )
    SurfaceColor(  NiteC  )
        Polygon_5(  14, 15, 16, 17, 18 )
     Db 0x52, 0x00, NiteC, 0x68
        Polygon_5(  14, 15, 16, 17, 18 )

Column:
    Return

ObjEnd:
    ENDMACRO
