;! " Street-Lamp "
;? " Scenery density required to show on (0-4): "=SML_Comp
;? " Lamp Color (10-16): "=SML_Lamp
;? " Highlighted area by night color (10-16) :"=SML_Nite

; converted by A. Antonini, with permisssion from Airport authour

MACRO _Lampad1

Local ObjEnd, Pcall, Scall, ObjReturn, NiteC, Nite, Lampc, Day,
      NiteGnd, Column

; color 1 = lamp
; color 2 = highlighted area by night

; setup default
NiteC = 0x16
Lampc = 0x14

If ( SML_Lamp == 10 )
    Lampc = 0x10
EndIf
If ( SML_Lamp == 11 )
    Lampc = 0x11
EndIf
If ( SML_Lamp == 12 )
    Lampc = 0x12
EndIf
If ( SML_Lamp == 13 )
    Lampc = 0x13
EndIf
If ( SML_Lamp == 14 )
    Lampc = 0x14
EndIf
If ( SML_Lamp == 15 )
    Lampc = 0x15
EndIf
If ( SML_Lamp == 16 )
    Lampc = 0x16
EndIf

If ( SML_Nite == 10 )
    NiteC = 0x10
EndIf
If ( SML_Nite == 11 )
    NiteC = 0x11
EndIf
If ( SML_Nite == 12 )
    NiteC = 0x12
EndIf
If ( SML_Nite == 13 )
    NiteC = 0x13
EndIf
If ( SML_Nite == 14 )
    NiteC = 0x14
EndIf
If ( SML_Nite == 15 )
    NiteC = 0x15
EndIf
If ( SML_Nite == 16 )
    NiteC = 0x16
EndIf


_Area( 0x05, SML_Lat, SML_Lon, 22 km, ObjEnd  )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
    PerspectiveCall( Pcall )
    Jump( ObjEnd )

Pcall:
    Perspective
    CondRefPoint( ObjReturn, 3000, 27, 0, 1, SML_Lat, SML_Lon, 0 )

       
    PointsList(   0, 26 )     
        Point(    0,     0,       0   )  ;0
        Point(    0,    24,       0   )  ;1
        Point(    0,    24,       3   )  ;2 
        Point(    3,    24,       2   )  ;3 
        Point(    3,    24,      -2   )  ;4 
        Point(    0,    24,      -3   )  ;5 
        Point(   -3,    24,      -2   )  ;6   
        Point(   -3,    24,       2   )  ;7  
        Point(    0,    27,       3   )  ;8 
        Point(    3,    27,       2   )  ;9 
        Point(    3,    27,      -2   )  ;10 
        Point(    0,    27,      -3   )  ;11 
        Point(   -3,    27,      -2   )  ;12   
        Point(   -3,    27,       2   )  ;13  
        Point(    0,     0,      16   )  ;14
        Point(    8,     0,      13   )  ;15
        Point(   14,     0,       8   )  ;16
        Point(   16,     0,       0   )  ;17
        Point(   14,     0,      -8   )  ;18 
        Point(    8,     0,     -13   )  ;19 
        Point(   00,     0,     -16   )  ;20
        Point(   -8,     0,     -13   )  ;21 
        Point(  -14,     0,      -8   )  ;22 
        Point(  -16,     0,       0   )  ;23
        Point(  -14,     0,       8   )  ;24
        Point(   -8,     0,      13   )  ;25

        GoIfNot( Day,  0x028C, 6 )        
            Call( Nite )
            Call( NiteGnd )
            Jump( Column )
        Return

Day:
     SurfaceColor(  0x03 )   
         Polygon_6(  7,  6,  5,  4,  3,  2 )
         Polygon_6(  8,  9, 10, 11, 12, 13  )
     SurfaceColor(  0x04 )   
         Polygon_4(  3,  9,  8,  2  )
     SurfaceColor(  0x03 )   
         Polygon_4(  4, 10,  9,  3  )
     SurfaceColor(  0x04 )   
         Polygon_4(  5, 11, 10,  4  )
     SurfaceColor(  0x03 )   
         Polygon_4(  6, 12, 11,  5  )
     SurfaceColor(  0x04 )   
         Polygon_4(  7, 13, 12,  6  )
     SurfaceColor(  0x03 )   
         Polygon_4(  2,  8, 13,  7  )
     Jump( Column )

Nite:
     SurfaceColor(  0x04  )   
         Polygon_6(  7,  6,  5,  4,  3,  2 )
         Polygon_6(  8,  9, 10, 11, 12, 13  )
     SurfaceColor(  LampC  )   
         Polygon_4(  3,  9,  8,  2  )
     SurfaceColor(  0x15 )   
         Polygon_4(  3,  9, 10,  4  )
     SurfaceColor(  LampC  )   
         Polygon_4(  5, 11, 10,  4  )
     SurfaceColor(  0x15   )   
         Polygon_4(  6, 12, 11,  5  )
     SurfaceColor(  LampC  )   
         Polygon_4(  7, 13, 12,  6  )
     SurfaceColor(  0x15   )   
         Polygon_4(  2,  8, 13,  7  )
     Return        

NiteGnd:
     SurfaceColor(  NiteC  )
         Polygon_12( 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 )
     Db 0x52, 0x00, NiteC, 0x68
         Polygon_12( 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 )
     Return

Column:        
    LineColor(  0x04  )
        MoveToPoint(   0  )
        LineToPoint(   1  )
    Return

ObjReturn:
    Return

ObjEnd:
    ENDMACRO
