;! " Nite-Light "
;? " Scenery complexity required to show on (1-4): "=SML_Comp
; by A.Antonini

MACRO _Lamp2
Local ObjEnd, PCall, SCall, Dwg, ObjReturn, Day, Night, Ntest, Multip

Multip = 2

Area( SML_Lat, SML_Lon, 15 km, ObjEnd )
    GoIfOut( ObjEnd, SceneryComplexity, SML_Comp, 4 )
    PerspectiveCall( PCall )
    ShadowCall( SCall )
    Jump( ObjEnd )

PCall:
    Perspective

Scall:
    CondRefPoint( ObjReturn, 2831, 18, 0, 0.25, SML_Lat, SML_Lon, 0 )
    _FS5SCALE = 1.2
    Rotate( Dwg , 0 , 0 , 0d )
    Return

Dwg:
    PointsListVect( 1, 48 )
    PointVect(   -1.5,    0,    2.5 ) ;1
    PointVect(    1.5,    0,    2.5 ) ;2
    PointVect(    2.5,    0,    1.5 ) ;3
    PointVect(    2.5,    0,   -1.5 ) ;4
    PointVect(    1.5,    0,   -2.5 ) ;5
    PointVect(   -1.5,    0,   -2.5 ) ;6
    PointVect(   -2.5,    0,   -1.5 ) ;7
    PointVect(   -2.5,    0,    1.5 ) ;8

    PointVect(   -1.5,  125,    2.5 ) ;9
    PointVect(    1.5,  125,    2.5 ) ;10
    PointVect(    2.5,  125,    1.5 ) ;11
    PointVect(    2.5,  125,   -1.5 ) ;12 
    PointVect(    1.5,  125,   -2.5 ) ;13
    PointVect(   -1.5,  125,   -2.5 ) ;14
    PointVect(   -2.5,  125,   -1.5 ) ;15
    PointVect(   -2.5,  125,    1.5 ) ;16

    PointVect(   -2.5,  125,    3.5 ) ;17
    PointVect(   -3.5,  125,    4.5 ) ;18
    PointVect(   -3.5,  125,   16.5 ) ;19
    PointVect(   -2.5,  125,     20 ) ;20
    PointVect(    2.5,  125,     20 ) ;21
    PointVect(    3.5,  125,     20 ) ;22
    PointVect(    3.5,  125,    4.5 ) ;23
    PointVect(    2.5,  125,    3.5 ) ;24

    PointVect(    3.5,  125,    2.5 ) ;25
    PointVect(    4.5,  125,    3.5 ) ;26
    PointVect(   16.5,  125,    3.5 ) ;27
    PointVect(     20,  125,    2.5 ) ;28
    PointVect(     20,  125,   -2.5 ) ;29
    PointVect(   16.5,  125,   -3.5 ) ;30
    PointVect(    4.5,  125,   -3.5 ) ;31
    PointVect(    3.5,  125,   -2.5 ) ;32

    PointVect(   -2.5,  125,   -3.5 ) ;33
    PointVect(    2.5,  125,   -3.5 ) ;34
    PointVect(    3.5,  125,   -4.5 ) ;35
    PointVect(    3.5,  125,  -16.5 ) ;36
    PointVect(    2.5,  125,    -20 ) ;37
    PointVect(   -2.5,  125,    -20 ) ;38
    PointVect(   -3.5,  125,  -16.5 ) ;39
    PointVect(   -3.5,  125,   -4.5 ) ;40

    PointVect(   -3.5,  125,    2.5 ) ;41
    PointVect(   -3.5,  125,   -2.5 ) ;42
    PointVect(   -4.5,  125,   -3.5 ) ;43
    PointVect(  -16.5,  125,   -4.5 ) ;44
    PointVect(    -20,  125,   -2.5 ) ;45
    PointVect(    -20,  125,    2.5 ) ;46
    PointVect(  -16.5,  125,    3.5 ) ;47
    PointVect(   -4.5,  125,    3.5 ) ;48
    Call( Day )
    Call( Night )
    Return

Day:
    SurfaceColor(  Sandlight  )
        Polygon_8( 24, 23, 22, 21, 20, 19, 18, 17 )
        Polygon_8( 32, 31, 30, 29, 28, 27, 26, 25 )
        Polygon_8( 40, 39, 38, 37, 36, 35, 34, 33 )
        Polygon_8( 48, 47, 46, 45, 44, 43, 42, 41 )

    GradColor(  LightGrey )
        GradPolygon_4(  1,  2, 10,  9  )
        GradPolygon_4(  2,  3, 11, 10  )
        GradPolygon_4(  3,  4, 12, 11  )
        GradPolygon_4(  4,  5, 13, 12  )
        GradPolygon_4(  5,  6, 14, 13  )
        GradPolygon_4(  6,  7, 15, 14  )
        GradPolygon_4(  7,  8, 16, 15  )
        GradPolygon_4(  8,  1,  9, 16  )

    SurfaceColor(  LightGrey )
        Polygon_8(  9, 10, 11, 12, 13, 14, 15, 16 )
        Polygon_8( 17, 18, 19, 20, 21, 22, 23, 24 )
        Polygon_8( 25, 26, 27, 28, 29, 30, 31, 32 )
        Polygon_8( 33, 34, 35, 36, 37, 38, 39, 40 )
        Polygon_8( 41, 42, 43, 44, 45, 46, 47, 48 )
    Return

Night:         
    GoIfNot(  ObjReturn,  0x028C, 6 )
    SurfaceColor(  0x14 )
        Polygon_8( 24, 23, 22, 21, 20, 19, 18, 17 )
        Polygon_8( 32, 31, 30, 29, 28, 27, 26, 25 )
        Polygon_8( 40, 39, 38, 37, 36, 35, 34, 33 )
        Polygon_8( 48, 47, 46, 45, 44, 43, 42, 41 )


    Rotate( Ntest, 0, 0,   0d )
    Rotate( Ntest, 0, 0,  90d )
    Rotate( Ntest, 0, 0, 180d )
    Rotate( Ntest, 0, 0, -90d )
    Return
    
Ntest:
    PointsList( 50, 13 )
    Point(    21*Multip,    0,    1.5*Multip ) ;50
    Point(    28*Multip,    0,     10*Multip ) ;51
    Point(    44*Multip,    0,   16.5*Multip ) ;52
    Point(  61.5*Multip,    0,     18*Multip ) ;53
    Point(    79*Multip,    0,   16.5*Multip ) ;54
    Point(  88.5*Multip,    0,     10*Multip ) ;55
    Point(  92.5*Multip,    0,      0*Multip ) ;56
    Point(  88.5*Multip,    0,    -10*Multip ) ;57
    Point(    79*Multip,    0,  -16.5*Multip ) ;58
    Point(  61.5*Multip,    0,    -18*Multip ) ;59
    Point(    44*Multip,    0,  -16.5*Multip ) ;60
    Point(    28*Multip,    0,    -10*Multip ) ;61
    Point(    21*Multip,    0,   -1.5*Multip ) ;62

    SurfaceColor( 0x16 )
        Polygon_13( 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62 )
    Db 0x52, 0x00, 0x16, 0x68
        Polygon_13( 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62 )
    Return

ObjReturn:
    Return
ObjEnd:
    ENDMACRO

