;! " Semi-Adjustable Textured Hangar "
;? " Scale: "=SML_Scale
;? " Heading [HDG]: "=SML_Heading
;? " Scenery density required to show on (1-4): "=SML_Comp
;? " Door location (1. Side, 2. No Door ): "=SML_Door

MACRO _Hangar7

Local ObjEnd, Pcall, Scall, Dwg, ObjReturn, Inner, Outer, Ferme, Loin, 
      HngOpen, Dtype
      
; default door
Dtype = 1

If ( SML_Door == 1 )
    Dtype = 1
EndIf
    
If ( SML_Door == 2 )
    Dtype = 2
EndIf
      

Area(  SML_Lat, SML_Lon, 14 km, ObjEnd )
    GoIfOut(  ObjEnd,  0x0346, SML_Comp,  4  ) 
    PerspectiveCall( Pcall )
    ShadowCall( Scall )
    Jump( ObjEnd )

Pcall:
    Perspective

Scall:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    _FS5SCALE = (SML_Scale * 100) / (SML_Scale*SML_Scale)/100
    Rotate(  Dwg, 0, 0, SML_Heading )
    Return

Dwg:
    PointsList(  0, 12 )     
        Point(       8,      0,      -20  )  ;0
        Point(      -8,      0,      -20  )  ;1
        Point(      -8,      0,       20  )  ;2 
        Point(       8,      0,       20  )  ;3
        Point(       8,     10,      -20  )  ;4
        Point(      -8,     10,      -20  )  ;5
        Point(      -8,     10,       20  )  ;6 
        Point(       8,     10,       20  )  ;7
        Point(       0,     13,      -20  )  ;8  
        Point(       0,     13,       20  )  ;9
        Point(       8,      9,       20  )  ;10
        Point(       8,      9,      -20  )  ;11

    PointsList( 20, 10 )
        Point(       8,      0,       14  )  ;20   
        Point(       8,      9,       14  )  ;21
        Point(       8,      0,        7  )  ;22   
        Point(       8,      9,        7  )  ;23
        Point(       8,      0,        0  )  ;24   
        Point(       8,      9,        0  )  ;25
        Point(       8,      0,       -7  )  ;26   
        Point(       8,      9,       -7  )  ;27
        Point(       8,      0,      -14  )  ;28   
        Point(       8,      9,      -14  )  ;29

    Call( Inner )
    GoIfOutCube( Loin,  -1500, 1500,  0, 1500,  -1500, 1500 )
    Call( Outer )
    If( Dtype == 1 )
        Call( HngOpen )
    Else
        Call( Ferme )
    EndIf
    Return

Inner:
    SurfaceColor( 0x02 )
        Polygon_4(  0,  1,  2,  3  )     ;sol
        Polygon_4(  9,  8,  4,  7  )     ;plafond intrieur
        Polygon_4(  8,  9,  6,  5  )

    SurfaceColor( 0x03 )
        Polygon_4(  2,  1,  5,  6  )
        Polygon_4(  7,  4, 11, 10  )
        Polygon_4( 10, 21, 20,  3  )
        Polygon_4( 29, 11,  0, 28  )
    Concave
        Polygon_5(  4,  8,  5,  1,  0  )
        Polygon_5(  3,  2,  6,  9,  7  ) 
    Return        

Loin:
    SurfaceColor(  0x03 )   
        Polygon_4(  6,  5,  1,  2  )
        Polygon_4(  4,  7,  3,  0  ) 
        Polygon_5(  4,  8,  5,  1,  0  )
        Polygon_5(  7,  9,  6,  2,  3  )
    SurfaceColor(  0x03  )  ;toiture
    Concave
        Polygon_4(  9,  8,  4,  7  )
        Polygon_4(  8,  9,  6,  5  )
    Return        
        
Outer:
    Texture( "airpt003", "oav"  )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  1,   0, 189  )
        TexturePt(  2,  82, 189  )
        TexturePt(  6,  82, 228  )
        TexturePt(  5,   0, 228  )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  7,   1, 150  )
        TexturePt(  4,  85, 150  )
        TexturePt(  8,  85, 187  )
        TexturePt(  9,   1, 187  )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  5,   1, 150  )
        TexturePt(  6,  85, 150  )
        TexturePt(  9,  85, 187  )
        TexturePt(  8,   1, 187  )
    AdjustTexture
    TexturePolygon( 5 )
        TexturePt(  0,  85, 189  )
        TexturePt(  1, 154, 189  )
        TexturePt(  5, 154, 228  )
        TexturePt(  8, 120, 244  )
        TexturePt(  4,  85, 228  )
    AdjustTexture
    TexturePolygon( 5 )
        TexturePt(  7,  85, 228  )
        TexturePt(  9, 120, 244  )
        TexturePt(  6, 154, 228  )
        TexturePt(  2, 154, 189  )
        TexturePt(  3,  85, 189  )
    Return

HngOpen:       
    RepeatBitMap
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 10,   0, 225  )  
        TexturePt( 11,  82, 225  )
        TexturePt(  4,  82, 228  )
        TexturePt(  7,   0, 228  )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  3,   0, 189  )
        TexturePt( 20,  20, 189  )
        TexturePt( 21,  20, 225  )
        TexturePt( 10,   0, 225  )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 28,  61, 189  )
        TexturePt(  0,  82, 189  )
        TexturePt( 11,  82, 225  )
        TexturePt( 29,  61, 225  )
   Return
                
Ferme:
    RepeatBitMap
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  3,   0, 189  )
        TexturePt(  0,  82, 189  )
        TexturePt(  4,  82, 228  )
        TexturePt(  7,   0, 228  )
    Return

ObjReturn:
    Return
        
ObjEnd:
    ENDMACRO


