;! " Quay crane "
;? " Heading [HDG] "=SML_Heading
;? " Scale "=SML_Scale
;? " Altitude "=SML_Alt
;? " Scenery density required to show on (1-4) "=SML_Comp
;? " Structure color (0-9) "=SML_Struc
;? " Base color (0-9) "=SML_Socle
;? " Counter-weight color (0-9) "=SML_Subst
; converted by A. Antonini ( with permission )

MACRO _Grue1

Local ObjEnd, Pcall1, Scall1, ObjReturn, nocrash, Dwg, dessus, socle, struc,
      rampe, clignot, eclaire    

Area( SML_Lat, SML_Lon, 22 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
    PerspectiveCall( Pcall1 )
    ShadowCall( Scall1  )
    Jump( ObjEnd )

Pcall1:
    Perspective

Scall1:
    ReferencePoint(  SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    _FS5SCALE = ((SML_Scale * 100) / (Pow(SML_Scale,2)) / 100 ) * 5
    GoIfOutCube( nocrash,  -50,  50,    0,  450,   -50,  50 )
    SetVar( 0x284, 14 )

nocrash:
    Rotate( Dwg, 0, 0, SML_Heading ) 
    Return

Dwg:
    PointsList(  0, 36 )
    Point(     -45,      60,     -45 )  ;0
    Point(     -45,     200,     -45 )  ;1
    Point(     -45,     320,     -40 )  ;2
    Point(     -45,     500,      00 )  ;3
    Point(     -45,     320,      40 )  ;4
    Point(     -45,     200,      45 )  ;5
    Point(     -45,      60,      45 )  ;6
    Point(     -45,     320,     300 )  ;7
    Point(     -45,     320,     450 )  ;8
    Point(     -45,     340,     450 )  ;9
    Point(     -45,     340,     300 )  ;10
    Point(     -45,     320,    -130 )  ;11
    Point(     -45,     350,    -130 )  ;12
    Point(     -45,     350,     -40 )  ;13
    Point(      45,      60,     -45 )  ;14
    Point(      45,     200,     -45 )  ;15
    Point(      45,     320,     -40 )  ;16
    Point(      45,     500,      00 )  ;17
    Point(      45,     320,      40 )  ;18
    Point(      45,     200,      45 )  ;19
    Point(      45,      60,      45 )  ;20
    Point(      45,     320,     300 )  ;21
    Point(      45,     320,     450 )  ;22
    Point(      45,     340,     450 )  ;23
    Point(      45,     340,     300 )  ;24
    Point(      45,     320,    -130 )  ;25
    Point(      45,     350,    -130 )  ;26
    Point(      45,     350,     -40 )  ;27
    Point(      55,      00,      55 )  ;28
    Point(     -55,      00,      55 )  ;29
    Point(     -55,      00,     -55 )  ;30
    Point(      55,      00,     -55 )  ;31
    Point(      55,      60,      55 )  ;32
    Point(     -55,      60,      55 )  ;33
    Point(     -55,      60,     -55 )  ;34
    Point(      55,      60,     -55 )  ;35

    GoIfVector( dessus,  32, 33, 34 )
    Call( socle )
    Call( struc )
    Return

dessus:
    Call( struc )
    Call( socle )
    Return

socle:
    If (SML_Socle == 0 )
        SurfaceColor( 0x00 )
    EndIf
    If (SML_Socle == 1 )
        SurfaceColor( 0x01 )
    EndIf
    If (SML_Socle == 2 )
        SurfaceColor( 0x02 )
    EndIf
    If (SML_Socle == 3 )
        SurfaceColor( 0x03 )
    EndIf
    If (SML_Socle == 4 )
        SurfaceColor( 0x04 )
    EndIf
    If (SML_Socle == 5 )
        SurfaceColor( 0x05 )
    EndIf
    If (SML_Socle == 6 )
        SurfaceColor( 0x06 )
    EndIf
    If (SML_Socle == 7 )
        SurfaceColor( 0x07 )
    EndIf
    If (SML_Socle == 8 )
        SurfaceColor( 0x08 )
    EndIf
    If (SML_Socle == 9 )
        SurfaceColor( 0x09 )
    EndIf

    Polygon_4( 32, 33, 29, 28 )  ; face verticale 
    Polygon_4( 33, 34, 30, 29 )  ; face verticale 
    Polygon_4( 34, 35, 31, 30 )  ; face verticale
    Polygon_4( 35, 32, 28, 31 )  ; face verticale
    Polygon_4( 35, 34, 33, 32 )  ; face horizontale
    Return

struc:
    If (SML_Struc == 0 )
        LineColor( 0x00 )
    EndIf
    If (SML_Struc == 1 )
        LineColor( 0x01 )
    EndIf
    If (SML_Struc == 2 )
        LineColor( 0x02 )
    EndIf
    If (SML_Struc == 3 )
        LineColor( 0x03 )
    EndIf
    If (SML_Struc == 4 )
        LineColor( 0x04 )
    EndIf
    If (SML_Struc == 5 )
        LineColor( 0x05 )
    EndIf
    If (SML_Struc == 6 )
        LineColor( 0x06 )
    EndIf
    If (SML_Struc == 7 )
        LineColor( 0x07 )
    EndIf
    If (SML_Struc == 8 )
        LineColor( 0x08 )
    EndIf
    If (SML_Struc == 9 )
        LineColor( 0x09 )
    EndIf
    ;structure mtallique
    MoveToPoint(  0  )
    LineToPoint(  1  )    
    LineToPoint(  2  )    
    LineToPoint(  3  )    
    LineToPoint(  4  )    
    LineToPoint(  5  )    
    LineToPoint(  6  )    

    MoveToPoint(  1  )
    LineToPoint(  5  )    
    LineToPoint(  2  )    
    LineToPoint(  4  )    

    MoveToPoint(  4  )
    LineToPoint(  7  )    
    LineToPoint(  8  )    
    LineToPoint(  9  )    
    LineToPoint( 10  )    
    LineToPoint(  4  )    

    MoveToPoint(  7  )
    LineToPoint( 10  )    
    LineToPoint(  3  )    
    LineToPoint( 12  )    

    MoveToPoint( 14  )
    LineToPoint( 15  )    
    LineToPoint( 16  )    
    LineToPoint( 17  )    
    LineToPoint( 18  )    
    LineToPoint( 19  )    
    LineToPoint( 20  )    

    MoveToPoint( 15  )
    LineToPoint( 19  )    
    LineToPoint( 16  )    
    LineToPoint( 18  )    

    MoveToPoint( 18  )
    LineToPoint( 21  )    
    LineToPoint( 22  )    
    LineToPoint( 23  )    
    LineToPoint( 24  )    
    LineToPoint( 18  )    

    MoveToPoint( 21  )
    LineToPoint( 24  )    
    LineToPoint( 17  )    
    LineToPoint( 26  )    

    MoveToPoint(  1  )
    LineToPoint( 15  )    

    MoveToPoint(  5  )
    LineToPoint( 19  )    

    MoveToPoint(  4  )
    LineToPoint( 18  )    

    MoveToPoint(  7  )
    LineToPoint( 21  )    

    MoveToPoint(  8  )
    LineToPoint( 22  )    

    MoveToPoint( 10  )
    LineToPoint( 24  )    

    MoveToPoint(  9  )
    LineToPoint( 23  )    

    MoveToPoint(  3  )
    LineToPoint( 17  )    

    MoveToPoint(  0  )
    LineToPoint(  5  )    

    MoveToPoint( 14  )
    LineToPoint( 19  )    

    If (SML_Subst == 0 )
        SurfaceColor( 0x00 )
    EndIf
    If (SML_Subst == 1 )
        SurfaceColor( 0x01 )
    EndIf
    If (SML_Subst == 2 )
        SurfaceColor( 0x02 )
    EndIf
    If (SML_Subst == 3 )
        SurfaceColor( 0x03 )
    EndIf
    If (SML_Subst == 4 )
        SurfaceColor( 0x04 )
    EndIf
    If (SML_Subst == 5 )
        SurfaceColor( 0x05 )
    EndIf
    If (SML_Subst == 6 )
        SurfaceColor( 0x06 )
    EndIf
    If (SML_Subst == 7 )
        SurfaceColor( 0x07 )
    EndIf
    If (SML_Subst == 8 )
        SurfaceColor( 0x08 )
    EndIf
    If (SML_Subst == 9 )
        SurfaceColor( 0x09 )
    EndIf
    ; counter-weight
    Polygon_4(  13, 12, 11,  2  )  ; face verticale droite
    Polygon_4(  16, 25, 26, 27  )  ; face verticale gauche
    Polygon_4(  12, 26, 25, 11  )  ; face verticale arriere
    Polygon_4(   2, 16, 27, 13  )  ; face verticale avant
    Polygon_4(  27, 26, 12, 13  )  ; face horizontale  haut
    Polygon_4(   2, 11, 25, 16  )  ; face horizontale bas
    Goto( rampe )

rampe:
    ;rampe suprieure clignotante claire la nuit
    GoIfOut( ObjReturn, Day_Time, 2, 4 )
    LineColor(  0x0F )
    DottedLine( -45, 500, 0,  45, 500, 0,  2 )
    Return
    
ObjReturn:
    Return

ObjEnd:
    ENDMACRO
