;! "Inclined hangar (textured) "
;? "Length: "=SML_Length
;? "Width: "=SML_Width
;? "Height: "=SML_Height
;? "Heading [HDG] "=SML_Heading
;? " Required scenery density to show (1-4) "=SML_Comp 
;? " Texture Smoothing (0-1)"=SML_Smooth
; by Alessandro Antonini

MACRO HangarInc1

Local ObjEnd, PCall, SCall, ObjReturn, Dwg, Inner, Outer, Ceiling

Area( SML_Lat, SML_Lon, 50 km, ObjEnd )
    GoIfOut(  ObjEnd, 0x0346, SML_Comp, 4 ) 
    PerspectiveCall( PCall  )
    ShadowCall( SCall  )
    Jump(  ObjEnd  )
    
PCall:
    Perspective
    
SCall:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 0.5 m, 0 )
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:     
    Pointslist( 1, 8 )     ; note: 40 mts. x 10 = about 124 x 24 feets
    Point( -( SML_Width / 2 ) ,  0 ,  ( SML_Length / 2 ) )
    Point(  ( SML_Width / 2 ) ,  0 ,  ( SML_Length / 2 ) )
    Point(  ( SML_Width / 2 ) ,  0 , -( SML_Length / 2 ) )
    Point( -( SML_Width / 2 ) ,  0 , -( SML_Length / 2 ) )
    
    Point( -( SML_Width / 2 ) , SML_Height+4 ,  ( SML_Length / 2 ) )
    Point(  ( SML_Width / 2 ) , SML_Height+4 ,  ( SML_Length / 2 ) )
    Point(  ( SML_Width / 2 ) , SML_Height , -( SML_Length / 2 ) )
    Point( -( SML_Width / 2 ) , SML_Height , -( SML_Length / 2 ) )

    Call( Ceiling )
    Call( Inner )
    Call( Outer )
    Return


inner:
    SurfaceColor( Grey )
    Polygon_4( 5, 6, 2, 1 )
    Polygon_4( 6, 7, 3, 2 )
    Polygon_4( 7, 8, 4, 3 )
    Polygon_4( 8, 5, 1, 4 )
    Return


outer:
    SurfaceColor( Grey )

    Texture( "a-obj-1", "r8" )
    If ( SML_Smooth == 1 )
        TextureSmoothOn
    EndIf

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  5, 252, 147 )     
        TexturePt(  6, 62,  147 )
        TexturePt(  7, 62,  114 )
        TexturePt(  8, 252, 114 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  1, 253,  97 ) 
        TexturePt(  2, 67,   97 )     
        TexturePt(  6, 67,   73 )     
        TexturePt(  5, 253,  73 )
    
    AdjustTexture
    TextureSmoothOn
    TexturePolygon( 4 )
        TexturePt(  2, 209, 191 )   
        TexturePt(  3, 162, 191 )   
        TexturePt(  7, 162, 157 )     
        TexturePt(  6, 209, 166 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  3, 253,  97 )    
        TexturePt(  4, 67,   97 )    
        TexturePt(  8, 67,   73 )    
        TexturePt(  7, 253,  73 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  4, 156, 191 )   
        TexturePt(  1, 109, 191 ) 
        TexturePt(  5, 109, 166 ) 
        TexturePt(  8, 156, 157 )
    Return
    If ( SML_Smooth == 1 )
        TextureSmoothOff
    EndIf

ceiling:
    SurfaceColor( LightGrey )
    Polygon_4( 8, 7, 6, 5 )
    Return
  
ObjEnd:
ENDMACRO
