;! " Textured building 4 floors, no hall "
;? " Scale "=SML_Scale
;? " Heading "=SML_Heading
;? " Altitude "=SML_Alt
;? " Minimum scenery density to show on (1-4) "=SML_Comp
;? " Texture Smoothing (0-1) "=SML_Smooth
; Converted by Alessandro Antonini (with permission)


MACRO TxtBld_2

Local ObjEnd, Pcall1, Scall1, Dwg, jour, nuit, ObjReturn

Area( SML_Lat, SML_Lon, 12 km, ObjEnd )
        
    GoIfOut(  ObjEnd, 0x0346, SML_Comp, 4 ) 
    PerspectiveCall( Pcall1  )
    ShadowCall( Scall1  )
    Jump( ObjEnd )

Pcall1:
    Perspective

Scall1:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    _FS5SCALE = (SML_Scale * 100) / (SML_Scale*SML_Scale)/100
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    PointsList(  0, 16 )
    Point(    30,     0,     10  )   ;0 
    Point(    30,     0,    -10  )   ;1 
    Point(    10,     0,     10  )   ;2 
    Point(    10,     0,    -10  )   ;3 
    Point(   -10,     0,     10  )   ;4 
    Point(   -10,     0,    -10  )   ;5 
    Point(   -30,     0,     10  )   ;6 
    Point(   -30,     0,    -10  )   ;7 
    Point(    30,    15,     10  )   ;8 
    Point(    30,    15,    -10  )   ;9 
    Point(    10,    15,     10  )   ;10
    Point(    10,    15,    -10  )   ;11
    Point(   -10,    15,     10  )   ;12
    Point(   -10,    15,    -10  )   ;13
    Point(   -30,    15,     10  )   ;14
    Point(   -30,    15,    -10  )   ;15

    GoIfOut( Jour, Day_Time, 2, 4)

nuit:
    Texture( "airpt006", "oav" )
    If (SML_SMooth == 1)
        TextureSmoothOn
    EndIf
    AdjustTexture
    TexturePolygon( 4 )                   ;faade est
        TexturePt(   1,  202,  27 )          
        TexturePt(   9,  202, 152 )
        TexturePt(   8,  252, 152 )
        TexturePt(   0,  252,  27 )
                
    AdjustTexture
    TexturePolygon( 4 )                   ;faade sud
        TexturePt(   3,  101,  27 )
        TexturePt(  11,  101, 152 )
        TexturePt(   9,  152, 152 )
        TexturePt(   1,  152,  27 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(   5,  101,  27 )
        TexturePt(  13,  101, 152 )
        TexturePt(  11,  152, 152 )
        TexturePt(   3,  152,  27 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(   7,  101,  27 )
        TexturePt(  15,  101, 152 )
        TexturePt(  13,  152, 152 )
        TexturePt(   5,  152,  27 )

    AdjustTexture
    TexturePolygon( 4 )                   ;faade ouest
        TexturePt(   6,  202,  27 )
        TexturePt(  14,  202, 152 )
        TexturePt(  15,  252, 152 )
        TexturePt(   7,  252,  27 )

    AdjustTexture
    TexturePolygon( 4 )                   ;faade nord
        TexturePt(   4,  101,  27 )
        TexturePt(  12,  101, 152 )
        TexturePt(  14,  152, 152 )
        TexturePt(   6,  152,  27 )

    AdjustTexture
    TexturePolygon( 4 )                
        TexturePt(   2,  101,  27 )
        TexturePt(  10,  101, 152 )
        TexturePt(  12,  152, 152 )
        TexturePt(   4,  152,  27 )

    AdjustTexture
    TexturePolygon( 4 )                   
        TexturePt(   0,  101,  27 )
        TexturePt(   8,  101, 152 )
        TexturePt(  10,  152, 152 )
        TexturePt(   2,  152,  27 )

    If (SML_SMooth == 1)
        TextureSmoothOff
    EndIf

    SurfaceColor( SandLight )
    Polygon_4(  8,  9, 15, 14 )  ;toit
    Return

jour:
    Texture( "airpt006", "oav" )
    If (SML_SMooth == 1)
        TextureSmoothOff
    EndIf
    AdjustTexture
    TexturePolygon( 4 )                   ;faade est
        TexturePt(   1,  202,  27 )          
        TexturePt(   9,  202, 152 )
        TexturePt(   8,  252, 152 )
        TexturePt(   0,  252,  27 )

    AdjustTexture
    TexturePolygon( 4 )                   ;faade sud
        TexturePt(   3,    0,  27 )
        TexturePt(  11,    0, 152 )
        TexturePt(   9,   51, 152 )
        TexturePt(   1,   51,  27 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(   5,    0,  27 )
        TexturePt(  13,    0, 152 )
        TexturePt(  11,   51, 152 )
        TexturePt(   3,   51,  27 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(   7,    0,  27 )
        TexturePt(  15,    0, 152 )
        TexturePt(  13,   51, 152 )
        TexturePt(   5,   51,  27 )

    AdjustTexture
    TexturePolygon( 4 )                   ;faade ouest
        TexturePt(   6,  202,  27 )
        TexturePt(  14,  202, 152 )
        TexturePt(  15,  252, 152 )
        TexturePt(   7,  252,  27 )

    AdjustTexture
    TexturePolygon( 4 )                   ;faade nord
        TexturePt(   4,    0,  27 )
        TexturePt(  12,    0, 152 )
        TexturePt(  14,   51, 152 )
        TexturePt(   6,   51,  27 )

    AdjustTexture
    TexturePolygon( 4 )                
        TexturePt(   2,    0,  27 )
        TexturePt(  10,    0, 152 )
        TexturePt(  12,   51, 152 )
        TexturePt(   4,   51,  27 )

    AdjustTexture
    TexturePolygon( 4 )                
        TexturePt(   0,    0,  27 )
        TexturePt(   8,    0, 152 )
        TexturePt(  10,   51, 152 )
        TexturePt(   2,   51,  27 )

    If (SML_SMooth == 0)
        TextureSmoothOff
    EndIf


    SurfaceColor( SandLight )
    Polygon_4(  8,  9, 15, 14 )  ;toit
    Return

ObjEnd:
ENDMACRO
