;! " Vor Antenna "
;? " Heading "=SML_Heading
;? " Altitude "=SML_Alt
; Converted by Alessandro Antonini

Macro VorAnt

		Local DR0, DR1, DR2, RR0, ObjReturn, ObjEnd

		Area(  SML_Lat, SML_Lon, 22km, ObjEnd )
		PerspectiveCall( DR0 )
    Goto(  ObjEnd  )

DR0:
    Perspective
    ReferencePoint(  SML_Lat, SML_Lon,  DR2,  1, SML_Alt )
    _FS5SCALE = 7
    Rotate(  RR0,  0, 0, SML_heading  )

DR2:
    Return

RR0:
   	PointsList( 0, 28 )
   	Point (   0,   0,  70	 ) ; 1
   	Point (  27,   0,  65  ) ; 2
   	Point (  50,   0,  50  ) ; 3
   	Point (  65,   0,  27  ) ; 4
   	Point (  70,   0,   0  ) ; 5
   	Point (  65,   0, -27  ) ; 6
   	Point (  50,   0, -50  ) ; 7
   	Point (  27,   0, -65  ) ; 8
   	Point (   0,   0, -70  ) ; 9
   	Point ( -27,   0, -65  ) ; 10
   	Point ( -50,   0, -50  ) ; 11
   	Point ( -65,   0, -27  ) ; 12
   	Point ( -70,   0,   0  ) ; 13
   	Point ( -65,   0,  27  ) ; 14
   	Point ( -50,   0,  50  ) ; 15
   	Point ( -27,   0,  65  ) ; 16

   	Point ( -20,   0, -20  ) ; 17
   	Point ( -20,   0,  20  ) ; 18
   	Point (  20,   0,  20  ) ; 19
   	Point (  20,   0, -20  ) ; 20

   	Point ( -20,  40, -20  ) ; 21
   	Point ( -20,  40,  20  ) ; 22
   	Point (  20,  40,  20  ) ; 23
   	Point (  20,  40, -20  ) ; 24

   	Point ( -10,   0,  20  ) ; 25
   	Point (  10,   0,  20  ) ; 26
   	Point ( -10,  30,  20  ) ; 27
   	Point (  10,  30,  20  ) ; 28


   SurfaceColour( Grey  )
   Polygon_17( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0 )

    SurfaceColour(  LightGrey  )
        Polygon_4( 17, 21, 20, 16 )
        Polygon_4( 18, 22, 21, 17 )
        Polygon_4( 19, 23, 22, 18 )
        Polygon_4( 16, 20, 23, 19 )

    SurfaceColour(  White  )
        Polygon_4( 20, 21, 22, 23 )

    SurfaceColour(  DarkGrey )
        Polygon_4( 25, 27, 26, 24 )

    LineColor(  Red  )
        MoveTo(  0, 40, 0  )
        LineTo(  0, 60, 0  )

    LineColor(  White )
        MoveTo(  0, 60, 0  )
        LineTo(  0, 80, 0  )

    LineColor(  Red  )
        MoveTo(  0, 80, 0  )
        LineTo(  0, 100, 0 )

    LineColour(  White  )
        MoveTo(  0, 100, 0  )
        LineTo(  0, 120, 0  )

    LineColour(  Red  )
        MoveTo(  0, 120, 0  )
        LineTo(  0, 140, 0  )

    LineColor(  White  )
        MoveTo(  10, 140,  20  )
        LineTo(  10, 140, -20  )
        MoveTo( -10, 140,  20  )
        LineTo( -10, 140, -20  )
        MoveTo( -10, 140,   0  )
        LineTo(  10, 140,   0  )

        GoIfOut (ObjReturn, Day_Time, 2, 4)
        LineColor(  NightWhite  )
				Intensity( 64000 )
        Dot(  0, 140, 0  )
        Dot(  0, 100, 0  )
        Dot(  0, 60, 0   )
        Return
        
ObjReturn:
   Return

ObjEnd:
EndMacro
