@ECHO OFF
REM This is the commented batch file from the 
REM OPUS 1.79 SYSOP OPERATIONS MANUAL

<Drive>
CD <Base_Dir>
REM make sure we are where we think we are

REM X00 B,0,38400 T=8192 R=4096 F=12
REM XU CAPTURE
REM load the comms fossil and make sure it has
REM control of the comms interrupt 

:MODEM
SET OPUS=BBS
REM SET TZ=UTC-10
REM set up some environment variables, especially the
REM timezone (tz) so that opus can keep track of events

REM AT COM1: s2=255s7=50s50=0s52=1s53=1s54=4q0v1
REM AT COM1: s0=0s9=12s51=5s58=2s66=1s68=2s90=1e0x3&w
REM initialise the Trailblazer PEP/V32 modem

REM OPUSDATE + NERF ** Opus Online ** >> C:\opus\opus.log
REM make a log entry
                 
:OPUS
CHAT 25
OPUS BBS 
REM load the chat fossil and run opus using the bbs
REM parameter file produced from the bbs.ctl file by nacl

:TEST
IF ERRORLEVEL 255 GOTO ERROR255
IF ERRORLEVEL 16 GOTO MASH
IF ERRORLEVEL 12 GOTO DOS
IF ERRORLEVEL 9 GOTO OPUS
IF ERRORLEVEL 4 GOTO ERROR4
IF ERRORLEVEL 3 GOTO ERROR3
IF ERRORLEVEL 2 GOTO ERROR2
IF ERRORLEVEL 1 GOTO OFFLINE
GOTO ERROR0
REM test for various dos errorlevels so that
REM we can take the appropriate action

:MASH
REM OMMM
GOTO OPUS
REM run oMMM to bundle mail and then rerun opus

:DOS
REM OPUSDATE # NERF Sysop dropped to DOS >> c:\opus\opus.log
REM log that sysop is heading for dos

REM NEWBAUD C:\OPUS\LASTUS00.DAT
REM IF ERRORLEVEL 96 GOTO REMOTE_DROP
REM IF ERRORLEVEL 48 GOTO REMOTE_DROP
REM IF ERRORLEVEL 24 GOTO REMOTE_DROP
REM IF ERRORLEVEL 12 GOTO REMOTE_DROP
REM IF ERRORLEVEL 3 GOTO REMOTE_DROP
REM IF ERRORLEVEL 0 GOTO LOCAL_DROP
REM newbaud reads the baud rate from lastus00.dat and exits
REM with an errorlevel = baud/100 so we can check if the
REM sysop logged on from the keyboard

:REMOTE_DROP
REM FSU 1 ON +
REM CTTY COM1:
REM ECHO ## Type EXIT to return to Opus ##
REM ECHO ** Carrier Monitoring in effect **
REM sysop must be logged on remotely so
REM turn on modem carrier watchdog and
REM redirect screen and keybaord to the
REM comms port

:LOCAL_DROP
COMMAND
REM we are here either because we fell through from
REM remote_drop, or the sysop logged on from the 
REM keyboard 

:RETURN
REM C:
REM CD C:\OPUS
REM FSU 1 OFF -
REM OPUSDATE # NERF Sysop returned from DOS >> c:\opus\opus.log
REM CTTY CON
REM make sure we are in the opus directory when returning
REM from dos, turn off carrier watchdog, log sysop's return
REM and cancel redirection of screen and keyboard

OPUS BBS -O
GOTO TEST
REM restart opus with the relog option and loop back to
REM errorlevel tests NOTE: after relog exit is set to 9
REM so that after the sysop logs off opus will exit with
REM errorlevel 9 and be rerun without the -o relog switch

:ERROR0
REM OPUSDATE ! NERF Errorlevel not detected in TEST >> c:\opus\opus.log
GOTO OPUS
REM log error and rerun opus

:ERROR2
REM OPUSDATE ! NERF Opus Errorlevel 2: Recycling >> c:\opus\opus.log
GOTO OPUS
REM log error and rerun opus

:ERROR3
REM OPUSDATE ! NERF Opus Errorlevel 3: Halting >> c:\opus\opus.log
GOTO OFFLINE
REM log error and halt

:ERROR4
REM OPUSDATE ! NERF Opus Errorlevel 4: Recycling >> c:\opus\opus.log
GOTO OPUS
REM log error and rerun opus

:ERROR255
REM OPUSDATE ! NERF MSC Stack Error: Recycling >>  c:\opus\opus.log
GOTO OPUS
REM log error and rerun opus

:OFFLINE
REM OPUSDATE : NERF ** Sentry Taken Offline ** >> c:\opus\opus.log
ECHO ON
REM log system taken offline

