/*
 * OCLIENT.H
 *
 * Public include file for functions and structures that an OLE client
 * application can use to treat the code in the modules listed below
 * as a library.
 *
 *     OLECLI.C
 *     OLEOBJ.C
 *     OLESTREA.C
 *     OLEVTBL.C
 *
 * Copyright(c) Microsoft Corp. 1992 All Rights Reserved
 *
 */



/*
 * OLE-Specific string identifiers.  These are defined first so
 * we can define an array of pointers to these strings and load
 * then when a DOCUMENT structure is allocated.  The PSZOLE macro
 * returns a string pointer for the given index.
 */

#define IDS_OLEFIRST            1024
#define IDS_NATIVE              IDS_OLEFIRST+0
#define IDS_OWNERLINK           IDS_OLEFIRST+1
#define IDS_OBJECTLINK          IDS_OLEFIRST+2
#define IDS_STDFILEEDITING      IDS_OLEFIRST+3
#define IDS_AUTOMATIC           IDS_OLEFIRST+4
#define IDS_MANUAL              IDS_OLEFIRST+5
#define IDS_UNAVAILABLE         IDS_OLEFIRST+6
#define IDS_STATIC              IDS_OLEFIRST+7
#define IDS_PACKAGE             IDS_OLEFIRST+8
#define IDS_UPDATELINKS0        IDS_OLEFIRST+9
#define IDS_UPDATELINKS1        IDS_OLEFIRST+10
#define IDS_UPDATELINKS2        IDS_OLEFIRST+11
#define IDS_CHANGELINK          IDS_OLEFIRST+12
#define IDS_CHANGELINKS1        IDS_OLEFIRST+13
#define IDS_CHANGELINKS2        IDS_OLEFIRST+14
#define IDS_INSERTTITLE         IDS_OLEFIRST+15
#define IDS_NOINSERT            IDS_OLEFIRST+16
#define IDS_VERBEDIT            IDS_OLEFIRST+17
#define IDS_OBJECT              IDS_OLEFIRST+18
#define IDS_OBJECTBUSY          IDS_OLEFIRST+19
#define IDS_OLEERROR            IDS_OLEFIRST+20
#define IDS_OLEERRORMSG         IDS_OLEFIRST+21
#define IDS_UPDATEMSG           IDS_OLEFIRST+22
#define IDS_OLELAST             IDS_OLEFIRST+23

#define COLESTRINGS             (IDS_OLELAST-IDS_OLEFIRST)
#define CCHOLESTRINGMAX         80


/*
 * Macro to reference a string through rgpszOLE given an index above.
 * Depends on IDS_OLEFIRST being the first string in a sequential list.
 */
#define PSZOLE(i) rgpszOLE[i-IDS_OLEFIRST]


//Globals specific to OLE code.
extern char NEAR *rgpszOLE[COLESTRINGS];




/*
 * Definitions for OLE dialogs.  If ID_NULL is not defined we'll
 * define it ourselves.
 */

#define IDD_INSERTOBJECT        1024
#define IDD_LINKS               1025
#define IDD_BADLINKS            1026

#define ID_OBJECTLIST           1024
#define ID_LINKLIST             1025
#define ID_UPDATEAUTO           1026
#define ID_UPDATEMANUAL         1027
#define ID_UPDATENOW            1028
#define ID_CANCELLINK           1029
#define ID_CHANGELINK           1030
#define ID_ICONEX               1031
#define ID_LINKS                1032


#ifndef ID_NULL
#define ID_NULL                 -1
#endif



//File-related string lengths.
#define CCHPATHMAX              256
#define CCHFILENAMEMAX          15




/*
 * Message processing function necessary to use a message loop within
 * the OLE code where we do not have a window handle and accelerator
 * table available.
 */

typedef BOOL (FAR PASCAL *LPFNMSGPROC)(LPMSG);


/*
 * Cheapo stream structure for storing objects directly in applcation files.
 */

typedef struct
    {
    LPOLESTREAMVTBL     pvt;            //Standard
    HANDLE              hFile;          //File handle we need in methods.
    } STREAM;


typedef STREAM FAR *LPSTREAM;
#define CBSTREAM sizeof(STREAM)




/*
 * The DOCUMENT structure for this OLE client application is NOT the
 * OLECLIENT structure.  OLECLIENT is reflected in the OBJECT structure
 * as we use one OLECLIENT structure for each object.  This DOCUMENT
 * structure simply holds variables that apply to a document that
 * holds one or more objects.
 */

typedef struct _DOCUMENT
    {
    LPOLECLIENTVTBL     pvt;            //Stores the global VTBL for all objects.
    LHCLIENTDOC         lh;             //Required for later OLE calls.
    ATOM                aCaption;       //Application name.
    ATOM                aFile;          //Document name.
    LPFNMSGPROC         pfnMsgProc;     //Message translate/dispatch function.
    LPFNMSGPROC         pfnBackProc;    //Background process function.
    LPSTREAM            pStream;        //Pointer to our document STREAM

    HWND                hWnd;           //HWND of document window.

    WORD                cObjects;       //Number of objects in the list.
    struct _OBJECT FAR *pObjFirst;      //Pointer to start of OBJECT list.
    struct _OBJECT FAR *pObjLast;       //Pointer to end of OBJECT list.

    WORD                cfNative;       //OLE Clipboard formats.
    WORD                cfOwnerLink;
    WORD                cfObjectLink;

    HWND                hList;          //Listbox handle for use in Links dialog.
    HWND                cxList;         //Tab width of the links dialog.
    WORD                cLinks;         //Number of links we load from a file.
    WORD                cWait;          //Number of objects awaiting release.

    /*
     * In the constructor for this structure we allocate a piece of
     * global memory for scratch work.  This prevents us from having
     * to allocate scratch memory over and over again, especially when
     * working with the links dialog where be build and rebuild listbox
     * strings.
     *
     * DO NOT depend on integrety of these strings across calls into
     * the OLE helper functions referenced in this file unless you
     * first check the sources:  HACK:  Make a list of fn's using them.
     */

    HANDLE              hData;          //Global handle to scratch area.
    LPSTR               pszData1;       //Pointers to blocks in hData
    LPSTR               pszData2;       //each containing CBSCRATCH
    LPSTR               pszData3;       //bytes.
    } DOCUMENT;

typedef DOCUMENT FAR *LPDOCUMENT;
#define CBDOCUMENT sizeof(DOCUMENT)

#define CBSCRATCH   1024
#define CSCRATCH    3




/*
 * The OBJECT structure for this application acts in place of the
 * OLECLIENT for each embedded or linked object.  The framework
 * of allocating and manipulating objects is centered around this
 * data structure, so you are free to change or add to it as you
 * see fit.
 */

typedef struct _OBJECT
    {
    LPOLECLIENTVTBL     pvt;            //Lets us use this as an OLECLIENT.
    LPOLEOBJECT         pObj;           //Identifies the object in OLECLI
    BOOL                fRelease;       //Released flag.
    BOOL                fOpen;          //Was this object activated?
    struct _OBJECT FAR *pPrev;          //Previous and next OBJECTs in
    struct _OBJECT FAR *pNext;          //the object list.
    LPDOCUMENT          pDoc;           //Parent document.
    ATOM                aName;          //Name of object.
    ATOM                aClass;         //Classname of the object.
    ATOM                aLink;          //Path of linked document.
    ATOM                aSel;           //Selection information.
    DWORD               dwType;         //Object type from OleQueryType
    OLEOPT_UPDATE       dwLink;         //Type of link, auto, manual, or static
    BOOL                fNoMatch;       //Marks the object when updating links.
    LPOLEOBJECT         pObjUndo;       //Clone OLEOBJECT for undo usage.
    BOOL                fUndoOpen;      //Indicates if the cloned object is open.
    BOOL                fLinkChange;    //Indicates modification in Links dialog.
    HANDLE              hData;          //App-defined data.
    } OBJECT;


typedef OBJECT FAR *LPOBJECT;
#define CBOBJECT sizeof(OBJECT)





/*
 * Defined for internal use in the Links dialog and when updating links.
 * OLE.H does not define values for unavailable and static link update
 * options in its OLEOPT_UPDATE type.
 */

#define OLEUPDATE_UNAVAILABLE   -2
#define OLEUPDATE_STATIC        -1


/*
 * This type is defined for the convenience of PVtblClientAllocate,
 * so it can typecast a FARPROC to the correct type in the OLECLIENTVTBL.
 */

typedef int (FAR PASCAL *LPCLIENTCALLBACK)(LPOLECLIENT, OLE_NOTIFICATION, LPOLEOBJECT);


/*
 * The parameter types for this prototype match the OLE.H definitions
 * since we will assign a pointer of this type to the LPOLESTREAMVTBL.
 * This should not be used to typecast an application-specific method
 * as those defined above, or else you'll see warnings about different
 * parameter types.
 */

typedef DWORD (FAR PASCAL *LPSTREAMMETHOD)(LPOLESTREAM, LPSTR, DWORD);




/*
 * Enumeration function types for FObjectsEnumerate and FLinksEnumerate
 */

typedef BOOL (FAR PASCAL *LPFNOBJECTENUM)(LPDOCUMENT, LPOBJECT, DWORD);
typedef BOOL (FAR PASCAL *LPFNLINKENUM)(HWND, WORD, LPDOCUMENT, LPOBJECT, DWORD);

//Selection types for FLinksEnumerate

#define ENUMLINK_SELECTED       0
#define ENUMLINK_UNSELECTED     1
#define ENUMLINK_ALL            2



//Windows.h leaves this out
typedef BOOL FAR *LPBOOL;


/*
 * Function prototypes.
 */

//OLEDOC.C
LPDOCUMENT      FAR PASCAL PDocumentAllocate(LPBOOL, HANDLE, LPSTR, FARPROC, FARPROC, FARPROC);
LPDOCUMENT      FAR PASCAL PDocumentFree(LPDOCUMENT);
BOOL            FAR PASCAL FDocumentFileSet(LPDOCUMENT, LPSTR);
void            FAR PASCAL PDocumentMsgProcSet(LPDOCUMENT, LPFNMSGPROC);
void            FAR PASCAL PDocumentBackgroundProcSet(LPDOCUMENT, LPFNMSGPROC);
HANDLE              PASCAL HLoadOLEStrings(HANDLE);


//OLEINS.C
LPOBJECT        FAR PASCAL PObjectInsertDialog(HWND, HANDLE, LPDOCUMENT, LPSTR);
BOOL            FAR PASCAL InsertObjectProc(HWND, WORD, WORD, LONG);


//OLELIB.C
BOOL            FAR PASCAL FFileDialog(HWND, HANDLE, LPSTR, LPSTR, LPSTR, LPSTR, BOOL);
LPSTR           FAR PASCAL PszFileFromPath(LPSTR);
LPSTR           FAR PASCAL PszExtensionFromFile(LPSTR);
LPSTR           FAR PASCAL PszWhiteSpaceScan(LPSTR, BOOL);
DWORD           FAR PASCAL DwReadHuge(WORD, LPVOID, DWORD);
DWORD           FAR PASCAL DwWriteHuge(WORD, LPVOID, DWORD);
void            FAR PASCAL RectConvertMappings(LPRECT, WORD, WORD);


//OLELINK1.C
BOOL            FAR PASCAL FOLELinksEdit(HWND, HANDLE, LPDOCUMENT);
BOOL            FAR PASCAL LinksProc(HWND, WORD, WORD, LONG);
BOOL            FAR PASCAL FEnumLinksInit(LPDOCUMENT, LPOBJECT, DWORD);
BOOL            FAR PASCAL FChangeLinks(HWND, LPDOCUMENT);
BOOL            FAR PASCAL FLinksEnumerate(HWND, LPDOCUMENT, LPFNLINKENUM, WORD, DWORD);
BOOL            FAR PASCAL FEnumOptionChange(HWND, WORD, LPDOCUMENT, LPOBJECT, DWORD);
BOOL            FAR PASCAL FEnumLinkUpdate(HWND, WORD, LPDOCUMENT, LPOBJECT, DWORD);
BOOL            FAR PASCAL FEnumLinkCancel(HWND, WORD, LPDOCUMENT, LPOBJECT, DWORD);
BOOL            FAR PASCAL FEnumLinkChange(HWND, WORD, LPDOCUMENT, LPOBJECT, DWORD);
BOOL            FAR PASCAL FEnumLinkFind(HWND, WORD, LPDOCUMENT, LPOBJECT, DWORD);
BOOL            FAR PASCAL FEnumLinksUndo(HWND, WORD, LPDOCUMENT, LPOBJECT, DWORD);
BOOL            FAR PASCAL FEnumLinksAccept(HWND, WORD, LPDOCUMENT, LPOBJECT, DWORD);


//OLELINK2.C
void            FAR PASCAL EnableLinkButtons(HWND, HWND);
WORD            FAR PASCAL CchLinkStringCreate(LPSTR, LPDOCUMENT, LPOBJECT);
WORD            FAR PASCAL CchTextLimit(LPSTR, HDC, WORD);
void            FAR PASCAL LinkStringChange(HWND, WORD, LPSTR);


//OLELOAD.C
BOOL            FAR PASCAL FObjectAutoLinkUpdate(LPDOCUMENT, LPOBJECT);
BOOL            FAR PASCAL FOLELinksUpdate(HWND, HANDLE, LPDOCUMENT);
BOOL            FAR PASCAL FEnumUpdate(LPDOCUMENT, LPOBJECT, DWORD);
BOOL            FAR PASCAL LinksUnavailableProc(HWND, WORD, WORD, LONG);


//OLEMENU.C
void            FAR PASCAL MenuOLEClipboardEnable(HMENU, LPDOCUMENT, LPWORD);
BOOL            FAR PASCAL FEnumOLEPaste(LPDOCUMENT, LPOBJECT, DWORD);
void            FAR PASCAL MenuOLEVerbAppend(HMENU, WORD, WORD, LPDOCUMENT, LPOBJECT);


//OLEOBJ.C
LPOBJECT        FAR PASCAL PObjectAllocate(LPBOOL, LPDOCUMENT);
LPOBJECT        FAR PASCAL PObjectInitialize(LPOBJECT, LPDOCUMENT);
LPOBJECT        FAR PASCAL PObjectFree(LPDOCUMENT, LPOBJECT);
BOOL            FAR PASCAL FObjectsEnumerate(LPDOCUMENT, LPFNOBJECTENUM, DWORD);
BOOL            FAR PASCAL FObjectPaint(HDC, LPRECT, LPOBJECT);
BOOL            FAR PASCAL FObjectRectSet(LPDOCUMENT, LPOBJECT, LPRECT, WORD);
BOOL            FAR PASCAL FObjectRectGet(LPOBJECT, LPRECT, WORD);
BOOL            FAR PASCAL FObjectDataGet(LPOBJECT, WORD, LPSTR);
BOOL            FAR PASCAL FObjectDataSet(LPDOCUMENT, LPOBJECT, WORD, LPSTR);
BOOL            FAR PASCAL FOLEReleaseWait(BOOL, LPDOCUMENT, LPOBJECT);
OLESTATUS       FAR PASCAL OsError(OLESTATUS, LPDOCUMENT, LPOBJECT, BOOL);

//OLESTREA.C
LPSTREAM        FAR PASCAL PStreamAllocate(LPBOOL, HANDLE, FARPROC, FARPROC);
LPSTREAM        FAR PASCAL PStreamFree(LPSTREAM);
DWORD           FAR PASCAL StreamGet(LPSTREAM, LPBYTE, DWORD);
DWORD           FAR PASCAL StreamPut(LPSTREAM, LPBYTE, DWORD);


//OLEVTBL.C
LPOLECLIENTVTBL FAR PASCAL PVtblClientAllocate(LPBOOL, HANDLE, FARPROC);
LPOLECLIENTVTBL FAR PASCAL PVtblClientFree(LPOLECLIENTVTBL);
LPOLESTREAMVTBL FAR PASCAL PVtblStreamAllocate(LPBOOL, HANDLE, FARPROC, FARPROC);
LPOLESTREAMVTBL FAR PASCAL PVtblStreamFree(LPOLESTREAMVTBL);
