/*
 * INIT.C
 *
 * Application (not OLE) specific initialization code.
 *
 * Copyright(c) Microsoft Corp. 1992 All Rights Reserved
 *
 */

#include <windows.h>
#include <ole.h>
#include "oclient.h"
#include "blackbox.h"
#include "patron.h"



/*
 * FApplicationInit
 *
 * Purpose:
 *  All application specific initialization including loading
 *  the stringtable, registering window classes, and calling any
 *  OLE specific initialziation code.
 *
 * Parameters:
 *  pGlob           LPGLOBALS to global variable block.
 *  hPrevInstance   HANDLE to the previous application instance, if any.
 *
 * Return Value:
 *  BOOL            TRUE if everything succeeds, FALSE otherwise.
 *                  If FALSE is returned, allocated memory and objects
 *                  are not necessarily freed.  The caller should then
 *                  use the FApplicationExit function to perform cleanup.
 */

BOOL FAR PASCAL FApplicationInit(LPGLOBALS pGlob, HANDLE hPrevInstance)
    {
    LPSTR           psz;
    LPSTR           pszT;
    BOOL            fTemp;  //For OLE, PDocumentAllocate

    /*
     * InitApp allocates local memory for strings. WinMain must free.
     * If this fails, we should quit BEFORE we register any classes
     * or do anything else to suck up USER or GDI resources.
     */
    pGlob->hMemStrings=HLoadAppStrings(pGlob->hInst);

    if (NULL==pGlob->hMemStrings)
        return FALSE;

    //Classes are only registered if hPrevInstance is NULL.
    if (!FClassRegister(pGlob, hPrevInstance))
        {
        LocalFree(pGlob->hMemStrings);
        return FALSE;
        }

    /*
     * If there is something on the command line, copy it to the szFile
     * buffer in pGlob.
     */

    psz=pGlob->pszCmdLine;

    //Skip whitespace to the beginning of the first item in the command line.
    psz=PszWhiteSpaceScan(psz, TRUE);

    if (0!=*psz)
        {
        /*
         * If there's something here, find the end (next whitespace) and
         * null-terminate it.  The copy it into the filename buffer.
         */
        pszT=PszWhiteSpaceScan(psz, FALSE);
        *pszT=0;

        lstrcpy(pGlob->szFile, psz);
        }


    /*
     * OLE:  Create a DOCUMENT structure.  This has the effect of
     * initializing VTBLs and allocating other structures.  Note that
     * we do not register any documents until later when we atually
     * open one.  Note that we pass ClientCallback so the constructor
     * can put it in the OLECLIENTVTBL and the default StreamGet and
     * StreamPut methods (OLESTREA.C) so the constructor can put them
     * in the OLESTREAMVTBL referenced through this document.
     */

    pDoc=PDocumentAllocate(&fTemp, pGlob->hInst, rgpsz[IDS_CAPTION],
                           (FARPROC)ClientCallback, (FARPROC)StreamGet,
                           (FARPROC)StreamPut);


    //If fTemp is FALSE, we'll call FApplicationExit which frees pDoc.
    return fTemp;
    }




/*
 * FClassRegister
 *
 * Purpose:
 *  Registers classes used by the application:  "Patron" the main
 *  window.
 *
 * Parameters:
 *  pGlob           LPGLOBALS to the global variables block.
 *  hPrevInstance   HANDLE of any previous application instance.
 *
 * Return Value:
 *  BOOL            TRUE if all classes are successfully registered
 *                  (or if hPrevInstance is non-NULL).  FALSE is
 *                  any registration fails.
 *
 */

BOOL FAR PASCAL FClassRegister(LPGLOBALS pGlob, HANDLE hPrevInstance)
    {
    WNDCLASS        wc;

    if (hPrevInstance)
        return TRUE;

    /*
     * Note that we do not need to unregister classes on a failure
     * since that's part of automatic app cleanup.
     */
    wc.style         = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc   = PatronWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = pGlob->hInst;
    wc.hIcon         = LoadIcon(pGlob->hInst, "Icon");
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = COLOR_APPWORKSPACE + 1;
    wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU);
    wc.lpszClassName = rgpsz[IDS_CLASSPATRON];

    if (!RegisterClass(&wc))
        return FALSE;


    wc.style         = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc   = BlackBoxWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = CBWNDEXTRABLACKBOX;
    wc.hInstance     = pGlob->hInst;
    wc.hIcon         = NULL;
    wc.hCursor       = LoadCursor(NULL, IDC_CROSS);
    wc.hbrBackground = COLOR_WINDOW + 1;
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = rgpsz[IDS_CLASSBLACKBOX];

    if (!RegisterClass(&wc))
        return FALSE;

    return TRUE;
    }




/*
 * HLoadAppStrings
 *
 * Purpose:
 *  Allocates FIXED local memory and reads the applications
 *  string resources into that memory.  Each string's pointer
 *  is available with rgpsz[i] where i is the ID value of the
 *  string.  The strings must have sequential IDs.
 *
 * Parameters:
 *  hInst           HANDLE to the application instance.
 *
 * Return Value:
 *  HANDLE          Handle to the local memory.  NULL if memory could
 *                  not be allocated.
 */

HANDLE FAR PASCAL HLoadAppStrings(HANDLE hInst)
    {
    HANDLE      hMem;
    char NEAR   *pch;
    WORD        cchUsed=0;
    WORD        cch;
    short       i;

    /*
     * Allocate memory and load strings.  NOTE!  The LPTR style
     * specifies FIXED memory.  This should not be a big deal
     * since this is an early allocation into the local heap.
     * But it should be watched if the number of strings becomes
     * large.
     */
    hMem=LocalAlloc(LPTR, CSTRINGS*CCHSTRINGMAX);

    if (hMem==NULL)
        return (HANDLE)NULL;

    /*
     * This operation is only valid for FIXED memory.  Otherwise use
     * LocalLock.
     */
    pch=(char *)hMem;


    /*
     * Load the strings into the memory and retain the specific
     * pointer to that string.
     */
    for (i=0; i<CSTRINGS; i++)
        {
        cch=LoadString(hInst, i, (LPSTR)(pch+cchUsed), CCHSTRINGMAX-1);
        rgpsz[i]=(char *)(pch+cchUsed);

        /*
         * One is added to cch to include a NULL.  The memory was ZEROINITed
         * on allocation so by skipping a byte we get the NULL.
         */
        cchUsed +=cch+1;
        }

    /*
     * We are assuming that no string is over CCHSTRINGMAX, and therefore
     * we did not use all the allocated memory.  Therefore LocalReAlloc
     * will only SHRINK the block, never expand it.  So if it fails, we
     * don't care--all the strings are still there, we just wasted some
     * space.
     */
    LocalReAlloc(hMem, cchUsed+1, LPTR);

    return hMem;
    }
