/*
 * EXIT.C
 *
 * Functions for final cleanup of the application.
 *
 * Copyright(c) Microsoft Corp. 1992 All Rights Reserved
 *
 */

#include <windows.h>
#include <ole.h>
#include "oclient.h"
#include "patron.h"



/*
 * FApplicationExit
 *
 * Purpose:
 *  Provides final cleanup of any objects and other actions that
 *  must occur at closing time.
 *
 * Parameters:
 *  pGlob           LPGLOBALS to global variable block.
 *
 * Return Value:
 *  BOOL            TRUE if everything succeeds, FALSE otherwise.
 */

BOOL FAR PASCAL FApplicationExit(LPGLOBALS pGlob)
    {
    BOOL        fRet=TRUE;

    //Free the stringtable.
    if (NULL!=pGlob->hMemStrings)
        LocalFree(pGlob->hMemStrings);

    //Free the DOCUMENT we allocated.
    PDocumentFree(pDoc);
    return fRet;
    }
