/*
 * BLACKBOX.H
 *
 * Definitions and prototypes for the BlackBox window.  Note that
 * OLE affects us but having another field in the BLACKBOX structure,
 * adding 3 messages, and adding additional parameters to the Create
 * function.
 *
 * The BlackBox window is somewhat tied to the implementation of Patron.
 *
 *
 * Copyright(c) Microsoft Corp. 1992 All Rights Reserved
 */


/*
 * BlackBox window structure referenced through a handle in the
 * window extra bytes.
 */

typedef struct
    {
    LPOBJECT        pObj;           //OLE:  OBJECT structure for this window.
    BOOL            fOpen;          //OLE:  Indicates if the object is activated.
    BOOL            fUserResize;    //Indicates a WM_SIZE caused by user action.
    RECT            rc;             //Rectangle occupied by this window.
    POINT           ptDrag;         //Dragging click point.
    BOOL            fDrag;          //Flag indicating dragging.
    } BLACKBOX;

typedef BLACKBOX *PBLACKBOX;
typedef BLACKBOX FAR *LPBLACKBOX;
#define CBBLACKBOX sizeof(BLACKBOX)


/*
 * Blackbox file structure.  Also used to pass initial values to
 * HBlackBoxCreate.
 */

typedef struct
    {
    RECT        rc;             //Rectangle of object
    WORD        wID;            //ID value of object
    char        szName[40];     //Persistent name of object.
    DWORD       cbObject;       //Size of OLE object--just for demonstration
    } FILEOBJECT;

typedef FILEOBJECT FAR *LPFILEOBJECT;
#define CBFILEOBJECT sizeof(FILEOBJECT)




#define CBWNDEXTRABLACKBOX  sizeof(HANDLE)
#define GWW_BLACKBOXHMEM    0


//Window-specific messages
#define BBM_RECTSET         WM_USER+0
#define BBM_RECTGET         WM_USER+1
#define BBM_POBJECTGET      WM_USER+2       //LPOBJECT is read-only.
#define BBM_OBJECTNOTIFY    WM_USER+3
#define BBM_VERBEXECUTE     WM_USER+4

//Notification codes
#define BBN_MOVED           0
#define BBN_SIZED           1
#define BBN_CHANGED         2
#define BBN_ACTIVATED       3


void     FAR PASCAL FileObjectDefaults(LPFILEOBJECT);
HWND     FAR PASCAL HBlackBoxCreate(HWND, LPFILEOBJECT, BOOL, LPOBJECT);
long     FAR PASCAL BlackBoxWndProc(HWND, UINT, UINT, LONG);
DWORD        PASCAL LBlackBoxUserMessage(HWND, WORD, WORD, LONG, PBLACKBOX);
LPRECT   FAR PASCAL PRectWindowGet(HWND, LPRECT, HWND);
WORD     FAR PASCAL WIDGetNext(BOOL);
LPRECT   FAR PASCAL PRectGetNext(LPRECT, BOOL);
