/////////////////////////////////////////////////////////////////////////
// OEMCLIP.CPP						         (C) Alberto R. Lopez Siemens, 1993
//
// Freeware, Public domain -  Also included OEMCLIP.PRJ
//
// OEM-Text to ANSI-text automatic clipboard translator
//
//	This program has been developed to fix a problem I encountered when
// tried to copy a portion of a DOS screen into my Word Processor.
//
// The problem is the following:
// ----------------------------
//
//	Supose you have a DOS application running in a Window. and want to
// copy its screen (or a portion of it) into a Windows application such as
// a Word Processor.
//
// The first thing you'd do is select Edit|Mark from the system bar menu,
// select the portion of the screen and press Enter. Then, switch to your
// word processor and paste the data.
//
// It simply doesn't work as expected !
//
// If the screen capture has ASCII characters greater than 127, as
// line-drawing, or international characters, you'll find that when pasted
// into a Windows application that caracters are translated. The good-
// looking line-drawing characters are transformed in ugly character
// equivalences as '-', '|' and '+'.
//
// That's not what I want. I want my screen as I see it. This is a
// Windows feature where "What you see is NOT what you get".
// 
// People at Microsoft wasn't be able to give me a solution. They said
// that Windows uses ANSI character set only. Period. And that I can't
// do what I want. So here is the solution. (Actually they gave me some
// trivial solutions as search-and-replacing the characters or use
// Alt-PrtScrn to get a bitmap representation of the screen).
//
// This program works registering itself as a Windows Clipboard Viewer.
// When it detects that a DOS application pastes data into the clipboard
// it simply translates it from ASCII to ANSI.
//
// To install OEMCLIP just double-click its icon or File|Run from
// Program Manager. As default it run minimized. You can maximize it but
// the contents of the window is meaningless. It is only a poor
// representation of the data in the clipboard.
//
// To use pasted text You'll need a Windows font with ASCII character set.
//	At this moment I know two: LotusLineDraw (comes with AmiPro or Lotus 123
// for Windows) and Video Terminal Screen (You can find it in DTPFORUM, 
// Lib 9, File: VTSR-T.ZIP (Shareware)
//
// Not too bad since this is my first Windows Program (I didn't even try
//	a WinHello.CPP). 
//
// You need BC++ 3.1 and ObjectWindows library to recompile this program.
//
// Suggestions & comments are welcome:
//    Mail Address:
//			DigiSoft SRL
// 		Ing. Alberto R. Lopez Siemens
//			Sarmiento 1426 6to Piso
//			(1042) Buenos Aires
//			Argentina
//
//    Voice/Fax #'s:
//			(541) 40-5714
//			or
//			(541) 46-2151 (Remember we'll answer the phone in spanish !)
//
// 	CIS Mail: 70501,1574
//
/////////////////////////////////////////////////////////////////////////

#include <owl.h>

#include <string.h>

class TMyApp : public TApplication
{
public:
  TMyApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    		LPSTR lpCmdLine, int nCmdShow) :
	 TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow)
	 {
		ClipboardChanged = FALSE;
	 }
  virtual void InitMainWindow();
  virtual void IdleAction();

  BOOL	ClipboardChanged;
  HWND	clipOwner;
};

_CLASSDEF(TMyWindow)
class TMyWindow : public TWindow
{
public:
  TMyWindow(PTWindowsObject AParent, LPSTR ATitle) :
	TWindow(AParent, ATitle),
	oldHWin(NULL) {};

  virtual BOOL Create();
  virtual void Destroy();

// Windows that are part of the clipboard-viewer chain must respond to
// WM_CHANGECBCHAIN, WM_DRAWCLIPBOARD, and WM_DESTROY messages.
// To remove itself from the clipboard-viewer chain, an application must
// call the ChangeClipboardChain function.
  virtual void WMDrawClipboard(RTMessage)
	 = [WM_FIRST + WM_DRAWCLIPBOARD];

  virtual void WMChageCBChain(RTMessage)
	 = [WM_FIRST + WM_CHANGECBCHAIN];

  HWND	oldHWin;
};

void TMyWindow::WMDrawClipboard(RTMessage Msg)
{
	if(oldHWin){
		SendMessage(oldHWin, Msg.Message, Msg.WParam, Msg.LParam);

		TMyApp *app = (TMyApp *)GetApplication();
		app->ClipboardChanged = TRUE;
		app->clipOwner = GetFocus();
// The GetFocus function retrieves the handle of the window that
// currently has the input focus.
	}
	Msg.Result = 0l;
	DefWndProc(Msg);
}

void TMyWindow::WMChageCBChain(RTMessage Msg)
{
// Each window that receives the WM_CHANGECBCHAIN message should call the
// SendMessage function to pass the message on to the next window in the
// clipboard-viewer chain. If the window being removed is the next window
// in the chain, the window specified by the hwndNext parameter becomes the 
// next window and clipboard messages are passed on to it. 

// WM_CHANGECBCHAIN
// hwndRemoved = (HWND) wParam;        /* handle of removed window */
// hwndNext = (HWND) LOWORD(lParam);   /* handle of next window    */

	SendMessage(oldHWin, Msg.Message, Msg.WParam, Msg.LParam);

	if((HWND) Msg.WParam == oldHWin)
		oldHWin = (HWND) LOWORD(Msg.LParam);

   Msg.Result = 0l;
	DefWndProc(Msg);
}

BOOL TMyWindow::Create()
{
	if(TWindow::Create()){
		oldHWin = SetClipboardViewer(HWindow);
		return TRUE;
	}
	return FALSE;
}

void TMyWindow::Destroy()
{
	ChangeClipboardChain(HWindow,oldHWin);

   TWindow::Destroy();
}

void TMyApp::InitMainWindow()
{
  MainWindow = new TMyWindow(NULL, Name);
}

#define	print(s)	{\
					TextOut(dc, 0, yPos,(LPSTR)s, strlen(s));\
					yPos+=15;}

#define	nprint(s,n)	{\
					TextOut(dc, 0, yPos,(LPSTR)s, n);\
					yPos+=15;}

void TMyApp::IdleAction()
{
	if(ClipboardChanged){
		// Check to see if the Window that had the focus when the clipboard
		// changed was a DOS-app.
		// I haven't found documentation about this, but the method used here
      // seems to work well

		char bufName[64];

		GetClassName(clipOwner, bufName, sizeof(bufName));
		if(stricmp(bufName,"tty") == 0 &&
		IsClipboardFormatAvailable(CF_OEMTEXT)){
			TMyWindow 	*win = (TMyWindow *)MainWindow;
			HDC			dc   = GetDC(win->HWindow);
			DWORD 		pos  = GetCurrentPosition(dc);
			WORD			yPos = HIWORD(pos);

			if(OpenClipboard(win->HWindow)){
				HANDLE 	hClip  = GetClipboardData(CF_OEMTEXT);
				DWORD		szClip = GlobalSize(hClip);
				HANDLE 	hTemp  = GlobalAlloc(GPTR,szClip);
				void FAR	*pClip = GlobalLock(hClip),
					  FAR *pTemp = GlobalLock(hTemp);

				_fmemcpy(pTemp, pClip, (size_t)szClip);

				// Translate characters not found in the ANSI character set
				int	i = 0;
				BYTE	*sTemp = (BYTE *)pTemp;

				while(i < szClip && sTemp[i] != 0){
					if(sTemp[i] < 32 &&
               sTemp[i] != 10 &&
					sTemp[i] != 13)
						sTemp[i] = ' ';
               i++;
				}

            // This is for debugging purposes only.
				nprint(pTemp,(size_t)szClip);

				GlobalUnlock(hTemp);
				GlobalUnlock(hClip);

				// Put the data into the clipboard but change
				// the Format Identifier to CF_TEXT.
				// Simple but effective.

				SetClipboardData(CF_TEXT, hTemp);
				CloseClipboard();
			}

			ReleaseDC(win->HWindow,dc);
		}

		ClipboardChanged = FALSE;
	}
}

#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TMyApp MyApp("OEM-Text ClipBoard Translator", hInstance, hPrevInstance,
					lpCmdLine, SW_SHOWMINNOACTIVE);
  MyApp.Run();
  return MyApp.Status;
}
