/* Rexx */
Arg Parms
If RxFuncQuery('rexxlibregister') <> 0 Then
Do
  call rxfuncadd 'rexxlibregister', 'rexxlib', 'rexxlibregister'
  call rexxlibregister
End
CRLF=D2C(13)||D2C(10)
Utility=Word(Parms,1); Queue Utility; Parse Upper Pull Utility
Filepath=Directory()"\"
Select
  When Utility="GETTOPICS"  Then Call GET_Topics
  When Utility="PARSEMSG"   Then Call Parse_Message
  When Utility="QUOTEMSG"   Then Call Quote_Message
  When Utility="PRINT"      Then Call Print_Text
  When Utility="MAKEICON" Then Call Create_Icon
  Otherwise Exit
End /* Select */
Exit

Get_Topics:
/*===========================================================================*/
/*  This code is called by DDIALER.EXE whenever a topic list is requested.   */
/*  If the topic list being requested is for a forum (TopType=1), then a     */
/*  xxxx.TOP file will be built in the forum directory.  If the topic list   */
/*  being requested is for a forum database (TopType=2), then a xxxxDB.TOP   */
/*  file will be be built in the forum directory.                            */
/*  There shouldn't be any need for the user to edit this code.              */
/*===========================================================================*/
Forum=Word(Parms,2); TopType=Word(Parms,3)
FN=".TOP"; Look="set:"
If TopType=2 Then Do; FN="DB.TOP"; Look="Menu:"; End
DBFile=FilePath||Forum"\"Forum"TOP.CAP"
TopFile=FilePath||Forum"\"Forum||FN
W=""
Do Until Pos(Look,W)>0
  If Lines(DBFile)=0 Then Signal ODNUtil_1_End
   W=LineIn(DBFile)
End
W=LineIn(DBFile); Cnt=0; Rcnt=0; LookAt=0; Max=0; MaxL=0
Do Until Word="" | Lines(DBFile)=0
    Word=LineIn(DBFile)
    If Word \="" Then
    Do
      Cnt=Cnt+1
      Line.Cnt=Word
      L=Pos("  ",Word)
      If L>Max Then Max=L
      L=Length(Word); If L>MaxL Then MaxL=L
    End
End
L=Length(Line.1)
If L>Max & Max>0 Then
Do
   Word=SubStr(Line.1,Max,L-Max+1)
   LookAt=WordIndex(Word,1)+Max-1
   MaxL=Max
End
RC=Stream(DBFile,"C","Close")
Do Z=1 to Cnt
  TopName.Z=Left(Line.Z,MaxL)
  If LookAt>0 Then
  Do
    If SubStr(Line.Z,LookAt,1) \=" " Then
    Do
       RCnt=RCnt+1
       RLine.RCnt=SubStr(LIne.Z,LookAt,MaxL)
    End
  End
End
Do Z=1 to RCnt
  Cnt=Cnt+1
  TopName.Cnt=RLine.Z
End
TopName.0=Cnt; RC=FileWrite(TopFile,"TopName.")
ODNUtil_1_End:
RC=Stream(DBFile,"C","Close")
"@Del "DBFile
Return

Parse_Message:
/*==========================================================================*/
/*  This code is called whenver:                                            */
/*  1)  DDIALER.EXE is online just prior to sending each forum message      */
/*      forum reply, or Email message.                                      */
/*                                                                          */
/*  One variable is available to this routine.  It is:                      */
/*  F     This variable contains the filename of the original outgoing      */
/*        message.                                                          */
/*  The code included here looks at 80 bytes from the message file.  If     */
/*  there is not already a CRLF present in that 80 bytes, a CRLF is placed  */
/*  at the closest blank character to the end of the 80 bytes.              */
/*  If a CRLF is already present, then it is honored.  Then the next 80     */
/*  byte chunk is processed.  This process is repeated until the entire     */
/*  message has been parsed.  If you want to change the 80 to something     */
/*  other than 80, change the MaxLineLength=80 to something of your choice. */
/*  Note: ODN's message files contain data important to ODN.  In forum      */
/*  replies, the first line of the file must not be changed.  In anything   */
/*  else, the first 3 lines must not be changed.                            */
/*  Upon completion, the new outgoing message will be contained in a file   */
/*  called ODN.MSG.  DDIALER.EXE will immediate send ODN.MSG to Delphi.     */
/*  Each time the previous ODN.MSG will be overwritten with the new one.    */
/*==========================================================================*/
F=Word(Parms,2)
MsgFile=FilePath||F       /* This file holds the original outgoing message */
If DosFSize(MsgFile)=0 Then Return  /* Ignore if file size = 0 */
OutFile=FilePath"ODN.MSG" /* This file will hold the new outgoing message  */
RC=FileRead(MsgFile,"Line.")
StartLine=4; If SubStr(F,8,4)=".REP" Then StartLine=2
Text=""; Do Z=StartLine to Line.0; Text=Text||Line.Z||CRLF; End
/*===========================================*/
/* Change embedded TABS (x'09') to 5 spaces  */
/*===========================================*/
Look_Tab:
If Pos(D2C(09),Text) >0 Then
Do
   L=Pos(D2C(09),Text); Len=Length(Text)
   Text=Left(Text,L-1)"     "SubStr(Text,L+1,Len-1)
   Signal Look_Tab
End
MaxLineLength=80; Parsed=0; Mess=""; LineCnt=StartLine-1
Do Until Parsed=1
  If Length(Text) > MaxLineLength Then
  Do
    Line=Left(Text,MaxLineLength)
    Z=Pos(CRLF,Line)
    If Z>0 Then
    Do
       MyLine=Left(Line,Z-1)
       Text=Strip(SubStr(Text,Z+2,Length(Text)),'T')
    End
    Else
    Do
      P=LastPos(" ",Left(Text,MaxLineLength))
      If P>0 Then
      Do
        MyLine=Left(Text,P-1)
        Text=Strip(SubStr(Text,P+1,Length(Text)),'T')
      End
      Else
      Do
        MyLine=Left(Text,MaxLineLength)
        Text=Strip(SubStr(Text,MaxLineLength+1,Length(Text)),'T')
      End
    End
  End
    Else
    Do
      MyLine=Text
      Parsed=1
    End
  LineCnt=LineCnt+1
  Line.LineCnt=MyLine
End
Line.0=LineCnt
RC=FileWrite(OutFile,"Line.")
Return

Quote_Message:
/*==========================================================================*/
/*  This code is called whenver:                                            */
/*  1)  You highlight a portion of a message and press the REPLY or the     */
/*      PRIVATE REPLY button.                                               */
/*  2)  You are replying to a forum message or Email message, highlight a   */
/*      portion of the message in the top box and press the QUOTE button.   */
/*  3)  You are looking at a reply in the Outbasket window, and highlight   */
/*      a portion of the top box and press the QUOTE button.                */
/*                                                                          */
/*  Three variables are available to this routine.  They are:               */
/*  MT    This variable will be equal to "E" if you are replying to Email.  */
/*        It will be equal to "F" if you are replying to forum mail.        */
/*  TEXT  This variable contains the exact text that you highlighted.       */
/*  USER  This variable contains the userid of the person that your are     */
/*        replying to.                                                      */
/*                                                                          */
/*  Upon completion, the quoted text is passed back to the calling program  */
/*  via the OK=VRMethod("Application","PutVar","Text") command.             */
/*==========================================================================*/
OK=VRMethod("Application","GetVar","MT")
OK=VRMethod("Application","GetVar","Text")
OK=VRMethod("Application","GetVar","User")
MyText=""; GO=0; GC=0
Max=65; If MT="F" Then Max=55
Do Until GO=1 | P=1
  If Pos(CRLF,Text)>0 Then
  Do
    P=Pos(CRLF,Text)
    If P>1 Then
    Do
      GC=GC+1
      Text.GC=Strip(Left(Text,P-1))
      Text=Strip(SubStr(Text,P+2,Length(Text)-P))
    End
  End
    Else GO=1
End
GC=GC+1; Text.GC=Text
Text=""
Do Z=1 To GC
   First14=Left(Text.z,14)
   If Pos("> ",First14) >0 Then Text=Text||Text.Z||CRLF
      Else Text=Text||" "Text.Z
End


Parse_Next:
GO=0;Cnt=0
If Pos(CRLF,Text) > 0 & Pos(CRLF,Text) < 100 Then
Do
  P=Pos(CRLF,Text)
  OutLine=Left(Text,P-1)
  Text=SubStr(Text,P+2,Length(Text)-P+1)
End
 Else
 Do
   Do until GO=1
     Cnt=Cnt+1
     P=WordIndex(Text,Cnt)
     If P>Max | P=0 Then GO=1
   End
   If P=0 Then OutLine=Text; Else
   Do
     OutLine=Left(Text,P-1)
     Text=SubStr(Text,P,Length(Text)-P+1)
   End
 End

OutLine=User"> "Strip(OutLine)
If Length(OutLine)>80 Then
Do
  Hold=Strip(SubStr(OutLine,71,35))
  OutLine=Left(OutLine,70)
  W=WordIndex(Hold,2); 
  If W>1 Then
  Do
     OutLine=OutLine||Left(Hold,W-1)
     Hold=Strip(SubStr(Hold,W,35))
  End
  MyText=MyText||OutLine||CRLF
  Temp=User"> "
  Z=LastPos(">",Left(OutLine,30)); If Z>1 Then Temp=Left(OutLine,Z)" "
  MyText=MyText||Temp||Hold||CRLF
End
  Else If Strip(OutLine) \= User">" Then MyText=MyText||OutLine||CRLF
If P \=0 Then Signal Parse_Next
Text=MyText
OK=VRMethod("Application","PutVar","Text")
Return

Print_Text:
/*==========================================================================*/
/*  This code is called whenver:                                            */
/*  1)  You highlight a portion of a message and press the select the       */
/*      PRINT selection under the Edit menubar pulldown.                    */
/*  2)  You highlight a portion of a message and press the select the       */
/*      PRINT HIGHLIGHTED selection under the Edit menubar pulldown.        */
/*                                                                          */
/*  One variable is passed to this routine. It is                           */
/*  PFILE The name of a file that contains either the entire message if     */
/*        PRINT was selected or the name of a file that contains the        */
/*        highlighted portion of a message if PRINT HIGHLIGHTED was         */
/*        selected.                                                         */
/*                                                                          */
/*  Basically with this exit, you can control whether a form feed occurs    */
/*  and also which LPT port. You can change PRN to LPT1, LPT2, LPT3, etc.   */
/*==========================================================================*/
PFile=Word(Parms,2)
"Type "PFile">PRN"
RC=LineOut("PRN",D2C(12))    /* This line causes a form feed on the printer */
Return

Create_Icon:
If RxFuncQuery('SysLoadFuncs') <> 0 Then
Do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
End
"@CLS"
Say ""
RC=Charout(,"Please Enter the text that will be placed under the ODN icon: ")
Pull Title
class='WPProgram'
location='<WP_DESKTOP>'
dupflag='U'
objectid='<ODN>'
setup='ExeName='FilePath'ODN.EXE;Parameters=;StartUpDir='FilePath';'
setup=setup||'ProgType=PM;IconFile='FilePath'ODN.ICO;'
call SysCreateObject CLASS, TITLE, LOCATION, ,
'ObjectID='OBJECTID';'setup, DUPFLAG
if result<>1 then say "An error occured.  Unable to create the object. Result="Result
  Else
  Do
    Say ""
    Say "An ODN icon entitled "Title" has been placed on your OS/2 Desktop."
    Say "You may now doubleclick on this icon to run ODN."
  End
