/*
 Ŀ
  Module....: UTILITY.prg                                                 
  Author....: Ken Trock, Brian Marasca                                    
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: February 1993                                               
 Ĵ
  Notes.....: Utility functions.                                          
 
*/

/*****************************************************************************
   Include file headers.
*****************************************************************************/

#include "objectdb.ch"
#include "inkey.ch"

/*****************************************************************************
   FUNCTION waitMsg()
*****************************************************************************/

FUNCTION waitMsg( lToggle )
  STATIC nOpen := 0
  STATIC cScreen

  IF lToggle
     nOpen++
     IF nOpen == 1
        cScreen := saveScreen( 0, maxCol() - 7, 0, maxCol() )
        @ 00, maxCol() - 07 SAY " WAIT " COLOR "w+/r"
     ENDIF
  ELSE
     nOpen--
     IF nOpen == 0
        restScreen( 0, maxCol() - 7, 0, maxCol(), cScreen )
     ENDIF
  ENDIF 

  RETURN nil

/*****************************************************************************
   FUNCTION statusLine()
*****************************************************************************/

FUNCTION statusLine( cStatStr )
  LOCAL cStatLine, cColor

  cStatLine := saveScreen( maxRow(), 0, maxRow(), maxCol() )
  IF ! ( cStatStr == NIL )
     cColor := setColor ("R/W" )
     @ 24, 0 
     @ 24, 40 - ( len( trim( cStatStr ) ) / 2 ) SAY cStatStr
     setColor( cColor )
  ENDIF

  RETURN cStatLine

/*****************************************************************************
   FUNCTION topLine()
*****************************************************************************/

FUNCTION topLine( cTopStr )
  LOCAL ctopLine, cColor

  cTopLine := saveScreen( 0, 0, 0, maxCol() )
  IF ! ( cTopStr == NIL )
     cColor := setColor ( "b/w" )
     @ 0, 0 
     @ 0, 40 - ( len( trim( cTopStr ) ) / 2 ) SAY cTopStr
     setColor( cColor )
  ENDIF

  RETURN cTopLine

/*****************************************************************************
   FUNCTION idxProgress

   Demonstrates the creation of progress gauges for indexing with objectDB.
*****************************************************************************/

FUNCTION idxProgress( lOn, cTable, cIndex )
  STATIC scScr
  STATIC scClr
  STATIC snShown
  LOCAL nPctDone
  LOCAL nNow

  DEFAULT cTable TO ""
  DEFAULT cIndex TO ""

  DO CASE
  CASE valType( lOn ) == "L" .AND. lOn
     scScr := saveScreen( 5, 20, 12, 60 )
     scClr := setColor( "gr+/r*" )
     scroll( 5, 20, 12, 60 )
     dispBox( 5, 20, 12, 60 )

     @ 6, 21 say padc( cTable + "/" + cIndex  , 39 ) COLOR "n/w"
     @ 9, 23 SAY "" COLOR "gr+/r*"
     @10, 23 SAY "       25%     50%     75%       " COLOR "gr+/r*"
     @11, 23 say "         Percent Indexed         " COLOR "w+/r*"

     snShown := 0

  CASE valType( lOn ) == "L" .AND. ! lOn
     restScreen( 5, 20, 12, 60, scScr )
     setColor( scClr )
     scScr := NIL
     scClr := NIL
     snShown := 0

  OTHERWISE
     nPctDone := recno()/lastrec()
     nNow := round( nPctDone * 33, 0 )
     IF ! ( nNow == snShown )
        @ 8, 23 SAY repl("", round( nPctDone * 33, 0 ) ) COLOR "w+/r*"
        snShown := nNow
     ENDIF

  ENDCASE

  RETURN TRUE

/*****************************************************************************
   FUNCTION shadow( t, l, b, r )
*****************************************************************************/

FUNCTION shadow( t, l, b, r )
  LOCAL h := saveScreen( b+1, l+1, b+1, r+1 )
  LOCAL v := saveScreen( t+1, r+1, b+1, r+1 )

  restScreen( b+1, l+1, b+1, r+1, strShadow( h ) )
  restScreen( t+1, r+1, b+1, r+1, strShadow( v ) )

  RETURN nil

/***************************************************************************
   FUNCTION readSource
***************************************************************************/

FUNCTION readSource
  LOCAL cScr, cColor, nCurs, cStat
  LOCAL cFile := procName( 3 ) + ".prg"

  IF file( cFile )
     cScr := saveScreen( 3, 0, 23, 79 )
     cColor := setColor( "w+/n" )
     nCurs := setCursor( 1 )
     cStat := statusLine( "" )
     dispBox( 3, 0, 23, 79, 2 )

     memoEdit( memoRead( cFile ), 4, 1, 22, 78, FALSE ) 

     restScreen( 3, 0, 23, 79, cScr )
     setColor( cColor )
     setCursor( nCurs )
     restScreen( 24, 0, 24, 79, cStat )
  ENDIF

  RETURN TRUE


