/*
 Ŀ
  Module....: TABLES.prg                                                  
  Author....: Ken Trock                                                   
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: February 1993                                               
 Ĵ
  Notes.....: Support table maintenence.                                  
 
*/

/*****************************************************************************
   Include file headers.
*****************************************************************************/

#include "objectdb.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "odbdemo.ch"

/*****************************************************************************
   FUNCTION partsTable()
*****************************************************************************/

FUNCTION partsTable()
  LOCAL cColor := setColor( "w+/b*" )
  LOCAL cStatLine := statusLine()
  LOCAL lExit := FALSE
  LOCAL oTB
  LOCAL cScr
  LOCAL oParts
  LOCAL nCtr
  LOCAL oCol

  db():bWait:eval( .T. )

  CREATE CONTEXT oParts FOR TABLE parts

  oTB  := oParts:browser( , 8, 5, 18, 49 )
  cScr := saveScreen( 4, 4, 19, 50 )

  dispBox( 4, 4, 19, 50, B_BLOCK_THIN, "w+/b*" )
  dispBox( 7, 5, 7, 49, 2 )

  @ 5, 5 SAY padc( upper( oParts:oTable:desc ), 45 ) COLOR "g+/b*"
  oTB:colorSpec := "gr+/b*, n/w, w+/b*, n/w"

  FOR nCtr := 1 TO oParts:oTable:numCols()
     oCol := vlfBrowseCol( oParts, nCtr )
     oTB:addColumn( oCol )
  NEXT

  oTB:headSep := ""
  oTB:colSep  := "  "

  db():bWait:eval( .F. )

  browseKeys( oParts, oTB, { |oCon, oTB, nKey| editPart( oCon, oTB, nKey ) } )

  DESTROY CONTEXT oParts

  setColor( cColor )
  restScreen( 4, 4, 19, 50, cScr )
  restScreen( 24, 0, 24, 79, cStatLine )

  RETURN nil

/*****************************************************************************
   FUNCTION editPart()
*****************************************************************************/

FUNCTION editPart( oParts, oTB, nAction )
  LOCAL lProceed := TRUE
  LOCAL getList := {} 
  LOCAL cStatLine
  LOCAL nCtr

  oTB:dehilite()

  IF ! ( nAction == ACTION_DELETE )
     DO CASE
     CASE nAction == ACTION_INSERT
        oParts:newRec()
        cStatLine := statusLine( "A d d i n g    R e c o r d" )
     CASE nAction == ACTION_MODIFY
        cStatLine := statusLine( "C h a n g i n g    R e c o r d" )
        @ oTB:nTop - 2, oTB:nLeft + 6  SAY oParts..part_no 
     ENDCASE

     @ oTB:nTop - 2, oTB:nLeft + 12 GET oParts..desc    PICTURE "@!"
     @ oTB:nTop - 2, oTB:nLeft + 34 GET oParts..price   PICTURE "999.99"

     READ

     restScreen( 24, 0, 24, 79, cStatLine )

     lProceed := ! ( lastKey() == K_ESC )
  ENDIF

  IF lProceed
     DO CASE
     CASE nAction == ACTION_INSERT
        oParts:addRec() 
     CASE nAction == ACTION_MODIFY
        oParts:putRec() 
     CASE nAction == ACTION_DELETE
        oParts:delRec()
     ENDCASE

     oTB:rowPos := min( oTB:rowPos, oParts:pos )
     oTB:refreshAll()
  ELSE
     oParts:loadRec()
  ENDIF
     
  @ oTB:nTop - 2, oTB:nLeft + 1 SAY space( 41 ) COLOR "w+/b*"

  RETURN lProceed


/*****************************************************************************
   FUNCTION salesmenTable()
*****************************************************************************/

FUNCTION salesmenTable 
  LOCAL cColor := setColor( "w+/b*" )
  LOCAL cStatLine := statusLine()
  LOCAL lExit := FALSE
  LOCAL oTB
  LOCAL cScr
  LOCAL oSalesmen
  LOCAL nCtr
  LOCAL oCol

  db():bWait:eval( .T. )

  CREATE CONTEXT oSalesmen FOR TABLE sm

  oTB  := oSalesmen:browser( , 8, 5, 18, 64 )
  cScr := saveScreen( 4, 4, 19, 65 )

  dispBox( 4, 4, 19, 65, B_BLOCK_THIN, "w+/b*" )
  @ 7, 5 TO 7, 64 DOUBLE
  @ 5, 5 SAY padc( upper( oSalesmen:oTable:desc ), 58 ) COLOR "g+/b*" 
  oTB:colorSpec := "gr+/b*, n/w, w+/b*, n/w"

  FOR nCtr := 1 TO oSalesmen:oTable:numCols()
     oCol := vlfBrowseCol( oSalesmen, nCtr )
     oTB:addColumn( oCol )
  NEXT

  oTB:headSep := ""
  oTB:colSep  := "  "

  db():bWait:eval( .F. )

  browseKeys( oSalesmen, oTB, { |oCon, oTB, nKey| editSales( oCon, oTB, nKey ) } )

  DESTROY CONTEXT oSalesmen

  setColor( cColor )
  restScreen( 4, 4, 19, 65, cScr )
  restScreen( 24, 0, 24, 79, cStatLine )

  RETURN nil

/*****************************************************************************
   FUNCTION editSales()
*****************************************************************************/

FUNCTION editSales( oSalesmen, oTB, nAction )
  LOCAL cTmp
  LOCAL lProceed := TRUE
  LOCAL getList := {} 
  LOCAL nCtr
  LOCAL cScr
  LOCAL cColor
  LOCAL cStatLine
  LOCAL nCursor

  oTB:dehilite()

  IF ! ( nAction == ACTION_DELETE )
     DO CASE
     CASE nAction == ACTION_INSERT
        oSalesmen:newRec()
        cStatLine := statusLine( "A d d i n g    R e c o r d" )
     CASE nAction == ACTION_MODIFY
        @ 6, 10 SAY oSalesmen..sm_code
        cStatLine := statusLine( "C h a n g i n g    R e c o r d" )
     ENDCASE

     @ 6, 14 GET oSalesmen..lname    PICTURE "@!"
     @ 6, 31 GET oSalesmen..fname    PICTURE "@!"
     @ 6, 43 GET oSalesmen..hired

     READ

     restScreen( 24, 0, 24, 79, cStatLine )

     lProceed := ! ( lastKey() == K_ESC )
  ENDIF

  IF lProceed
     IF ! ( nAction == ACTION_DELETE )
        cScr := saveScreen( 12, 28, 21, 77 )
        cColor := setColor( "n/g" ) 

        dispBox( 12, 28, 21, 77, B_SINGLE )
        @ 13, 29 SAY padc( "Comments", 48 ) COLOR "gr+/g" 
        @ 14, 29 TO 14, 76

        nCursor := setCursor( SC_NORMAL )
        cTmp := memoEdit( oSalesmen..comments, 15, 30, 20, 75 )
        setCursor( nCursor )

        IF ! ( lastKey() == K_ESC )
           oSalesmen..comments := cTmp
        ENDIF

        restScreen( 12, 28, 21, 77, cScr )
        setColor( cColor )
     ENDIF

     DO CASE
     CASE nAction == ACTION_INSERT
        oSalesmen:addRec() 
     CASE nAction == ACTION_MODIFY
        oSalesmen:putRec() 
     CASE nAction == ACTION_DELETE
        oSalesmen:delRec()
     ENDCASE

     oTB:rowPos := min( oTB:rowPos, oSalesmen:pos )
     oTB:refreshAll()
  ELSE
     oSalesmen:loadRec()
  ENDIF

  @ 6, 10 SAY space( 48 ) COLOR "w+/b*"

  RETURN lProceed

/*****************************************************************************
   FUNCTION browseKeys()
*****************************************************************************/

STATIC FUNCTION browseKeys( oCon, oTB, bEditFunc )
  LOCAL lExit := FALSE
  LOCAL cStatLine 
  LOCAL nKey

  statusLine( "INS : Add    Enter : Modify    Del : Delete    Esc : Exit" )
  cStatLine := statusLine()

  WHILE ! lExit
     WHILE nextKey() == 0 .AND. ! oTB:stabilize(); END

     nKey := iif( oCon:isEmpty(), K_INS, inkey( 0 ) )

     DO CASE
     CASE nKey == K_UP
        oTB:up()
     CASE nKey == K_DOWN 
        oTB:down()
     CASE nKey == K_PGUP
        oTB:pageUp()
     CASE nKey == K_PGDN
        oTB:pageDown()
     CASE nKey == K_CTRL_PGUP
        oTB:goTop()
     CASE nKey == K_CTRL_PGDN
        oTB:goBottom()
     CASE nKey == K_LEFT
        oTB:left()
     CASE nKey == K_RIGHT
        oTB:right()
     CASE nKey = K_ENTER
        eval( bEditFunc, oCon, oTB, ACTION_MODIFY )
     CASE nKey = K_INS
        IF ! eval( bEditFunc, oCon, oTB, ACTION_INSERT )
           lExit := oCon:isEmpty()
        ENDIF
     CASE nKey = K_DEL
        eval( bEditFunc, oCon, oTB, ACTION_DELETE ) 
        IF oCon:isEmpty()
           lExit := TRUE
        ENDIF
     CASE nKey = K_ESC
        lExit = TRUE
     ENDCASE
  END

  restScreen( 24, 0, 24, 79, cStatLine )

  RETURN nil


/*****************************************************************************
   FUNCTION vlfBrowseCol
*****************************************************************************/

STATIC FUNCTION vlfBrowseCol( oCon, nCol )
  LOCAL bCol, oCol
  
  IF oCon:oTable:aColumns[nCol]:type == "V"
     bCol := { || iif( oCon:flds[nCol]:isNull, "N", "Y" ) }
  ELSE
     bCol := oCon:fldBlock( nCol )
  ENDIF

  oCol := tbColumnNew( oCon:oTable:aColumns[nCol]:desc, bCol ) 
  oCol:colorBlock := { || { 3, 4 } } 

  RETURN oCol
