/*
 Ŀ
  Module....: RI.prg                                                      
  Author....: Ken Trock                                                   
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Entity and Referential integrity display                    
 
*/

/***************************************************************************
   Include file headers.
***************************************************************************/

#include "objectdb.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "memoedit.ch"
#include "odbdemo.ch"
#include "mb.ch"

/***************************************************************************
   Manifest constants.
***************************************************************************/

#define STATUS_LINE   " F2 : Source  Tab : Switch  Ins : Add   : Edit  Del : Delete  ESC : Exit "

/***************************************************************************
   FUNCTION ri()
***************************************************************************/

FUNCTION ri()
  LOCAL cColor := setColor( "w+/b*" )
  LOCAL getList := {}
  LOCAL oCust, oInv, oLine
  LOCAL oTBcust, oTBinv, oTBline
  LOCAL aCon
  LOCAL aTB
  LOCAL aDesc
  LOCAL cStatLine

  CREATE CONTEXT oCust  FOR TABLE Customer
  CREATE CONTEXT oInv   FOR TABLE Invoice   CHILD OF oCust
  CREATE CONTEXT oLine  FOR TABLE Lineitem  CHILD OF oInv

  /*****
  * Configure browses
  *****/

  oTBcust := oCust:browser( { 1, 2 }, 3, 1, 22, 26 ) 
  oTBinv  := oInv:browser( { 1, 2 }, 3, 28, 22, 52 )
  oTBline := oLine:browser( { "cust_id", "inv_no", "line_no" }, 3, 54, 22, 78 )

  /*****
  * Prepare the browse
  *****/

  CLS

  aCon := { oCust, oInv, oLine }
  aTB  := { oTBcust, oTBinv, oTBline }

  topLine( "R e f e r e n t i a l    I n t e g r i t y" )
  cStatLine := statusLine( STATUS_LINE )

  @ 1, 27 TO 23, 27  
  @ 4, 27 SAY ""
  @ 1, 53 TO 23, 53  
  @ 4, 53 SAY ""

  aeval( aTB, { |o| o:colorSpec := BR_COLORS } )
  aeval( aTB, { |o| o:headSep := SING_HEADSEP } )

  MULTIBROWSE KEY K_DEL   CALLS delFunc
  MULTIBROWSE KEY K_INS   CALLS insFunc
  MULTIBROWSE KEY K_ENTER CALLS editFunc
  MULTIBROWSE KEY K_F2    CALLS readSource

  MULTIBROWSE aTB WITH CONTEXTS IN aCon  ;
    CAPTION COLOR "w+/r, w/b"            

  restScreen( 24, 0, 24, 79, cStatLine )
  setColor( cColor )

  /****
  * Can't forget these.
  ****/

  DESTROY CONTEXT oCust 
  DESTROY CONTEXT oInv  
  DESTROY CONTEXT oLine 

  RETURN nil

