/*
 Ŀ
  Module....: MB.prg                                                      
  Author....: Brian Marasca                                               
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Generic multiple TBROWSE function for objectDB.             
 
*/

#include "inkey.ch"
#include "objectdb.ch"

/*****************************************************************************
   Manifest constants.
*****************************************************************************/

#define B_BLOCK_THIN_NOCLR   ""
#define B_BLOCK_THIN         " "
#define B_DOUBLE             "ͻȺ "
#define B_SINGLE_NOCLR       "Ŀ"

#xtrans .capFocus         => \[1]
#xtrans .capNoFocus       => \[2]

#xtrans .key              => \[1]
#xtrans .block            => \[2]

/*****************************************************************************
   Static data.
*****************************************************************************/

STATIC saExcep := {}

/*****************************************************************************
   FUNCTION multiBrowse()
*****************************************************************************/

FUNCTION multiBrowse( aTB, aCon, aDesc, cClr, lBorders, bIter )
  LOCAL lStillGoing := TRUE
  LOCAL nBrowses := len( aTB )
  LOCAL nFoc := 1
  LOCAL aColors
  LOCAL nKey
  LOCAL n

  DEFAULT lBorders TO TRUE

  aColors := parseColorString( cClr )

  drawCaptions( aTB, aCon, aDesc, aColors, nFoc )
  drawBorders( aTB, nFoc, lBorders )
  displayAll( aTB )

  info( procName( 1 ) )

  WHILE lStillGoing
     nKey := inkey( 0 )

     DO CASE
     CASE nKey == K_UP
        aTB[nFoc]:up()
     CASE nKey == K_DOWN 
        aTB[nFoc]:down()
     CASE nKey == K_PGUP
        aTB[nFoc]:pageUp()
     CASE nKey == K_PGDN
        aTB[nFoc]:pageDown()
     CASE nKey == K_CTRL_PGUP
        aTB[nFoc]:goTop()
     CASE nKey == K_CTRL_PGDN
        aTB[nFoc]:goBottom()
     CASE nKey == K_LEFT
        aTB[nFoc]:left()
     CASE nKey == K_RIGHT
        aTB[nFoc]:right()
     CASE nKey == K_CTRL_LEFT
        aTB[nFoc]:panLeft()
     CASE nKey == K_CTRL_RIGHT
        aTB[nFoc]:panRight()
     CASE nKey == K_ESC
        lStillGoing := FALSE
        LOOP
     CASE nKey == K_TAB
        nFoc := iif( nFoc == nBrowses, 1, nFoc + 1 )
        drawCaptions( aTB, aCon, aDesc, aColors, nFoc )
        drawBorders( aTB, nFoc, lBorders )
     CASE nKey == K_SH_TAB
        nFoc := iif( nFoc == 1, nBrowses, nFoc - 1 )
        drawCaptions( aTB, aCon, aDesc, aColors, nFoc )
        drawBorders( aTB, nFoc, lBorders )
     OTHERWISE
        IF ( n := ascan( saExcep, { |e| e.key == nKey } ) ) > 0
           IF ! eval( saExcep[n].block, aTB[nFoc], aCon[nFoc] )
              displayAll( aTB )
           ENDIF
        ENDIF
     ENDCASE

     multiStabilize( aTB, aCon, nFoc )

     IF ! ( bIter == NIL )
        eval( bIter )
     ENDIF
  END

  saExcep := {}

  RETURN nil

/*****************************************************************************
   FUNCTION drawCaptions()
*****************************************************************************/

STATIC FUNCTION drawCaptions( aTB, aCon, aDesc, aColors, nFoc )
  LOCAL nLen := len( aTB )
  LOCAL nWid 
  LOCAL cClr
  LOCAL n

  IF aDesc == NIL
      aDesc := {}
      FOR n := 1 TO nLen
         aadd( aDesc, aCon[n]:oTable:desc )
      NEXT
  ENDIF

  FOR n := 1 TO nLen
     devPos( aTB[n]:nTop - 2, aTB[n]:nLeft )
     nWid := aTB[n]:nRight - aTB[n]:nLeft + 1 
     cClr := iif( n == nFoc, aColors.capFocus, aColors.capNoFocus )
     dispOut( padc( aDesc[n], nWid ), cClr )
  NEXT

  setColor( cClr )

  RETURN nil

/*****************************************************************************
   FUNCTION drawBorders()
*****************************************************************************/

STATIC FUNCTION drawBorders( aTB, nFoc, lDo )

  IF lDo
    aeval( aTB, {|e,x| dispBox( e:nTop-3, e:nLeft-1, e:nBottom+1, e:nRight+1, ;
           iif( x == nFoc, B_BLOCK_THIN_NOCLR, B_SINGLE_NOCLR ), "w+/bg" ) } )
  ENDIF

  RETURN nil

/*****************************************************************************
   FUNCTION displayAll()
*****************************************************************************/

STATIC FUNCTION displayAll( aTB )

  dispBegin()
  aeval( aTB, { |o| o:refreshAll(), o:forceStable() } )
  dispEnd()

  RETURN nil

/*****************************************************************************
   FUNCTION parseColorString()
*****************************************************************************/

STATIC FUNCTION parseColorString( cColors )
  LOCAL aRet := {}
  LOCAL n

  WHILE ( n := at( ",", cColors ) ) > 0
     aadd( aRet, alltrim( left( cColors, n - 1 ) ) )
     cColors := subs( cColors, n + 1 )
  END

  IF len( cColors := alltrim( cColors ) ) > 0
     aadd( aRet, cColors )
  ENDIF

  RETURN aRet


/*****************************************************************************
   FUNCTION multiStabilize()
*****************************************************************************/

STATIC FUNCTION multiStabilize( aTB, aCon, nFoc )
  LOCAL lAllStable := FALSE
  LOCAL nMax := len( aTB )
  LOCAL n := nFoc

  WHILE ! lAllStable .AND. nextKey() == 0
    IF aTB[n]:stabilize()
       n := iif( n == nMax, 1, n + 1 )
       IF ! ( lAllStable := ( n == nFoc ) )
          IF aCon[n]:lInvalid
             aTB[n]:refreshAll()
          ENDIF
       ENDIF
    ENDIF
  END

  RETURN nil     
       
     
/*****************************************************************************
   FUNCTION postKeyHandler()
*****************************************************************************/

FUNCTION postKeyHandler( nKey, bBlock )
  IF valtype( nKey ) == "N" .AND. valtype( bBlock ) == "B"
     aadd( saExcep, { nKey, bBlock } )
  ENDIF

  RETURN nil

