/*
 Ŀ
  Module....: EDCON.prg                                                   
  Author....: Brian Marasca                                               
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Generic Context Editor.                                     
 
*/

/***************************************************************************
   Include file headers.
***************************************************************************/

#include "objectdb.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "getexit.ch"
#include "odbdemo.ch"
#include "set.ch"

/***************************************************************************
   FUNCTION edCon( oCon, nAction, cGetClr, cWinClr )
***************************************************************************/

FUNCTION edCon( oCon, nAction, cGetClr, cWinClr )
  LOCAL t, l, b, r, h, w
  LOCAL nGetLists := 0, nGets
  LOCAL oTab := oCon:oTable
  LOCAL nFlds := oTab:numCols()
  LOCAL oCol
  LOCAL nDesc := 0, nFoc := 1, nCurs
  LOCAL nMaxFld := 0
  LOCAL aGetLists := {}
  LOCAL aDesc := {}, aNCol := {}, aDesc2 := {}
  LOCAL nGPP := int( ( maxRow() + 1 ) / 2 )
  LOCAL cDesc
  LOCAL cx, dx, ex := 1, pos := 0
  LOCAL lStillGoing := TRUE
  LOCAL lProceed := FALSE
  LOCAL cStatLine
  LOCAL cScr

  nCurs := setCursor( 0 )

  FOR cx := 1 TO nFlds
     oCol := oTab:aColumns[cx]
     IF ! oCol:autoInc .AND. ! ( oCol:type $ "VE" )
        pos++

        aadd( aNCol, cx )
        aadd( aDesc, oTab:aColumns[cx]:desc )
        IF empty( aDesc[pos] )
           aDesc[pos] := oTab:aColumns[cx]:name
        ENDIF

        nDesc := max( nDesc, len( aDesc[pos] ) )
        nMaxFld := max( nMaxFld, oTab:aColumns[cx]:width )
     ENDIF
  NEXT

  nGets := pos

  WHILE nGets > 0
    aadd( aGetLists, {} )
    aadd( aDesc2, {} )
    nGetLists++
    nGets -= min( nGets, nGPP )
  END

  IF nAction == ACTION_INSERT
     oCon:newRec()
     oCon:loadRelated()
  ENDIF

  nGPP := min( pos, nGPP )

  w := nDesc + nMaxFld + 4 + 3
  h := nGPP + 2
  l := ( ( maxCol() + 1 ) / 2 ) - int( w / 2 )
  r := l + w
  t := ( ( maxRow() + 1 ) / 2 ) - int( h / 2 )
  b := t + h

  aeval( aDesc, { |e,x| aDesc[x] := padr( e, nDesc ) + " : " } )

  nGets := pos

  FOR cx := 1 TO nGetLists
     FOR dx := 1 TO nGPP
        IF ex > nGets
           EXIT
        ENDIF
        aadd( aDesc2[cx], aDesc[ex] )
        aadd( aGetLists[cx],                                              ;
          getNew( t + dx,                                                 ;
                  l + nDesc + 5,                                          ;
                  oCon:fldBlock( aNCol[ex] ),,                            ;
                  oTab:aColumns[aNCol[ex]]:picture,                       ;
                  cGetClr                                                 ;
                )                                                         ;
            ) 
        ex++
     NEXT
  NEXT

  setKey( K_PGUP, { || getActive():exitState := GE_WRITE } )
  setKey( K_PGDN, { || getActive():exitState := GE_WRITE } )
  setKey( K_CTRL_ENTER, { || getActive():exitState := GE_WRITE } )

  cScr := saveScreen( t, l, b+1, r+1 )

  cStatLine := statusLine( " Press CTRL-Enter to save or ESC to exit. " )

  WHILE lStillGoing
     setColor( cWinClr )
     scroll( t, l, b, r )
     dispBox( t, l, b, r )
     shadow( t, l, b, r )

     aeval( aDesc2[nFoc], { |e,x| setPos( t+x, l+2 ), devOut( e ) } )
     aeval( aGetLists[nFoc], { |o| o:display() } )

     setCursor( 1 )
     readModal( aGetLists[nFoc] )
     setCursor( 0 )

     DO CASE
     CASE lastKey() == K_PGUP
        nFoc := iif( nFoc == 1, nGetLists, nFoc - 1 )
     CASE lastKey() == K_PGDN
        nFoc := iif( nFoc == nGetLists, 1, nFoc + 1 )
     CASE lastKey() == K_CTRL_ENTER
        IF askUser( "Confirm", "Are you ready to save this screen?" )
           lStillGoing := FALSE
           lProceed := TRUE
        ENDIF
     CASE lastKey() == K_ESC
        IF askUser( "Confirm", "Do you want to exit without saving?" )
           lStillGoing := FALSE
        ENDIF
     ENDCASE
  END

  setKey( K_PGUP, NIL )
  setKey( K_PGDN, NIL )
  setKey( K_CTRL_ENTER, NIL )

  IF lProceed
     DO CASE
     CASE nAction == ACTION_INSERT
        lProceed := oCon:addRec()
     CASE nAction == ACTION_MODIFY
        lProceed := oCon:putRec()
     ENDCASE
  ENDIF

  restScreen( maxRow(), 0, maxRow(), maxCol(), cStatLine )
  restScreen( t, l, b+1, r+1, cScr )
  setCursor( nCurs )

  RETURN lProceed
     
     
    

  
