## Copyright (C) 1996 John W. Eaton
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## usage: subwindw (xn, yn)
##
## NOTE: this will work only with gnuplot installed with
##       multiplt patch
##
## Sets subwindw position in multiplt mode for next plot. The
## multiplt mode has to be previously initialized using multiplt()
## command, else this command just becomes an aliad to multiplt()

## Author: Vinayak Dutt <Dutt.Vinayak@mayo.EDU>
## Created: 3 July 95
## Adapted-By: jwe

function subwindw (xn, yn)

  if (! gnuplot_has_multiplt)
    error ("subwindw: gnuplot does not appear to support this feature");
  endif

  ## global variables to keep track of multiplt options

  global multiplt_mode
  global multiplt_xsize multiplt_ysize
  global multiplt_xn multiplt_yn

  ## check calling argument count

  if (nargin != 2)
    usage ("subwindw (xn, yn)");
  endif

  ## check for scalar inputs

  if (! (is_scal (xn) && is_scal (yn)))
    error ("subwindw: xn and yn have to be scalars");
  endif

  xn = round (xn);
  yn = round (yn);

  ## switch to multiplt mode if not already in, and use the args as the
  ## args to multiplt()

  if (multiplt_mode != 1)
    multiplt (xn, yn);
    return;
  endif

  ## get the sub plot location

  if (xn < 1 || xn > multiplt_xn || yn < 1 || yn > multiplt_yn)
    error ("subwindw: incorrect xn and yn");
  endif

  xo = (xn - 1.0)*multiplt_xsize;
  yo = (multiplt_yn - yn)*multiplt_ysize;

  eval (sprintf ("gset origin %g, %g", xo, yo));

endfunction
