## Copyright (C) 1996 John W. Eaton
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## usage: multiplt (xn, yn)
##
## Sets and resets multiplt mode
##
## If multiplt(0,0) then it will close multiplt mode and and if
## arguments are non-zero, then it will set up multiplt mode with
## xn,yn subplots along x and y axes.
##
## NOTE: this will work only with gnuplot installed with
##       multiplt patch

## Author: Vinayak Dutt, Dutt.Vinayak@mayo.EDU
## Created: 3 July 95
## Adapted-By: jwe

function multiplt (xn, yn)

  if (! gnuplot_has_multiplt)
    error ("multiplt: gnuplot does not appear to support this feature");
  endif

  ## global variables to keep track of multiplt options

  global multiplt_mode
  global multiplt_xsize multiplt_ysize
  global multiplt_xn multiplt_yn
  global multiplt_xi multiplt_yi

  ## This is a real kludge.  We gnuplot should be made so that replot can
  ## be executed while doing multiple plots...

  global multiplt_save_auto_replot = automatic_replot

  if (nargin != 2)
    usage ("multiplt (xn, yn)");
  endif

  if (! (is_scal (xn) && is_scal (yn)))
    error ("multiplt: xn and yn have to be scalars");
  endif

  if (automatic_replot)
    warning ("turning off automatic replot for multiplt mode");
    multiplt_save_auto_replot = automatic_replot;
    automatic_replot = 0;
  endif

  xn = round (xn);
  yn = round (yn);

  if (xn == 0 && yn == 0)

    gset nomultiplt;
    gset size 1, 1;
    gset origin 0, 0;

    multiplt_mode = 0;
    multiplt_xsize = 1;
    multiplt_ysize = 1;
    multiplt_xn = 1;
    multiplt_yn = 1;
    multiplt_xi = 1;
    multiplt_yi = 1;

    ## Someone may have reset it betweeen calls...

    if (! isstr (automatic_replot) && ! automatic_replot)
      automatic_replot = multiplt_save_auto_replot;
    endif

    return;

  else

    if (xn < 1 || yn < 1)
      error ("multiplt: xn and yn have to be positive integers");
    endif

    gset multiplt;

    xsize = 1.0 ./ xn;
    ysize = 1.0 ./ yn;

    eval (sprintf ("gset size %g, %g", xsize, ysize));

    xo = 0.0;
    yo = (yn - 1.0)*ysize;

    eval (sprintf ("gset origin %g, %g", xo, yo));

    multiplt_mode = 1;
    multiplt_xsize = xsize;
    multiplt_ysize = ysize;
    multiplt_xn = xn;
    multiplt_yn = yn;
    multiplt_xi = 1;
    multiplt_yi = 1;

  endif

endfunction
