## Copyright (C) 1996 John W. Eaton
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## usage: mplot (x, y)
##        mplot (x1, y1, x2, y2, ...)
##        mplot (x, y, fmt)
##
## This is a modified version of plot() command to work with
## multiplt version of gnuplot to plot multiple plots per page.
## This plot version automatically updates the plot position to
## next plot position after making the plot in the given subplot
## position.
##
## See command plot() for the various options to this command
## as this is just mulitplot version of the same command.

## Author: Vinayak Dutt <Dutt.Vinayak@mayo.EDU>
## Adapted-By: jwe

function mplot (...)

  if (! gnuplot_has_multiplt)
    error ("mplot: gnuplot does not appear to support this feature");
  endif

  ## global variables to keep track of multiplt options

  global multiplt_mode
  global multiplt_xsize multiplt_ysize
  global multiplt_xn multiplt_yn
  global multiplt_xi multiplt_yi

  ## This is a real kludge.  We gnuplot should be made so that replot can
  ## be executed while doing multiple plots...

  global multiplt_save_auto_replot = automatic_replot

  if (automatic_replot)
    warning ("turning off automatic replot for multiplt mode");
    multiplt_save_auto_replot = automatic_replot;
    automatic_replot = 0;
  endif

  gset nologscale;
  gset nopolar;

  __plt__ ("plot", all_va_args);

  ## update the plot position

  if (multiplt_mode)

    if (multiplt_xi < multiplt_xn)
      multiplt_xi++;
    else
      multiplt_xi = 1;
      if (multiplt_yi < multiplt_xn)
	multiplt_yi++;
      else
	multiplt_yi = 1;
      endif
    endif

    xo = (multiplt_xi - 1.0)*multiplt_xsize;
    yo = (multiplt_yn - multiplt_yi)*multiplt_ysize;

    eval (sprintf ("gset origin %g, %g", xo,yo));

  endif

endfunction
