/*
*******************************************************************************
** Update an previous Octave/2 Installation                                  **
** (c) Klaus Gebhardt, 1996 - 1997                                           **
*******************************************************************************
*/

/*
*******************************************************************************
** This script will make all the necessary changes in the following files:   **
**                                                                           **
**   1. CONFIG.SYS                                                           **
**   2. .emacs                                                               **
**   3. .octaverc                                                            **
**     (or the file pointed to by the environment variable OCTAVE_INITFILE)  **
**   4. %INFOPATH%dir                                                        **
**   5. make-octfile.cmd                                                     **
*******************************************************************************
** It will also copy the info files to the directoy pointed to by the        **
** variable INFOPATH, and it replaces emx.dll, emxlibcs.dll and              **
** termcap.dat, if the files coming with Octave/2 are newer than those       **
** on your system.                                                           **
*******************************************************************************
** This script also creates a folder with a program object for Octave/2      **
** on the WPS.                                                               **
*******************************************************************************
** ALL ORIGINAL FILES, WHICH ARE MODIFIED OR REPLACED BY THIS SCRIPT         **
** ARE BACKUPED IN THE DIRECTORY YOU HAVE OCTAVE/2 INSTALLED IN.             **
*******************************************************************************
** NO WARRANTY!                                                              **
*******************************************************************************
*/

"@echo off"
debug = ">NUL 2>NUL"
debug_mode = 0;

version     = "2.05";
script_arc  = "SCRIPTS.ZIP";
dlfcn_arc   = "DLFCN.ZIP";

default_dir.0 = 2;
default_dir.1 = "h:/apps/science/octave-";
default_dir.2 = "i:/apps/octave-";

config_modified   = 0;
config.0.nr =  9;
config.1.nr =  8; config.1.name = "LIBPATH=";             config.1.zeile = "";
config.2.nr =  9; config.2.name = "SET PATH=";            config.2.zeile = "";
config.3.nr = 16; config.3.name = "SET OCTAVE_HOME=";     config.3.zeile = "";
config.4.nr = 12; config.4.name = "SET TERMCAP=";         config.4.zeile = "";
config.5.nr =  9; config.5.name = "SET TERM=";            config.5.zeile = "";
config.6.nr =  9; config.6.name = "SET HOME=";            config.6.zeile = "";
config.7.nr = 20; config.7.name = "SET OCTAVE_INITFILE="; config.7.zeile = "";
config.8.nr = 13; config.8.name = "SET INFOPATH=";        config.8.zeile = "";
config.9.nr = 12; config.9.name = "SET GNUPLOT=";         config.9.zeile = "";

emacs_modified = 0;
octaverc_modified = 0;
dir_modified = 0;


call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs

parse upper arg option cmdl

/*
*******************************************************************************
** Debug-Mode                                                                **
*******************************************************************************
*/
if (option == "/DEBUG") then
  do
    say "info: Running in DEBUG mode!";
    "@echo on"
    debug = ""
    debug_mode = 1;
  end
else
  do
    debug_mode = 0;
    cmdl = option;
  end

/*
*******************************************************************************
** Wrong argument and usage message                                          **
*******************************************************************************
*/
if ((cmdl <> "/USAGE") & (cmdl <> "")) then
  do
    say "error: Unknown command line option!";
    say "";
    cmdl = "/USAGE";
  end

if (cmdl == "/USAGE") then
  do
    say "Usage:"
    say "  Type 'updt-octave' to update your Octave/2" version "Installation";
    say "  Type 'updt-octave /usage'   to see this message.";
    say "on FAT systems you must type 'updt-oct' instead of 'updt-octave'";
    exit;
  end

/*
*******************************************************************************
** Updating the installation                                 **
*******************************************************************************
*/
say "info: Updating Octave/2" version "..."

octave_home = to_unix_sep(directory());
octave_dll = octave_home || "/dll";
if (check_octave_files(octave_home, 1) == 0) then
  do
    say "error: Run this script from within in the directory octave is"
    say "error: installed in!"
    exit;
  end
say "info: Octave/2 is installed in" octave_home || ".";

/* Removing old files */
"del doc\refcard*" debug

/* Unzip the files for dynamic loading */
call unzip_dlfcn_files dlfcn_arc

/* Create the script for compiler DLFCN modules */
call make_octfile octave_home

/* Unzip the script files */
call unzip_script_files script_arc

say "info: Done.";
exit;

/*
*******************************************************************************
** Write the modified config.sys                                             **
*******************************************************************************
*/
write_config_new: procedure expose config. debug version
parse arg boot, dir
  config_old = to_os2_sep(dir) || "\config.old";
  config_new = to_os2_sep(dir) || "\config.new";
  "del" config_new debug

  rc = stream(config_old, "C", "open read");
  if rc <> "READY:" then
    do
      say "error: Cannot open the backup of CONFIG.SYS!";
      exit;
    end

  rc = stream(config_new, "C", "open write");
  if rc <> "READY:" then
    do
      say "error: Cannot open CONFIG.NEW!";
      rc = stream(config_old, "C", "close");
      exit;
    end

  say "info: Writing" config_new "...";
  do while(lines(config_old))
    line = linein(config_old);
    do i=1 to config.0.nr
      if (to_upper(substr(strip(line), 1, config.i.nr)) == config.i.name) then
        do
          if config.i.zeile <> "" then
            do
              p = pos(to_upper(config.i.name), to_upper(config.i.name));
              if (p <= 1) then
                line = config.i.name || config.i.zeile;
              else
                line = substr(" ",1,p," ") || config.i.name || config.i.zeile;
              config.i.zeile = "";
            end
          leave;
        end
    end
    call lineout config_new, line
  end

  sep = 0;
  do i=1 to config.0.nr
    if (config.i.zeile <> "") then
      do
        if (sep == 0) then
          do
            call lineout config_new, ""
            call lineout config_new, "REM Octave/2" version
            sep = 1;
          end
        call lineout config_new, config.i.name || config.i.zeile;
        config.i.zeile = "";
      end
  end

  rc = stream(config_new, "C", "close");
  rc = stream(config_old, "C", "close");
  return;

/*
*******************************************************************************
** Analysing CONFIG.SYS:                                                     **
*******************************************************************************
*/
read_config_sys: procedure expose config. default_dir. debug
parse arg boot, dir
  config_old = to_os2_sep(dir) || "\config.old";
  say "info: Copying" boot || "\config.sys to" config_old "...";
  "copy" boot || "\config.sys" config_old debug

  rc = stream(config_old, "C", "open read");
  if (rc <> "READY:") then
    do
      say "error: Cannot open the backup of CONFIG.SYS!";
      exit;
    end

  say "info: Analysing" config_old "...";
  do while(lines(config_old))
    line  = strip(linein(config_old));
    do i=1 to config.0.nr
      strupper = to_upper(substr(line, 1, config.i.nr));
      if (strupper == config.i.name) then
        do
          config.i.zeile = substr(line, config.i.nr+1);
          leave;
        end
    end
  end
  rc = stream(config_old, "C", "close");

  if (config.1.zeile == "") then
    do
      say "error: No "LIBPATH" statement found!";
      exit;
    end
  else libpath = config.1.zeile;

  if (config.2.zeile == "") then
    do
      say "error: No "SET PATH" statement found!";
      exit;
    end
  else path = config.2.zeile;

  oh = config.3.zeile;
  if (oh <> "") then return to_unix_sep(oh);
  else
    do
      do i = 1 to default_dir.0
        oh = check_octave_old_home(default_dir.i, libpath, path);
        if (oh <> "") then return to_unix_sep(oh);
      end
    end
  return "";

check_octave_old_home: procedure expose debug
parse arg str, libpath, path
  string = to_os2_sep(str);
  pa = 0;
  do while(1)
    pa = pos(to_upper(string), to_upper(path), pa + 1);
    if (pa == 0) then return "";
    if ((pa <> 1) & (substr(path, pa - 1, 1) <> ";")) then iterate;
    pe = pos(";", path, pa);
    if (pe == 0) then old_home = substr(path, pa);
    else              old_home = substr(path, pa, pe-pa);
    qa = pos(to_upper(old_home || "\DLL"), to_upper(libpath));
    if (qa == 0) then iterate;
    if ((qa <> 1) & (substr(path, qa - 1, 1) <> ";")) then iterate;
    qe = pos(";", libpath, qa);
    if qe == 0 then old_dll = to_upper(substr(libpath, qa));
    else            old_dll = to_upper(substr(libpath, qa, qe-qa));
    if (to_upper(old_home || "\DLL") == old_dll) then
      do
	flag = check_octave_files(old_home, 0);
	if (flag == 0) then
          do
            say "notice: I FOUND AN OLD OCTAVE DIRECTORY ("fullpath") IN";
            say "notice: LIBPATH AND PATH, BUT WITHOUT ANY OCTAVE FILES.";
            say "notice: SHOULD I REMOVE ALL ENTRIES IN LIBPATH AND PATH";
            say "notice: POINTING TO THAT DIRECTORY [Y/N]";
            parse pull in;
            flag = (in == "Y") | (in == "y");
          end
        if (flag) then return to_unix_sep(old_home);
      end
    else  return "";
  end

check_octave_files: procedure expose debug
parse arg string, flag
  path = to_os2_sep(string);
  rc = SysFileTree(path || "\octave.exe",     exe, "FO");
  rc = SysFileTree(path || "\octave.ico",     ico, "FO");
  rc = SysFileTree(path || "\dll\cruft?.dll", crt, "FO");
  if (flag <> 0) then rc = SysFileTree(path || "\dll\octave?.dll", oct, "FO");
  else                oct.0 = 2;
  res = (exe.0 == 1) & (ico.0 == 1) & (crt.0 == 4) & (oct.0 == 2);
  return res;

/*
*******************************************************************************
** Updating the emx TERMCAP.DAT                                              **
*******************************************************************************
*/
emx_termcap: procedure expose debug
parse arg termcap
  call SysFileTree "etc\termcap.dat", oct_datei, "FT";
  if oct_datei.0 <> 1 then return termcap;
  if datei.1 > 80 then oct = "19" || oct_datei.1;
  else                 oct = "20" || oct_datei.1;

  call SysFileTree to_os2_sep(termcap), emx_datei, "FT";
  if emx_datei.0 <> 1 then return "";
  if datei.1 > 80 then emx = "19" || emx_datei.1;
  else                 emx = "20" || emx_datei.1;

  if oct == emx then return termcap;
  if oct > emx then
    do
      say "info: Replacing" to_os2_sep(termcap) "...";
      "copy" to_os2_sep(termcap) "termcap.old" debug
      "copy etc\termcap.dat" to_os2_sep(termcap) debug
    end
  else
    do
      say "info: Removing termcap.dat coming with Octave/2 ...";
      "del etc\termcap.dat" debug
      "rd etc" debug
    end

  return termcap;

/*
*******************************************************************************
** Replacing the emx-DLLs                                                    **
*******************************************************************************
*/
emx_dlls: procedure expose debug
parse arg libpath, file
  call SysFileTree "dll\" || file, oct_datei, "FT";
  if oct_datei.0 <> 1 then return;
  if datei.1 > 80 then oct = "19" || oct_datei.1;
  else                 oct = "20" || oct_datei.1;

  count = 0;
  do while(1)
    n = setlocal();
    "SET OCTAVE_LIBPATH=" || libpath
    fullpath = SysSearchPath(OCTAVE_LIBPATH, file);
    if fullpath == "" then leave;
    call SysFileTree fullpath, emx_datei, "FT";
    if emx_datei.0 <> 1 then leave;
    if datei.1 > 80 then emx = "19" || emx_datei.1;
    else                 emx = "20" || emx_datei.1;
    n = endlocal();

    if oct == emx then leave;
    if oct > emx then
      do
        count = count+1;
        bak_file = substr(file, 1, length(file)-3) || count;
        "copy" fullpath bak_file debug
        say "info: Older DLL (" || file || ") saved as:" bak_file;
        say "info: Removing DLL (" || file || ") ...";
        rc = 1;
        do while(rc <> 0)
          rc = SysFileDelete(fullpath);
          if rc <> 0 then
            do
              say "notice: UNABLE TO DELETE FILE:" fullpath;
              say "notice: THE DLL IS USED BY ONE OR MORE EMX PROGRAMS!";
              say "notice: KILL ALL THOSE PROGRAMS BEFORE CONTINUING!";
              say "notice: PRESS ENTER, WHEN READY ...";
              parse pull in;
            end
        end            
      end
    else
      do
        say "info: Removing" file "coming with Octave/2 ...";
        "del dll\" || file debug;
        leave;
      end
  end
  return;

/*
*******************************************************************************
** Updating .octaverc                                                        **
*******************************************************************************
*/
update_octaverc: procedure expose debug debug_mode version
parse arg home, initfile, old, new
  if (initfile == "") then octrc = ".octaverc";
  else                     octrc = initfile;

  octrc_new = "octaverc.new";
  rc = ini_files(home, octrc, "octaverc", old, new);
  if (rc == -1) then
    do
      "del" octrc_new debug
      rc = stream(octrc_new, "C", "open write");
      if (rc == "READY:") then
        do
          call lineout octrc_new, "# Startup file"
          call lineout octrc_new, "# Octave" version "for OS/2"
          call lineout octrc_new, "# (c) 1996 - 1997, Klaus Gebhardt"
          rc = stream(octrc_new, "C", "close");
          rc = 2;
        end
      else
        do
          say "error: Cannot create octaverc.new!";
         exit;
        end
    end

  if (rc == 2) then
    do
      "del" to_os2_sep(home) || "\" || octrc debug
      octrc_ini = to_os2_sep(home) || "\octave.ini"
      "copy" octrc_new octrc_ini debug
      "ren" octrc_ini ".octaverc" debug
      rc = stream(octrc_ini, "C", "open read");
      if (rc == "READY:") then
        do
          rc = stream(octrc_new, "C", "close");
          rc = stream(octrc_ini, "C", "open write");
          call lineout octrc_new, ''
          call lineout octrc_new, 'history_file = "octave.hst"'
          rc = stream(octrc_new, "C", "close");
          return "octave.ini";
        end
      return "";
    end
  return initfile;

/*
*******************************************************************************
** Modify the files .emacs, .octaverc                                        **
*******************************************************************************
*/
ini_files: procedure expose debug
parse arg home, inifile, newfile, oldpath, newpath
  file = to_os2_sep(home) || "\" || inifile;
  ini_old = newfile || ".old";
  ini_new = newfile || ".new";
  say "info: Copying" file "to" ini_old "...";
  "copy" file ini_old debug

  old = to_unix_sep(oldpath);
  new = to_unix_sep(newpath);

  rc = stream(ini_old, "C", "open read");
  if (rc <> "READY:") then return -1;

  "del" ini_new debug;
  rc = stream(ini_new, "C", "open write");
  if (rc <> "READY:") then
    do
      say "info: Cannot open" ini_new || "!";
      rc = stream(ini_old, "C", "close");
      exit;
    end

  if (to_upper(old) == to_upper(new)) then return 0;

  rv = 1;
  do while(lines(ini_old))
    line  = linein(ini_old);
    p = pos(to_upper(old), to_upper(line));
    if (p <> 0) then
      do
        rv = 2;
        line = substr(line, 1, p-1) || new || substr(line, p+length(old));
      end
    call lineout ini_new, line
  end

  rc = stream(ini_new, "C", "close");
  rc = stream(ini_old, "C", "close");
  return rv;

/*
*******************************************************************************
** Remove old INFO files, modify all dir files                               **
*******************************************************************************
*/
info_path_dir: procedure expose debug
parse arg info_path, octave_home, version
  infopath = to_os2_sep(info_path);
  octaveinfopath = to_os2_sep(octave_home || "/doc");

  p = 1;
  q = 1;
  do while (q > 0)
    q = pos(";", infopath, p);
    if (q == 0) then infodir = substr(infopath, p);
    else             infodir = substr(infopath, p, q - p);
    p = q + 1;

    if (infodir == ".")  then iterate;
    if (to_upper(infodir) == to_upper(octaveinfopath)) then iterate;

    say "info: Removing old info files in" infodir;
    "del" infodir || "\octave" debug
    "del" infodir || "\octave.i0?" debug
    "del" infodir || "\octave.i1?" debug
    "del" infodir || "\liboct" debug
    "del" infodir || "\liboct.i0?" debug
    "del" infodir || "\faq" debug

    file = infodir || "\dir"
    dir_old = "dir" || p || ".old";
    dir_new = "dir" || p || ".new";
    say "info: Copying" file "to" dir_old "...";
    "copy" file dir_old debug

    rc = stream(dir_old, "C", "open read");
    if (rc <> "READY:") then return;

    "del" dir_new debug;
    rc = stream(dir_new, "C", "open write");
    if (rc <> "READY:") then
      do
        say "error: Cannot open" dir_new || "!";
        rc = stream(dir_old, "C", "close");
        exit;
      end

    line = " ";
    do while(lines(dir_old))
      if line == d2c(31) then call lineout dir_new, line
      line  = linein(dir_old);
      parse var line w1 w2 ":" w3 "." w4
      if ((w1 <> "*") | ((to_upper(w3) <> "(FAQ)") & (to_upper(w3) <> "(OCTAVE)") & (to_upper(w3) <> "(LIBOCT)"))) then
        do
          if line <> d2c(31) then call lineout dir_new, line
        end
    end

    call lineout dir_new, "* octave:    (octave).      Octave" version || "."
    call lineout dir_new, "* liboctave: (liboct).      Info about liboctave" version || "."
    call lineout dir_new, "* octave-faq:(faq).         FAQs about Octave" version || "."
   call lineout dir_new, d2c(31)

    rc = stream(dir_new, "C", "close");
    rc = stream(dir_old, "C", "close");

    say "info: Copying" dir_new "to" file "...";
    "copy" dir_new file debug
  end
  return;

/*
*******************************************************************************
** Create MAKE-OCTFILE                                                       **
*******************************************************************************
*/
make_octfile: procedure expose debug
parse arg octave_home
  "del make-octfile.cmd make-oct.cmd" debug
  rc = stream("make-oct.cmd", "C", "open write");
  if (rc <> "READY:") then
    do
      say "error: Cannot open make-oct.cmd!"
      exit;
    end

  call lineout "make-oct.cmd", "/* Build .OCT file from source */"
  call lineout "make-oct.cmd", "/* (c) Klaus Gebhardt, 1997 */"
  call lineout "make-oct.cmd", "'@setlocal'"
  call lineout "make-oct.cmd", "'@SET C_INCLUDE_PATH=" || to_unix_sep(octave_home) || "/dlfcn/octave;" || to_unix_sep(octave_home) || "/dlfcn;%C_INCLUDE_PATH%'"
  call lineout "make-oct.cmd", "'@SET CPLUS_INCLUDE_PATH=" || to_unix_sep(octave_home) || "/dlfcn/octave;" || to_unix_sep(octave_home) || "/dlfcn;%CPLUS_INCLUDE_PATH%'"
  call lineout "make-oct.cmd", "'@SET LIBRARY_PATH=" || to_unix_sep(octave_home) || "/dlfcn/lib;%LIBRARY_PATH%'"
  call lineout "make-oct.cmd", "call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'"
  call lineout "make-oct.cmd", "call SysLoadFuncs"
  call lineout "make-oct.cmd", "parse arg ccfile libs"
  call lineout "make-oct.cmd", "if (ccfile <> '') then"
  call lineout "make-oct.cmd", "  do"
  call lineout "make-oct.cmd", "    len  = length(ccfile);"
  call lineout "make-oct.cmd", "    name = substr(ccfile,1,len-3);"
  call lineout "make-oct.cmd", "    ext  = substr(ccfile,len-2);"
  call lineout "make-oct.cmd", "  end"
  call lineout "make-oct.cmd", "if ((ext <> '.cc') & (ext <> '.CC')) then"
  call lineout "make-oct.cmd", "  do"
  call lineout "make-oct.cmd", "    say 'error: invalid argument'"
  call lineout "make-oct.cmd", "    exit;"
  call lineout "make-oct.cmd", "  end"
  call lineout "make-oct.cmd", "gccopt2 = '-m486 -mieee-fp -O3 -malign-loops=2 -malign-jumps=2 -malign-functions=2 -DEMX09C -DOS2';"
  call lineout "make-oct.cmd", "'gcc' gccopt2 '-s -c' ccfile '-o' name || '.obj -Zomf'"
   call lineout "make-oct.cmd", "'@echo LIBRARY' name || ' INITINSTANCE TERMINSTANCE>' name || '.def'"
  call lineout "make-oct.cmd", "'@echo DESCRIPTION ' || d2c(34) || name || '.oct, (c) Klaus Gebhardt 1995-1997' || d2c(34) || '>>' name || '.def'"
  call lineout "make-oct.cmd", "'@echo.>>' name || '.def'"
  call lineout "make-oct.cmd", "'@echo DATA>>' name || '.def'"
  call lineout "make-oct.cmd", "'@echo   MULTIPLE NONSHARED>>' name || '.def'"
  call lineout "make-oct.cmd", "'@echo.>>' name || '.def'"
  call lineout "make-oct.cmd", "'@echo EXPORTS>>' name || '.def'"
  call lineout "make-oct.cmd", "'emxexp' name || '.obj >> ' name || '.def'"
  call lineout "make-oct.cmd", "lnkopt2 = '-lcruft1 -lcruft2 -lcruft3 -lcruft4 -loctave1 -loctave2 -lreadline -lgnuinfo -lkpathsea -lxmalloc -lgpp2 -lstdcpp2 -lsocket -ldlfcn -lf2cdll -loct-img' libs;"
  call lineout "make-oct.cmd", "'gcc' gccopt2 '-o' name || '.oct' name || '.def' name || '.obj' lnkopt2 '-Zdll -Zomf -Zcrtdll'"
  call lineout "make-oct.cmd", "'@del' name || '.obj' name || '.def >NUL 2>NUL'"
  call lineout "make-oct.cmd", "'@endlocal'"
  call lineout "make-oct.cmd", "exit;"
  rc = stream("make-oct.cmd", "C", "close");
  "ren make-oct.cmd make-octfile.cmd" debug
  return;

/*
*******************************************************************************
** Unzip DLFCN files                                                         **
*******************************************************************************
*/
unzip_dlfcn_files: procedure expose debug
parse arg dlfcn
  ".\unzip -o" dlfcn debug
  return;

/*
*******************************************************************************
** Unzip script files                                                        **
*******************************************************************************
*/
unzip_script_files: procedure expose debug
parse arg zipfile
  rc = SysFileTree(zipfile, fs, "F");
  if fs.0 = 0 then return;
  rc = SysFileTree("ChangeLog", fs, "F");
  if fs.0 = 1 then scr = "scripts/*";
  else             scr = "scripts.fat/*";
  say "info: Unzipping scriptfiles ...";
  if fs.0 = 0 then "ren scripts scripts.fat";
  ".\unzip -o" zipfile scr debug
  if fs.0 = 0 then "ren scripts.fat scripts";
  return;

/*
*******************************************************************************
** Create a WPS object for Octave/2                                          **
*******************************************************************************
*/
create_wps_object: procedure expose debug
parse arg octave_home, version
  call SysCreateObject "WPFolder", "Octave/2", "<WP_DESKTOP>", ,
       "OBJECTID=<HWB_OCTAVE_FOLDER>", "fail"

  object_name = "Octave" version;
  octave_file = to_os2_sep(octave_home) || "\octave.exe";
  octave_icon = to_os2_sep(octave_home) || "\octave.ico";

  rc = SysCreateObject("WPProgram", object_name, "<HWB_OCTAVE_FOLDER>", ,
       "EXENAME="octave_file";PROGTYPE=WINDOWABLEVIO;ICONFILE="octave_icon||,
       ";OBJECTID=<HWB_OCTAVE>", "replace");

  if rc == 1 then say "info: Program object for Octave created successfully."
  else            say "notice: Could not create program object for Octave."
  return;

/*
*******************************************************************************
** Determine the drive OS/2 is booted from                                   **
*******************************************************************************
*/
get_boot_drive: procedure expose debug
  irc = SysIni("BOTH", "FolderWorkareaRunningObjects",,
               "ALL:", "Objects");
  boot1 = left(Objects.1, 2);
  boot2 = substr(translate(value("PATH", , "OS2ENVIRONMENT")), pos("\OS2\SYSTEM", translate(value("PATH", , "OS2ENVIRONMENT")))-2, 2);
  rc = SysFileTree(boot1 || "\config.sys", cfg, "FO");
  if ((to_upper(boot1) <> to_upper(boot2)) | (cfg.0 <> 1)) then
    do
      say "error: Unable to determine the boot drive!";
      exit;
    end
  return boot1;

/*
*******************************************************************************
** Replace old pathes                                                        **
*******************************************************************************
*/
subst_paths: procedure expose debug
parse arg path_arg, old_path, new_path
  path= to_os2_sep(path_arg);
  old = to_os2_sep(old_path);
  new = to_os2_sep(new_path);

  p = 0;
  do while(1)
    p = pos(to_upper(old), to_upper(path), p + 1);
    if (p == 0) then
      do
        if (substr(path, length(path)) == ";") then return path || new || ";";
        else                                        return path || ";" || new;
      end
    if ((p <> 1) & (substr(path, p - 1, 1) <> ";")) then iterate;
    q = pos(";", path, p);
    if (q == 0) then old_path = substr(path, p);
    else             old_path = substr(path, p, q - p);
    if (to_upper(old_path) <> to_upper(old)) then iterate;
    if (q == 0) then return substr(path, 1, p-1) || new;
    else             return substr(path, 1, p-1) || new || substr(path, q);
  end

/*
*******************************************************************************
** Utilities                                                                 **
*******************************************************************************
*/
to_upper: procedure
parse arg string
  return translate(string, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "abcdefghijklmnopqrstuvwxyz");

to_lower: procedure
parse arg string
  return translate(string, "abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ");

to_unix_sep: procedure
parse arg string
  return translate(string, "/", "\");

to_os2_sep: procedure
parse arg string
  return translate(string, "\", "/");
