(*(*(*********************************************************************

:Program.    TestGetImageClass.mod
:Contents.   test module for GetImageClass
:Author.     hartmut Goebel [hG]
:Address.    Aufseplatz 5, D-90459 Nrnberg
:Address.    UseNet: hartmut@oberon.nbg.sub.org
:Address.    Z-Netz: hartmut@asn.zer   Fido: 2:246/81.1
:Copyright.  Copyright  1993 by hartmut Goebel
:Language.   Oberon-2
:Translator. Amiga Oberon 3.01
:Version.    $VER: TestGetImageClass.mod 3.0 (15.9.93)

(* $StackChk- $NilChk- $RangeChk- $CaseChk- $OvflChk- $ReturnChk- $ClearVars- *)
*********************************************************************)*)*)

MODULE TestGetImageClass;

IMPORT
  e := Exec,
  gf := GetImageClass,
  I := Intuition,
  NoGuru,
  u := Utility,
  y := SYSTEM;

VAR
  win : I.WindowPtr;
  scr: I.ScreenPtr;

CONST
  versionString = "$VER: TestGetImageClass 3.0 (15.9.93)";

  numImages = 7;
TYPE
  ImageTypes = ARRAY numImages OF INTEGER;
CONST
  imageTypes = ImageTypes(gf.getFile, gf.getFolder, gf.getScreen,
                          gf. getFont, gf.getScreenMode, gf.getSomethingElse,
                          gf.getPrinter);

  leftOffset = 10; rightOffset = 10;
  width1 = 20; height1 = 30;
  width2 = 30; height2 = 15;
  distance = width2+10;

PROCEDURE ResizeGadget(gad: I.GadgetPtr; width, height: INTEGER);
VAR
  image: I.ImagePtr;
BEGIN
  image := gad.gadgetRender;
  I.EraseImage(win.rPort, image^, gad.leftEdge, gad.topEdge);
  IF 0 # I.SetAttrs(image,
    I.iaWidth,width,
    I.iaHeight, height,
    u.done)
  THEN
    (* I.DrawImage(win.rPort, image^, gad.leftEdge, gad.topEdge); *)
  END;
  IF 0 = I.SetGadgetAttrs(gad^,win,NIL,
     I.gaWidth,width,
     I.gaHeight,height,
     u.done)
  THEN END;
  I.RefreshGList(gad,win,NIL,1);
END ResizeGadget;

PROCEDURE MakeImage(VAR image: I.ImagePtr; which: INTEGER);
BEGIN
  image := I.NewObject (gf.getImageClass, NIL,
                        gf.which,  which,
                        I.iaWidth, width1,
                        I.iaHeight,height1,
                        u.done);
  IF image = NIL THEN HALT(20); END;
END MakeImage;

PROCEDURE MakeGadget(VAR gad: I.GadgetPtr; prev: I.GadgetPtr;
                     image: I.ImagePtr; left: INTEGER);

BEGIN
  gad := I.NewObject(NIL,I.buttonGClass,
             I.gaWidth, width1,
             I.gaHeight,height1,
             I.gaTop,   40,
             I.gaLeft,  left+win.borderLeft,
             I.gaImage, image,
             u.IgnoreIfNIL(I.gaPrevious, prev), prev,
             u.done);
  IF gad = NIL THEN HALT(20); END;
END MakeGadget;

PROCEDURE WaitClose();
VAR
  msg: I.IntuiMessagePtr;
BEGIN
  LOOP
    e.WaitPort(win.userPort);
    msg := e.GetMsg(win.userPort);
    WHILE msg # NIL DO
      IF msg.class = LONGSET{I.closeWindow} THEN RETURN END;
      msg := e.GetMsg(win.userPort);
    END;
  END;
END WaitClose;


VAR
  images: ARRAY numImages OF I.ImagePtr;
  gads: ARRAY numImages OF I.GadgetPtr;
  i: INTEGER;

BEGIN
  IF I.int.libNode.version < 37 THEN HALT(20) END;

  IF gf.InitClass() THEN
    scr := y.ADR(versionString); (* necessary dummy :-( *)
    scr := I.LockPubScreen(NIL);
    win := I.OpenWindowTagsA(NIL,
               I.waPubScreen,scr,
               I.waInnerWidth, (numImages)*(distance)+rightOffset,
               I.waInnerHeight, 80,
               I.waTitle, y.ADR("<- Click here for some magic :-)"),
               I.waFlags, LONGSET{I.windowDepth,I.windowDrag,I.windowClose},
               I.waIDCMP, LONGSET{I.closeWindow},
               u.end);
    I.UnlockPubScreen(NIL,scr);

    IF win # NIL THEN
      FOR i := 0 TO numImages-1 DO
        MakeImage(images[i],imageTypes[i]);
      END;

      MakeGadget(gads[0],NIL,images[0],leftOffset);
      FOR i := 1 TO numImages-1 DO
        MakeGadget(gads[i],gads[i-1],images[i],leftOffset+i*distance);
      END;

      IF I.AddGList(win,gads[0],-1,numImages,NIL) = 0 THEN END;
      I.RefreshGadgets(gads[0],win,NIL);
      WaitClose();

      FOR i := 0 TO numImages-1 DO
        ResizeGadget(gads[i],width2,height2);
      END;
      WaitClose();

      IF I.RemoveGList(win,gads[0],numImages) = 0 THEN END;
    END;
  END;

CLOSE
  FOR i := numImages-1 TO 0 BY -1 DO
    I.DisposeObject(gads[i]);
    I.DisposeObject(images[i]);
  END;
  IF win# NIL THEN I.CloseWindow(win); END;

END TestGetImageClass.

