(*(***********************************************************************

:Program.    TestFuelGaugeIClass.mod
:Contents.   test program for FuelGaugeIClass
:Author.     hartmtut Goebel [hG]
:Address.    Aufseplatz 5, D-90459 Nrnberg
:Address.    UseNet: hartmut@oberon.nbg.sub.org
:Address.    Z-Netz: hartmut@asn.zer   Fido: 2:246/81.1
:Copyright.  Copyright  1993 by hartmtut Goebel
:Language.   Oberon-2
:Translator. Amiga Oberon 3.0
:Version.    $VER: TestFuelGaugeIClass.mod 1.4 (5.9.93)

(* $StackChk- $NilChk- $RangeChk- $CaseChk- $OvflChk- $ReturnChk- $ClearVars- *)
(****i* /--history-- ***************************************
*
*  V1.4  more comments in source
*  V1.3  can be used with textgaugi.class shared library (option asLib)
*  V1.2  reacts on CloseGadget
*  V1.1  cosmetics on source and output window
*  V1.0  initial version
*
*********************************************************************)*)*)

MODULE TestFuelGaugeIClass;

IMPORT
  e := Exec,
  I := Intuition,
  Dos,
  TG := TextGaugeIClass,
  FG := FuelGaugeIClass,
  NoGuru,
  u := Utility,
  y := SYSTEM;

CONST
  versionString = "$VER: TestFuelGaugeIClass 1.4 (5.9.93)";

(*
** compiling with SET asLib will produce a version which tries to use
** the public class textgaugeiclass. Thatfor you have to compile
** TextGaugeIClass.mod with SET asLib, too, and link it using
** 'LibLink WITH txt/TextGaugeIClass.wth'. This will produce the file
** 'textgaugei.class' whcih will be loaded as shared class library in
** the current dir.
*)
  (* $IF asLib *)
    useLib = TRUE;
  (* $ELSE *)
    useLib = FALSE;
  (* $END *)

VAR
  win : I.WindowPtr;
  scr: I.ScreenPtr;
  drawinfo : I.DrawInfoPtr;

  fuelGauge1, fuelGauge2: I.ImagePtr;
  fuelGauge3, fuelGauge4: I.ImagePtr;
  dummy: y.ADDRESS;

  classLib: e.LibraryPtr; (* for useLib only *)

CONST
  fg1width  = 100; fg1height = 14;
  fg2width  = 14; fg2height = 100;
  fg1left = 30; fg1top = 66;
  fg3left = fg1left; fg3top = fg1top+fg1height+10;

  fg2left = fg1left+fg1width+10; fg2top  = 30;
  fg4left = fg2left+fg2width+10; fg4top  = fg2top;

PROCEDURE MakeImage(VAR image: I.ImagePtr; width, height: INTEGER;
                    vertical, reverse: BOOLEAN);
VAR
  v, r: I.LONGBOOL;
BEGIN
  v := I.LFALSE; r := I.LFALSE;
  IF vertical THEN v := I.LTRUE; END;
  IF reverse THEN r := I.LTRUE; END;
  IF useLib THEN
    image := I.NewObject(NIL, TG.textGaugeIClassName, (* use public name *)
               I.iaWidth,width,
               I.iaHeight,height,
               I.sysiaDrawInfo, drawinfo,
               FG.max, 1000,
               FG.vertical, v,
               FG.fromRightToLeft, r,
               u.end);
  ELSE
    image := I.NewObject(TG.textGaugeIClass, NIL, (* use private class *)
               I.iaWidth,width,
               I.iaHeight,height,
               I.sysiaDrawInfo, drawinfo,
               FG.max, 1000,
               FG.vertical, v,
               FG.fromRightToLeft, r,
               u.end);
  END;
END MakeImage;

PROCEDURE SetCurrent(image: I.ImagePtr; current: LONGINT; left, top: INTEGER);
BEGIN
  IF I.SetAttrs(image, FG.current, current, u.done) # 0 THEN
    I.DrawImage(win.rPort,image^,left,top);
  END;
END SetCurrent;

PROCEDURE CheckCloseGad(): BOOLEAN;
VAR
  msg: I.IntuiMessagePtr;
BEGIN
  msg := e.GetMsg(win.userPort);
  IF msg = NIL THEN
    RETURN FALSE;
  ELSE
    e.ReplyMsg(msg);
    RETURN TRUE;
  END;
END CheckCloseGad;

PROCEDURE CountUp(): BOOLEAN;
VAR
  i: LONGINT;
BEGIN
  FOR i := 0 TO 1000 BY 10 DO
    (*
    IF I.GetAttr(FG.current, fuelGauge, qwe)=0 THEN END;
    Dos.PrintF("currval = %ld\n", qwe);
    Dos.Delay(10);
    *)
    SetCurrent(fuelGauge1, i, fg1left, fg1top);
    SetCurrent(fuelGauge2, i, fg2left, fg2top);
    SetCurrent(fuelGauge3, i, fg3left, fg3top);
    SetCurrent(fuelGauge4, i, fg4left, fg4top);
    Dos.Delay(8);
    IF CheckCloseGad() THEN RETURN FALSE END;
  END;
  RETURN TRUE;
END CountUp;

PROCEDURE CountDown(): BOOLEAN;
VAR
  i: LONGINT;
BEGIN
  FOR i := 1000 TO 0 BY -10 DO
    (* IF I.GetAttr(FG.current, fuelGauge, qwe)=0 THEN END; *)
    SetCurrent(fuelGauge1, i, fg1left, fg1top);
    SetCurrent(fuelGauge2, i, fg2left, fg2top);
    SetCurrent(fuelGauge3, i, fg3left, fg3top);
    SetCurrent(fuelGauge4, i, fg4left, fg4top);
    IF CheckCloseGad() THEN RETURN FALSE END;
  END;
  RETURN TRUE;
END CountDown;

BEGIN
  IF I.int.libNode.version < 37 THEN HALT(20) END;
  dummy := y.ADR(versionString);

  IF useLib THEN
    classLib := e.OpenLibrary("textgaugei.class",0);
    IF classLib = NIL THEN HALT(20) END;
  END;

  scr := I.LockPubScreen(NIL);
  win := I.OpenWindowTagsA(NIL,
           I.waPubScreen,scr,
           I.waTitle, y.ADR("Whow, some fancy FuelGauges!!"),
           I.waWidth, 250,
           I.waHeight, 150,
           I.waFlags, LONGSET{I.windowDepth,I.windowDrag,I.windowClose},
           I.waIDCMP, LONGSET{I.closeWindow},
           u.end);
  I.UnlockPubScreen(NIL,scr);

  IF win # NIL THEN
    IF useLib OR TG.InitClass() THEN
      drawinfo:=I.GetScreenDrawInfo(win.wScreen);
      IF drawinfo # NIL THEN
        MakeImage(fuelGauge1, fg1width, fg1height, FALSE, FALSE);
        MakeImage(fuelGauge2, fg2width, fg2height, TRUE,  FALSE);
        MakeImage(fuelGauge3, fg1width, fg1height, FALSE, TRUE);
        MakeImage(fuelGauge4, fg2width, fg2height, TRUE,  TRUE);
        IF (fuelGauge1 # NIL) & (fuelGauge2 # NIL)
          &(fuelGauge3 # NIL) & (fuelGauge4 # NIL) THEN
          I.DrawImage(win.rPort,fuelGauge1^,fg1left,fg1top);
          I.DrawImage(win.rPort,fuelGauge2^,fg2left,fg2top);
          I.DrawImage(win.rPort,fuelGauge3^,fg3left,fg3top);
          I.DrawImage(win.rPort,fuelGauge4^,fg4left,fg4top);
          IF CountUp() & CountDown() THEN
            Dos.Delay(100);
          END;
        END;
        I.FreeScreenDrawInfo(win.wScreen, drawinfo);
      END;
    END;
  END;

CLOSE
  I.DisposeObject(fuelGauge1);
  I.DisposeObject(fuelGauge2);
  I.DisposeObject(fuelGauge3);
  I.DisposeObject(fuelGauge4);
  IF win # NIL THEN I.CloseWindow(win); END;
  IF useLib & (classLib # NIL) THEN e.CloseLibrary(classLib); END;

END TestFuelGaugeIClass.

