// *************************************************************** //
// Filename:    ChildA.cpp                                         //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //
#include "MDIMenu.h"

// --------------------------------------------------------------- //
// MDIMenuChild constructor                                        //
// --------------------------------------------------------------- //
TMDIChildA::TMDIChildA(TMDIClient &parent, 
  const char far *title, TWindow *clientWnd, 
  BOOL shrinkToClient, TModule *module) :
  TMDIChild(parent, title, clientWnd, shrinkToClient, module)
{
  TMenuDescr menuDescr("AMenu", 0, 0, 0, 1, 0, 0);
  SetMenuDescr(menuDescr);
  Gadget = new TButtonGadget("A", CMA_ACTION);
  Inserted = FALSE;
}

// --------------------------------------------------------------- //
// MDIMenuChild destructor                                         //
// --------------------------------------------------------------- //
TMDIChildA::~TMDIChildA()
{
  if (!Inserted)
  {
    delete Gadget;
  }
}

// --------------------------------------------------------------- //
// GetClassName                                                    //
// --------------------------------------------------------------- //
char *TMDIChildA::GetClassName()
{
  return "MDIChildB";
}

// --------------------------------------------------------------- //
// GetWindowClass                                                  //
// --------------------------------------------------------------- //
void TMDIChildA::GetWindowClass(WNDCLASS &wc)
{
  TMDIChild::GetWindowClass(wc);
  wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
}

// --------------------------------------------------------------- //
// SetupWindow                                                     //
// --------------------------------------------------------------- //
void TMDIChildA::SetupWindow()
{
  TMDIChild::SetupWindow();
  // put new stuff here
}

// --------------------------------------------------------------- //
// CleanupWindow                                                   //
// --------------------------------------------------------------- //
void TMDIChildA::CleanupWindow()
{
  // put new stuff here
  TMDIChild::CleanupWindow();
}

// --------------------------------------------------------------- //
// Response table for MDIMenuChild                                 //
// --------------------------------------------------------------- //
DEFINE_RESPONSE_TABLE1(TMDIChildA, TMDIChild)
  EV_COMMAND(CMA_ACTION, CmAction),
  EV_WM_MDIACTIVATE,
END_RESPONSE_TABLE;


// --------------------------------------------------------------- //
// TryMe                                                           //
// --------------------------------------------------------------- //
void TMDIChildA::CmAction()
{
  MessageBox("Thank you for selecting me", "A", MB_OK);
}

void TMDIChildA::EvMDIActivate(HWND hWndActivated, HWND hWndDeactivated)
{
  TMDIMenuApp *app = TYPESAFE_DOWNCAST(GetApplication(), TMDIMenuApp);
  if (*this == hWndActivated)
  {
    // add button gadgets
    if (app)
    {
      app->ControlBar->Insert(*Gadget);
      app->ControlBar->LayoutSession();
      app->ControlBar->Invalidate();
      Inserted = TRUE;
    }
  }
  else if (*this == hWndDeactivated)
  {
    // remove button gadgets
    if (app && app->ControlBar->Remove(*Gadget))
    {
      app->ControlBar->LayoutSession();
      app->ControlBar->Invalidate();
      Inserted = FALSE;
    }
  }
  // continue with default processing, merge menus
  TMDIChild::EvMDIActivate(hWndActivated, hWndDeactivated);
}

