{$X+,V-,B-}
program tstServ;

{ Testprogram for the nwServ unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

{ Tests the following nwServ functions:

  GetFileServerDateAndTime
  GetFileServerDescriptionStrings
  GetNetworkSerialNumber
  GetFileServerInformation
  SetFileServerDateAndTime
  VerifyNetworkSerialNumber
}

uses nwMisc,nwServ;

Var t1,t2,t3:TnovTime;
    s1,s3:string;

    serialNbr:Longint;
    appNbr,appNbr2:word;

    Sinfo:TFileServerInformation;

    companyName,VersionAndRevision,
    revisionDate,copyrightNotice:String;

begin
writeln('TSTSERV: Test of some server function calls.');
writeln;
writeln('This program will change (and reset) the server time & date.');
writeln('--This will cause the server to beep (twice)--');
writeln;
writeln('Continue ? (Y/N) + <RETURN>');
readln(s1);
if (pos('y',s1)=0) and (pos('Y',s1)=0)
 then halt(1);

writeln('Testing the Get/Set ServerTime Calls. (temporarily setting the year to 2020)');
IF GetFileServerDateAndTime(t1)
 then begin
      nwMisc.NovTime2String(t1,s1);
      writeln('Original server time:',s1);
      t2:=t1;
      t2.year:=20; { set year to 2020 }
      t2.day:=1;
      t2.month:=4;
      IF SetFileServerDateAndTime(t2)
       then begin
            GetFileServerDateAndTime(t3);
            nwMisc.NovTime2String(t3,s3);
            if t3.year<>t2.year
             then writeln('Error: FileServerDateAndTime NOT changed..');
            writeln('New server time:',s3);
            SetFileServerDateAndTime(t1)  {restore old date & time }
            end
       else begin
            if nwServ.result=$C6
             then writeln('Error: You need console privileges in order to change the server time.')
             else writeln('SetFileServerDateAndTime Error: $',HexStr(nwServ.result,2));
            end
      end
 else writeln('GetFileServerDateAndTime Error: $',HexStr(nwServ.result,2));

writeln;
IF GetFileServerInformation(Sinfo)
 then begin
      writeln('Testing GetServerInformation..');
      writeln('Servername:',Sinfo.serverName);
      writeln('NW version:',Sinfo.NetwareVersion,'.',Sinfo.NetwareSubVersion);
      writeln('Conn Max,Current:',Sinfo.ConnectionsMax,',',Sinfo.ConnectionsInUse);
      writeln('Peak Conn Used  :',Sinfo.Peak_Conn_Used);
      end
 else writeln('GetFileServerDateAndTime Error: $',HexStr(nwServ.result,2));

writeln;
IF GetFileServerDescriptionStrings(companyName,VersionAndRevision,
                                   revisionDate,copyrightNotice)
 then begin
      writeln('Testing GetFileServerDescriptionStrings');
      writeln('Company    :',companyName);
      writeln('Version/Rev:',VersionAndRevision);
      writeln('Rev.Date   :',revisionDate);
      writeln('Copyright  :',copyRightNotice);
      end
 else writeln('GetFileServerDescriptionStrings Error: $',HexStr(nwServ.result,2));


writeln;
IF GetNetworkSerialNumber(serialNbr,appNbr)
 then begin
      writeln('Testing GetNetworkSerialNumber');
      writeln('SerialNbr=',HexStr(serialNbr,8));
      writeln('AppNbr   =',HexStr(appNbr,4));
      end
 else writeln('GetNetworkServerSerialNumber Error: $',HexStr(nwServ.result,2));

{ The last test is commented out. It works, but it is a bit irritating to
  be disconnected every time I'm testing a call.. }


writeln('Testing VerifyNetworkSerialNumber (will abort workstations'' connection)');
writeln('Continue ? (Y/N) + <RETURN>');
readln(s1);
if (pos('y',s1)=0) and (pos('Y',s1)=0)
 then halt(1);

{
IF VerifyNetworkSerialNumber(serialNbr,appNbr2)
 then begin
      if appNbr2=appNbr then writeln('Serial Number Verified.');
      writeln;
      writeln('Verifying a wrong network serialnumber..');
      writeln('**** THIS WILL TERMINATE THE CONNECTION **** (if the calls works..)');
      If VerifyNetworkSerialNumber($12345678,appNbr2)
       then writeln('false serialnumber verified as being OK');
      end
 else writeln('VerifyNetworkSerialNumber Error: $',HexStr(nwServ.result,2));
}

end.
