program tstdh;

{ Testprogram for the nwFile unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

uses nwMisc,nwConn,nwFile;

{ Test the following drive(handle) related calls:

  GetDirectoryHandle
  GetDirectoryPath
  GetDriveConnectionId
  GetDriveHandle
  GetDriveFlag
  GetNumberOfLocalDrives (nwConn)
  GetVolumeNameWithHandle
  IsNetworkDrive

  GetEnvPath
  GetSearchDriveVector
  IsSearchDrive
  SetEnvPath
  SetSearchDriveVector

}

Var t,dirhandle,status:byte;
    status2,dirHandle2:byte;
    volname:string;
    connId:byte;
    locDrives:byte;
    dirPath:string;
    serverName:string;

    NewDirHandle, EffectiveRights:byte;
    connId2,Dflag:byte;

    vector,vector2:TsearchDriveVector;
    pth,pth2:string;

begin
{-- drivenumbers, dirhandles --}

nwconn.GetNumberofLocalDrives(locDrives);
writeln('Local Drives:',locDrives); { Drivenumbers 0..locDrives-1 taken by local drives }
writeln;

for t:=0 to locDrives-1
 do If IsNetworkDrive(t)
     then writeln('Error?: IsNetworkDrive failed for drive ',chr(ord('A')+t));

for t:=locDrives to 31
 do begin
    IF GetDirectoryHandle(t,dirHandle,status)
     then begin
          writeln(chr(t+ord('A')),' handle=',dirHandle,' status=',status);
          GetDriveHandle(t,dirHandle2);
          GetDriveFlag(t,status2);
          if (status<>status2) or (dirHandle<>dirHandle2)
           then writeln('Error: GetDirectoryHandle data differs from GetDriveHandle/Flag data.');

          if IsNetworkDrive(t) XOR ((status AND $80)=0)
           then writeln('Error: IsNetworkDrive failed.');

          GetDirectoryPath(dirHandle,dirpath);
          write('=> ',dirpath);

          if GetDriveConnectionId(t,connId)
           then begin
                write(' connId=',connId);
                nwConn.GetFileServerName(connId,serverName);
                write(' volume=\\',servername,'\');
                end;

          IF (status<3) {temporary or permanent mapping}
             and GetVolumeNameWithHandle(dirHandle,volName)
           then write(volName);

          writeln;
          end
    end;


{-- seachdrives, searchdrive vector-- }
writeln;
writeln('<RETURN> to continue..');
writeln;
readln;

GetSearchDriveVector(vector);
write('Searchdrivevector: ');
for t:=1 to 17
 do if vector[t]<255
     then write(chr(byte(vector[t]+ord('A'))),' ')
     else write('$FF ');
writeln;

FillChar(vector2,Sizeof(TsearchDriveVector),#$FF);
SetSearchDriveVector(vector2);
FillChar(vector2,Sizeof(TsearchDriveVector),#$00);
GetSearchDriveVector(vector2);
if (vector2[1]<>$FF)
 then writeln('Error: SetSearchdriveVector Failed.');
SetSearchDriveVector(vector); { restore old vector }

GetEnvPath(pth);
writeln('PATH setting in the master environment=',pth);
SetEnvPath('this_is_a_bogus_path;');
GetEnvPath(pth2);
writeln('Path is temporarily set to: ',pth2);
SetEnvPath(pth);
writeln('Path reset to original value.');

Write('Searchdrives (using IsSearchDrive):');
for t:=locDrives to 31
 do If IsSearchDrive(t)
     then write(chr(t+ord('A')),' ');
writeln;

{----------------- directory handles ---------------------}
writeln('<RETURN> to continue..');
writeln;

t:=locDrives;
While (t<26) and GetDirectoryHandle(t,dirHandle,status)
 do inc(t);
Writeln('First free drive: ',chr(t+ord('A')));

IF NOT AllocPermanentDirHandle(t,0,'SYS:LOGIN',NewDirHandle, EffectiveRights)
 then writeln('Error calling AllocPermanentDirHandle: ',nwFile.result);

GetDirectoryPath(NewDirHandle,pth);
IF SetDriveHandle(t,NewDirHandle)
 then writeln('SetDriveHandle: drive ',chr(t+ord('A')),' asociated with dirHandle to path ',pth)
 else writeln('Error using SetDriveHandle: ',nwFile.result);

GetDriveHandle(t,dirHandle);
if dirHandle<>NewDirHandle
 then writeln('Error in SetDriveHandle.');

GetEffectiveConnectionId(connId);
{ all requests have been sent to the effective  server up to now, so
  that's the server the drive is connected to }
SetDriveConnectionId(t,connId);
GetDriveConnectionId(t,connId2);
If ConnId2<>ConnId
 then writeln('Error in Set/GetDriveConnectionId');
GetDriveFlag(t,Dflag);
SetDriveFlag(t,(Dflag and $80) or 1);

writeln('(non-root) Mapping completed.');
{ see the MAPDRIVE function in nwFile;
  it creates (temporary) mappings in much the same way as above }


{map a temporary drive}
IF MapDrive(31,'SYS:MAIL',{root drive:} false, {permanent mapping:} false {true})
 then begin
      GetDriveHandle(31,dirHandle);
      GetDirectoryPath(dirHAndle,pth);
      Writeln('Temporary! drive ',chr(31+ord('A')),' mapped to ',pth);
      { If mapdrive works, so must

        DeleteFakeRootDirectory
        GetTrueEntryName
        MapFakeRootDirectory

      }
      end
 else writeln('Error using MapDrive: ',nwFile.result);


writeln;
t:=locDrives;
While (t<26) and GetDirectoryHandle(t,dirHandle,status)
 do inc(t);
Writeln('Another free drive: ',chr(t+ord('A')));

IF MapSearchDrive(t,'SYS:PUBLIC',16,{insert:}false,
                  {root:}false,{permanent:}true)
 then begin
      GetDriveHandle(t,dirHandle);
      GetDirectoryPATh(dirHAndle,pth);
      Writeln('drive ',chr(t+ord('A')),' mapped (as a searchdrive) to ',pth);
      end
 else writeln('Error using MapSearchDrive: ',nwFile.result);


writeln;
t:=locDrives;
While (t<26) and GetDirectoryHandle(t,dirHandle,status)
 do inc(t);
Writeln('Another free drive: ',chr(t+ord('A')));

IF MapPermanentDrive(t,'SYS:PUBLIC',{root:}true)
 then begin
      GetDriveHandle(t,dirHandle);
      GetDirectoryPATh(dirHAndle,pth);
      Writeln('drive ',chr(t+ord('A')),' mapped (permanently) to ',pth);

      IF NOT SetDirectoryHandle(0,'SYS:MAIL',dirHandle)
       then writeln('Error using SetDirectoryHandle: ',nwFile.result)
       else begin
            GetDirectoryPATh(dirHAndle,pth);
            Writeln('drive ',chr(t+ord('A')),' => handle changed to ',pth);
            end;

      end
 else writeln('Error using MapPermanentDrive: ',nwFile.result);


end.