program QAvailable;

{ QMS related utility / NwTP 0.5 API. (c) 1993,1994, R.Spronk }

uses nwMisc,nwBindry,nwQMS;

Var Qname :string;
    QobjId:Longint;
    Qtype :word;

    BinAccLev:Byte;
    MyObjId  :Longint;
    MyObjName:string;
    MyObjType:word;

    SegNbr   :Byte;
    propName :string;
    propValue:Tproperty;
    moreSeg  :boolean;
    propFlags:byte;
    i        :Byte;

    GrpObjId  :Longint;
    GrpObjName:string;
    GrpObjType:word;

begin
{--- Parameter section }

if paramCount<>1
 then begin
      writeln('QAVAIL usage:  QAVAIL <queue name>');
      writeln('Batch file utility to check for the availability of queues.');
      writeln;
      writeln('Errorlevel 0 : Queue exists, calling user is allowed to use Queue');
      writeln('           1 : Queue doesn''t exist on default fileserver.');
      writeln('           2 : Queue exists but calling user has no Queue rights.');
      halt(1); { No queue available }
      end;
Qname:=ParamStr(1);

{--- Startup checks }

IF Not (IsShellLoaded and IsUserLoggedOn)
 then halt(1); { Queue not available }

{--- Queue name in bindery of effective server ? }

UpString(Qname);
IF not GetBinderyObjectId(Qname,3 {ot_print_queue},QobjId)
 then halt(1);

{--- Queue exists. Does the caller have rights to use the queue ? }

IF NOT (GetBinderyAccessLevel(BinAccLev,MyObjId) and
        GetBinderyObjectName(MyObjId,MyObjName,MyObjType))
  then halt(1); { Oops.. some kind of bindery error }

IF IsBinderyObjectInSet(Qname,3 {OT_PRINT_QUEUE},'Q_USERS',MyObjName, MyObjType)
 then halt(0); { OK. Caller has rights }

if nwbindry.result=$FB { According to QMS definitions, when the property }
 then halt(0);         { Q_USERS doesn't exist, all users have queue rights. }

{--- Is one of the groups I'm a member of a queue user ? }

SegNbr:=1;
propName:='GROUPS_I''M_IN';

While ReadPropertyValue(MyObjName,MyObjType,propName,SegNbr,
                        propValue,moreSeg,propFlags)
 do begin
    { A segment of a set-property consists of a list of object IDs,
      each ID 4 bytes long, stored hi-lo.
      The end of the list (within THIS segment) is marked by an ID of 00000000. }
    i:=1;
    Repeat
     GrpObjId:=MakeLong((propValue[i] *256 +propValue[i+1]), ( propValue[i+2] *256 + propValue[i+3] ) );
     if GrpObjId<>0
      then begin
           IF GetBinderyObjectName(GrpObjId,GrpObjName,GrpObjType)
              and IsBinderyObjectInSet(Qname,3 {OT_PRINT_QUEUE},
                                       'Q_USERS',GrpObjName, GrpObjType)
            then halt(0); { OK. Caller's group has queue rights }
           end;
     inc(i,4);
    Until (i>128) or (GrpObjId=0);
    inc(SegNbr);
    end;

{--- Still no rights found.. }
halt(2);

end.

