program GetOFil;

{ Testprogram for the nwFile unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

{ Uses the following calls:

  GetConnectionsOpenFiles (nwServ)
  MapDirEntryIdToPath     (nwFile)

}

uses nwMisc,nwConn,nwFile,nwServ;


Var ConnNumber     : Byte;
    LastRecordSeen : word;
    NbrOfRecords   : word;
    FileInfo       : TfileInfoRecList;
    t              : Byte;
    ExtPath,DosPath: string;
    VolName        : string;

    errCode:Integer;
    dHelp:byte;
    INaddress:TinternetworkAddress;

begin
dHelp:=0;

If (NOT CheckConsolePrivileges)
 then dHelp:=4;

IF (ParamCount<>1)
 then dHelp:=1;

if dHelp=0
 then begin
      Val(ParamStr(1),ConnNumber,errCode);
      if (errCode<>0) then dHelp:=2;
      end;

{ determine whether connectionnumber is valid.
  Remember: using invalid connectionnumbers in combination with the
            GetConnection'sOpenFiles function may result in an Abend.. }
if (dHelp=0) and (NOT GetInterNetAddress(connNumber,INaddress))
 then dHelp:=3;

if dHelp>0
 then begin
      if (dHelp=2) or (dHelp=3)
       then writeln('Error: invalid connection number specified.');
      if dHelp=4
       then writeln('!! You need console operator privileges to use this utility.');
      writeln;
      writeln('GETOFIL - Get connection''s open files.');
      writeln;
      writeln('Usage: GETOFIL <connection number>');
      halt(1);
      end;

LastRecordSeen:=0;

Writeln('Files currently held open by connection ',ConnNumber);
REPEAT { iterate / "only" 28 files (max.) returned per call }
 IF GetConnectionsOpenFiles (ConnNumber, LastRecordSeen,
                             NbrOfRecords ,FileInfo)
   then begin
        for t:=1 to NbrOfRecords
         do with FileInfo[t]
             do begin
                IF MapDirEntryIdToPath(VolNbr,ParentEntryID,NStype,
                                       FileName)
                 then begin
                      NovPath2DosPath(ExtPath,DosPath);
                      GetVolumeName(VolNbr,VolName);
                      writeln(VolName,':',DosPath,'\',FileName)
                      end
                 else writeln('Error calling MapDirEntryIdToPath, err#',nwFile.result);
                end;
        end
   else begin
        writeln('err: ',nwServ.result);
        halt(1);
        end;
UNTIL LastRecordSeen=0;

end.
