{$X+,B-,V-} {essential compiler directives}

Program ClrConn;

{ Example for the nwServ unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

{ Purpose: Utility for users with console privileges:
           Terminate a connection on the current server. }

{ Tests the following nwServ functions:

  CheckConsolePrivileges
  ClearConnectionNumber
}

Uses nwMisc,nwServ;

Var errCode:Integer;
    connNbr:byte;
    connStr:String;
    showHelp:boolean;

begin

IF NOT CheckConsolePrivileges
 then begin
      IF nwServ.result=$C6
       then writeln('You need console privileges to run this util.')
       else writeln('Error checking console privileges, err#',nwServ.result);
      halt(1);
      end;

IF ParamCount=1
 then begin
      connStr:=ParamStr(1);
      Val(connStr,connNbr,errCode);
      showhelp:=(errCode<>0);
      end
 else showHelp:=true;

IF showHelp
 then begin
      writeln('CLRCONN-- usage:');
      writeln;
      writeln('CLRCONN connection_number');
      writeln;
      writeln('the connection_number must be supplied.');
      writeln('it should contain numbers only (range 1..255)');
      halt(1);
      end;
IF ClearConnectionNumber(connNbr)
 then writeln('Connection ',connNbr,' was terminated.')
 else if nwServ.result=253
      then writeln('Connection NOT cleared. The supplied ConnectionNumber was too high.')
      else if nwServ.result=162
           then writeln('You cleared your own connection!')
           else writeln('Connection NOT cleared. Error# ',nwServ.result);

end.