unit Nds;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     dialogs,
     Controls, 
     Buttons,
     StdCtrls, 
     ExtCtrls, 
     Nwtools, 
     Nwnds, 
     Nwlib;

type
  TwinNDS = class(TForm)
    OKBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    NDScontext: TEdit;
    NWNDS1: TNWNDS;
    NWTools1: TNWTools;
    binderyContext: TEdit;
    Label2: TLabel;
    NWLib1: TNWLib;
    serverDN: TEdit;
    Label3: TLabel;
    whoAmI: TEdit;
    Label4: TLabel;
    bLogin: TButton;
    bLogout: TButton;
    root: TEdit;
    Label5: TLabel;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bLoginClick(Sender: TObject);
    procedure bLogoutClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winNDS: TwinNDS;

implementation

{$R *.DFM}

procedure TwinNDS.FormShow(Sender: TObject);
  var
    nserver     : TNWConnHandle    ;
    attrRights  : TNWDSAttrRights  ;
    entryRights : TNWDSEntryRights ;
    smsRights   : TNWDSSMSRights   ;
  begin
    if ndsInit then
      begin
        binderyContext.text := ndsGetBinderyContextName(getPrimaryServerID) ;
        serverDN.text       := ndsGetServerDN(getPrimaryServerID) ;
        whoAmI.text         := ndsWhoAmI ;
        root.text           := ndsGetRootName(whoami.text) ;
        ndscontext.text     := ndsGetContextName ;
        { Show Some Rights }
        if ndsGetattrRights(ndsWhoAmI,
                   '_some_attribute_List_',attrRights) then
          okbox('Attribute Rights:;;' +
                iif(attrRights.compare    ,'Compare;','') +
                iif(attrRights.read       ,'Read;','') +
                iif(attrRights.write      ,'Write;','') +
                iif(attrRights.self       ,'Self;','') +
                iif(attrRights.supervisor,'Supervisor;','')) ;
        if ndsGetEntryRights(ndsWhoAmI,
                   'printServer.marketing',entryRights) then
          okbox('Entry Rights:;;' +
                iif(entryRights.browse    ,'Browse;','') +
                iif(entryRights.add       ,'Add;','') +
                iif(entryRights.delete    ,'Delete;','') +
                iif(entryRights.rename    ,'Rename;','') +
                iif(entryRights.supervisor,'Supervisor;','')) ;
        if ndsGetSMSRights(ndsWhoAmI,
                 '_put_sms_data_here_',smsRights) then
          okbox('SMS Rights:;;' +
                iif(smsRights.scan   ,'Scan;','') +
                iif(smsRights.backup ,'Backup;','') +
                iif(smsRights.restore,'Restore;','') +
                iif(smsRights.rename ,'Rename;','') +
                iif(smsRights.delete ,'Delete;','') +
                iif(smsRights.admin  ,'Admin;','')) ;
      end
    else
      AlertBox('Novell Directory Services Not Installed') ;
  end;

procedure TwinNDS.FormClose(Sender: TObject; var Action: TCloseAction);
  begin
    { must shut down nds communications! }
    ndsClose;

  end;

procedure TwinNDS.bLoginClick(Sender: TObject);
  var
    ctext : string ;
    cUserID : string ;
  begin
    ctext   := space(20) ;
    cUserID := space(20) ;
    if inputQuery('NDS Login','Type Your Login ID:',cUserID) and
       inputQuery('NDS Login','Type Your Password:',ctext) then
      begin
         if ndsPassCheck(cUserID,ctext) and  { in case already logged in, } 
            ndsLogin(cUserID,ctext) then     { don't kill login on bad attempt}
           begin
             bLogout.enabled := True ;
             okBox('Login OK!') ;
           end
         else
           alertBox('Incorrect UserID/Password;;Try Again') ;
      end;
  end;

procedure TwinNDS.bLogoutClick(Sender: TObject);
  begin
    if YesNoBox('Logging Out;;Are You Sure?') and
       ndsLogout then
      begin
        bLogout.enabled := False ;
        okBox('logged out!') ;
      end
    else
      alertBox('You Are Still Logged In') ;
  end;

end.
