unit Main;

interface

uses
    SysUtils, 
    WinTypes,   
    WinProcs, 
    Messages, 
    Classes,         
    Graphics, 
    Controls,
    Forms,     
    Dialogs, 
    StdCtrls, 
    ExtCtrls,
    nwLib,
    nwServer,
    Nwtools, Menus;

type
  TwinMain = class(TForm)
    Panel1: TPanel;
    foot1: TLabel;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    everyone: TListBox;
    Header1: THeader;
    groups: TListBox;
    Header2: THeader;
    Panel2: TPanel;
    bExit: TButton;
    userid: TLabel;
    objectid: TLabel;
    netname: TLabel;
    server: TLabel;
    Bevel1: TBevel;
    username: TLabel;
    loggedin: TLabel;
    isSuper: TCheckBox;
    isEveryOne: TCheckBox;
    serverdate: TLabel;
    label6: TLabel;
    bMap: TButton;
    bEnable: TButton;
    bDisable: TButton;
    Label2: TLabel;
    netDrive: TLabel;
    Panel3: TPanel;
    foot2: TLabel;
    isConsole: TCheckBox;
    serverlist: TListBox;
    servertext: TEdit;
    bLogout: TButton;
    isManager: TCheckBox;
    bCapture: TButton;
    mapList: TListBox;
    Header3: THeader;
    bStats: TButton;
    volumes: TListBox;
    NWLib1: TNWLib;
    NWTools1: TNWTools;
    NWServer1: TNWServer;
    bFiles: TButton;
    bRights: TButton;
    everyonePopup: TPopupMenu;
    ChangePassword1: TMenuItem;
    SendLineMessage1: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure everyoneDblClick(Sender: TObject);
    procedure groupsDblClick(Sender: TObject);
    procedure bExitClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bMapClick(Sender: TObject);
    procedure bEnableClick(Sender: TObject);
    procedure bDisableClick(Sender: TObject);
    procedure serverlistDblClick(Sender: TObject);
    procedure bLogoutClick(Sender: TObject);
    procedure bCaptureClick(Sender: TObject);
    procedure mapListDblClick(Sender: TObject);
    procedure bStatsClick(Sender: TObject);
    procedure bFilesClick(Sender: TObject);
    procedure bRightsClick(Sender: TObject);
    procedure ChangePassword1Click(Sender: TObject);
    procedure SendLineMessage1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winMain: TwinMain;

implementation

{$R *.DFM}

uses
  Stats,
  userStat,
  PrintCap,
  files;

procedure TwinMain.FormShow(Sender: TObject);
  begin
     if not NWInit then
       AlertBox('Netware Shells Are Not Loaded;;Inconsistent Results Are Likely') ;

     { Show Footer }
     foot1.caption := WhoAmi + '  (' +
                      intToStr(GetConnectID(GetPrimaryServerID)) + ')';
     foot2.caption := FormDate(date) ;

     { Various Labels }
     userid.caption     := WhoAmI ;  
     objectid.caption   := GetObjID(userid.caption,nw_user) ;
     server.caption     := GetServerName(GetPrimaryServerID) ;
     serverdate.caption := FormatDateTime('mm/dd/yyyy',GetServerDate(GetPrimaryServerID)) + ' @ ' +
                           FormatDateTime('hh:nn am/pm',GetServerTime(GetPrimaryServerID));
     netname.caption    := FullName(userid.caption) ;
     netdrive.caption   := GetFirstNetDrive + ':' + '     Next Free: ' +
                           GetNextNetDrive + ':' ;

     { checkboxes }
     isSuper.checked    := SecureEquiv(userid.caption,'SUPERVISOR') ;
     isEveryone.checked := IsMember(userid.caption,'EVERYONE') ;
     isConsole.checked  := IsConsoleOperator(GetPrimaryServerID);
     isManager.checked  := IsNWManager(GetPrimaryServerID) ;

     { Popup Menu Disable ChangePW Option if not SUPERVISOR }
     if not isSuper.checked then
       everyonePopup.items[0].enabled := false ;
            
     { Disable 'Disable Login' Button }
     if not IsConsoleOperator(GetPrimaryServerID) then
       bDisable.enabled := False ;

     { Test the Login (Attach) Function - note intended typo to prevent lockout}
     if NWLogin('fs1','FSUPERVISOR','badmofo') then
       okBox('SUPERVISOR Login Successful!') ;

     { Password Check }                    
     if NWPassCheck(GetPrimaryServerID,'FSUPERVISOR','ZOOMY') then
       AlertBox('Wow!  I Guessed Supervisor''s Password!!') ;

     { Build EVERYONE List }
     everyone.items.AddStrings(GetMemberList(
                               GetPrimaryServerID,'EVERYONE',True )) ;
     { Build GroupList }
     groups.items.AddStrings(GetBinderyList(
                             GetPrimaryServerID,
                             nw_group)) ;                   
     { Build ServerList }
     serverList.items.AddStrings(SList) ;

     { Network Volume Listing }
     volumes.items.AddStrings(GetVolumes(GetPrimaryServerID)) ;

     { Build Drive Map List }
     mapList.items.AddStrings(mapShow) ;

  end;

procedure TwinMain.everyoneDblClick(Sender: TObject);
  var
    ctemp : string ;
  begin
    ctemp := everyone.items[everyone.itemindex] ;
    if IsLoggedIn(ctemp) then
      begin
        { Show Stats Window }
        try
          Application.CreateForm(TWinUserStats,winUserStats) ;
          winUserStats.netname.text := ctemp ; 
          winUserStats.showModal ;
          { Send Line Message to Self ... because we can.} 
          if ctemp = WhoAmi then
            begin
              if not SendLineMessage(ctemp,'Hey! Watch Where You''re Clicking That Mouse!') then
                AlertBox('Have You Disabled Broadcasts?'); 
            end;   
        finally
          winUserStats.free ;
        end;
      end
    else
      begin
        username.caption := FullName(ctemp)  ;
        loggedin.Caption := 'Is NOT Logged In!' ;
      end;
  end;

procedure TwinMain.groupsDblClick(Sender: TObject);
  begin
    username.caption := groups.items[groups.itemindex] ;
    loggedin.caption := GetObjID(groups.items[groups.itemindex],nw_group) ;
    { Get Members }
    header1.sections[0] := lowerCase(username.caption) ;
    everyone.clear ;
    everyone.items.Addstrings(GetMemberList(getPrimaryServerID,username.caption,true)) ;
  end;

procedure TwinMain.bExitClick(Sender: TObject);
  begin
    close ;
  end;

procedure TwinMain.FormClose(Sender: TObject; var Action: TCloseAction);
  begin
    action := caFree ;
  end;

procedure TwinMain.bMapClick(Sender: TObject);
  begin
    if YesNoBox('Mapping Drive ' + GetNextNetDrive + 
                ': to SYS;;OK with You?') then
      begin
        if map(GetNextNetDrive,GetServerName(GetPrimaryServerID) + '/sys:') then
          begin
            mapList.clear ;
            mapList.items.AddStrings(mapShow) ;
            netdrive.caption := GetFirstNetDrive + ':' + '     Next Free: ' +
                                GetNextNetDrive + ':' ;
            OKBox('Drive Map Created Successfully')
          end
        else
          AlertBox('Error Mapping Drive') ;
      end;
  end;

procedure TwinMain.bEnableClick(Sender: TObject);
  begin
    if EnableLogins(GetPrimaryServerID) then
      begin
        bEnable.enabled := false ;
        bDisable.enabled := True ;
      end
    else
      AlertBox('You Must Have Console Privileges to Enable Logins!') ;
  end;

procedure TwinMain.bDisableClick(Sender: TObject);
  begin
    if YesNoBox('Disabling Logins Can be Dangerous!;;Continue?') then
      begin
        if DisableLogins(GetPrimaryServerID) then 
          begin
            bEnable.enabled := True ;
            bDisable.enabled := False ;
          end
        else
          AlertBox('Could Not Disable Logins;;Maybe They''re Already Disabled?') ;
      end;
  end;

procedure TwinMain.serverlistDblClick(Sender: TObject);
  var
    cserver : string ;
  begin
    cserver := serverlist.items[serverlist.itemindex] ;
    servertext.text := 'sn: ' + intToStr(GetServerSerial(cserver)) + '/' +
                       'conID: ' + intToStr(GetServerHandle(cserver)) ;
    { show server's volumes }
    if getServerHandle(cserver) > 0 then
      begin
        volumes.items.clear ;
        volumes.items.addStrings(getVolumes(getServerHandle(cServer))) ;
      end;
  end;

procedure TwinMain.bLogoutClick(Sender: TObject);
  begin
    if YesNoBox('Logout of ' +
                 GetServerName(GetPrimaryServerID) + '?') then
      begin
        if NWLogout(GetPrimaryServerID) then
          OKBox('You Asked For It!') 
        else
          AlertBox('Big Problem!;;Could Not Logout!?') ;
      end;
  end;

procedure TwinMain.bCaptureClick(Sender: TObject);
  begin
    try
      application.CreateForm(TWinCapture,winCapture) ;
      winCapture.showModal ;
    finally
      winCapture.Free ;
    end;
  end;

procedure TwinMain.mapListDblClick(Sender: TObject);
  var
    ctemp : string ;
  begin
    ctemp := maplist.items[maplist.itemindex] ;
    username.caption := Copy(ctemp,1,2) ;
    loggedin.caption := Copy(ctemp,3,length(ctemp)-2) ;
  end;

procedure TwinMain.bStatsClick(Sender: TObject);
  begin
    try
      application.createform(TwinStats,winStats) ;
      winStats.showModal ;
    finally
      winstats.free ;
    end;
  end;

procedure TwinMain.bFilesClick(Sender: TObject);
  begin
    try
      application.CreateForm(TWinFile,winFile) ;
      winFile.showmodal ;
    finally
      winFile.free ;
    end;
  end;

procedure TwinMain.bRightsClick(Sender: TObject);
  var
    nwRights : TNWRights ;
  begin
    { Rights Test }
    if getDirRights('sys:public',nwRights) then  { could also say server/vol:path or z:\public}
      okbox('Your Effective Rights in SYS:PUBLIC:;;' +
            iif(nwRights.read,'Read;','') +
            iif(nwRights.write,'Write;','') + 
            iif(nwRights.create,'Create;','') +
            iif(nwRights.accessControl,'AccessControl;','') +
            iif(nwRights.fileScan,'FileScan;','') +
            iif(nwRights.modify,'Modify','') )
    else
      AlertBox('Error Retrieving Rights;;Probably an Invalid Path Specification') ;
  end;

{ End of Unit }
procedure TwinMain.ChangePassword1Click(Sender: TObject);
  var
    newPass : string ;
  begin
    newpass := space(20) ;
    if inputQuery('Change User Password','Type New Password',newPass) then
       begin
         if changeNWPassword(getPrimaryServerID,
                             everyone.items[everyone.itemIndex],
                             newPass)then
           okBox('Password Changed Successfully')
         else
           alertBox('Password Not Changed!;;Check Supervisor Status and Try Again') ;
       end
  end;

procedure TwinMain.SendLineMessage1Click(Sender: TObject);
  var
    messageText : string ;
  begin
    messageText := space(20) ;
    if inputQuery('Send Line Message','Type Message',messageText) then
       begin
         if sendLineMessage(everyone.items[everyone.itemIndex],
                            messageText)then
           okBox('Line Message Sent to ' + everyone.items[everyone.itemIndex]) 
         else
           alertBox('Line Message Not Sent!') ;
       end
  end;

end.
 