unit Files;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     Controls, 
     Buttons,
     StdCtrls,
     ExtCtrls, 
     Nwtools, 
     NWServer, 
     Nwlib;


const filePath : string = 'z:' ;


type
  TwinFile = class(TForm)
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Panel1: TPanel;
    SalvageList: TListBox;
    Header1: THeader;
    NWServer1: TNWServer;
    NWTools1: TNWTools;
    NWLib1: TNWLib;
    Bevel2: TBevel;
    Panel2: TPanel;
    fileList: TListBox;
    Header2: THeader;
    bInfo: TButton;
    bSalvage: TButton;
    Bevel3: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    fileowner: TEdit;
    fileAccess: TEdit;
    filedate: TEdit;
    fileSize: TEdit;
    deleteDate: TEdit;
    deleteBy: TEdit;
    archiveDate: TEdit;
    archiveBy: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    procedure FormShow(Sender: TObject);
    procedure SalvageListEnter(Sender: TObject);
    procedure fileListEnter(Sender: TObject);
    procedure bSalvageClick(Sender: TObject);
    procedure bInfoClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winFile: TwinFile;

implementation

{$R *.DFM}

procedure TwinFile.FormShow(Sender: TObject);
  begin
    header1.sections[0] := filePath + 'SALVAGE' ;
    header2.sections[0] := filePath + '*.* ' ;
    { Add to Salvage List }
    SalvageList.items.addStrings(
         getDeletedFiles(getPrimaryServerID,filePath)) ;
    { Add to FileList }
    fileList.items.addStrings(getVolFileList(filePath + '*.*')) ;
    if (salvageList.items.count > 0) then
      begin
        salvageList.setfocus;
        salvageList.itemIndex := 0 ;
        bSalvage.enabled := true ;
        bInfoClick(sender) ;
      end
    else
      okBox('No Deleted Files in ' + filePath ) ;
  end;


procedure TwinFile.SalvageListEnter(Sender: TObject);
  begin
    bSalvage.enabled := (SalvageList.items.count > 0) ;
  end;

procedure TwinFile.fileListEnter(Sender: TObject);
  begin
    bSalvage.enabled := False ;
  end;

procedure TwinFile.bSalvageClick(Sender: TObject);
  begin
    if Salvage(getPrimaryServerID,
                filePath + salvageList.items[salvageList.itemIndex],
                filePath + 'erase.me') then
      okbox('File Salvaged')
    else
      alertBox('Salvage Failed!') ;
  end;

procedure TwinFile.bInfoClick(Sender: TObject);
  var
    fileInfo        : TNWFileInfo ;
    deletedFileInfo : TNWDeletedFileInfo ;
  begin
     if bSalvage.enabled then
       begin
         if GetDeletedFileInfo(filePath + salvageList.items[salvageList.itemIndex],
                               deletedFileInfo) then
           begin               
             deleteBy.text    := deletedFileInfo.deletedBy ;
             deleteDate.text  := dateToStr(deletedFileInfo.deletedDateTime) ;
             fileOwner.text   := deletedFileInfo.ownerID                    ;
             fileDate.text    := dateToStr(deletedFileInfo.updateDateTime)  ;
             fileSize.text    := intToStr(deletedFileInfo.fileSize)         ;
             archiveBy.text   := deletedFileInfo.lastArchivedBy             ;
             archiveDate.text := dateToStr(deletedFileInfo.lastArchiveDate) ;
             fileAccess.text  := dateToStr(deletedFileInfo.lastAccessDate)  ;
           end;
       end
     else
       begin
         if GetFileInfo(filePath + fileList.items[fileList.itemIndex],
                        fileInfo) then
           begin
             deleteBy.text    := 'N/A' ;
             deleteDate.text  := 'N/A' ;
             fileOwner.text   := fileInfo.ownerID ;
             fileDate.text    := dateToStr(fileInfo.updateDateTime);
             fileSize.text    := intToStr(fileInfo.fileSize) ;
             archiveBy.text   := fileInfo.lastArchivedBy ;
             archiveDate.text := dateToStr(fileInfo.lastArchiveDate) ;
             fileAccess.text  := dateToStr(fileInfo.lastAccessDate) ;
           end;
       end;

  end;

end.
