#
# 09-29-94 14:03 cmb v0.0
#
# Perl script to take output of (dir; ndir /VER) and produce a SDF file of
#
# path, file, date, time, size, crc1-6, and version text strings.
#
# ------------------------------------------------------------------------
#
# Sample command:
#
#    cd sys:
#    global vercheck > c:\vcheck.txt
#
#    where vercheck.bat is:
#
#     @echo off
#     echo off
#
#     %SI_ECHO%
#
#     if "%1" == "!" goto internal
#     for %%a in (*.*) do call %0 ! %%a
#     goto exit
#
#     :internal
#     dir %2
#     ndir %2 /ver
#     goto exit
#
#     :exit
#

$state = 0;
while (<>) {

    chop $_;

    tr/\032/!/; 		    # mask 1A > ! (doesn't work!)
    tr/\001-\010\012-\037/./;	    # mask "illegal" ASCII to .
    tr/\200-\377/./;		    # mask high "illegal" ASCII to .

# basic state machine debugging point
#print "$state: $_\n";

    if (/^[ \t]*$/) {
#print "<blank line>\n";
	next;
    }

# detect incomplete entry
#
    if (/Directory of (..)(.*)/ && $state != 0) {
	$state = 0;

	if ($dospath ne "") {
	    print substr("$dospath",1,99);
	} else {
	    print "\\";
	}

	print ", $dosfilename, $dosdate, $dostime, $dossize\n";

	undef @line;
    }

# detect initial line
#
    if ($state == 0) {
	if (/Directory of (..)(.*)/) {
	    $state = 1;
	    $dosletter = $1;
	    $dospath = $2;
#print "newstate=$state, letter=<$dosletter>, path=<$dospath>\n";
	}

# decode dos directory line
#			       1	   2	      3 		 4
    } elsif ($state == 1) {
	if (/^(.{12})\s+([0-9,]+)\s+(\d\d-\d\d-\d\d)\s+(\d?\d\:\d\d[ap])\s*$/) {
#print "state 1\n";
	    $state = 2;
	    $dosfilename = $1;
	    $dossize = $2;
	    $dosdate = $3;
	    $dostime = $4;

	    $dosfilename =~ s/ /./;
	    $dosfilename =~ s/ //g;
	    $dossize =~ s/,//g;
#print "newstate=$state, filename=<$dosfilename>, size=<$dossize>, date=<$dosdate>, time=<$dostime>\n";

	}

# junk X files X bytes line
#
    } elsif ($state == 2) {
	if (/file.*bytes/) {
	    $state = 3;
#print "newstate=$state\n";
	}

# junk X bytes free line
#
    } elsif ($state == 3) {
	if (/bytes free/) {
	    $state = 4;
#print "newstate=$state\n";
	}

# grab NDIR path line
#
    } elsif ($state == 4) {
	if (/not a dos program/i) {
	    $state = 9; 		# STUPID ndir /ver won't let DOS do OS/2
	} elsif (/(\S+)\:(\S*)/) {
	    $state = 5;
	    $nvlvolume = $1;
	    $nvlpath = $2;
#print "newstate=$state\n, volume=<$nvlvolume>, path=<$nvlpath>\n";
	}

# grab lines until checksum appears
#
    } elsif ($state == 5) {
	tr/,"/../;                # no internal commas or quotes
	$line[@line] = $_;
	die "Out of sync; missing checksum in file $ARGV line $.\n" if (@line > 9);

	if (/Checksum/) {

	    m/Checksum is (....) (....) (....) (....) (....) (....)/;
	    $crc1 = $1;
	    $crc2 = $2;
	    $crc3 = $3;
	    $crc4 = $4;
	    $crc5 = $5;
	    $crc6 = $6;

# debug all available data; get rid of #
#   print '$dosletter=', $dosletter, "\n";
#   print '$dospath=', $dospath, "\n";
#   print '$dosfilename=', $dosfilename, "\n";
#   print '$dossize=', $dossize, "\n";
#   print '$dosdate=', $dosdate, "\n";
#   print '$dostime=', $dostime, "\n";
#   print '$nvlvolume=', $nvlvolume, "\n";
#   print '$nvlpath=', $nvlpath, "\n";
#   print '$line[0]=', "<$line[0]>, \n" if (0 < @line);
#   print '$line[1]=', "<$line[1]>, \n" if (1 < @line);
#   print '$line[2]=', "<$line[2]>, \n" if (2 < @line);
#   print '$line[3]=', "<$line[3]>, \n" if (3 < @line);
#   print '$line[4]=', "<$line[4]>, \n" if (4 < @line);
#   print '$line[5]=', "<$line[5]>, \n" if (5 < @line);
#   print '$line[6]=', "<$line[6]>, \n" if (6 < @line);
#   print '$line[7]=', "<$line[7]>, \n" if (7 < @line);
#   print '$line[8]=', "<$line[8]>, \n" if (8 < @line);
#   print '$line[9]=', "<$line[9]>, \n" if (9 < @line);
#   print '$crc1=', $crc1, "\n";
#   print '$crc2=', $crc2, "\n";
#   print '$crc3=', $crc3, "\n";
#   print '$crc4=', $crc4, "\n";
#   print '$crc5=', $crc5, "\n";
#   print '$crc6=', $crc6, "\n";

if ($nvlpath ne "") {       # fake a root parent if necessary
    print "$nvlpath";
} else {
    print "\\";
}

print ", $dosfilename, $dosdate, $dostime, $dossize, $crc1, $crc2, $crc3, $crc4, $crc5, $crc6";

for ($i = 1; $i < @line; ++$i) {	# now print only meaningful comment lines

    $l = $line[$i];

    if ($l =~ /copyright/i || $l =~ /checksum/i || $l =~ /rights/i || $l =~ /reserved/i || $l =~ /not found/i) {
	next;
    }

    $l =~ s/^ +//g;	# no white space at the beginning, and
    $l =~ s/ +$//g;	# no white space at the end

    print ", \"$l\"";
}

print "\n";

$state = 0;

undef @line;

	}

    } else {
	print "<line ignored!>\n";
	if (/Checksum is"/) {
	    print "Error!  State reset in file $0 line $.";
	    $state = 0;
	}
    }

    if ($state == 9) {	       # version or nver /ver died!   STUPID thing.
	if ($dospath ne "") {
	    print substr("$dospath",1,99);
	} else {
	    print "\\";
	}

	print ", $dosfilename, $dosdate, $dostime, $dossize\n";

	$state = 0;

	undef @line;
    }
}
