#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <mbstring.h>
#include "cgi.h"
#include "gMail.h"


CTemplateInfo::CTemplateInfo()
{
	m_pFormInformation = new FormContents;

	strcpy(m_pRawData, "");
			
    strcpy(m_pRespondMsg, "");
	m_pMailFrom = m_pSendTo = m_pSucceedMsg = NULL;
	m_pTemplateName = m_pSucceed = NULL;
	m_pSMTPServer = m_pDefaultSender = NULL;
	m_pErrTemplate = NULL;

	//Get the form data
	cgiData.Initialize("POST");
	//cgiData.SetContent("e_mail1=ivan_m_hendricks@ccm.hf.intel.com&send_to1=ivan_m_hendricks@ccm.hf.intel.com&send_to=ivanh@aracnet.com&name=Ivan M Hendricks&phone=357-0230&e_mail=ivanh@aracnet.com&submit=on&");
}

CTemplateInfo::~CTemplateInfo()
{
	delete m_pFormInformation;
}

void CTemplateInfo::SetTemplateFile(char* t)
{
	m_pTemplateName = t;
	if (!LoadTemplateFile())
		//product error because we could not load/find the file
		HdrErr("Error loading template file", "Error occured loading the template file.  Please contact your system administrator");

}

////////////////////////////////////////////////////////////////////////////////
//Load the template file and dumps all the data into m_pRawData//
////////////////////////////////////////////////////////////////////////////////
int CTemplateInfo::LoadTemplateFile()
{
	FILE* pFile;
	char temptext[201];

	//Initialize temptext
	strcpy(temptext, "");

	//Check to make sure the file exist, if not then error out, otherwise read the data
	if((pFile = fopen(m_pTemplateName, "rt")) != NULL)
	{
		//Get all information from template file until we have reached the end (NULL)
		//We are only allowing 500 characters per line.
		while( (fgets(temptext, sizeof(temptext) - 1, pFile)) != NULL )
			strcat(m_pRawData, temptext);	
		return TRUE;
	}
	else
		return FALSE;
}

///////////////////////////////////////////////////////////////////////////////

int CTemplateInfo::ParseTags()
{

	m_pDefaultSender = GetTagData("<SENDER>", "</SENDER>", TRUE);
	m_pSMTPServer = GetTagData("<SMTPSERVER>", "</SMTPSERVER>", TRUE);

	m_pErrTemplate = GetTagData("<ERRTEMPLATE>", "</ERRTEMPLATE>", TRUE);
	m_pSubject = GetTagData("<SUBJECT>", "</SUBJECT>", TRUE);	
	m_pSucceed = GetTagData("<SUCCEEDMSG>", "</SUCCEEDMSG>", TRUE);
	
	ParseFormData();

	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////


/**********************************************************************
** GetTagData - Send it the tag you are looking for and it returns  ***
**				the data between the tag							***
**********************************************************************/
char* CTemplateInfo::GetTagData(char* BeginTag, char* EndTag, int required)
{
	char* pTagStart,
		* pTagEnd,
		* token = NULL;
	int tokenlength = 0,
		tokendifference = 0;
	char errstr[200];
	
	//Check to make sure the tags are there
	if ( stristr(m_pRawData, BeginTag) == NULL )
		if (required)
		{
			sprintf(errstr, "%s is missing, please recheck your template file", BeginTag);
			HdrErr("Tag missing", errstr);
		}
		else
			return NULL;
	if ( stristr(m_pRawData, EndTag) == NULL )
		if (required)
		{
			sprintf(errstr, "%s is missing, please recheck your template file", EndTag);
			HdrErr("Tag missing", errstr);
		}
		else
			return NULL;
	
	//Parse out the data between the tags
	pTagStart = stristr(m_pRawData, BeginTag);
	pTagStart += strlen(BeginTag); //Move to the end ot the tag name
	
	pTagEnd = stristr(m_pRawData, EndTag);
	tokendifference =  strlen(pTagStart) - strlen(pTagEnd);
	token = new char[tokendifference + 1];

	strncpy(token, pTagStart, tokendifference);
	strncpy(token + tokendifference, "\0", 1);

	return token;

}
/////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
void CTemplateInfo::ParseFormData()
{
	m_pRawFormData = GetTagData("<FORMDATA>", "</FORMDATA>", TRUE);	
	SeperateFormInformation(m_pRawFormData);
	GetFormData();	

}

////////////////////////////////////////////////////////////////////////////////////
//Based upon the information gathered from the template file, Find the values     //
//stored in pCursor->pName and put the form variable contents into pCursor->pValue//
////////////////////////////////////////////////////////////////////////////////////
void CTemplateInfo::GetFormData()
{
	FormContents* pCursor = m_pFormInformation;
	
	do
	{
		//Based on the variable name, put the value in pCursor->pValue
		pCursor->pValue = cgiData.FindData(pCursor->pName, FALSE);
		//Check to make sure that if it's a required field that it has some data in it.
		if (pCursor->required) 
			if (!pCursor->pValue)
					PrintErrHTML(pCursor->pReqErr);
			else			
			if ( strlen(pCursor->pValue) == 0) 
					PrintErrHTML(pCursor->pReqErr);
		
		//Advance to the next variable link
		pCursor = pCursor->next;
	}
	while (pCursor != NULL);

}

////////////////////////////////////////////////////////////////////////////////////////////
//Based upon the infomation from the Template file, parse out the information in the      //
// <formdata>...</formdata> tags and store the informatin in pCursor->					  //
////////////////////////////////////////////////////////////////////////////////////////////
void CTemplateInfo::SeperateFormInformation(char RawData[])
{
	char* token;
	FormContents* pCursor = m_pFormInformation;

	//Parse the form name information
 	token = strtok(RawData, "<");
	token = strtok(NULL, ">");
	do
	{
		//initialize variables
		pCursor->pName = pCursor->pOutput = pCursor->pReqErr 
					   = pCursor->pRespondMsg = pCursor->pValue = NULL;
		pCursor->next = NULL;		

		GetNameToken(token, pCursor);
		GetRequiredToken(token, pCursor);
		GetSendToToken(token, pCursor);
		GetRespondToToken(token, pCursor);
		GetMailBodyToken(token, pCursor);

		//Go to the next section
		token = strtok(NULL, "<");
		token = strtok(NULL, ">");
		if (token != NULL)
		{
			pCursor->next = new FormContents;
			pCursor = pCursor->next;
		}
		//If we haven't reached the end, then create a new leaf for the next group of data
	}while (token != NULL);
}

/////////////////////////////////////////////////////////////////////////////////
//Parse out the NAME= token and the associated value goes into pCursor->pName. //
//The variable pCursor->pName is the name of the form variable				   //
/////////////////////////////////////////////////////////////////////////////////
void CTemplateInfo::GetNameToken(char* token, FormContents* pCursor)
{
	char* nameToken = NULL;
	int stringsize = 0;
	
	pCursor->pName = NULL;
	pCursor->pValue = NULL;
	
	nameToken = stristr(token, "NAME");

	//Make sure the 'name' tag exists
	if (nameToken == NULL)
		HdrErr("Bad command in template file", "Missing 'name' tag.  Please check template file");

	//find the '=' sign
	nameToken = strstr(nameToken, "=");
	//get the data between the double-quotes
	nameToken = strstr(nameToken, "\"");
	stringsize = strlen(++nameToken) - strlen (strstr(nameToken, "\""));
	
	pCursor->pName = new char[stringsize + 2];

	strncpy(pCursor->pName, nameToken, stringsize);
	strncpy(pCursor->pName + stringsize, "=\0", 2);

}

/////////////////////////////////////////////////////////////////////////////////
//Parse out the 'required' token.  If exists, also get 'requiredErr' token	   //
/////////////////////////////////////////////////////////////////////////////////
void CTemplateInfo::GetRequiredToken(char token[], FormContents* pCursor)
{
	char* requiredErrToken = NULL;
	int stringsize = 0;
	char err[50] = "";
	
	//Parse the required boolean information.  If the 'required' is there, then 
	//also get 'requiredErr' variable
	if (stristr(token, "REQUIRED") != NULL)
	{
		pCursor->required = TRUE;
		//Make sure the field 'requiredErr' exists.  If so, get the error message
		if ( stristr(token, "REQUIREDERR")!= NULL)
		{
			requiredErrToken = stristr(token, "REQUIREDERR");
			requiredErrToken = strstr(requiredErrToken, "=");
			requiredErrToken = strstr(requiredErrToken, "\"");
			stringsize = strlen(++requiredErrToken) - strlen (strstr(requiredErrToken, "\""));
			if (stristr(token, "<") != NULL)
			{
				sprintf(err, "Error on %s.  HTML tags are not allowed.  Use <errTemplate> tag below to customize your errors.", pCursor->pName);
				HdrErr("Error in template file", err);
			}
			pCursor->pReqErr = new char[stringsize];
			strncpy(pCursor->pReqErr, requiredErrToken, stringsize);
			strncpy(pCursor->pReqErr + stringsize, "\0", 1);
		}
		//The user specified 'required', but forgot to define a custom error message,
		// so let's create a default message.  Not pretty, but it works.
		else
		{
			pCursor->pReqErr = new char[70];
			sprintf(pCursor->pReqErr, "%s is a required field. "
									 "Please go back", pCursor->pName);
		}
	}
	//didn't find 'required'
	else
	{
		pCursor->required = FALSE;
		pCursor->pReqErr = NULL;
	}
}
/////////////////////////////////////////////////////////////////////////////////
//Get the 'sendto' token information										   //
/////////////////////////////////////////////////////////////////////////////////
void CTemplateInfo::GetSendToToken(char token[], FormContents* pCursor)
{
	//Parse 'sendto' boolean information
	if (stristr(token, "SENDTO") != NULL)
		pCursor->sendto = TRUE;
	else
		pCursor->sendto = FALSE;
}

/////////////////////////////////////////////////////////////////////////////////
void CTemplateInfo::GetRespondToToken(char token[], FormContents* pCursor)
{
	char* respondToken = NULL;
	int stringsize = 0;
	char err[100] = "";

	//Default initialization
	pCursor->respondto = FALSE;
	pCursor->pRespondMsg = NULL;

	//Parse 'respondto' boolean information'
	if (stristr(token, "RESPONDTO") != NULL)
	{
		//respondto and sendto cannot co-exist
		if (pCursor->sendto)
			HdrErr("Bad command in template file", "If there is a 'sendto' tag, then there cannot be a 'respondto' tag");

		pCursor->respondto = TRUE;
		//Parse 'respondmsg' information
		respondToken = stristr(token, "RESPONDMSG");
		if (respondToken == NULL)
		{
			sprintf(err, "You specified a 'respondto' tag on %s with no corresponding 'respondmsg' tag", pCursor->pName);
			HdrErr("Missing template data", err);
		}
		respondToken = strstr(respondToken, "=");
		respondToken = strstr(respondToken, "\"");
		stringsize = strlen(++respondToken) - strlen (strstr(respondToken, "\""));
		pCursor->pRespondMsg = new char[stringsize];
		strncpy(pCursor->pRespondMsg, respondToken, stringsize);
		strncpy(pCursor->pRespondMsg + stringsize, "\0", 1);
	}
}

/////////////////////////////////////////////////////////////////////////////////
//Get the mail body information (output).  Check a few conditions.			   //
//Condition 1:  If the 'sendto' tag is specified, then you cannot have an	   //
//              'output' tag												   //
/////////////////////////////////////////////////////////////////////////////////
void CTemplateInfo::GetMailBodyToken(char token[], FormContents* pCursor)
{
	char* outputToken = NULL;
	int stringsize = 0;
	char err[50] = "";

	//Default initialization
	pCursor->pOutput = NULL;
	
	//Parse 'output' information
	outputToken = stristr(token, "OUTPUT");
	//If 'sendto' tag and 'output' tag is specified, then error out
	if (pCursor->sendto && (outputToken != NULL))
		HdrErr("Bad command in template file", "A 'sendto' tag and 'output' tag cannot co-exist");
	//If 'output' token is not empty and 'sendto' is not specified, then error out
	if (!pCursor->sendto)
		if (outputToken != NULL) 
		{
			outputToken = strstr(outputToken, "=");
			outputToken = strstr(outputToken, "\"");
			stringsize = strlen(++outputToken) - strlen (strstr(outputToken, "\""));
			pCursor->pOutput = new char[stringsize];
			strncpy(pCursor->pOutput, outputToken, stringsize);
			strncpy(pCursor->pOutput + stringsize, "\0", 1);
		}
	    else
		{
			sprintf(err, "Missing the 'output' tag for %s'", pCursor->pName);
			HdrErr("Bad command in template file", err);
		}
}

/////////////////////////////////////////////////////////////////////////////////

int CTemplateInfo::ParseSucceed()
{
	return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
//Get the mail subject line													 //
/////////////////////////////////////////////////////////////////////////////////
int CTemplateInfo::ParseSubject()
{
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////
//All the data that's stored in the link list (pCursor), dump all it's contents//
//into a single variable that will, later, be dumped out to a file			   //
/////////////////////////////////////////////////////////////////////////////////
void CTemplateInfo::GenerateMailToFile()
{
	FormContents* pCursor = m_pFormInformation;

	strcpy(m_pMailInfoTo, "");
	strcpy(m_pRespondMsg, "");
	do
	{
		//Write info to variable to be put in mail file.
		if (pCursor->pOutput != NULL) 
			sprintf(m_pMailInfoTo, "%s %s %s \n", m_pMailInfoTo, pCursor->pOutput, pCursor->pValue);
		//Advance to the next variable link
		pCursor = pCursor->next;
	}
	while (pCursor != NULL);
	
}

/////////////////////////////////////////////////////////////////////////////////
//Mail all the information to all the 'sendto' tagged people and send out the  //
//'respondto' tag data to the respective people.  
/////////////////////////////////////////////////////////////////////////////////
void CTemplateInfo::MailInformation()
{
	char buf[500];
	char *pTempFileName;		//Holds the temp filename used to hold the body of the message
	char BlatExec[] = "blat.exe";
	char param1[50] = "",
		 param2[50] = "",
		 param3[50] = "",
		 param4[50] = "";
	FormContents* pCursor = m_pFormInformation;
		
	GenerateMailToFile();
	pTempFileName = CreateTempFile(m_pMailInfoTo);
	//Flush the stream and buffers.  Docs say this must be done before system(..) is called
	_flushall();

	do
	{
		//Generate a commandline to call the blat program and send the contents of the temporary file
		if (pCursor->sendto)
		{
			sprintf(param1, "%s", pTempFileName); //file to send with the contents of message
			sprintf(param2, "-s \"%s\"", m_pSubject); // Create the subject line
			sprintf(param3, "-f \"%s\" -server \"%s\"", m_pDefaultSender, m_pSMTPServer);
			//space for param3
			sprintf(param4, "-t %s > send.log", pCursor->pValue); //create the mailto line;

			//mail file from command-line
			sprintf(buf, "%s %s %s %s %s", BlatExec, param1, param2, param3, param4);
			
			//spawn off a process to call blat and mail the file.
			system(buf); 
		}

		pCursor = pCursor->next;
	} while (pCursor != NULL);			


	//Cleanup and delete the temporary file
	DeleteFile(pTempFileName);

	//Now do the Mailback to person filling out form
	pCursor = m_pFormInformation;
	do
	{
		if (pCursor->respondto)
		{
			pTempFileName = CreateTempFile(pCursor->pRespondMsg);
			
			//reversed from and to so the original sender of the form gets a confirmation request.  This is
			//used to verify that the user sent the correct e-mail address.
			sprintf(buf, "blat.exe %s -s \"%s\" -t %s %s>respond.log", pTempFileName, m_pSubject, _strlwr(pCursor->pValue), param3 ); 		
			_flushall();
			system(buf);

			//Cleanup and delete the temporary file
			DeleteFile(pTempFileName);
		}
		pCursor = pCursor->next;

	} while(pCursor != NULL);

	PrintSucceedMsg();
}

/////////////////////////////////////////////////////////////////////////////////
//This is the HTML Success message
/////////////////////////////////////////////////////////////////////////////////
void CTemplateInfo::PrintSucceedMsg()
{
	PrintHeader("Thankyou");
	printf(m_pSucceed);
}

char* CreateTempFile(const char* pFileContents)
{
	FILE* pOutputFile;			//File stream that data is written to
	char* pTempFileName = NULL;

	//Create a temporary file to contain the information to send through blat
	//GetTempPath( sizeof(pTempDir), pTempDir );
    
	pTempFileName = new char[15];
	GetTempFileName( ".\\", "cml", 0, pTempFileName );

	if ( (pOutputFile = fopen(pTempFileName,"w") ) == NULL)
	{
		//Couldn't file the file
		HdrErr("File Creation error", "Error occured while creating mail file.");
		exit(0);
	}	
	fputs ("\n", pOutputFile);
	fputs (pFileContents, pOutputFile);
	fputs ("\n", pOutputFile);
	fclose(pOutputFile);

	return pTempFileName;
}



void HdrErr(char* pErrorHeader, char* pErrorText)
{
	PrintHeader(pErrorHeader);
	printf(pErrorText);
	exit(0);
}



void CTemplateInfo::PrintErrHTML(char* errstring)
{
	char* temp = NULL;
	char* errtag = NULL;
	int j = 0;

	PrintHeader("Required field missing information");

	errtag = stristr(m_pErrTemplate, "$err$");
	if (errtag == NULL)
		err(m_pErrTemplate);
	for (char* i= m_pErrTemplate; i < errtag; i++)
	{
		printf("%c", *i);
	}
	errtag += 5;
	printf("%s", errstring);
	printf(errtag);
	exit(0);
}
