Comment
==========================================================

This include file exports definitions that create a Novell menu look and
feel. This is one of several look and feel files that export the same
procedures.

Useful Routines Exported:

LookSetup
   Call this to initialize the screen. Set MenuTitle and StatusLineText
   before calling this routine.

CornerStretchBox (Header,Col,Row)
   Creates a window from the array Choices with the upper left corner at
   Row/Col. LastKey is set to the letter that is chosen.

CenterStretchBox (Header,Col,Row)
   Creates a window from the array Choices with the center at Row/Col.
   if a 0 is passed for either the Row or Col then the center of the
   screen is assumed. LastKey is set to the letter that is chosen.

Leave
   Puts up an exit box.


==========================================================
EndComment


var
  Choices
  MenuTitle
  StatusLineText
  StatusWindow
  HeightDifference
  Greek = False
  BotText
  HeadWin
  LastSec

var
  BackGroundFG
  BackGroundBG
  TitleBoxBorderFG
  TitleBoxBG
  TitleBoxInsideFG
  ClockColorFG
  StatusLineFG
  StatusLineBG
  MenuInsideFG
  MenuBG
  MenuHeaderFG
  MenuBorderFG
  MenuInactiveFG
  MenuVertLinesFG
  MenuInverseFG
  MenuInverseBG
  MenuCapColorFG
  ConsoleInsideFG
  GreekFG
  GreekBG

;------ This is where you set your favorite colors.

Procedure SetColors
   if ColorScreen
      BackGroundFG     = Cyan
      BackGroundBG     = Blue
      TitleBoxBG       = Brown
      TitleBoxBorderFG = White
      TitleBoxInsideFG = Yellow
      ClockColorFG     = Yellow
      StatusLineFG     = Yellow
      StatusLineBG     = Mag
      MenuBG           = Blue
      MenuInsideFG     = Yellow
      MenuBorderFG     = Yellow
      MenuInactiveFG   = LGreen
      MenuHeaderFG     = LCyan
      MenuVertLinesFG  = LGreen
      MenuInverseFG    = White
      MenuInverseBG    = Mag
      MenuCapColorFG   = White
      ConsoleInsideFG  = White
      GreekFG          = Blue
      GreekBG          = Green
      BoxHeaderColor White Brown
   else
      BackGroundFG     = Grey
      BackGroundBG     = Black
      TitleBoxBG       = Grey
      TitleBoxBorderFG = Black
      TitleBoxInsideFG = Black
      ClockColorFG     = Black
      StatusLineFG     = Black
      StatusLineBG     = Grey
      MenuBG           = Grey
      MenuInsideFG     = Black
      MenuBorderFG     = Black
      MenuInactiveFG   = Grey
      MenuHeaderFG     = Black
      MenuVertLinesFG  = Black
      MenuInverseFG    = Grey
      MenuInverseBG    = Black
      MenuCapColorFG   = Black
      ConsoleInsideFG  = Grey
      GreekFG          = Black
      GreekBG          = Grey
      BoxHeaderColor Black Grey
   endif
EndProc

;------ Sets up main window to Novell look.

Procedure LookSetup
var St
   if MenuInsideFG = 0 then SetColors
   NoExit

   ;------ Clear the screen with a textured background

   if not Overlayed
      TextColor BackGroundFG BackGroundBG
      ClearScreen 176

      ;------ If Greek is true then draw greek columns

      if Greek then GreekColumns
   endif

   ;------ Draw Status Line

   NoBoxBorder
   InactiveBox NoBoxBorder
   Explode Off
   BoxInsideColor StatusLineFG StatusLineBG
   DrawBox 1 ScreenHeight ScreenWidth 1
   StatusWindow = CurrentWindow
   WriteCenter(StatusLineText)

   if not Overlayed

      ;------ Draw the Title Box

      SingleLineBox
      BoxInsideColor TitleBoxInsideFG TitleBoxBG
      BoxBorderColor TitleBoxBorderFG TitleBoxBG
      BoxFooter = ''
      DrawBox 1 1 ScreenWidth 3
      HeadWin = CurrentWindow
      GotoXY 13 1
      if NovFullName > ''
         Write NovFullName
      else
         if NovLoginName > ''
            Write NovLoginName
         else
            Write 'Local'
         endif
      endif
      GotoXY 29 1
      ResultsInK
      Write(PadLeft(Str(FreeDiskSpace('.') / 977) + ' Mb',9))
      GotoXY 41 1
      Write Left(CurrentDirectory,26)
      GotoXY 70 1
      Write DateString

      ;------ Setup Console

      ConsolePos 42 5
      ConsoleHeaderColor MenuInverseFG MenuInverseBG
      ConsoleInsideColor ConsoleInsideFG MenuBG

   endif
   HeightDifference = 6
   SmallShadow
   Shadow
   InactiveShadow Off
   IdleProgram = Loc SaberIdle
EndProc


Procedure MakeBox(Header,Col,Row,Center)
var NumElem Height Width Cnt

   Width = Max(Length(Header) + 1,21)
   NumElem = NumberOfElements(Choices)

     ;Get the widest element in the Choices Array

   if Length(Choices[1]) > 0
      Cnt = 65
      loop NumElem
         Trim(Choices[LoopIndex])
         if left(Choices[LoopIndex],1) <> ''
            Choices[LoopIndex] = " " + Char(Cnt) + ") " + Choices[LoopIndex]
            Cnt = Cnt + 1
         endif
         Width = Max(Width,Length(Choices[LoopIndex]))
      endloop
   else
      Width = ScreenWidth - 7
   endif
   Height = NumElem + 2
   if Header > '' then Height = NumElem + 4
   Width = Width + 4
   if Center
      if Row = 0

         ;Center window verticaly

         Row = ((ScreenHeight - Height) / 2) + 2
      else

         ;Center window with X Coordinate

         Row = (Row - (Height / 2) + 1)
      endif
      if Col = 0

         ;Center window horizonitly

         Col = (ScreenWidth - Width) / 2 + 1
      else

         ;Center window with Y Coordinate

         Col = (Col - (Width / 2) + 1)
      endif
   endif

   ;Make Sure Row and Col are within their range

   Row = Max(Row,5)
   Row = Min(Row,ScreenHeight - Height - 1)
   Col = Max(Col,2)
   Col = Min(Col,ScreenWidth - Width)

   DrawTheBox(Col,Row,Width - 1,Height + 2,Header)

     ;Write the menu choices

   loop(NumElem - 1)
      if left(Choices[LoopIndex],1) = ''
         TextColor MenuVertLinesFG MenuBG
         ClearLine 196
         TextColor MenuInsideFG MenuBG
         CapsColor(MenuCapColorFG,MenuBG)
         Writeln
      else
         Writeln(Choices[LoopIndex])
      endif
   endloop

   Write Choices[NumElem]
   UseArrows On
   Dispose(Choices)
EndProc

;------ Draw the Box

Procedure DrawTheBox (Col,Row,Width,Height,Header)

     ;Draw the main window

   InactiveBoxColor MenuInactiveFG MenuBG
   BoxInsideColor MenuInsideFG MenuBG
   BoxBorderColor MenuBorderFG MenuBG
   DrawBox(Col,Row,Width,Height)

   if (CurrentWindow = 4) or (Width < 22)
      BotText = 'Enter'
   else
      BotText 'Enter  Esc=Previous'
   endif

   if Header > ''

     ;Write the header

      TextColor(MenuHeaderFG,MenuBG)
      WriteCenter(Header)
      GotoXY 2 Height - 2
      Write BotText

     ;Write the vertical lines

      GotoXY 1 2
      TextColor(MenuVertLinesFG,MenuBG)
      ClearLine 196
      GotoXY 1 Height - 3
      ClearLine 196

     ;Draw the menu text box

      CapsColor(MenuCapColorFG,MenuBG)
      InverseColor(MenuInverseFG,MenuInverseBG)
      Window(Col + 1, Row + 3, Width - 2, Height - 6)
   else
      CapsColor Black Black
   endif
EndProc


Procedure SaberIdle
var STime Moment S M H Pm
   Moment = Now
   S = SecondOf(Moment)
   if S <> LastSec
      M = MinuteOf(Moment)
      H = HourOf(Moment)
      Pm = Hour > 11
      if Pm
         H = H - 12
         if H = 0 then H = 12
      endif
      if H < 10 then STime = ' '
      STime = STime + Str(H)
      if S mod 2 = 0
         STime = STime + ':'
      else
         STime = STime + ' '
      endif
      if M < 10 then STime = STime + '0'
      STime = STime + Str(M) + ' '
      if Pm
         STime = STime + 'pm'
      else
         STime = STime + 'am'
      endif
      SetTopWindow HeadWin
      GotoXY 2 1
      Write STime
      SetWindowUnder (HeadWin,HeadWin + 1)
      LastSec = S
   endif
EndProc


Procedure GetPassword (Pswd)
var P
   BotText 'Enter  Esc=Cancel'
   DrawTheBox(3,17,50,7,'Enter Password')
   UseArrows Off
   TextColor MenuInsideFG MenuBG
   Write ' Enter Password: '
   NoBoxBorder
   TextColor LGreen Black
   ClearLine
   Security
   P = UpperCase(Readln)
   LastKey = ' '
   Return P = Pswd
   EraseTopWindow
EndProc

