/* Translate and compile a NetRexx program             */
/*                                                     */
/* use as:  NETREXXC hello [file2]...                  */
/*                                                     */
/*   which will use the NetRexx translator             */
/*     translate hello.nrx to hello.java               */
/*   then will use JAVAC to compile hello.java         */
/*                                                     */
/* Any NetRexxT (translator) flags may be used, along  */
/* with the following extra flags:                     */
/*                                                     */
/*   -run       = run class after compilation          */
/*   -runpm     = run class as a PM application        */
/*   -keep      = keep the java file after successful  */
/*                compilation (as xxx.java.keep)       */
/*   -nocompile = only translate, do not compile       */
/*                                                     */
/* Multiple programs may be specified; in this case    */
/* they are all run (if requested) after all compiles. */

parse arg args
w=wordpos('-run', args)
if w>0 then do; run=1;   args=delword(args,w,1); end; else run=0
w=wordpos('-runpm', args)
if w>0 then do; runpm=1; args=delword(args,w,1); end; else runpm=0
w=wordpos('-nocompile', args)
if w>0 then do; noc=1; end; else noc=0


/* ----- Translate & Compile ----- */
'@java netrexx.process.NetRexxC' args

/* ----- Run ----- */
if rc=0 & (run | runpm) then do
  if noc then say 'Run option ignored as -nocompile specified'
   else do
    do forever /* find the file parameter */
      parse var args file args
      if file='' then leave
      if left(file,1)='-' then iterate
      filename=filespec('n', file); parse var filename fn '.' fe
      if runpm then exe='javapm'; else exe='java'
      say 'Running' fn '...'
      '@'exe fn
      end
    end
  end

exit rc

