
#: 73884 S4/Fractal Sources  [GRAPHDEV]
    06-Jul-94  16:33:00
Sb: #73847-#Another Newton - reprise
Fm: Timothy Wegner 71320,675
To: Jon Horner 100112,1700 (X)

>Any joy with the Newton query I sent you on 26 Jun?<g>.

Original post:

>>I have access to a computer graphics magazine called Computers and
>>Graphics,in it Clifford Pickover edits a section called Chaos and
>>Graphics.  One of the articles discusses elliptic functions such as :
>>z = sqr(z^3 + c*z^2 +1).

I assume this means f(z) = sqr(z^3 + cz^2 +1)

>>Now I wrote the Newton's method formula for
>>this equation but must have done something wrong.  Do you know what the
>>derivative of this equation would be?

Derivative is 2*(z^3 + cz^2 +1)*(3z^2 + 2cz)

Oops! first I didn't read carefully and thought "sqr" was "sqrt". Since I
did this, might as well give the result to posterity. Enjoy! As payment,
send me some PARS you get from these. Hey - sign up for a calculus course
and you can do these yourself<g!>

Newt_ellipt_oops { ; Tim Wegner - use float=yes and periodicity=0
   ; fractal generated by Newton formula  (z^3 + c*z^2 +1)^.5
   ; try p1 = 1 and p2 = .1
   ; if p2 is small (say .001), converges very slowly so need large maxit
   ; another "tim's error" - mistook sqr for sqrt (see next)
   z = pixel, z2 = z*z, z3 = z*z2:
   num = (z3 + p1*z2 + 1)^.5      ; f(z)
   denom = (1.5*z2 + p1*z)/num    ; f'(z)
   z = z - (num/denom)            ; z - f(z)/f'(z)
   z2 = z*z
   z3 = z*z2,
   p2 <= |z3 + p1*z2 + 1|         ; no need for sqrt because sqrt(z)==0 iff z==0
  }

I'm using z = z - f/f' below but you might not recognize it - some terms
cancelled. This is the right formula - I think!

Newton_elliptic { ; Tim Wegner - use float=yes and periodicity=0
   ; fractal generated by Newton formula f(z) = (z^3 + c*z^2 +1)^2
   ; try p1 = 1 and p2 = .0001
   z = pixel, z2 = z*z, z3 = z*z2:
   z = z - (z3 + p1*z2 + 1)/(6*z2 + 4*p1*z)      ; z - f(z)/f'(z)
   z2 = z*z
   z3 = z*z2,
   p2 <= |z3 + p1*z2 + 1|  ; no need for sqr because sqr(z)==0 iff z==0
  }

Tim

There is 1 Reply.

