comment {
  begin select.frm
}

              { Formulae created by:  Jon Osuch  [73277,1432] }

{=========================================================================}

BirdOfPrey(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=cosxx
    z   = p1,
    x   = 1:
   (x  <  10) * (z=fn1(z)+pixel),
   (10 <= x)  * (z=fn2(z)+pixel),
    x   = x+1,
   |z| <=p2
   }

{=========================================================================}

DeepSpaceProbe(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sin, fn3=cosxx
    z   = p1,
    x   = 1:
   (x  <  10) * (z=fn1(z) + pixel),
   (10 <= x)  * (x<20)    * (z=fn2(z)+pixel),
   (20 <= x)  * (z=fn3(z) + pixel),
    x   = x+1,
   |z| <= p2
   }

DeepSpaceProbeC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=10, p2=20, fn1=sqr, fn2=sin, fn3=cosxx
    ; Note:  use floating point
    z  = p1,
    x  = 1:
(z=fn1(z)+pixel)*(x<10)+(z=fn2(z)+pixel)*(10<=x)*(x<20)+(z=fn3(z)+pixel)*(20<=x)
,
    x  = x+1,
   |z| <= 4
   }

DpSpaceProbeTwoC(XAXIS_NOPARM) {; Jon Osuch
   ; Try p1=0, p2=4, fn1=sqr, fn2=exp, fn3=cosxx
    ; Note:  use floating point
   z    = p1,
   x    = 1:
(z=fn1(z)+pixel)*(x<10)+(z=fn2(z)+pixel)*(10<=x)*(x<20)+(z=fn3(z)+pixel)*(20<=x)
,
    x   = x+1,
   |z| <= p2
   }

{=========================================================================}

EvilEyeC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=1, p2=4, fn1=sin, fn2=cosxx
    ; Note:  use floating point
    z  =  p1,
    x  = |z|:
   (z  = fn1(z)+pixel) * (1<x)  +  (z=fn2(z) + pixel)*(x<=1),
    x  = |z|,
    x <= p2
  }

{=========================================================================}

Eyeball(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sinh
    z    = p1,
    x    = 1:
    (x  <  10) * (z=fn1(z) + pixel),
    (10 <= x)  * (z=fn2(z) + pixel),
    x    = x+1,
   |z|  <= p2
   }

{=========================================================================}

FlyingSquirrel(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sin, fn2=cosxx, fn3=sqr
    z  = p1,
    x  = |z|:  (1<x) * (z=fn1(z) / fn2(z) + pixel),
    z  = fn3(z)+pixel,
    x  = |z|,
    x <= p2
   }

{=========================================================================}

FractalFender(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=cosh, fn2=sqr
    z  = p1,
    x  = |z|:  (1<x) * (z=fn1(z)+pixel),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

FractalFenderC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=cosh, fn2=sqr
    ; Note:  use floating point
    ; Spectacular!
    z  = p1, 
    x  = |z|:
   (z  = fn1(z)+pixel) * (1<x)+(z=z) * (x<=1),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

FractalFender2(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=cosxx, fn2=sqr
    z  = p1,
    x  = |z|:  (1<x) * (z=fn1(z)+pixel),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

FractalFender2C(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=cosxx, fn2=sqr
    ; Note:  use floating point
    z  = p1,
    x  = |z|:
   (z  = fn1(z)+pixel) * (1<x) + (z=z) * (x<=1),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

{=========================================================================}

Frog(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=tanh, fn2=sqr
    z  = p1,
    x  = |z|:     (1<x) * (z=fn1(z) + pixel),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

FrogC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=tanh, fn2=sqr
    ; Note:  use floating point
    z  = p1,
    x  = |z|:
   (z  = fn1(z)+pixel) * (1<x) + (z=z) * (x<=1),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

{=========================================================================}

Fly(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sqr
    z   = p1:
    x   = real(z),
   (x  <  0)  * (z=fn1(z) + pixel),
   (0  <= x)  * (z=fn2(z) - pixel),
   |z| <= p2
   }

{=========================================================================}

IfThenfn1fn2(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sin, fn2=cos
    z  = p1,
    x  = |z|:
   (z  = fn1(z)) * (1<x)+(z=z)*(x<=1),
   (z  = fn2(z)  + pixel),
    x  = |z|,
    x <= p2
   }

IfThenElsefn1fn2(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sin
    z  = p1,
    x  = |z|:
   (z  = fn1(z)+pixel) * (1<x)+(z=fn2(z)+pixel) * (x<=1),
    x  = |z|,
    x <= p2
   }

IfElsefn1fn2fn3(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1,2,3=whatever
    z   = p1,
    x   = 1:
(z=fn1(z)+pixel)*(x<10)+(z=fn2(z)+pixel)*(10<=x)*(x<20)+(z=fn3(z)+pixel)*(20<=x)
,
    x   = x+1,
   |z| <= p2
    }

{=========================================================================}

IslandOfChaos(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sin, fn3=cosxx
    z   =  p1,
    x   =  1:
   (x  <  10)  * (z=fn1(z) + pixel),
   (10 <=  x)  * (z=fn2(z) / fn3(z) + pixel),
    x   = x+1,
   |z| <= p2
   }


{=========================================================================}

ManInTheOzone(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=cosxx, fn3=sin
    z    = p1,
    x    = 1:
    (x  < 10)  * (z=fn1(z) + pixel),
    (10 <= x)  * (x<20)    * (z=fn2(z)+pixel),
    (20 <= x)  * (z=fn3(z) + pixel),
    x    =  x+1,
   |z|  <= p2
   }

{=========================================================================}

Moth(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=exp, fn3=log
    z    = p1,
    x    = 1:
    (x  <  10) * (z=fn1(z)  +  pixel),
    (10 <= x)  * (x<20)     *  (z=fn2(z)+pixel),
    (20 <= x)  * (z=fn3(z)  +  pixel),
    x    = x+1,
   |z|  <= p2
   }

{=========================================================================}

SinhEgg(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sinh, fn2=sqr
    z  = p1,
    x  = |z|:
    (1 < x) * (z=fn1(z) + pixel),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

{=========================================================================}

TestSinMandC(XAXIS_NOPARM) {;Jon Osuch
     ; Try: p1=4, fn1=sin, fn2=sqr    
     z  = p1,
     x  = |z|:
    (z  = fn1(z)) * (1<x)+(z=z) * (x<=1),
    (z  = fn2(z)+pixel),
     x  = |z|,
     x <= p1
  }

{=========================================================================}

TurtleC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sqr
    ; Note:  use floating point
    z   = p1:
    x   = real(z),
   (z   = fn1(z)+pixel) * (x<0) + (z=fn2(z)-pixel) * (0<=x),
   |z| <= p2
   }


{=========================================================================}

WaldoTwinsC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=cosxx, fn2=sin
    ; Note:  use floating point
    z   = p1:
    z   = fn1(fn2(z+pixel)) + pixel,
   |z| <= p2
   }

comment {
  end select.frm
}
This file contains the SMURF2.PAR file that has some more Smurf discoveries.
Since the advent of my 486-33 my sense of time has been blown to Hades.  Every
thing runs fast on this machine so it is hard to say how fast these batches
will run on someone else's machine.  I hope they are not too slow.

The file FLIP.FRM contains formulas utilizing the FLIP function.  There are 3
fliped Mandelbrot formulas and their respective Julia style formulas.

Another formula is a "Non-conformal" depicted in the 1992 Fractal Universe
Calender (August) from Media Magic.  The inside=zmag has some very interesting
structure.  Non-conformals are those where the parts of the Mandelbrot
quadratic equation are added/subtracted in different ways from the standard
solution of the formula.  The flip0 is considered a non-conformal.  Note
how the intergers are converted to a complex number (z = x + flip(y)).

BTW this calender is incredibly beautiful.

Two other formulas are included, PHOENIX_J and PHOENIX_M.  The Phoenix_j curve
was discovered by Shigehiro Ushiki at Kyoto University.  The creation of
the map version was done by Roger Stevens in his "Fractal Programming in C".
The interesting aspect of this formula is that the Phoenix doesn't lie at any
interesting point on the map.  It is at co-ordinates 0.56667 / -0.5 which is
off the lower right side in a very boring section.  One that I found is at
0.1 / 0.8 off the top right hand side; which is also a very boring place on
the map. There are probably several more Phoenixes waiting to be found.  BTW,
it was while trying to devise a better map that I discovered the zmag coloring
scheme for Mandelbrots.

Included also is the testpt.c for the Phoenix for those with the Fractint
source.  I feel it would be a great addition to the Fractint stable of hard
coded fractals.  But since I couldn't figure out how to do it before and since
I no longer have the Fractint source, I guess it will have to remain for
some one else to accomplish this.

Brainy Smurf
