The picture 'quad.gif' is a fractal created with Fractint that shows
some of the weirder things that can be done inside Fractint's type=
formula option.  It's based on this formula:

    test { 
        z = 0, c=pixel: 
        z = sqr(z)+c, 
        c=c+p1/z, 
        |z| <= 4 
        } 

wherein the value of c is changed each iteration by adding p1/z.  Dan
Farmer introduced Boolean arithmetic into this system with:

    testm { 
        z = 0, c=pixel: 
        z = sqr(z)+c, 
        c=c+(p1 * (|z| <= p2)) 
        |z| <= 4 
        } 

Now, the value of c is altered depending on whether or not |z| is less
than the parameter p2.  To expand on this idea, I made quad.gif using
this formula:

quadrants {
	z=0, c=pixel,
	r1=(0.0,1.0), r2=(-1.0,0.0), r3=(0.0,-1.0), r4=1:
	z=sqr(z)+c,
	x=real(z), y=imag(z),
	xp=(0 < x), xn=(x < 0), yp=(0 < y), yn=(y < 0),
	k1=xp*yp, k2=xn*yp, k3=xn*yn, k4=xp*yn,
	k=k1*r1+k2*r2+k3*r3+k4*r4,
	c=c+k*p1/z,
	|z| <= 4
	}

What happens is that there are 4 coefficients, r1 through r4,
corresponding to i, i^2, i^3, and i^4, where i*i = -1.  For each
iteration, z is split into its real and imaginary parts x and y.
The xp, xn, yp, and yn are used to determine whether x and y are
positive or negative.  These are combined into k1 through k4.  Only
one of these 4 will equal 1:  k1 = 1 if z is in the first quadrant
(x > 0, y > 0); k2 = 1 if z is in the second quadrant, etc.  The other
3 k's will all be 0.  The k's are incorporated into one coefficient
k.  If z lies in the first quadrant, k = i.  If z lies in the second
quadrant, k = -1.  Similarly for the third and fourth quadrants.
Finally, c is adjusted by k*p1/z, giving a different type of adjustment
to c each iteration, depending on the quadrant of z.

The results are shown in quad.gif, which is 320 x 200 x 256 colors.

Kerry Mitchell
