;;
;;  Rick Hughes
;;  70461,3272
;;  22 Dec 92
;;  Fractal Sources
;;
;;   Bert,
;;    Here are 5 formulas for the .FRM file.  Note that the last 2 are
;;  Newtons and they have to run with inside=zmag to shut off periodicity
;;  checking

Legendre(XAXIS)       {   ;Advanced Fractal Programming in C  - Stevens
   z=0:
   zsq = z*z,
   z=.125*(35*zsq*zsq-30*zsq+3)+pixel,
   |z| <= 4
   }

Tchebychev-c6(XYAXIS) {   ;Advanced Fractal Programming in C  - Stevens
   z=0:
   zsq = z*z,
   z = pixel * (zsq*zsq*zsq - 6*zsq*zsq + 9*zsq - 2),
   |z| <= 4
   }

Tchebychev-t5(XYAXIS) {   ;Advanced Fractal Programming in C  - Stevens
   z=(0.654,0):
   zcube = z*z*z,
   z = pixel * (16*z*z*zcube - 20*zcube + 5*z),
   |z| <= 4
   }

z^3-1=0(XAXIS)  {         ; Advanced Fractal Programming in C  - Stevens
   ; Run with inside = ZMAG to turn off periodicity checking
   x=real(pixel), y=imag(pixel):
   x2 = x*x, y2 = y*y,
   xold = x, yold = y, xmy = x2 - y2,
   d = 3 * (xmy * xmy + 4*x2*y2),
   x = .66666667*x + xmy/d,   y = .66666667*y - 2*x*y/d,
   x != xold && y != yold
   }

z^3-2z-5=0(XAXIS)  {      ; Advanced Fractal Programming in C  - Stevens
   ; --- SLOW on a 486-33 ---  Run with inside = ZMAG
   x=real(pixel), y=imag(pixel):
   x2 = x*x, y2 = y*y, xold = x, yold = y,
   t2 = 3*x2 - 3*y2 -2,          d = t2*t2 + 36*x2*y2,
   t1 = x*x2 - 3*x*y2 - 2*x -5, t3 = 3*x2*y - y2*y - 2*y,
   x = x - (t1 * t2 - 6*x*y*t3)/d,
   y = y - (t1 * (-6*x*y) + t3 * t2)/d,
   x != xold && y != yold
   }

;;  #: 12599 S4/Fractal Sources
;;      29-Jan-93 19:30:44
;;  Sb: #Adjustable Spiders
;;  Fm: Rick Hughes 70461,3272
;;  To: All

;;  Here are 2 variations on the Spider formula.  The function were thrown
;;  in as an after thought.

a_spider1 { ; Adjustable spider - After Homer Smith of Art Matrix
            ; try p1 = (.55,0) or (0,.4) or (.4,.35)
   z=0, c=pixel:
   z = z*z + c,        z = fn1(z),
   c = c * p1 + z,     c = fn2(c),
   |z| <= 4
   }

a_spider2 { ; Adjustable spider - After Fractint's version
            ; try p1 = (.55,0) or (0,.4) or (.4,.35)
   z=c=pixel:
   z = z*z + c,        z = fn1(z),
   c = c * p1 + z,     c = fn2(c),
   |z| <= 4
   }

;; Brainy Smurf

