comment {
These formulae can be used to initiate exploration in the two "hybridised" 
planes as referred to in 3dfract.doc. Type SJ iterate in the "ZC" plane,
and type 3rdim in the "CZ" plane. Ititially, param p2=0. Altering the real
value of p2 in type SJ, or the imaginary value of p2 in type 3rdim, will
step the position of the iterated image along the x or y axes respectively
of the C-plane Mandelbrot set.
Paramater p1, normally set to 0, can, by varying the real value, rotate
the angle of the iteration plane to intermediate planal regions, for some
quite striking effects. p1=1 will revert to the C-plane, and in the case of
z^2+c will produce the familiar Mandelbrot set.
}

SJMAND01 {;Mandelbrot
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=z*z+c, |z|<=64}

3RDIM01  {;Mandelbrot
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        z=z*z+c, |z|<=64}

SJMAND02 {;Tetration
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=c^z, |z|<=32}

3RDIM02  {;Tetration
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        z=c^z, |z|<=32}

SJMAND03 {;Mandelbrot function
        z=real(pixel)+p1*(flip(imag(pixel))),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=fn1(z)+c, |z|<=64}

3RDIM03  {;Mandelbrot function
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        z=fn1(z)+c, |z|<=64}

SJMAND04 {;Tetrated function
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=fn1(c)^z, |z|<=64}

3RDIM04  {;Tetrated function     
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        z=fn1(c)^z, |z|<=64}

SJMAND05 {;Mandelbrot lambda function
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=fn1(z)*c, |z|<=64}

3RDIM05  {;Mandelbrot lambda function
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        z=fn1(z)*c, |z|<=64}

SJMAND06 {z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)),
        z=conj(z),c=conj(c):
        z=fn1(z)+c, |z|<=4}

3RDIM06  {z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1),
        z=conj(z),c=conj(c):
        z=fn1(z)+c, |z|<=4}

SJMAND07 {;Mandelbrot function
        ;changing real(p1) will now rotate between ZC & CZ planes
        z=(1-p1)*real(pixel)+p1*flip(imag(pixel)),
        c=p1*real(pixel)+(1-p1)*flip(imag(pixel)):
        z=fn1(z)+c, |z|<=4}

SJMAND08 {;Mandelbar
        z=real(pixel)+flip(imag(pixel))*p1,
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=conj(z*z)+c, |z|<=4}

3RDIM08  {;Mandelbar
        z=p1*real(pixel)+flip(imag(pixel)), 
        c=p2+real(pixel)+p1*flip(imag(pixel)):
        z=conj(z*z)+c, |z|<=4}

comment {
These formulae can be used to initiate exploration in the two "hybridised" 
planes as referred to in 4dfract.txt. Type SJ iterate in the "zc" plane,
and type 3RDIM in the "cz" plane. Ititially, param p2=0. Altering the real
value of p2 in type SJ, or the imaginary value of p2 in type 3rdim, will
step the position of the iterated image along the x or y axis respectively
of the c-plane Mandelbrot set.
Parameter p1, normally set to 0, can, by varying the real value, rotate
the angle of the iteration plane to intermediate planal regions, for some
quite striking effects. p1=1 will revert to the c-plane, and in the case of
z^2+c will produce the familiar Mandelbrot set.

There is enough here for many happy (?) years of iterating. Enjoy.

Gordon Lamb (CIS: 100272,3541)
}

SJMAND01 {;Mandelbrot
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=z*z+c, |z|<=64}

3RDIM01  {;Mandelbrot
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        
        z=z*z+c, |z|<=64}

SJMAND02 {;Tetration
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=c^z, |z|<=32}

3RDIM02  {;Tetration
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        z=c^z, |z|<=32}

SJMAND03 {;Mandelbrot function
        z=real(pixel)+p1*(flip(imag(pixel))),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=fn1(z)+c, |z|<=64}

3RDIM03  {;Mandelbrot function
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        z=fn1(z)+c, |z|<=64}

SJMAND04 {;Tetrated function
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=fn1(c)^z, |z|<=64}

3RDIM04  {;Tetrated function     
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        z=fn1(c)^z, |z|<=64}

SJMAND05 {;Mandelbrot lambda function
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=fn1(z)*c, |z|<=64}

3RDIM05  {;Mandelbrot lambda function
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        z=fn1(z)*c, |z|<=64}

SJMAND06 {z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)),
        z=conj(z),c=conj(c):
        z=fn1(z)+c, |z|<=4}

3RDIM06  {z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1),
        z=conj(z),c=conj(c):
        z=fn1(z)+c, |z|<=4}

SJMAND07 {;Mandelbrot function
        ;changing real(p1) will now rotate between ZC & CZ planes
        z=(1-p1)*real(pixel)+p1*flip(imag(pixel)),
        c=p1*real(pixel)+(1-p1)*flip(imag(pixel)):
        z=fn1(z)+c, |z|<=4}

SJMAND08 {;Mandelbar
        z=real(pixel)+flip(imag(pixel))*p1,
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=conj(z*z)+c, |z|<=4}

3RDIM08  {;Mandelbar
        z=p1*real(pixel)+flip(imag(pixel)), 
        c=p2+real(pixel)+p1*flip(imag(pixel)):
        z=conj(z*z)+c, |z|<=4}

SJMAND09 { 
        z=real(pixel)+flip(imag(p2)),
        c=real(p2)+flip(imag(pixel)):
        z=z*z+c, |z|<=4}

SJMAND10 {;Mandelbrot power function
        z=real(pixel),c=p2+flip(imag(pixel)):
        z=(fn1(z)+c)^p1, |z|<=4}

3RDIM10  {;Mandelbrot power function
         z=flip(imag(pixel)),c=p2+real(pixel):
         z=(fn1(z)+c)^p1, |z|<=4}

SJMAND11 {;Mandelbrot lambda function - lower bailout
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=fn1(z)*c, |z|<=4}

SJMAND12 {;Mandelbrot with perturbed initiator
        z=real(pixel)+p1,c=flip(imag(pixel))+p2:
        z=z*z+c, |z|<=4}

SJMAND13 {;Mandelbrot function
        z=real(pixel)+p1*(flip(imag(pixel))),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=1/fn1(z)+c, |z|<=64}

3RDIM13  {;Mandelbrot function
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        z=1/fn1(z)+c, |z|<=64}

SJMAND14 {;Mandelbrot lambda function
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=c/fn1(z), |z|<=64}

3RDIM14  {;Mandelbrot lambda function
        z=p1*real(pixel)+flip(imag(pixel)),
        c=p2+real(pixel)+flip(imag(pixel)*p1):
        z=c/fn1(z), |z|<=64}

#: 44645 S4/Fractal Sources  [GRAPHDEV]
    03-Dec-93  18:44:22
Sb: #44266-#Bailout Formulas
Fm: Chuck Ebbert 76306,1226
To: Timothy Wegner 71320,675 (X)

 Oops, looks like hypercomplex formulas are more "complex" than I thought.
Try this one:

hypercomplex { ; Chuck Ebbert -- must use periodicity=0
 ; P1 is (cj,ck), bailout is real(p2) (default 64)
 z = zi = 0,
 t = (64 * (real(p2)<=0) + real(p2) * (0<real(p2)) ):
  a = z - imag(zi) + flip(real(zi)),
  b = z + imag(zi) - flip(real(zi)),
  a = fn1(a),
  b = fn1(b),
  z = (a+b)/2 + pixel,
  zi = (imag(a)-imag(b)+flip(real(b))-flip(real(a)))/2 + p1,
   |z| + |zi| <= t
 }

 BTW, I think there is a problem with symmetry in the hypercomplex type. I
was comparing the formula's image to the built-in one's for (cj,ck)=(2,2)
and bailout=16.  The built-in type shows two different images depending on
whether symmetry is enabled or not :(

A1 (XAXIS) {
    z = Pixel:
    z = ((2*(z*z*z))-(3*(z*z))+1)^p1
    z = z+Pixel
    z = Sqr(z) * (p1)
    |z| <= 4;
  }

bizarre    {
        (x<10)*(z=sqr(z)+pixel),
        (10<=x)*(x<20)*(z=exp(z)+pixel),
        (20<=x)*(z=log(z)+pixel),
        x=x+1, |z|<=4
        }

{ The formulas with names ending in C are the 'correct' version. }
{ The floating point flag MUST be set for these. }

{ TestSinMandC demonstrates an IF-THEN type formula as an IF-THEN-ELSE
  without the ELSE.
    if |z|<1 then z=sin(z)
    else nothing
    z=sqr(z)+pixel }

{ Verified with Testpt.c version. }
   TestSinMandC(XAXIS_NOPARM) {z=p1,x=|z|:
    (z=sin(z))*(1<x)+(z=z)*(x<=1),
    (z=sqr(z)+pixel),
    x=|z|, x<=4}

{ EvilEyeC demonstrates an IF-THEN-ELSE structure.
    if |z|<1 then z=sin(z)+pixel
    else z=cos(z)+pixel }

{ Verified with Testpt.c version. }
   EvilEyeC(XAXIS_NOPARM) {z=p1,x=|z|:
    (z=sin(z)+pixel)*(1<x)+(z=cos(z)+pixel)*(x<=1),
    x=|z|, x<=4}
      
{ DeepSpaceProbeC demonstrates a more complicated IF-THEN-ELSE
  structure.
    if x<10 then z=sqr(z)+pixel
    else if x<20 then z=sin(z)+pixel
    else z=cos(z)+pixel }

{ Verified with Testpt.c version. }
  DeepSpaceProbeC(XAXIS_NOPARM) { z=p1, x=1:
  (z=sqr(z)+pixel)*(x<10)+(z=sin(z)+pixel)*(10<=x)*(x<20)+(z=cos(z)+pixel)*(20<=x),
     x=x+1, |z|<=4 }

   IslandOfChaos(XAXIS_NOPARM) {z=p1, x=1:
         (x<10)*(z=sqr(z)+pixel),
         (10<=x)*(z=sin(z)/cos(z)+pixel),
         x=x+1, |z|<=4}

   IslandOfChaosC(XAXIS_NOPARM) {z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=sin(z)/cos(z)+pixel)*(10<=x),
    x=x+1, |z|<=4}

   BirdOfPrey(XAXIS_NOPARM) {z=p1, x=1:
         (x<10)*(z=sqr(z)+pixel),
         (10<=x)*(z=cos(z)+pixel),
         x=x+1, |z|<=4}

   BirdOfPreyC(XAXIS_NOPARM) {z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=cos(z)+pixel)*(10<=x),
    x=x+1, |z|<=4}

   FractalFender(XAXIS_NOPARM) {z=p1,x=|z|:
       (1<x)*(z=cosh(z)+pixel),
       z=sqr(z)+pixel,x=|z|,
       x<=4 }

{ Spectacular! }
   FractalFenderC(XAXIS_NOPARM) {z=p1,x=|z|:
       (z=cosh(z)+pixel)*(1<x)+(z=z)*(x<=1),
       z=sqr(z)+pixel,x=|z|,
       x<=4 }

   FractalFenderTwo(XAXIS_NOPARM) {z=p1,x=|z|:
             (1<x)*(z=cos(z)+pixel),
             z=sqr(z)+pixel,x=|z|,
             x<=4 }

   FractalFenderTwoC(XAXIS_NOPARM) {z=p1,x=|z|:
             (z=cos(z)+pixel)*(1<x)+(z=z)*(x<=1),
             z=sqr(z)+pixel,x=|z|,
             x<=4 }

   FlyingSquirrel(XAXIS_NOPARM) {z=p1,x=|z|:
             (1<x)*(z=sin(z)/cos(z)+pixel),
             z=sqr(z)+pixel,x=|z|,
             x<=4 }

   FlyingSquirrelC(XAXIS_NOPARM) {z=p1,x=|z|:
             (z=sin(z)/cos(z)+pixel)*(1<x)+(z=z)*(x<=1),
             z=sqr(z)+pixel,x=|z|,
             x<=4 }

   Frog(XAXIS_NOPARM) {z=p1,x=|z|:
             (1<x)*(z=sinh(z)/cosh(z)+pixel),
             z=sqr(z)+pixel,x=|z|,
             x<=4 }

   FrogC(XAXIS_NOPARM) {z=p1,x=|z|:
             (z=sinh(z)/cosh(z)+pixel)*(1<x)+(z=z)*(x<=1),
             z=sqr(z)+pixel,x=|z|,
             x<=4 }

  Fly(XAXIS_NOPARM) {z=p1:
      x=real(z),
      (x<0)*(z=sqr(z)+pixel),
      (0<=x)*(z=sqr(z)-pixel),
      |z|<=4}

  FlyC(XAXIS_NOPARM) {z=p1:
      x=real(z),
      (z=sqr(z)+pixel)*(x<0)+(z=sqr(z)-pixel)*(0<=x),
      |z|<=4}

  DeepSpaceProbe(XAXIS_NOPARM) { z=p1, x=1:
     (x<10)*(z=sqr(z)+pixel),
     (10<=x)*(x<20)*(z=sin(z)+pixel),
     (20<=x)*(z=cos(z)+pixel),
     x=x+1, |z|<=4 }

  DeepSpaceProbeTwo(XAXIS_NOPARM) { z=p1, x=1:
     (x<10)*(z=sqr(z)+pixel),
     (10<=x)*(x<20)*(z=exp(z)+pixel),
     (20<=x)*(z=cos(z)+pixel),
     x=x+1, |z|<=4 }

  DeepSpaceProbeTwoC(XAXIS_NOPARM) { z=p1, x=1:
  (z=sqr(z)+pixel)*(x<10)+(z=exp(z)+pixel)*(10<=x)*(x<20)+(z=cos(z)+pixel)*(20<=x),
     x=x+1, |z|<=4 }

  Moth(XAXIS_NOPARM) { z=p1, x=1:
     (x<10)*(z=sqr(z)+pixel),
     (10<=x)*(x<20)*(z=exp(z)+pixel),
     (20<=x)*(z=log(z)+pixel),
     x=x+1, |z|<=4 }

  MothC(XAXIS_NOPARM) { z=p1, x=1:
     (z=sqr(z)+pixel)*(x<10)+(z=exp(z)+pixel)*(10<=x)*(x<20)+(z=log(z)+pixel)*(20<=x),
     x=x+1, |z|<=4 }

  ManInTheOzone(XAXIS_NOPARM) { z=p1, x=1:
     (x<10)*(z=sqr(z)+pixel),
     (10<=x)*(x<20)*(z=cos(z)+pixel),
     (20<=x)*(z=sin(z)+pixel),
     x=x+1, |z|<=4 }

  ManInTheOzoneC(XAXIS_NOPARM) { z=p1, x=1:
     (z=sqr(z)+pixel)*(x<10)+(z=cos(z)+pixel)*(10<=x)*(x<20)+(z=sin(z)+pixel)*(20<=x),
     x=x+1, |z|<=4 }

   SinhEgg(XAXIS_NOPARM) {z=p1,x=|z|:(1<x)*(z=sinh(z)+pixel),
             z=sqr(z)+pixel,x=|z|,
             x<=4 }

   SinhEggC(XAXIS_NOPARM) {z=p1,x=|z|:
   (z=sinh(z)+pixel)*(1<x)+(z=z)*(x<=1),
   z=sqr(z)+pixel,x=|z|,
   x<=4 }

   SinEgg(XAXIS_NOPARM) {z=p1,x=|z|:(1<x)*(z=sin(z)+pixel),
             z=sqr(z)+pixel,x=|z|,
             x<=4 }

   SinEggC(XAXIS_NOPARM) {z=p1,x=|z|:
   (z=sin(z)+pixel)*(1<x)+(z=z)*(x<=1),
   z=sqr(z)+pixel,x=|z|,
   x<=4 }

   Eyeball(XAXIS_NOPARM) {z=p1, x=1:
         (x<10)*(z=sqr(z)+pixel),
         (10<=x)*(z=sinh(z)+pixel),
         x=x+1, |z|<=4}

   EyeballC(XAXIS_NOPARM) {z=p1, x=1:
         (z=sqr(z)+pixel)*(x<10)+(z=sinh(z)+pixel)*(10<=x),
         x=x+1, |z|<=4}

   TurtleC(XAXIS_NOPARM) {z=p1:
         x=real(z),
         (z=sqr(z)+pixel)*(x<0)+(z=sqr(z)-pixel)*(0<=x),
         |z|<=4}

{ An extraneous one. }
   WaldoTwinsC(XAXIS_NOPARM) {z=p1:z=cos(sin(z+pixel))+pixel, |z|<=4}
   DAFRM01  {;  Don Archer, 1993
   z = pixel :
   z = z ^ (z - 1) * (fn1(z) + pixel),
   |z| <= 4
   }

   DAFRM02  {;  
   z = pixel :
   z = (z ^ (z - 1) + 7/11) * (fn1(z) + pixel),
   |z| <= 4
   }

   DAFRM03  {; 
   z = pixel :
   z = z * z^ (1 - z) * fn1(z) + pixel,
   |z| < 4
   }

   DAFRM04  {;
   z = pixel, c = p1 :
   z = z ^ (z - 1) * fn1(z) + pixel,
   c = c + p2,
   |z| <= 4
   }

   DAFRM05  {;  M_TchebychevT3
   c = P1, z = Pixel:
   z = c*z*(4*z*z-3),
   |z|<100
}
   

   ; See da.frm for formulas 1 thru 5
   ; 9/6/93

   DAFRM06  {;  var M_TchebychevT3
   c = P1, z = Pixel:
   z = 2*c*z*(z*z*3.14159),
   |z|<100
   }

   DAFRM07  {
   z = pixel, c = p1 :
   z = z ^ (z - 1) * fn1(z) + pixel,
   |z| <= 4
   }

   DAFRM08  {
   z = pixel, c = z + z^ (1 - z):
   tmp = fn1(z),
   real(tmp) = real(tmp) * real(c) - imag(tmp) * imag(c),
   imag(tmp) = real(tmp) * imag(c) - imag(tmp) * real(c), 
   z = tmp + pixel,
   |z| <= 100
   }

   DAFRM09  {  
   z = pixel, c = z + z^ (z - 1):
   tmp = fn1(z),
   real(tmp) = real(tmp) * real(c) - imag(tmp) * imag(c),
   imag(tmp) = real(tmp) * imag(c) - imag(tmp) * real(c), 
   z = tmp + pixel + 12,
   |z| <= 4
   }

   DAFRM10  { ; var Ron Barnett REB004K
   z = pixel:
   x = flip(pixel + fn1(4/z - z/5 + 125)),
   z = x*z + p1 + 125, 
   |z| <= 100
   }

   DAFRM11  { ; var Ron Barnett REB004L
   z = pixel:
   x = flip(pixel + fn1(2*p1/3*z - z/(p2+125))),
   z = x*z + pixel, 
   |z| <= 100
   }

   DAFRM12 { ; var Ron Barnett REB004M
   z = pixel:
   x = real(z), y = imag(z),
   x1 = -fn1((x*x + y*y) - 6*x)*x/(2*x*x + y*y),
   y1 = -fn2((x*x + y*y) + 6*x)*y/(2*x*x + y*y),
   x2 = x1*x1 - y1*y1 + p1 + 25,
   y2 = 3*x*y - 25,
   z = x2 + flip(y2), 
   |z| <= 100
   }   

aaa {
  z = pixel, c = z:
   z = sqr(c);
    |z|<p1
}

aaaa(XAXIS)  {
  z = pixel, c = z:
   z = exp(z*log(z));
    |z| <= p1
}
; formulas accessed from my PARS, lumped in here for convenience.
; Sources are noted ... thanks, folks 
; 
; >>don CIS:76704,41

; from SKINNER.FRM - Lee Skinner


 comment { version 15.1:}
 OldNewtonSinExp (XAXIS) {; Chris Green
  ; Newton's formula applied to sin(x)+exp(x)-1=0.
  ; Use floating point.
  z=pixel:
   z1=exp(z)
   z2=sin(z)+z1-1
   z=z-p1*z2/(cosxx(z)+z1),
    .0001 < |z2|
  }

comment { version 15.1:}
 OldCGNewtonSinExp (XAXIS) {
        z=pixel:
        z1=exp(z);
        z2=sin(z)+z1-z;
        z=z-p1*z2/(cosxx(z)+z1), .0001 < |z2|
   }

OldManowar (XAXIS) {
           z0 = 0,
           z1 = 0,
         test = p1 + 3,
           c = pixel :
               z = z1*z1 + z0 + c;
               z0 = z1;
               z1 = z,  |z| < test }

CGNewtonSinExp (XAXIS) {
        z=pixel:
        z1=exp(z);
        z2=sin(z)+z1-z;
        z=z-p1*z2/(cos(z)+z1), .0001 < |z2|
   }
   
Leeze (XAXIS) = {
                       s = exp(1.,0.), z = Pixel, f = Pixel ^ s:
                       z = cosxx (z) + f, |z| <= 50 }

FractalFenderC(XAXIS_NOPARM) {
                       z=p1,x=|z|:
                       (z=cosh(z)+pixel)*(1<x)+(z=z)*(x<=1),
                       z=sqr(z)+pixel,x=|z|,
                       x<=4 }

TSinh (XAXIS) = {
        z = c = sinh(pixel):
        z = c ^ z,
        z <= (p1 + 3)
        }

ScSkLMS(XAXIS) { z = pixel, TEST = (p1+3): z = log(z) - sin(z), |z|<TEST }
;
ScSkZCZZ(XYAXIS) { z = pixel, TEST = (p1+3): z = (z*cosxx(z)) - z, |z|<TEST }
;

;REB004.FRM - Ron Barnett

REB004A = {; Ron Barnett, 1993
   z = pixel:
   z =p1*fn1(z) + p1*p1*fn2(p2*z) + pixel, |z| <= 100
   }

REB004M = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1(const - 12*x)*x/(4*const);
   y1 = -fn2(const + 12*x)*y/(4*const);
   x2 = x1*x1 - y1*y1 + p1;
   y2 = 2*x*y;
   z = x2 + flip(y2), |z| <= 100
   } 
;

;
; REB002.FRM                                     
; Ron Barnett 70153,1233                         

FlipLambdaJ = { ; Ron Barnett, 1993
   z = pixel:
   z = p1*z*(1-flip(z)*flip(z)), |z| <= 100
   }

; REB005.FRM                                     
; Ron Barnett 70153,1233                         
REB005E = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1((const - x)*x/const);
   y1 = -fn2((const + y)*y/const);
   x2 = x1*x1 - y1*y1 + p1;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   }

REB005F = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1((const - 12*x)*x/(4*const));
   y1 = -fn2((const + 12*y)*y/(4*const));
   x2 = x1*x1 - y1*y1 + p1;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   } 

REB005G = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1(const + p1*x)*y/const;
   y1 = -fn2(const + y)*x/const;
   x2 = x1*x1 - y1*y1 + p2;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   }
       



;LIAR.FRM - Chuck Ebbert

Liar3 { ; by Chuck Ebbert.
        ; X: X is true to P1 times the extent that Y is true
        ; Y: Y is true to the extent that X is false.
        ; Sequential reasoning.  P1 usually 0 to 1.  P1=1 is Liar2 formula.
        ; x(n+1) = 1 - abs(p1*y(n)-x(n) );
        ; y(n+1) = 1 - abs((1-x(n+1) )-y(n) );
   z = pixel:
   x = 1 - abs(imag(z)*real(p1)-real(z) )
   z = flip(1 - abs(1-real(x)-imag(z) ) ) + real(x)
  |z| <= 1;
}


Liar4 { ; by Chuck Ebbert.
        ; X: X is as true as (p1+1) times Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; Real part of p1 changes probability.  Use floating point.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = pixel, p = p1 + 1:
   z = 1-abs(imag(z)*p-real(z))+flip(1-abs(1-real(z)-imag(z)));
    |z| <= 1
    }

;Tim Wegner - from a message on the board in GraphDev 1/10/94

Newton_poly2 { ; Tim Wegner - use float=yes
   ; fractal generated by Newton formula z^3 + (c-1)z - c
   ; p1 is c in above formula
   z = pixel, z2 = z*z, z3 = z*z2:
   z = (2*z3 + p1) / (3*z2 + (p1 - 1));
   z2 = z*z;
   z3 = z*z2,
  .004 <= |z3 + (p1-1)*z - p1|
  }

comment {the following forumlas are from OVERKILL.FRM, by Bradley Beacham
         CIS: 74223,2745  Internet 74223.2745@compuserve.com}

OK-13 { ;overkill.frm - bradley beacham
        ;TRY FN1 = SQR, FN2 = SQR
   z = 0, c = fn1(pixel) :
   z = fn1(z) + c;
   z = fn2(z),
   |z| <= (5 + p1)
  }

OK-23 {;overkill.frm - bradley beacham
   
   z = c = pixel, k = 1 + p1:
   z = k * fn1(z^z + c) + c/z,
   |z| <= (5 + p2)
  }

OK-26 {;overkill.frm - bradley beacham
  
   z = c = pixel, k = 2 + p1, test = k/(2 + p2):
   a = fn1(z);
   b = (|z| > test)  * (a - c);
   d = (|z| <= test) * (a + c);
   z = b + d,
   |z| <= k
  }

OK-27 {;overkill.frm - bradley beacham

   z = pixel, c = fn1(pixel), k = 1 + p1:
   a = fn2(z);
   b = (|z| >= k) * (a - c);
   d = (|z| < k) * (a + c);
   z = a + b + d,
   |z| <= (10 + p2)
  }

OK-30 {;overkill.frm - bradley beacham
 
   z = v = pixel, k = .5 + p1:
   a = fn1(z);
   b = (z <= k) * (a + v);
   e = (z > k) * (a - v);
   v = z;
   z = b + e,
   |z| <= (5 + p2)
  }

OK-31 {;overkill.frm - bradley beacham

   z = v = pixel, k = .1 + p1:
   a = fn1(z);
   b = (a <= k) * (a + v);
   e = (a > k) * fn2(a);
   v = z;
   z = b + e,
   |z| <= (5 + p2)
  }

OK-40 { ; DISECTED OK-39
  ; (ASSUMING YOU USE OK-39 WITH FN1= IDENT & FN2 = SQR...)
  z = pixel, cx = fn1(real(pixel)), cy = fn2(imag(pixel)), k = 2 + p1:
  zx = real(z), zy = imag(z);
  a = zx*cx - zy*cy;
  b = cx*zy + zx*cy;
  x = fn3(a*a - b*b) + cx;
  y = fn4(k*a*b) + cy;
  z = x + flip(y),
  |z| <= (10 + p2)
 }

OK-42 { ;overkill.frm - bradley beacham
        ; MUTATION OF FN + FN
  z = pixel, p1x = real(p1)+1, p1y = imag(p1)+1,
  p2x = real(p2)+1, p2y = imag(p2)+1:
  zx = real(z), zy = imag(z);
  x = fn1(zx*p1x - zy*p1y) + fn2(zx*p2x - zy*p2y);
  y = fn3(zx*p1y + zy*p1x) + fn4(zx*p2y + zy*p2x);
  z = x + flip(y),
  |z| <= 20
}

OK-43 { ;overkill.frm - bradley beacham
        ; DISECTED SPIDER
        ; TO GENERATE "STANDARD" SPIDER, SET P1 = 0,0 & ALL FN = IDENT
  z = c = pixel, k = 2 + p1:
  zx = real(z), zy = imag(z);
  cx = real(c), cy = imag(c);
  x = fn1(zx*zx - zy*zy) + cx;
  y = fn2(k*zx*zy) + cy;
  z = x + flip(y);
  c = fn3((cx + flip(cy))/k) + z,
  |z| <  (10 + p2)
}


comment {more from Brad Beacham ... FUBAR.FRM}

Curly { ; Mutation of 'Natura'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Michael Theroux [71673,2767]
  ; For 'Natura', set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 = Parameter (default 0.5,0), real(p2) = Bailout (default 4)
  z = pixel
  ; The next line sets c=default if p1=0, else c=p1
  c = ((0.5,0) * (|p1|<=0) + p1)
  ; The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2)):
    z = fn1(fn2(z*z*z)) + c
    |z| <= test
}

Moe { ; Mutation of 'Zexpe'.  Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Lee Skinner [75450,3631]
  ; For 'Zexpe', set FN1 & FN2 =IDENT and P1 = default
  ; real(p1) = Bailout (default 100)
  s = exp(1.,0.), z = pixel, c = fn1(pixel)
  ; The next line sets test=100 if real(p1)<=0, else test=real(p1)
  test = (100 * (real(p1)<=0) + real(p1) * (0<p1)):
    z = fn2(z)^s + c
    |z| <= test
}

Harpo { ; Mutation of 'Gopalsamy3'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Ron Barnett [70153,1233]
  ; For 'Gopalsamy3' with Ron's suggested parameters,
  ; set FN1 & FN2 = IDENT and P1 & P2 = default
  ; p1 = Parameter (default 1.099,0), real(p2) = Bailout (default 4)
  z = pixel
  ; The next line sets c=default if p1=0, else c=p1
  c = ((1.099,0) * (|p1|<=0) + p1)
  ; The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2)):
    x = real(z), y = imag(z)
    x1 = fn1(3*x*y*y - x*x*x) + c
    y = fn2(y*y*y - 3*x*x*y)
    z = x1 + flip(y)
    |z| <= test
}

Groucho { ; Mutation of 'Fish2'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Dave Oliver via Tim Wegner
  ; For 'Fish2', set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 = Parameter (default 1,0), real(p2) = Bailout (default 4)
  z = c = pixel
  ; The next line sets k=default if p1=0, else k=p1
  k = ((1,0) * (|p1|<=0) + p1)
  ; The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2)):
    z1 = c^(fn1(z)-k)
    z = fn2(((c*z1)-k)*(z1))
    |z| <= test
}

Chico { ; Mutation of 'M-SetInNewton'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Jon Horner [100112,1700]
  ; For 'M-SetInNewton' set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 & p2 = Parameters (default 3,0 and 0,0)
  z = 0,  c = fn1(pixel),  cminusone = c-1
  ; The next line sets k=default if p1=0, else k=p1
  k = (3 * (|p1|<=0) + p1)
  kminusone = k - 1:
    oldz = z
    nm = k*c-kminusone*z*cminusone
    dn = k*(k*z*z+cminusone)
    z = fn2(nm/dn)+kminusone*z/k + p2
    0.01 <= |(z-oldz)|
}

Zeppo { ; Mutation of 'Liar4'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Chuck Ebbert [76306,1226]
  ; For 'Liar4' set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 & p2 = Parameters (default 1,0 and 0,0)
  z = pixel
  ; The next line sets p=default if p1=0, else p=p1
  p = (1 * (|p1|<=0) + p1):
    z =fn1(1-abs(imag(z)*p-real(z)))+flip(fn2(1-abs(1-real(z)-imag(z))))-p2
    |z| <= 1
}

comment {from 4DFRACT.FRM, Gordon Lamb (CIS: 100272,3541) ... astounding
 stuff}

SJMAND05 {;Mandelbrot lambda function
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=fn1(z)*c, |z|<=64}

comment { Jm Collard-Richard - JMCR1.FRM}


FlipConjJul_N  { ; Jm Collard-Richard
      z=pixel:
      z=flip(conj(z^p2))+p1,
      |z|<=4         }

GenInvMand1_N  { ; Jm Collard-Richard
c=z=1/pixel:
z=fn1(z)*fn2(z)+fn3(fn4(c)),
|z|<=4         }


;All of these formulas are based on the Golden Section or Phi as it is found
;everywhere in nature. Exhibiting true patterns of growth, these are new to
;the genre and have many interesting characteristics not found in the
;"secular" world of fractals.  All of these fractal formulas work with
;Fractint 17.2. Enjoy.
 
Michaelbrot(origin) {    ;based on Golden Mean
	  
z = pixel:
z = sqr(z) + ((sqrt 5 + 1)/2), 
|z| <= 4;
} 


Raphaelbrot(xyaxis) {  ;phi

z = pixel:
z = sqr(z) + ((sqrt 5 - 1)/2) 
|z| <= 4;
}


DrChaosbrot1(xaxis) { ;more phi

z = c = pixel:
z = sqr(z) + (((sqrt 5 + 1)/2)+c)
|z| <= 4;
}


DrChaosbrot2(xyaxis)   { ;more phi

z = c = pixel:
z = sqr(z) + (((sqrt 5 + 1)/2)+c)
|z| <= 4;
}


Natura(xyaxis)  {  ;phi yoni

z = pixel:
z = z*z*z + ((sqrt 5 + 1)/2) 
|z| <= 4;
}

Element(xyaxis) { ;phi lingam

z = pixel:
z = z*z*z*z + ((sqrt 5 + 1)/2) 
|z| <= 4;
}

;try inside=maxiter and outside=imag on these

test(xyaxis) { ;=phi 
z = ((sqrt 5 + 1)/2)/pixel:
z =  z*z + pixel*((sqrt 5 + 1)/2)
|z| <= 4;
}

test1(xyaxis) { ;=phi
c = pixel 
z = ((sqrt 5 + 1)/2):
z =  z*z + pixel*((sqrt 5 + 1)/2) + c
|z| <= 4;
}

test2(xyaxis) { ;=phi 
z = ((sqrt 5 + 1)/2)/pixel:
z =  z*z*z + pixel*((sqrt 5 + 1)/2)
|z| <= 4;
}


test3(xyaxis) { ;=phi 
z = ((sqrt 5 + 1)/2)/pixel:
z =  z*z + pixel*((sqrt 5 + 1)/2)/((sqrt 5 - 1)/2)
|z| <= 4;
}

Tetratephi(xyaxis) { ;?

z  = c = ((sqrt 5 +1)/2)/pixel:
z = c^z + ((sqrt 5 +1)/2) 
|z| <= 4;
}

;;  #: 15473 S4/Fractal Sources
;;      26-Feb-93 16:42:16
;;  Sb: #15349-#Good News/Bad News
;;  Fm: Chuck Ebbert 76306,1226
;;  To: Jon Horner 100112,1700 (X)
;;
;;  Jon, try these.  I learned a lot when I figured out the magnet2m
;;  formula:

Tetrate(XAXIS) { ; duplicate of built-in type.
  ; p1=initial perturbation of z(0), p2 changes bailout from 4.
  z = pixel + p1, b = real(p2) + 4:
   z = pixel ^ z;
    |z| <= b;
 }

FnxZpZ  {
  ; Duplicate of built-in 'fn*z+z' type.
  ; p1, p2 same as built-in
  z = pixel:
   z = (p1 * fn1(z) + p2 ) * z,
    |z| <= 64
 }

FnZpFnPix {
  ; Duplicate of built-in type 'fn(z)+fn(pix).'
  ; P1 = perturbation of z(0), p2 = multiplication factor.
  z = pixel + p1, c = p2 * fn2(pixel):
   z = fn1(z) + c,
    |z| <= 64
 }

LambdaFnOrFn { ; Chuck Ebbert
   ; Duplicate of built-in 'lambda(fn||fn).'
   ; P1 = lambda, real(p2) changes shift value from default of 1,
   ;  imag(p2) changes bailout from default of 64.
  z = pixel, modz = |z|, b = imag(p2) + 64, t = real(p2) + 1:
   z = ( fn1(z) * (modz<t) + fn2(z) * (real(t)<=modz ) ) * p1,
   modz = |z|,
    modz <= b
 }

Magnet1M(XAXIS) {
  ; Duplicate of built-in type.
  ; P1 = initial perturbation of z(0).
  z = p1, cm1 = pixel - 1, cm2 = cm1 - 1:
   z = sqr( (z*z+cm1 ) / (z+z+cm2 ) );
    |z-1| > .000030517578 && |z| <= 100;
 }

Magnet2M(XAXIS) {
  ; Duplicate of built-in type.
  ; P1 = initial perturbation of z(0).
  z=p1,c1=pixel-1,c1x3=c1*3,c2x3=c1x3-3,c1c2=c1*c1-c1,c1c2p1=c1c2+1:
   z=sqr( ( (z*z+c1x3 )*z+c1c2 ) / ( (z*3+c2x3 )*z+c1c2p1 ) );
    |z-1| > .000030517578 && |z| <= 100;
 }

Gen_01 {; generalized type
  ; p1=p2=0, fn1=fn2=fn3=ident, fn4=sqr gives Mandelbrot
  z=pixel, t=p1+4, q = (p2+1) * fn1(pixel):
   z=fn2(fn3(fn4(z))) + q,
    |z|<=t
  }

a---mand {
  z = c = pixel:
   z = z^c + sin(c)
    |z|<p1
}

dots {
  z = c = pixel:
   z = z^c + c
    |z|<p1
}

a--mand {
  z = c = pixel:
   z = (sqr(z)+c) / |c|
    |z|<p1
}

aaa-deals {
  z = pixel, a=real(z), b=imag(z), i=((0-1)^0.5):
   x = real(z)
   y = imag(z)
   u = x*x + y*y + a
   v = (0-2)*x*y + b
   z = u + v*i;
    |z|<p1
}

aa-mand-re(XAXIS) {
  z = c = pixel:
   z = sqr(z)+c;
    real(z)<p1
}

aa-mand-im(XAXIS) {
  z = c = pixel:
   z = sqr(z)+c;
    imag(z)<p1
}

aa-diamand {
  z = c = pixel:
   z = sqr(z)+c;
    (real(z)+imag(z))<p1
}

aa-c-to-z(XAXIS)  {
  z = pixel, c = z:
   z = c^z;
    |z| <= p1
}

aa-z-to-c(XAXIS)  {
  z = pixel, c = z:
   z = exp(c*log(z));
    |z| <= p1
}

aa-z-to-z(XAXIS)  {
  z = pixel, c = z:
   z = exp(z*log(z));
    |z| <= p1
}
	Here is the Fractint formula file used for explod.gif:

j1 {
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2,
	|z| <= 4
	}

m1 {
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1,
	|z| <= 4
	}

jz {
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*z,
	|z| <= 4
	}

mz {
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*z,
	|z| <= 4
	}

joz {
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2/z,
	|z| <= 4
	}

moz {
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1/z,
	|z| <= 4
	}

jfnz {
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*fn1(z),
	|z| <= 4
	}

mfnz {
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*fn1(z),
	|z| <= 4
	}

jc {
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*c,
	|z| <= 4
	}

mc {
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*c,
	|z| <= 4
	}

joc {
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2/c,
	|z| <= 4
	}

moc {
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1/c,
	|z| <= 4
	}

jfnc {
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*fn1(c),
	|z| <= 4
	}

mfnc {
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*fn1(c),
	|z| <= 4
	}


#: 61642 S4/Fractal Sources  [GRAPHDEV]
    18-Apr-94  12:01:30
Sb: Fish
Fm: Timothy Wegner 71320,675
To: ALL

Here's a fractal that looks like a fish. I've listed the formula in
Fractint's FRM format that was just sent to me from the UK. I've added
comments for non-fractint folks who want to code this up themselves. You'll
need a complex number exponent function to do it.

The formula doesn't really have exact xaxis symmetry, but it looks
reasonably similar with symmetry turned off. I guess if this makes it into
FRACTINT.FRM the symmetry could be removed -- symmetry=xaxis could be in
the Fish PAR entry. IMHO symmetry should be used in a FRM entry only if the
formula is really symmetrical.

To see the fish, use corners=-4/4/-3/3.
The second version is faster because one of the exponentiations is avoided.

Fish (xaxis) {; Dave Oliver   >INTERNET:D.E.Oliver@soton.ac.uk
   z=pixel:                       ; initialize z to coordinates at pixel
   z=((pixel^z)-1)*(pixel^(z-1))  ; the "^" means complex exponentiation
   |z|<=4                         ; escape radius is 2 (|z| is sqr(x)+sqr(y))
}

Fish2 (xaxis) {; Dave Oliver   >INTERNET:D.E.Oliver@soton.ac.uk
               ; (sped up 20% by T. Wegner)
   z=pixel:
   z1 = pixel^(z-1)
   z=((pixel*z1)-1)*(z1)
   |z|<=4
}

N1(XYAXIS) {    z=pixel:  z=1/sin(1/(z*pixel)) ,             |z|<=4
   } try maxiter=35 then 200
N_n(XYAXIS) {   z=pixel:  z=(1/sin(1/(z^2*pixel))) ,         |z|<=4
   } n integer
N_n1(XYAXIS) {  z=pixel:  z=(1/sin(1/(z^2*pixel)))*pixel ,   |z|<=4
   }
N2(XAXIS){      z=pixel:  z=(1/sin(sinh(z*pixel)))*pixel ,   |z|<=4
   }
N2_1(XYAXIS){   z=pixel:  z=sin(sinh(z*pixel))*pixel   ,     |z|<=4
   }
N2_2(XYAXIS){   z=pixel:  z=sin(sinh(z*pixel))+pixel   ,     |z|<=4
   }
N3(XAXIS)  {    z=pixel:  z=1/sin(1/((z^z)*pixel))     ,     |z|<=4
   }
N3_1(XAXIS) {   z=pixel:  z=1/sin(1/((z^z)*pixel))+pixel,    |z|<=4
   }
N3_2(XAXIS) {   z=pixel:  z=1/sin(1/((z^z)*pixel))*pixel,    |z|<=4
   }
N3sh(XAXIS)   { z=pixel:  z=1/sinh(1/((z^z)*pixel))     ,    |z|<=4
   }
N3_1sh(XAXIS)  {z=pixel:  z=1/sinh(1/((z^z)*pixel))+pixel,   |z|<=4
   }
N3_2sh(XAXIS)  {z=pixel:  z=1/sinh(1/((z^z)*pixel))*pixel,   |z|<=4
   }
N3_1ch(XAXIS) { z=pixel:  z=1/cosh(1/((z^z)*pixel))+pixel,   |z|<=4
   }
N3_2ch(XAXIS) { z=pixel:  z=1/cosh(1/((z^z)*pixel))*pixel,   |z|<=4
   }
N4(XYAXIS) {    z=pixel:  z=(1/sin(1/(z*pixel)))*pixel ,     |z|<=4
   }
N5(XYAXIS) {    z=pixel:  z=(1/sin(1/(z*pixel)))+pixel ,     |z|<=4
   }
N6(XAXIS) {     z=pixel:  z=(1/cos(1/(z*z)))+pixel ,         |z|<=4
   }
N7(XAXIS) {     z=pixel:  z=(1/cos(1/(z*pixel)))+pixel ,     |z|<=4
   }
N8(XYAXIS) {    z=pixel:  z=1/sinh(1/(z*pixel)) ,            |z|<=4
   }
N9(XAXIS) {     z=pixel:  z=1/sinh(1/(z*pixel))+pixel,       |z|<=4
   }
N10(XYAXIS) {   z=pixel:  z=1/sinh(1/(z*pixel))*pixel,       |z|<=4
   }
N11(XYAXIS) {   z=pixel:  z=1/cosh(1/(z*pixel)) ,            |z|<=4
   }
N12(XAXIS)  {   z=pixel:  z=1/cosh(1/(z*pixel))+pixel,       |z|<=4
   }
N13(XYAXIS) {   z=pixel:  z=1/cosh(1/(z*pixel))*pixel,       |z|<=4
   }
N15(XAXIS) {    z=pixel:  z=(sin(z*z*sin(1/(z*z))))+pixel,   |z|<=4
   }
N16(XYAXIS) {   z=pixel:  z=(sin(z*z*sin(1/(z*z))))*pixel,   |z|<=4
   }
ducks(xaxis) {  z=pixel,t=1+pixel:   z=sqr(z)+t,             |z|<=4
   }
It seems not so ugly at first glance and lot of corners to zoom in.
try this:
 Corners              X                  Y
top-left         -1.178372          -0.601683
bottom-right     -0.978384          -0.751678
center           -1.07838           -0.67668

NxA(XAXIS)   { z=pixel:   z=sin(z^pixel)  ,                  |z|<=4
   }
NxB(XAXIS)   { z=pixel:   z=sin(z^pixel)*pixel  ,            |z|<=4
   }
NxE(XAXIS)   { z=pixel:   z=sinh(z^pixel)  ,                 |z|<=4
   }
NxF(XAXIS)   { z=pixel:   z=sinh(z^pixel)*pixel  ,           |z|<=4
   }
NxJ(XYAXIS)  { z=pixel:   z=1/sin(z*pixel)  ,                |z|<=4
   }
NxK(XAXIS)   { z=pixel:   z=(1/sin(z^pixel))*pixel  ,        |z|<=4
   }
NxL(XYAXIS)  { z=pixel:   z=(1/sin(z*pixel))*pixel  ,        |z|<=4
   }
NxM(XAXIS)   { z=pixel:   z=1/cos(z^pixel)  ,                |z|<=4
   }
NxN(XYAXIS)  { z=pixel:   z=1/cos(z*pixel)  ,                |z|<=4
   }
NxP(XYAXIS)  { z=pixel:   z=(1/cos(z*pixel))*pixel  ,        |z|<=4
   }
NxR(XYAXIS)  { z=pixel:   z=1/sinh(z*pixel)  ,               |z|<=4
   }
NxT(XYAXIS)  { z=pixel:   z=(1/sinh(z*pixel))*pixel  ,       |z|<=4
   }
NxU(XAXIS)   { z=pixel:   z=1/cosh(z^pixel)  ,               |z|<=4
   }
NxV(XYAXIS)  { z=pixel:   z=1/cosh(z*pixel)  ,               |z|<=4
   }
NxX(XYAXIS)  { z=pixel:   z=(1/cosh(z*pixel))*pixel  ,       |z|<=4
   }
NxY(XYAXIS)  { z=pixel:   z=z*pixel*sin(z*pixel)  ,          |z|<=4
   }
NxZ(XAXIS)   { z=pixel:   z=z*pixel*sin(z*pixel)+pixel ,     |z|<=4
   }
Nx2(XYAXIS)  { z=pixel:   z=z*pixel*sinh(z*pixel)+pixel ,    |z|<=4
   }
Nx3(XYAXIS)  { z=pixel:   z=z*pixel*cosh(z*pixel)  ,         |z|<=4
   }
Nx5(XYAXIS)  { z=pixel:   z=1/((z*pixel)*sin(z*pixel))   ,   |z|<=4
   }
Nx6(XYAXIS)  { z=pixel:   z=(1/((z*pixel)*sin(z*pixel)))*pixel  , |z|<=4
   }
Nx7(XYAXIS)  { z=pixel:   z=1/((z*pixel)*sinh(z*pixel))  ,   |z|<=4
   }
Nx8(XYAXIS)  { z=pixel:   z=(1/((z*pixel)*sinh(z*pixel)))*pixel  , |z|<=4
   }
Nx9(XAXIS)   { z=pixel:   z=(z^pixel)*sin(z^pixel)  ,        |z|<=4
   }
Ny1(XYAXIS)  { z=pixel:   z=(z^pixel)*sinh(z^pixel)  ,       |z|<=4
   }





phoenix_m { ; Mandelbrot stye map of the Phoenix curves
   z=x=y=nx=ny=x1=y1=x2=y2=0:
   x2 = sqr(x), y2 = sqr(y),
   x1 = x2 - y2 + real(pixel) + imag(pixel) * nx,
   y1 = 2 * x * y + imag(pixel) * ny,
   nx=x, ny=y, x=x1, y=y1, z=x + flip(y),
   |z| <= 4
   }
phoenix_j (XAXIS) { ; Use P1=0.56667/-0.5   &   .1/.8
   x=real(pixel), y=imag(pixel), z=nx=ny=x1=x2=y1=y2=0:
   x2 = sqr(x), y2 = sqr(y),
   x1 = x2 - y2 + real(p1) + imag(p1) * nx,
   y1 = 2 * x * y + imag(p1) * ny,
   nx=x, ny=y, x=x1, y=y1, z=nx + flip(ny),
   |z| <= 4
   }
non-conformal { ; From Media Magic Calender - August
   z=x=y=x2=y2=0:
   t = x * y,
   x = x2 + t + real(pixel),  y = y2 - t + imag(pixel),
   x2 = sqr(x),  y2 = sqr(y), z=x + flip(y),
   |z| <= 4
   }
flip0_man_m(XAXIS) {
   z=0:
   z = flip(sqr(z) + pixel),
   |z| <= 4
   }
flip0_man_j(ORIGIN) {
   z=pixel:
   z = flip(sqr(z) + p1),
   |z| <= 4
   }
flip1_man_m {
   z=0, q = pixel:
   q = flip(q),
   z = sqr(z) + q,
   |z| <= 4
   }
flip1_man_j(ORIGIN) {
   z=pixel, q = p1:
   q = flip(q),
   z = sqr(z) + q,
   |z| <= 4
   }
flip2_man_m { ;
   z=0, q = pixel:
   q = flip(q),
   z = flip(sqr(z) + q),
   |z| <= 4
   }
flip2_man_j(ORIGIN) {
   z=pixel, q = p1:
   q = flip(q),
   z = flip(sqr(z) + q),
   |z| <= 4
   }
flip3_man_m(XAXIS) { ;
   z = 0:
   z = 1/flip(sqr(z) + pixel),
   |z| <= 4
   }
flip3_man_j { ;
   z = pixel:
   z = 1/flip(sqr(z) + p1),
   |z| <= 4
   }

comment {
 FRACTINT.DOC has instructions for adding new formulas to this file.
 There are several hard-coded restrictions in the formula interpreter:

 1) The fractal name through the open curly bracket must be on a single line.
 2) There is a hard-coded limit of 200 formulas per formula file, only
	because of restrictions in the prompting routines.
 3) Formulas can containt at most 250 operations (references to variables and
	arithmetic); this is bigger than it sounds, no formula in the default
	fractint.frm uses even 100
 3) Comment blocks can be set up using dummy formulas with no formula name
	or with the special name "comment".

 The formulas at the beginning of this file are from Mark Peterson, who
 built this fractal interpreter feature.  The rest are grouped by contributor.
 (Scott Taylor sent many but they are no longer here - they've been
 incorporated as hard-coded types.  Lee Skinner also sent many which have
 now been hard-coded.)

 Note that the builtin "cos" function had a bug which was corrected in
 version 16.  To recreate an image from a formula which used cos before
 v16, change "cos" in the formula to "cosxx" which is a new function
 provided for backward compatibility with that bug.
 }

Mandelbrot(XAXIS) {; Mark Peterson
  ; Classical fractal showing LastSqr speedup
  z = Pixel, z = Sqr(z):  ; Start with z**2 to initialize LastSqr
   z = z + Pixel
   z = Sqr(z)
	LastSqr <= 4      ; Use LastSqr instead of recalculating
  }

Dragon (ORIGIN) {; Mark Peterson
  z = Pixel:
   z = sqr(z) + (-0.74543, 0.2),
	|z| <= 4
  }

Daisy (ORIGIN) {; Mark Peterson
  z = pixel:
   z = z*z + (0.11031, -0.67037),
	|z| <= 4
  }

InvMandel (XAXIS) {; Mark Peterson
  c = z = 1 / pixel:
   z = sqr(z) + c;
	|z| <= 4
  }

DeltaLog(XAXIS) {; Mark Peterson
  z = pixel, c = log(pixel):
   z = sqr(z) + c,
	|z| <= 4
  }

Newton4(XYAXIS) {; Mark Peterson
  ; Note that floating-point is required to make this compute accurately
  z = pixel, Root = 1:
   z3 = z*z*z;
   z4 = z3 * z;
   z = (3 * z4 + Root) / (4 * z3);
	.004 <= |z4 - Root|
  }

comment {
   The following are from Chris Green:
   These fractals all use Newton's or Halley's formula for approximation
   of a function.  In all of these fractals, p1 real is the "relaxation
   coefficient". A value of 1 gives the conventional newton or halley
   iteration. Values <1 will generally produce less chaos than values >1.
   1-1.5 is probably a good range to try.  P1 imag is the imaginary component
   of the relaxation coefficient, and should be zero but maybe a small
   non-zero value will produce something interesting. Who knows?
   For more information on Halley maps, see "Computers, Pattern, Chaos,
   and Beauty" by Pickover.
   }

Halley (XYAXIS) {; Chris Green. Halley's formula applied to x^7-x=0.
  ; P1 real usually 1 to 1.5, P1 imag usually zero. Use floating point.
  ; Setting P1 to 1 creates the picture on page 277 of Pickover's book
  z=pixel:
   z5=z*z*z*z*z;
   z6=z*z5;
   z7=z*z6;
   z=z-p1*((z7-z)/ ((7.0*z6-1)-(42.0*z5)*(z7-z)/(14.0*z6-2))),
	0.0001 <= |z7-z|
  }

CGhalley (XYAXIS) {; Chris Green -- Halley's formula
  ; P1 real usually 1 to 1.5, P1 imag usually zero. Use floating point.
  z=(1,1):
   z5=z*z*z*z*z;
   z6=z*z5;
   z7=z*z6;
   z=z-p1*((z7-z-pixel)/ ((7.0*z6-1)-(42.0*z5)*(z7-z-pixel)/(14.0*z6-2))),
	0.0001 <= |z7-z-pixel|
  }

halleySin (XYAXIS) {; Chris Green. Halley's formula applied to sin(x)=0.
  ; Use floating point.
  ; P1 real = 0.1 will create the picture from page 281 of Pickover's book.
  z=pixel:
   s=sin(z), c=cos(z)
   z=z-p1*(s/(c-(s*s)/(c+c))),
	0.0001 <= |s|
  }

NewtonSinExp (XAXIS) {; Chris Green
  ; Newton's formula applied to sin(x)+exp(x)-1=0.
  ; Use floating point.
  z=pixel:
   z1=exp(z)
   z2=sin(z)+z1-1
   z=z-p1*z2/(cos(z)+z1),
	.0001 < |z2|
  }

CGNewton3 {; Chris Green -- A variation on newton iteration.
  ; The initial guess is fixed at (1,1), but the equation solved
  ; is different at each pixel ( x^3-pixel=0 is solved).
  ; Use floating point.
  ; Try P1=1.8.
  z=(1,1):
   z2=z*z;
   z3=z*z2;
   z=z-p1*(z3-pixel)/(3.0*z2),
	0.0001 < |z3-pixel|
  }

HyperMandel {; Chris Green.
  ; A four dimensional version of the mandelbrot set.
  ; Use P1 to select which two-dimensional plane of the
  ; four dimensional set you wish to examine.
  ; Use floating point.
  a=(0,0),b=(0,0):
   z=z+1
   anew=sqr(a)-sqr(b)+pixel
   b=2.0*a*b+p1
   a=anew,
	|a|+|b| <= 4
  }


MTet (XAXIS) {; Mandelbrot form 1 of the Tetration formula --Lee Skinner
  z = pixel:
   z = (pixel ^ z) + pixel,
	|z| <= (P1 + 3)
  }

AltMTet(XAXIS) {; Mandelbrot form 2 of the Tetration formula --Lee Skinner
  z = 0:
   z = (pixel ^ z) + pixel,
	|z| <= (P1 + 3)
  }

JTet (XAXIS) {; Julia form 1 of the Tetration formula --Lee Skinner
  z = pixel:
   z = (pixel ^ z) + P1,
	|z| <= (P2 + 3)
  }

AltJTet (XAXIS) {; Julia form 2 of the Tetration formula --Lee Skinner
  z = P1:
   z = (pixel ^ z) + P1,
	|z| <= (P2 + 3)
  }

Cubic (XYAXIS) {; Lee Skinner
  p = pixel, test = p1 + 3,
  t3 = 3*p, t2 = p*p,
  a = (t2 + 1)/t3, b = 2*a*a*a + (t2 - 2)/t3,
  aa3 = a*a*3, z = 0 - a :
   z = z*z*z - aa3*z + b,
	|z| < test
 }


{ The following resulted from a FRACTINT bug. Version 13 incorrectly
  calculated Spider (see above). We fixed the bug, and reverse-engineered
  what it was doing to Spider - so here is the old "spider" }

Wineglass(XAXIS) {; Pieter Branderhorst
  c = z = pixel:
   z = z * z + c
   c = (1+flip(imag(c))) * real(c) / 2 + z,
	|z| <= 4 }


{ The following is from Scott Taylor.
  Scott says they're "Dog" because the first one he looked at reminded him
  of a hot dog. This was originally several fractals, we have generalized it. }

FnDog(XYAXIS)  {; Scott Taylor
  z = Pixel, b = p1+2:
   z = fn1( z ) * pixel,
	|z| <= b
  }

Ent {; Scott Taylor
  ; Try params=.5/.75 and the first function as exp.
  ; Zoom in on the swirls around the middle.  There's a
  ; symmetrical area surrounded by an asymmetric area.
  z = Pixel, y = fn1(z), base = log(p1):
   z = y * log(z)/base,
	|z| <= 4
  }

Ent2 {; Scott Taylor
  ; try params=2/1, functions=cos/cosh, potential=255/355
  z = Pixel, y = fn1(z), base = log(p1):
   z = fn2( y * log(z) / base ),
	|z| <= 4
  }

{ From Kevin Lee: }

LeeMandel1(XYAXIS) {; Kevin Lee
  z=Pixel:
;; c=sqr(pixel)/z, c=z+c, z=sqr(z),  this line was an error in v16
   c=sqr(pixel)/z, c=z+c, z=sqr(c),
	|z|<4
  }

LeeMandel2(XYAXIS) {; Kevin Lee
  z=Pixel:
   c=sqr(pixel)/z, c=z+c, z=sqr(c*pixel),
	|z|<4
   }

LeeMandel3(XAXIS) {; Kevin Lee
  z=Pixel, c=Pixel-sqr(z):
   c=Pixel+c/z, z=c-z*pixel,
	|z|<4
  }

{ These are a few of the examples from the book,
  Fractal Creations, by Tim Wegner and Mark Peterson. }

MyFractal {; Fractal Creations example
  c = z = 1/pixel:
   z = sqr(z) + c;
	|z| <= 4
  }

Bogus1 {; Fractal Creations example
  z = 0; z = z + * 2,
   |z| <= 4 }

MandelTangent {; Fractal Creations example (revised for v.16)
  z = pixel:
   z = pixel * tan(z),
	|real(z)| < 32
  }

Mandel3 {; Fractal Creations example
  z = pixel, c = sin(z):
   z = (z*z) + c;
   z = z * 1/c;
	|z| <= 4;
   }

{ These are from: "AKA MrWizard W. LeRoy Davis;SM-ALC/HRUC"
		  davisl@sm-logdis1-aflc.af.mil
  The first 3 are variations of:
			   z
	   gamma(z) = (z/e) * sqrt(2*pi*z) * R      }

Sterling(XAXIS) {; davisl
  z = Pixel:
   z = ((z/2.7182818)^z)/sqr(6.2831853*z),
	|z| <= 4
  }

Sterling2(XAXIS) {; davisl
  z = Pixel:
   z = ((z/2.7182818)^z)/sqr(6.2831853*z) + pixel,
	|z| <= 4
  }

Sterling3(XAXIS) {; davisl
  z = Pixel:
   z = ((z/2.7182818)^z)/sqr(6.2831853*z) - pixel,
	|z| <= 4
  }

PsudoMandel(XAXIS) {; davisl - try center=0,0/magnification=28
  z = Pixel:
   z = ((z/2.7182818)^z)*sqr(6.2831853*z) + pixel,
	|z| <= 4
  }

{ These are the original "Richard" types sent by Jm Richard-Collard. Their
  generalizations are tacked on to the end of the "Jm" list below, but
  we felt we should keep these around for historical reasons.}

Richard1 (XYAXIS) {; Jm Richard-Collard
  z = pixel:
   sq=z*z, z=(sq*sin(sq)+sq)+pixel,
	|z|<=50
  }

Richard2 (XYAXIS) {; Jm Richard-Collard
  z = pixel:
   z=1/(sin(z*z+pixel*pixel)),
	|z|<=50
  }

Richard3 (XAXIS) {; Jm Richard-Collard
  z = pixel:
   sh=sinh(z), z=(1/(sh*sh))+pixel,
	|z|<=50
  }

Richard4 (XAXIS) {; Jm Richard-Collard
  z = pixel:
   z2=z*z, z=(1/(z2*cos(z2)+z2))+pixel,
	|z|<=50
  }

Richard5 (XAXIS) {; Jm Richard-Collard
  z = pixel:
   z=sin(z*sinh(z))+pixel,
	|z|<=50
  }

Richard6 (XYAXIS) {; Jm Richard-Collard
  z = pixel:
   z=sin(sinh(z))+pixel,
	|z|<=50
  }

Richard7 (XAXIS) {; Jm Richard-Collard
  z=pixel:
   z=log(z)*pixel,
	|z|<=50
  }

Richard8 (XYAXIS) {; Jm Richard-Collard
  ; This was used for the "Fractal Creations" cover
  z=pixel,sinp = sin(pixel):
   z=sin(z)+sinp,
	|z|<=50
  }

Richard9 (XAXIS) {; Jm Richard-Collard
  z=pixel:
   sqrz=z*z, z=sqrz + 1/sqrz + pixel,
	|z|<=4
  }

Richard10(XYAXIS) {; Jm Richard-Collard
  z=pixel:
   z=1/sin(1/(z*z)),
	|z|<=50
  }

Richard11(XYAXIS) {; Jm Richard-Collard
  z=pixel:
   z=1/sinh(1/(z*z)),
	|z|<=50
  }

{ These types are generalizations of types sent to us by the French
  mathematician Jm Richard-Collard. If we hadn't generalized them
  there would be --ahhh-- quite a few. With 11 possible values for
  each fn variable,Jm_03, for example, has 14641 variations! }

Jm_01 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=(fn1(fn2(z^pixel)))*pixel,
	|z|<=t
  }

Jm_02 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=(z^pixel)*fn1(z^pixel),
	|z|<=t
  }

Jm_03 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1((fn2(z)*pixel)*fn3(fn4(z)*pixel))*pixel,
	|z|<=t
  }

Jm_03a {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1((fn2(z)*pixel)*fn3(fn4(z)*pixel))+pixel,
	|z|<=t
  }

Jm_04 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1((fn2(z)*pixel)*fn3(fn4(z)*pixel)),
	|z|<=t
  }

Jm_05 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2((z^pixel))),
	|z|<=t
  }

Jm_06 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3((z^z)*pixel))),
	|z|<=t
  }

Jm_07 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3((z^z)*pixel)))*pixel,
	|z|<=t
  }

Jm_08 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3((z^z)*pixel)))+pixel,
	|z|<=t
  }

Jm_09 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(fn4(z))))+pixel,
	|z|<=t
  }

Jm_10 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(fn4(z)*pixel))),
	|z|<=t
  }

Jm_11 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(fn4(z)*pixel)))*pixel,
	|z|<=t
  }

Jm_11a {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(fn4(z)*pixel)))+pixel,
	|z|<=t
  }

Jm_12 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)*pixel)),
	|z|<=t
  }

Jm_13 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)*pixel))*pixel,
	|z|<=t
  }

Jm_14 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)*pixel))+pixel,
	|z|<=t
  }

Jm_15 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   f2=fn2(z),z=fn1(f2)*fn3(fn4(f2))*pixel,
	|z|<=t
  }

Jm_16 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   f2=fn2(z),z=fn1(f2)*fn3(fn4(f2))+pixel,
	|z|<=t
  }

Jm_17 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z)*pixel*fn2(fn3(z)),
	|z|<=t
  }

Jm_18 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z)*pixel*fn2(fn3(z)*pixel),
	|z|<=t
  }

Jm_19 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z)*pixel*fn2(fn3(z)+pixel),
	|z|<=t
  }

Jm_20 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z^pixel),
	|z|<=t
  }

Jm_21 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z^pixel)*pixel,
	|z|<=t
  }

Jm_22 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   sq=fn1(z), z=(sq*fn2(sq)+sq)+pixel,
	|z|<=t
  }

Jm_23 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)+pixel*pixel)),
	|z|<=t
  }

Jm_24 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z2=fn1(z), z=(fn2(z2*fn3(z2)+z2))+pixel,
	|z|<=t
  }

Jm_25 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z*fn2(z)) + pixel,
	|z|<=t
  }

Jm_26 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(z)) + pixel,
	|z|<=t
  }

Jm_27 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   sqrz=fn1(z), z=sqrz + 1/sqrz + pixel,
	|z|<=t
  }

Jm_ducks(XAXIS) {; Jm Richard-Collard
  ; Not so ugly at first glance and lot of corners to zoom in.
  ; try this: corners=-1.178372/-0.978384/-0.751678/-0.601683
  z=pixel,tst=p1+4,t=1+pixel:
   z=sqr(z)+t,
	|z|<=tst
  }

Gamma(XAXIS)={ ; first order gamma function from Prof. Jm
  ; "It's pretty long to generate even on a 486-33 comp but there's a lot
  ; of corners to zoom in and zoom and zoom...beautiful pictures :)"
  z=pixel,twopi=6.283185307179586,r=10:
   z=(twopi*z)^(0.5)*(z^z)*exp(-z)+pixel
	|z|<=r
  }

ZZ(XAXIS) { ; Prof Jm using Newton-Raphson method
  ; use floating point with this one
  z=pixel,solution=1:
   z1=z^z;
   z2=(log(z)+1)*z1;
   z=z-(z1-1)/z2 ,
	0.001 <= |solution-z1|
  }

ZZa(XAXIS) { ; Prof Jm using Newton-Raphson method
  ; use floating point with this one
  z=pixel,solution=1:
   z1=z^(z-1);
   z2=(((z-1)/z)+log(z))*z1;
   z=z-((z1-1)/z2) ,
	.001 <= |solution-z1|
  }


comment {
  You should note that for the Transparent 3D fractals the x, y, z, and t
  coordinates correspond to the 2D slices and not the final 3D True Color
  image.  To relate the 2D slices to the 3D image, swap the x- and z-axis,
  i.e. a 90 degree rotation about the y-axis.
				-Mark Peterson 6-2-91
  }

MandelXAxis(XAXIS) {    ; for Transparent3D
  z = zt,       ; Define Julia axes as depth/time and the
  c = xy:       ;   Mandelbrot axes as width/height for each slice.
			;   This corresponds to Mandelbrot axes as
			;   height/depth and the Julia axes as width
			;   time for the 3D image.
   z = Sqr(z) + c
	LastSqr <= 4;
  }

OldJulibrot(ORIGIN) {           ; for Transparent3D
  z = real(zt) + flip(imag(xy)),    ; These settings coorespond to the
  c = imag(zt) + flip(real(xy)):    ;   Julia axes as height/width and
					;   the Mandelbrot axes as time/depth
					;   for the 3D image.
   z = Sqr(z) + c
	LastSqr <= 4;
  }
   IkenagaMap(XAXIS) = {; based upon the Ikenaga function described
	  ; in Dewdneys's The Armchair Universe.
	  ; The initial starting point allows the function to provide a
	  ; "map" for the corresponding Julia function (Julike ) 
	  z = ((1-pixel)/3)^0.5: 
	  z = z*z*z + (pixel-1)*z - pixel, |z| <= 4
   }

   Julike = {; a Julia function based upon the Ikenaga function
	  z = Pixel:
	  z = z*z*z + (P1-1)*z - P1, |z| <= 4
   }

   Mask = {; try fn1 = log, fn2 = sinh, fn3 = cosh
	  ;P1 = (0,1), P2 = (0,1)
	  ;Use floating point
	  z = fn1(pixel):
	  z = P1*fn2(z)^2 + P2*fn3(z)^2 + pixel, |z| <= 4
   }

   JMask = {      
	  z = fn1(pixel):
	  z = P1*fn2(z)^2 + P2, |z| <= 4
   }

   PseudoZeePi = {
	  z = pixel:
	  x = 1-z^p1;
	  z = z*((1-x)/(1+x))^(1/p1) + p2, |z| <= 4
   }

   ZeePi = {; This Julia function is based upon Ramanujan's iterative
	  ; function for calculating pi
	  z = pixel:
	  x = (1-z^p1)^(1/p1);
	  z = z*(1-x)/(1+x) + p2, |z| <= 4
   }

   IkeNewtMand = {
   z = c = pixel:
   zf = z*z*z + (c-1)*z - c;
   zd = 3*z*z + c-1;
   z = z - p1*zf/zd, 0.001 <= |zf|
   }

   IkeNewtJul = {
   z =  pixel:
   zf = z*z*z + (p2-1)*z - p2;
   zd = 3*z*z + p2-1;
   z = z - p1*zf/zd, 0.001 <= |zf|
   }

   RecipIke = {
   z = pixel:
   z = 1/(z*z*z + (p1-1)*z - p1), |z| <= 4
   }

   Frame-RbtM(XAXIS) = {; from Mazes for the Mind by Pickover
   z = c = pixel:
   z = z*z*z/5 + z*z + c, |z| <= 100
   }

   Frame-RbtJ = {
   z = pixel:
   z = z*z*z/5 + z*z + p1, |z| <= 100
   }

 comment = { SKINNER.FRM }

 Zexpe (XAXIS) = {
	  s = exp(1.,0.), z = Pixel:
	  z = z ^ s + pixel, |z| <= 100
   }

 Zexpe2 (XAXIS) = {
	  s = exp(1.,0.), z = Pixel:
	  z = z ^ s + z ^ (s * pixel), |z| <= 100
   }

 Ze2 (XAXIS) = {
	  s1 = exp(1.,0.),
	  s = s1 * s1,
	  z = Pixel:
	  z = z ^ s + pixel, |z| <= 100
   }

 comment = {  s = log(-1.,0.) / (0.,1.)   is   (3.14159265358979, 0.0 }

 Exipi (XAXIS) = {
	  s = log(-1.,0.) / (0.,1.), z = Pixel:
	  z = z ^ s + pixel, |z| <= 100
   }

 comment { version 13.0:}
 LambdaLog(XAXIS) {
	  z = pixel, c = log(pixel):  
		 z = c * sqr(z) + pixel, 
	  |z| <= 4 
   }

 comment { version 15.1:}
 CGNewtonSinExp (XAXIS) {
		z=pixel:
		z1=exp(z);
		z2=sin(z)+z1-z;
		z=z-p1*z2/(cos(z)+z1), .0001 < |z2|
   }

 OldManowar (XAXIS) {
		   z0 = 0,
		   z1 = 0,
		 test = p1 + 3,
		   c = pixel :
			   z = z1*z1 + z0 + c;
			   z0 = z1;
			   z1 = z,  |z| < test }

 comment { version 15.1:}
 OldHalleySin (XYAXIS) {
		z=pixel:
		s=sin(z);
		c=cosxx(z);
		z=z-p1*(s/(c-(s*s)/(c+c))),
		0.0001 <= |s|
   }

 comment { version 15.1:}
 OldCGNewtonSinExp (XAXIS) {
		z=pixel:
		z1=exp(z);
		z2=sin(z)+z1-z;
		z=z-p1*z2/(cosxx(z)+z1), .0001 < |z2|
   }

 comment { version 15.1:}
 OldNewtonSinExp (XAXIS) {; Chris Green
  ; Newton's formula applied to sin(x)+exp(x)-1=0.
  ; Use floating point.
  z=pixel:
   z1=exp(z)
   z2=sin(z)+z1-1
   z=z-p1*z2/(cosxx(z)+z1),
	.0001 < |z2|
  }

 comment { some of the following are included here because
		   BAILOUT=3 is still not supported}

 ScottLPC(XAXIS) { z = pixel, TEST = (p1+3): z = log(z)+cosxx(z), |z|<TEST }

 ScottLPS(XAXIS) { z = pixel, TEST = (p1+3): z = log(z)+sin(z), |z|<TEST }

 ScottLTC(XAXIS) { z = pixel, TEST = (p1+3): z = log(z)*cosxx(z), |z|<TEST }

 ScottLTS(XAXIS) { z = pixel, TEST = (p1+3): z = log(z)*sin(z), |z|<TEST }

 ScottSIC(XYAXIS) { z = pixel, TEST = (p1+3): z = sqr(1/cosxx(z)), |z|<TEST }

 ScSkCosH(XYAXIS) { z = pixel, TEST = (p1+3): z = cosh(z) - sqr(z), |z|<TEST }

 ScSkLMS(XAXIS) { z = pixel, TEST = (p1+3): z = log(z) - sin(z), |z|<TEST }

 ScSkZCZZ(XYAXIS) { z = pixel, TEST = (p1+3): z = (z*cosxx(z)) - z, |z|<TEST }

comment {
This file includes the formulas required to support the file
RCLPAR.PAR.

In addition, I have included a number of additional formulas 
for your enjoyment <G>.

Ron Lewen
CIS: 76376,2567 

  }

RCL_Cosh (XAXIS) { ; Ron Lewen, 76376,2567
  ; Try corners=2.008874/-3.811126/-3.980167/3.779833/
  ; -3.811126/3.779833 to see Figure 9.7 (P. 123) in 
  ; Pickover's Computers, Pattern, Chaos and Beauty.
  ; Figures 9.9 - 9.13 can be found by zooming.
  ; Use floating point
  ;
  z=0:
	z=cosh(z) + pixel,
	  abs(z) < 40
  }

Mothra (XAXIS) { ; Ron Lewen, 76376,2567
  ; Remember Mothra, the giant Japanese-eating moth?
  ; Well... here he (she?) is as a fractal!
  ;
  z=pixel:
	z2=z*z
	z3=z2*z
	z4=z3*z
	a=z4*z + z3 + z + pixel
	b=z4 + z2 + pixel
	z=b*b/a,
	  |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_11 { ; Ron Lewen, 76376,2567
  ; A variation on the formula used to generate
  ; Figure 9.18 (p. 134) from Pickover's book.
  ; P1 sets the initial value for z.
  ; Try p1=.75, or p1=2, or just experiment!
  ;
  z=real(p1):
	z=z*pixel-pixel/sqr(z)
	z=flip(z),
	  abs(z) < 8
  }

RCL_10 { ; Ron Lewen, 76376,2567
  ;
  ;
  ;
  z=pixel:
	z=flip((z*z+pixel)/(pixel*pixel+z))
	  |z| <= 4
  }

{ Spectacular! }
   FractalFenderC(XAXIS_NOPARM) {z=p1,x=|z|:
	   (z=cosh(z)+pixel)*(1<x)+(z=z)*(x<=1),
	   z=sqr(z)+pixel,x=|z|,
	   x<=4 }

   SpecC(XAXIS_NOPARM) {z=p1,x=|z|:
	   (z=fn1(z)+pixel)*(1<x)+(z=z)*(x<=1),
	   z=fn2(z)+pixel,x=|z|,
	   x<=4 }

 Silverado(XAXIS) {; Rollo Silver
  ; Select p1 such that 0. <= p1 <= 1.
  z = Pixel, zz=z*z, zzz=zz*z, z = (1.-p1)*zz + (p1*zzz), test = (p2+4)*(p2+4): ;
   z = z + Pixel
   zsq = z*z
   zcu = zsq*z
   z = (1.-p1)*zsq + p1*zcu,
   |z| <= test
  }

 comment = { Moire Tetrated Log - Improper Bailout }

 TLog (XAXIS) = {
		z = c = log(pixel):
				z = c ^ z,
					z <= (p1 + 3)
		}

 comment = { Tetrated Hyperbolic Sine - Improper Bailout }

 TSinh (XAXIS) = {
		z = c = sinh(pixel):
				z = c ^ z,
					z <= (p1 + 3)
		}

 DrChaosbrot2(xyaxis)   { ;more phi

 z = c = pixel:
 z = sqr(z) + (((sqrt 5 + 1)/2)+c)
 |z| <= 4;
 }

phoenix_m { ; Mandelbrot stye map of the Phoenix curves
   z=x=y=nx=ny=x1=y1=x2=y2=0:
   x2 = sqr(x), y2 = sqr(y),
   x1 = x2 - y2 + real(pixel) + imag(pixel) * nx,
   y1 = 2 * x * y + imag(pixel) * ny,
   nx=x, ny=y, x=x1, y=y1, z=x + flip(y),
   |z| <= 4
   }

 ScottSIS(XYAXIS) { z = pixel, TEST = (p1+3): z = sqr(1/sin(z)), |z|<TEST }

M-SetInNewton(XAXIS) {; use float=yes
					  ; jon horner 100112,1700, 12 feb 93
  z = 0,  c = pixel,  cminusone = c-1:
  oldz = z,  nm = 3*c-2*z*cminusone, dn = 3*(3*z*z+cminusone),
  z = nm/dn+2*z/3,   |(z-oldz)|>=|0.01|
 }

;========================================================================
;Date:    Mon, 10 Feb 1992 13:10:12 EST
;From: "Bruno"
;Subject: MORE .par and .frm
;X-Topic: Entry #3185 of LISTS.FRAC-L
;To: "LISTS.FRAC-L.3185"
;
;Posted on 10 Feb 1992 at 12:24:22 by BrownVM Mailer (103837)
;
;MORE .par and .frm
;
;Date:         Mon, 10 Feb 1992 08:18:36 GMT
;Reply-To:     'FRACTAL' discussion list <FRAC-L@GITVM1.BITNET>
;From:         Rob den Braasem <rdb@KTIBV.UUCP>
;
;Here are a group of files with formulas derived from a book of Roger Stevens
;
;First the formmats file and then the par file.
;
;
;--------------------------------------------------------------------
;{
;  ADVANCE FRACTAL PROGRAMMING IN C
;  by Roger Stevens.
;
;  I changed them in a Julia and Mandelbrot type fractal generatoren.
;  The Graphical Gnome (rdb@ktibv)
;
;}
;
;{
;   JULIA TYPE FRACTALS
;}
;

J_TchebychevT2 {
   c = pixel, z = P1:
   z = c*(2*z*z-1),
   |z|<100
}

J_TchebychevT3 {   ;
   c = pixel, z = P1:
   z = c*z*(4*z*z-3),
   |z|<100
}

J_TchebychevT4 {
   c = pixel, z = P1:
   z = c*(z*z*(8*z*z+8)+1),
   |z|<100
}

J_TchebychevT5 {    ;
   c = pixel, z = P1:
   z = c*(z*(z*z*(16*z*z-20)+5)),
   |z|<100
}

J_TchebychevT6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(32*z*z-48)+18)-1),
   |z|<100
}

J_TchebychevT7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(64*z*z-112)+56)-7),
   |z|<100
}

J_TchebychevC2 {
   c = pixel, z = P1:
   z = c*(z*z-2),
   |z|<100
}

J_TchebychevC3 {   ;
   c = pixel, z = P1:
   z = c*z*(z*z-3),
   |z|<100
}

J_TchebychevC4 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z-4)+2),
   |z|<100
}

J_TchebychevC5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z-5)+5),
   |z|<100
}

J_TchebychevC6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(z*z-6)+9)-2),
   |z|<100
}

J_TchebychevC7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(z*z-7)+14)-7),
   |z|<100
}


J_TchebychevU2 {
   c = pixel, z = P1:
   z = c*(4*z*z-1),
   |z|<100
}

J_TchebychevU3 {   ;
   c = pixel, z = P1:
   z = c*z*(8*z*z-4),
   |z|<100
}

J_TchebychevU4 {
   c = pixel, z = P1:
   z = c*(z*z*(16*z*z-12)+1),
   |z|<100
}

J_TchebychevU5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(32*z*z-32)+6),
   |z|<100
}

J_TchebychevU6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(64*z*z-80)+24)-1),
   |z|<100
}

J_TchebychevU7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(128*z*z-192)+80)-8),
   |z|<100
}

J_TchebychevS2 {
   c = pixel, z = P1:
   z = c*(z*z-1),
   |z|<100
}

J_TchebychevS3 {   ;
   c = pixel, z = P1:
   z = c*z*(z*z-2),
   |z|<100
}

J_TchebychevS4 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z-3)+1),
   |z|<100
}

J_TchebychevS5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z-4)+3),
   |z|<100
}

J_TchebychevS6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(z*z-5)+6)-1),
   |z|<100
}

J_TchebychevS7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(z*z-6)+10)-4),
   |z|<100
}

J_Laguerre2 {
   c = pixel, z = P1:
   z = (z*(z - 4) +2 ) / 2 + c,
   |z| < 100

}

J_Laguerre3 {
   c = pixel, z = P1:
   z = (z*(z*(-z + 9) -18) + 6 ) / 6 + c,
   |z| < 100
}

J_Laguerre4 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z - 16)+ 72) - 96)+ 24 ) / 24 + c,
   |z| < 100
}

J_Laguerre5 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z * (-z +25) -200) +600) -600) + 120 ) / 120 + c,
   |z| < 100
}

J_Laguerre6 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z*(z*(z -36) +450) -2400) + 5400)-4320) + 720 ) / 720
+ c,
   |z| < 100
}

J_Lagandre2 {
   c = pixel, z = P1:
   z = (3 * z*z - 1) / 2 + c
   |z| < 100
}

J_Lagandre3 {
   c = pixel, z = P1:
   z = z * (5 * z*z - 3) / 2 + c
   |z| < 100
}

J_Lagandre4 {
   c = pixel, z = P1:
   z = (z*z*(35 * z*z - 30) + 3) / 8 + c
   |z| < 100
}

J_Lagandre5 {
   c = pixel, z = P1:
   z = z* (z*z*(63 * z*z - 70) + 15 ) / 8 + c
   |z| < 100
}

J_Lagandre6 {
   c = pixel, z = P1:
   z = (z*z*(z*z*(231 * z*z - 315)  + 105 ) - 5) / 16 + c
   |z| < 100
}

J_Lagandre7 {
   c = pixel, z = P1:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / 16 + c
   |z| < 100
}

{
 MANDELBROT TYPE FRACTALS
}

M_TchebychevT2 {
   c = P1, z = Pixel:
   z = c*(2*z*z-1),
   |z|<100
}

M_TchebychevT3 {   ;
   c = P1, z = Pixel:
   z = c*z*(4*z*z-3),
   |z|<100
}

M_TchebychevT4 {
   c = P1, z = Pixel:
   z = c*(z*z*(8*z*z+8)+1),
   |z|<100
}

M_TchebychevT5 {    ;
   c = P1, z = Pixel:
   z = c*(z*(z*z*(16*z*z-20)+5)),
   |z|<100
}

M_TchebychevT6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(32*z*z-48)+18)-1),
   |z|<100
}

M_TchebychevT7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(64*z*z-112)+56)-7),
   |z|<100
}

M_TchebychevC2 {
   c = P1, z = Pixel:
   z = c*(z*z-2),
   |z|<100
}

M_TchebychevC3 {   ;
   c = P1, z = Pixel:
   z = c*z*(z*z-3),
   |z|<100
}

M_TchebychevC4 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z-4)+2),
   |z|<100
}

M_TchebychevC5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z-5)+5),
   |z|<100
}

M_TchebychevC6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(z*z-6)+9)-2),
   |z|<100
}

M_TchebychevC7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(z*z-7)+14)-7),
   |z|<100
}


M_TchebychevU2 {
   c = P1, z = Pixel:
   z = c*(4*z*z-1),
   |z|<100
}

M_TchebychevU3 {   ;
   c = P1, z = Pixel:
   z = c*z*(8*z*z-4),
   |z|<100
}

M_TchebychevU4 {
   c = P1, z = Pixel:
   z = c*(z*z*(16*z*z-12)+1),
   |z|<100
}

M_TchebychevU5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(32*z*z-32)+6),
   |z|<100
}

M_TchebychevU6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(64*z*z-80)+24)-1),
   |z|<100
}

M_TchebychevU7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(128*z*z-192)+80)-8),
   |z|<100
}

M_TchebychevS2 {
   c = P1, z = Pixel:
   z = c*(z*z-1),
   |z|<100
}

M_TchebychevS3 {   ;
   c = P1, z = Pixel:
   z = c*z*(z*z-2),
   |z|<100
}

M_TchebychevS4 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z-3)+1),
   |z|<100
}

M_TchebychevS5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z-4)+3),
   |z|<100
}

M_TchebychevS6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(z*z-5)+6)-1),
   |z|<100
}

M_TchebychevS7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(z*z-6)+10)-4),
   |z|<100
}

M_Laguerre2 {
   c = P1, z = Pixel:
   z = (z*(z - 4) +2 ) / 2 + c,
   |z| < 100

}

M_Laguerre3 {
   c = P1, z = Pixel:
   z = (z*(z*(-z + 9) -18) + 6 ) / 6 + c,
   |z| < 100
}

M_Laguerre4 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z - 16)+ 72) - 96)+ 24 ) / 24 + c,
   |z| < 100
}

M_Laguerre5 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z * (-z +25) -200) +600) -600) + 120 ) / 120 + c,
   |z| < 100
}

M_Laguerre6 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z*(z*(z -36) +450) -2400) + 5400)-4320) + 720 ) / 720
+ c,
   |z| < 100
}

M_Lagandre2 {
   c = P1, z = Pixel:
   z = (3 * z*z - 1) / 2 + c
   |z| < 100
}

M_Lagandre3 {
   c = P1, z = Pixel:
   z = z * (5 * z*z - 3) / 2 + c
   |z| < 100
}

M_Lagandre4 {
   c = P1, z = Pixel:
   z = (z*z*(35 * z*z - 30) + 3) / 8 + c
   |z| < 100
}

M_Lagandre5 {
   c = P1, z = Pixel:
   z = z* (z*z*(63 * z*z - 70) + 15 ) / 8 + c
   |z| < 100
}

M_Lagandre6 {
   c = P1, z = Pixel:
   z = (z*z*(z*z*(231 * z*z - 315)  + 105 ) - 5) / 16 + c
   |z| < 100
}

M_Lagandre7 {
   c = P1, z = Pixel:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / 16 + c
   |z| < 100
}

test{
  z=pixel,c=p1:
   c = P1, z = Pixel:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / (16 * (z+c))
   |z| < 100
}
comment {
 FRACTINT.DOC has instructions for adding new formulas to this file.
 There are several hard-coded restrictions in the formula interpreter:

 1) The fractal name through the open curly bracket must be on a single line.
 2) There is a hard-coded limit of 200 formulas per formula file, only
    because of restrictions in the prompting routines.
 3) Formulas can containt at most 250 operations (references to variables and
    arithmetic); this is bigger than it sounds, no formula in the default
    fractint.frm uses even 100
 3) Comment blocks can be set up using dummy formulas with no formula name
    or with the special name "comment".

 The formulas at the beginning of this file are from Mark Peterson, who
 built this fractal interpreter feature.  The rest are grouped by contributor.
 (Scott Taylor sent many but they are no longer here - they've been
 incorporated as hard-coded types.  Lee Skinner also sent many which have
 now been hard-coded.)

 Note that the builtin "cos" function had a bug which was corrected in
 version 16.  To recreate an image from a formula which used cos before
 v16, change "cos" in the formula to "cosxx" which is a new function
 provided for backward compatibility with that bug.
 }

Mandelbrot(XAXIS) {; Mark Peterson
  ; Classical fractal showing LastSqr speedup
  z = Pixel, z = Sqr(z):  ; Start with z**2 to initialize LastSqr
   z = z + Pixel
   z = Sqr(z)
    LastSqr <= 4	  ; Use LastSqr instead of recalculating
  }

Dragon (ORIGIN) {; Mark Peterson
  z = Pixel:
   z = sqr(z) + (-0.74543, 0.2),
    |z| <= 4
  }

Daisy (ORIGIN) {; Mark Peterson
  z = pixel:
   z = z*z + (0.11031, -0.67037),
    |z| <= 4
  }

InvMandel (XAXIS) {; Mark Peterson
  c = z = 1 / pixel:
   z = sqr(z) + c;
    |z| <= 4
  }

DeltaLog(XAXIS) {; Mark Peterson
  z = pixel, c = log(pixel):
   z = sqr(z) + c,
    |z| <= 4
  }

Newton4(XYAXIS) {; Mark Peterson
  ; Note that floating-point is required to make this compute accurately
  z = pixel, Root = 1:
   z3 = z*z*z;
   z4 = z3 * z;
   z = (3 * z4 + Root) / (4 * z3);
    .004 <= |z4 - Root|
  }

comment {
   The following are from Chris Green:
   These fractals all use Newton's or Halley's formula for approximation
   of a function.  In all of these fractals, p1 real is the "relaxation
   coefficient". A value of 1 gives the conventional newton or halley
   iteration. Values <1 will generally produce less chaos than values >1.
   1-1.5 is probably a good range to try.  P1 imag is the imaginary component
   of the relaxation coefficient, and should be zero but maybe a small
   non-zero value will produce something interesting. Who knows?
   For more information on Halley maps, see "Computers, Pattern, Chaos,
   and Beauty" by Pickover.
   }

Halley (XYAXIS) {; Chris Green. Halley's formula applied to x^7-x=0.
  ; P1 real usually 1 to 1.5, P1 imag usually zero. Use floating point.
  ; Setting P1 to 1 creates the picture on page 277 of Pickover's book
  z=pixel:
   z5=z*z*z*z*z;
   z6=z*z5;
   z7=z*z6;
   z=z-p1*((z7-z)/ ((z6*7.0-1)-(z5*42.0)*(z7-z)/(z6*14.0-2))),
    0.0001 <= |z7-z|
  }

CGhalley (XYAXIS) {; Chris Green -- Halley's formula
  ; P1 real usually 1 to 1.5, P1 imag usually zero. Use floating point.
  z=(1,1):
   z5=z*z*z*z*z;
   z6=z*z5;
   z7=z*z6;
   z=z-p1*((z7-z-pixel)/ ((7.0*z6-1)-(42.0*z5)*(z7-z-pixel)/(14.0*z6-2))),
    0.0001 <= |z7-z-pixel|
  }

halleySin (XYAXIS) {; Chris Green. Halley's formula applied to sin(x)=0.
  ; Use floating point.
  ; P1 real = 0.1 will create the picture from page 281 of Pickover's book.
  z=pixel:
   s=sin(z), c=cos(z)
   z=z-p1*(s/(c-(s*s)/(c+c))),
    0.0001 <= |s|
  }

NewtonSinExp (XAXIS) {; Chris Green
  ; Newton's formula applied to sin(x)+exp(x)-1=0.
  ; Use floating point.
  z=pixel:
   z1=exp(z)
   z2=sin(z)+z1-1
   z=z-p1*z2/(cos(z)+z1),
    .0001 < |z2|
  }

CGNewton3 {; Chris Green -- A variation on newton iteration.
  ; The initial guess is fixed at (1,1), but the equation solved
  ; is different at each pixel ( x^3-pixel=0 is solved).
  ; Use floating point.
  ; Try P1=1.8.
  z=(1,1):
   z2=z*z;
   z3=z*z2;
   z=z-p1*(z3-pixel)/(3.0*z2),
    0.0001 < |z3-pixel|
  }

HyperMandel {; Chris Green.
  ; A four dimensional version of the mandelbrot set.
  ; Use P1 to select which two-dimensional plane of the
  ; four dimensional set you wish to examine.
  ; Use floating point.
  a=(0,0),b=(0,0):
   z=z+1
   anew=sqr(a)-sqr(b)+pixel
   b=2.0*a*b+p1
   a=anew,
    |a|+|b| <= 4
  }


MTet (XAXIS) {; Mandelbrot form 1 of the Tetration formula --Lee Skinner
  z = pixel:
   z = (pixel ^ z) + pixel,
    |z| <= (P1 + 3)
  }

AltMTet(XAXIS) {; Mandelbrot form 2 of the Tetration formula --Lee Skinner
  z = 0:
   z = (pixel ^ z) + pixel,
    |z| <= (P1 + 3)
  }

JTet (XAXIS) {; Julia form 1 of the Tetration formula --Lee Skinner
  z = pixel:
   z = (pixel ^ z) + P1,
    |z| <= (P2 + 3)
  }

AltJTet (XAXIS) {; Julia form 2 of the Tetration formula --Lee Skinner
  z = P1:
   z = (pixel ^ z) + P1,
    |z| <= (P2 + 3)
  }

Cubic (XYAXIS) {; Lee Skinner
  p = pixel, test = p1 + 3,
  t3 = 3*p, t2 = p*p,
  a = (t2 + 1)/t3, b = 2*a*a*a + (t2 - 2)/t3,
  aa3 = a*a*3, z = 0 - a :
   z = z*z*z - aa3*z + b,
    |z| < test
 }

{ The following are from Lee Skinner, have been partially generalized. }

Fzppfnre  {; Lee Skinner
  z = pixel, f = 1./(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnpo  {; Lee Skinner
  z = pixel, f = (pixel)^(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnsr  {; Lee Skinner
  z = pixel, f = (pixel)^.5:
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnta  {; Lee Skinner
  z = pixel, f = tan(pixel):
   z = fn1(z) + f,
    |z|<= 50
  }

Fzppfnct  {; Lee Skinner
  z = pixel, f = cos(pixel)/sin(pixel):
   z = fn1(z) + f,
    |z|<= 50
  }

Fzppfnse  {; Lee Skinner
  z = pixel, f = 1./sin(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfncs  {; Lee Skinner
  z = pixel, f = 1./cos(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnth  {; Lee Skinner
  z = pixel, f = tanh(pixel):
   z = fn1(z)+f,
    |z|<= 50
  }

Fzppfnht  {; Lee Skinner
  z = pixel, f = cosh(pixel)/sinh(pixel):
   z = fn1(z)+f,
    |z|<= 50
  }

Fzpfnseh  {; Lee Skinner
  z = pixel, f = 1./sinh(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzpfncoh  {; Lee Skinner
  z = pixel, f = 1./cosh(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }


{ The following resulted from a FRACTINT bug. Version 13 incorrectly
  calculated Spider (see above). We fixed the bug, and reverse-engineered
  what it was doing to Spider - so here is the old "spider" }

Wineglass(XAXIS) {; Pieter Branderhorst
  c = z = pixel:
   z = z * z + c
   c = (1+flip(imag(c))) * real(c) / 2 + z,
    |z| <= 4 }


{ The following is from Scott Taylor.
  Scott says they're "Dog" because the first one he looked at reminded him
  of a hot dog. This was originally several fractals, we have generalized it. }

FnDog(XYAXIS)  {; Scott Taylor
  z = Pixel, b = p1+2:
   z = fn1( z ) * pixel,
    |z| <= b
  }

Ent {; Scott Taylor
  ; Try params=.5/.75 and the first function as exp.
  ; Zoom in on the swirls around the middle.  There's a
  ; symmetrical area surrounded by an asymmetric area.
  z = Pixel, y = fn1(z), base = log(p1):
   z = y * log(z)/base,
    |z| <= 4
  }

Ent2 {; Scott Taylor
  ; try params=2/1, functions=cos/cosh, potential=255/355
  z = Pixel, y = fn1(z), base = log(p1):
   z = fn2( y * log(z) / base ),
    |z| <= 4
  }

{ From Kevin Lee: }

LeeMandel1(XYAXIS) {; Kevin Lee
  z=Pixel:
;; c=sqr(pixel)/z, c=z+c, z=sqr(z),  this line was an error in v16
   c=sqr(pixel)/z, c=z+c, z=sqr(c),
    |z|<4
  }

LeeMandel2(XYAXIS) {; Kevin Lee
  z=Pixel:
   c=sqr(pixel)/z, c=z+c, z=sqr(c*pixel),
    |z|<4
   }

LeeMandel3(XAXIS) {; Kevin Lee
  z=Pixel, c=Pixel-sqr(z):
   c=Pixel+c/z, z=c-z*pixel,
    |z|<4
  }

{ These are a few of the examples from the book,
  Fractal Creations, by Tim Wegner and Mark Peterson. }

MyFractal {; Fractal Creations example
  c = z = 1/pixel:
   z = sqr(z) + c;
    |z| <= 4
  }

Bogus1 {; Fractal Creations example
  z = 0; z = z + * 2,
   |z| <= 4 }

MandelTangent {; Fractal Creations example (revised for v.16)
  z = pixel:
   z = pixel * tan(z),
    |real(z)| < 32
  }

Mandel3 {; Fractal Creations example
  z = pixel, c = sin(z):
   z = (z*z) + c;
   z = z * 1/c;
    |z| <= 4;
   }

{ These are from: "AKA MrWizard W. LeRoy Davis;SM-ALC/HRUC"
		  davisl@sm-logdis1-aflc.af.mil
  The first 3 are variations of:
			   z
	   gamma(z) = (z/e) * sqrt(2*pi*z) * R	    }

Sterling(XAXIS) {; davisl
  z = Pixel:
   z = ((z/2.7182818)^z)/sqr(6.2831853*z),
    |z| <= 4
  }

Sterling2(XAXIS) {; davisl
  z = Pixel:
   z = ((z/2.7182818)^z)/sqr(6.2831853*z) + pixel,
    |z| <= 4
  }

Sterling3(XAXIS) {; davisl
  z = Pixel:
   z = ((z/2.7182818)^z)/sqr(6.2831853*z) - pixel,
    |z| <= 4
  }

PsudoMandel(XAXIS) {; davisl - try center=0,0/magnification=28
  z = Pixel:
   z = ((z/2.7182818)^z)*sqr(6.2831853*z) + pixel,
    |z| <= 4
  }

{ These are the original "Richard" types sent by Jm Richard-Collard. Their
  generalizations are tacked on to the end of the "Jm" list below, but
  we felt we should keep these around for historical reasons.}

Richard1 (XYAXIS) {; Jm Richard-Collard
  z = pixel:
   sq=z*z, z=(sq*sin(sq)+sq)+pixel,
    |z|<=50
  }

Richard2 (XYAXIS) {; Jm Richard-Collard
  z = pixel:
   z=1/(sin(z*z+pixel*pixel)),
    |z|<=50
  }

Richard3 (XAXIS) {; Jm Richard-Collard
  z = pixel:
   sh=sinh(z), z=(1/(sh*sh))+pixel,
    |z|<=50
  }

Richard4 (XAXIS) {; Jm Richard-Collard
  z = pixel:
   z2=z*z, z=(1/(z2*cos(z2)+z2))+pixel,
    |z|<=50
  }

Richard5 (XAXIS) {; Jm Richard-Collard
  z = pixel:
   z=sin(z*sinh(z))+pixel,
    |z|<=50
  }

Richard6 (XYAXIS) {; Jm Richard-Collard
  z = pixel:
   z=sin(sinh(z))+pixel,
    |z|<=50
  }

Richard7 (XAXIS) {; Jm Richard-Collard
  z=pixel:
   z=log(z)*pixel,
    |z|<=50
  }

Richard8 (XYAXIS) {; Jm Richard-Collard
  ; This was used for the "Fractal Creations" cover
  z=pixel,sinp = sin(pixel):
   z=sin(z)+sinp,
    |z|<=50
  }

Richard9 (XAXIS) {; Jm Richard-Collard
  z=pixel:
   sqrz=z*z, z=sqrz + 1/sqrz + pixel,
    |z|<=4
  }

Richard10(XYAXIS) {; Jm Richard-Collard
  z=pixel:
   z=1/sin(1/(z*z)),
    |z|<=50
  }

Richard11(XYAXIS) {; Jm Richard-Collard
  z=pixel:
   z=1/sinh(1/(z*z)),
    |z|<=50
  }

{ These types are generalizations of types sent to us by the French
  mathematician Jm Richard-Collard. If we hadn't generalized them
  there would be --ahhh-- quite a few. With 11 possible values for
  each fn variable,Jm_03, for example, has 14641 variations! }

Jm_01 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=(fn1(fn2(z^pixel)))*pixel,
    |z|<=t
  }

Jm_02 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=(z^pixel)*fn1(z^pixel),
    |z|<=t
  }

Jm_03 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1((fn2(z)*pixel)*fn3(fn4(z)*pixel))*pixel,
    |z|<=t
  }

Jm_03a {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1((fn2(z)*pixel)*fn3(fn4(z)*pixel))+pixel,
    |z|<=t
  }

Jm_04 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1((fn2(z)*pixel)*fn3(fn4(z)*pixel)),
    |z|<=t
  }

Jm_05 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2((z^pixel))),
    |z|<=t
  }

Jm_06 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3((z^z)*pixel))),
    |z|<=t
  }

Jm_07 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3((z^z)*pixel)))*pixel,
    |z|<=t
  }

Jm_08 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3((z^z)*pixel)))+pixel,
    |z|<=t
  }

Jm_09 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(fn4(z))))+pixel,
    |z|<=t
  }

Jm_10 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(fn4(z)*pixel))),
    |z|<=t
  }

Jm_11 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(fn4(z)*pixel)))*pixel,
    |z|<=t
  }

Jm_11a {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(fn4(z)*pixel)))+pixel,
    |z|<=t
  }

Jm_12 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)*pixel)),
    |z|<=t
  }

Jm_13 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)*pixel))*pixel,
    |z|<=t
  }

Jm_14 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)*pixel))+pixel,
    |z|<=t
  }

Jm_15 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   f2=fn2(z),z=fn1(f2)*fn3(fn4(f2))*pixel,
    |z|<=t
  }

Jm_16 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   f2=fn2(z),z=fn1(f2)*fn3(fn4(f2))+pixel,
    |z|<=t
  }

Jm_17 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z)*pixel*fn2(fn3(z)),
    |z|<=t
  }

Jm_18 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z)*pixel*fn2(fn3(z)*pixel),
    |z|<=t
  }

Jm_19 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z)*pixel*fn2(fn3(z)+pixel),
    |z|<=t
  }

Jm_20 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z^pixel),
    |z|<=t
  }

Jm_21 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z^pixel)*pixel,
    |z|<=t
  }

Jm_22 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   sq=fn1(z), z=(sq*fn2(sq)+sq)+pixel,
    |z|<=t
  }

Jm_23 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)+pixel*pixel)),
    |z|<=t
  }

Jm_24 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z2=fn1(z), z=(fn2(z2*fn3(z2)+z2))+pixel,
    |z|<=t
  }

Jm_25 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(z*fn2(z)) + pixel,
    |z|<=t
  }

Jm_26 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   z=fn1(fn2(z)) + pixel,
    |z|<=t
  }

Jm_27 {; generalized Jm Richard-Collard type
  z=pixel,t=p1+4:
   sqrz=fn1(z), z=sqrz + 1/sqrz + pixel,
    |z|<=t
  }

Jm_ducks(XAXIS) {; Jm Richard-Collard
  ; Not so ugly at first glance and lot of corners to zoom in.
  ; try this: corners=-1.178372/-0.978384/-0.751678/-0.601683
  z=pixel,tst=p1+4,t=1+pixel:
   z=sqr(z)+t,
    |z|<=tst
  }

Gamma(XAXIS)={ ; first order gamma function from Prof. Jm
  ; "It's pretty long to generate even on a 486-33 comp but there's a lot
  ; of corners to zoom in and zoom and zoom...beautiful pictures :)"
  z=pixel,twopi=6.283185307179586,r=10:
   z=(twopi*z)^(0.5)*(z^z)*exp(-z)+pixel
    |z|<=r
  }

ZZ(XAXIS) { ; Prof Jm using Newton-Raphson method
  ; use floating point with this one
  z=pixel,solution=1:
   z1=z^z;
   z2=(log(z)+1)*z1;
   z=z-(z1-1)/z2 ,
    0.001 <= |solution-z1|
  }

ZZa(XAXIS) { ; Prof Jm using Newton-Raphson method
  ; use floating point with this one
  z=pixel,solution=1:
   z1=z^(z-1);
   z2=(((z-1)/z)+log(z))*z1;
   z=z-((z1-1)/z2) ,
    .001 <= |solution-z1|
  }

a--mand { ;; eli.frm
  z = c = pixel:
   z = (sqr(z)+c) / |c|
    |z|<p1
}

a---mand { ;; eli.frm
  z = c = pixel:
   z = z^c + sin(c)
    |z|<p1
}

A1 (XAXIS) {  ;; a1.frm
    z = Pixel:
    z = ((2*(z*z*z))-(3*(z*z))+1)^p1
    z = z+Pixel
    z = Sqr(z) * (p1)
    |z| <= 4;
}

aa-c-to-z (XAXIS)  { ;; eli.frm
  z = pixel, c = z:
   z = c^z;
    |z| <= p1
}


aa-diamand { ;; eli.frm
  z = c = pixel:
   z = sqr(z)+c;
    (real(z)+imag(z))<p1
}

aa-mand-im (XAXIS) { ;; eli.frm
  z = c = pixel:
   z = sqr(z)+c;
    imag(z)<p1
}

aa-mand-re (XAXIS) { ;; eli.frm
  z = c = pixel:
   z = sqr(z)+c;
    real(z)<p1
}

aa-z-to-c (XAXIS)  { ;; eli.frm
  z = pixel, c = z:
   z = exp(c*log(z));
    |z| <= p1
}

aa-z-to-z (XAXIS)  { ;; eli.frm
  z = pixel, c = z:
   z = exp(z*log(z));
    |z| <= p1
}
aaa-deals { ;; eli.frm
  z = pixel, a=real(z), b=imag(z), i=((0-1)^0.5):
   x = real(z)
   y = imag(z)
   u = x*x + y*y + a
   v = (0-2)*x*y + b
   z = u + v*i;
    |z|<p1
}

aaa { ;; dan.frm
    z = pixel, c = z:
    z = sqr(c);
    |z|<p1
}

aaaa (XAXIS)  { ;; dan.frm
    z = pixel, c = z:
    z = exp(z*log(z));
    |z| <= p1
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

BirdOfPrey (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(z=cos(z)+pixel),
    x=x+1, |z|<=4
}

BirdOfPreyC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=cos(z)+pixel)*(10<=x),
    x=x+1, |z|<=4
}

bizarre    { ;; bizarre.frm
        (x<10)*(z=sqr(z)+pixel),
        (10<=x)*(x<20)*(z=exp(z)+pixel),
        (20<=x)*(z=log(z)+pixel),
        x=x+1, |z|<=4
        }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

DeepSpaceProbe (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(x<20)*(z=sin(z)+pixel),
    (20<=x)*(z=cos(z)+pixel),
    x=x+1, |z|<=4
}

DeepSpaceProbeTwo (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(x<20)*(z=exp(z)+pixel),
    (20<=x)*(z=cos(z)+pixel),
    x=x+1, |z|<=4
}

DeepSpaceProbeTwoC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=exp(z)+pixel)*(10<=x)*(x<20)+(z=cos(z)+pixel)*(20<=x),
    x=x+1, |z|<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

;; DeepSpaceProbeC demonstrates a more complicated IF-THEN-ELSE structure
;;    if x<10 then z=sqr(z)+pixel
;;    else if x<20 then z=sin(z)+pixel
;;    else z=cos(z)+pixel

;; Verified with Testpt.c version

DeepSpaceProbeC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=sin(z)+pixel)*(10<=x)*(x<20)+(z=cos(z)+pixel)*(20<=x),
    x=x+1, |z|<=4
}

dots { ;; eli.frm
  z = c = pixel:
   z = z^c + c
    |z|<p1
}

DrChaosbrot1 (xaxis) { ;; drcha.frm, based on phi
    z = c = pixel:
    z = sqr(z) + (((sqrt 5 + 1)/2)+c)
    |z| <= 4;
}


DrChaosbrot2 (xyaxis) { ;; drcha.frm, based on phi
    z = c = pixel:
    z = sqr(z) + (((sqrt 5 + 1)/2)+c)
    |z| <= 4;
}

Element (xyaxis) { ;; drcha.frm, phi lingam
    z = pixel:
    z = z*z*z*z + ((sqrt 5 + 1)/2)
    |z| <= 4;
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

;; EvilEyeC demonstrates an IF-THEN-ELSE structure.
;;    if |z|<1 then z=sin(z)+pixel
;;    else z=cos(z)+pixel

;; Verified with Testpt.c version

EvilEyeC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sin(z)+pixel)*(1<x)+(z=cos(z)+pixel)*(x<=1),
    x=|z|, x<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

Eyeball (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(z=sinh(z)+pixel),
    x=x+1, |z|<=4
}

EyeballC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=sinh(z)+pixel)*(10<=x),
    x=x+1, |z|<=4
}

;; {=======================================================================}
;; {      File originally distributed with FRAC'Cetera Vol 2 Iss 6         }
;; {=======================================================================
;; =  From GRAPHDEV Fractal Sources forum messages - Dec-92.                =
;; =  Chaotic Liars   Author: Chuck Ebbert        CIS: 76306,1226           =
;; =  F'names,  where present,  are  FRAC'Cetera  created variations or     =
;; =  derivatives based, sometimes quite loosely, on the author's originals =
;; ========================================================================}

;; { Chaotic Liar formulas for FRACTINT, from Liar.FRM
;;
;;    These formulas reproduce some of the pictures in the paper 'Pattern
;; and Chaos: New Images in the Semantics of Paradox' by Gary Mar and
;; Patrick Grim of the Department of Philosophy, SUNY at Stony Brook.
;;
;;    "...what is being graphed within the unit square is simply
;; information regarding the semantic behavior for different inputs of a
;; pair of English sentences:"
;;
;; Fm: Dan Farmer 70703,1632
;;
;;    I tried out the Chaotic Liar formulas.  Interesting.
;; Liar1 is rather dull, Liar2 gets better, and Liar3 is really
;; interesting.  But, best of all, run Liar3 with Sound = z and
;; floating point OFF.  Press "O" for orbits. Great sound and a
;; really different orbits display. I did discover that these
;; types require floating point math.  I get either black
;; screen or totally different results with integer math
;;
;; !_Press_F2_!     {; There is text in this formula file.  Shell to DOS
;;                  ; with <d> key and use a text reader to browse file
;;                   }

F'Liar1 { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = pixel:
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) );
    fn1(abs(z))<p1 }

F'Liar1A { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = fn1(pixel):
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) );
    |z| <= p1 }

F'Liar1C { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = fn1(pixel):
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) );
    fn2(abs(z))<p1 }

F'Liar1D { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = fn1(pixel):
   z = p1 - abs(imag(z)-real(z) ) + flip(p2 - abs(1-real(z)-imag(z) ) );
    |z| <1 }

flip0_man_j (ORIGIN) { ;; flip.frm
   z=pixel:
   z = flip(sqr(z) + p1),
   |z| <= 4
   }

flip0_man_m (XAXIS) { ;; flip.frm
   z=0:
   z = flip(sqr(z) + pixel),
   |z| <= 4
   }

flip1_man_j (ORIGIN) { ;; flip.frm
   z=pixel, q = p1:
   q = flip(q),
   z = sqr(z) + q,
   |z| <= 4
   }

flip1_man_m { ;; flip.frm
   z=0, q = pixel:
   q = flip(q),
   z = sqr(z) + q,
   |z| <= 4
   }

flip2_man_j (ORIGIN) { ;; flip.frm
   z=pixel, q = p1:
   q = flip(q),
   z = flip(sqr(z) + q),
   |z| <= 4
   }

flip2_man_m { ;; flip.frm
   z=0, q = pixel:
   q = flip(q),
   z = flip(sqr(z) + q),
   |z| <= 4
   }

flip3_man_j { ;; flip.frm
   z = pixel:
   z = 1/flip(sqr(z) + p1),
   |z| <= 4
   }

flip3_man_m (XAXIS) { ;; flip.frm
   z = 0:
   z = 1/flip(sqr(z) + pixel),
   |z| <= 4
   }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

Fly (XAXIS_NOPARM) {
    z=p1:
    x=real(z),
    (x<0)*(z=sqr(z)+pixel),
    (0<=x)*(z=sqr(z)-pixel),
    |z|<=4
}

FlyC (XAXIS_NOPARM) {
    z=p1:
    x=real(z),
    (z=sqr(z)+pixel)*(x<0)+(z=sqr(z)-pixel)*(0<=x),
    |z|<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

FlyingSquirrel (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (1<x)*(z=sin(z)/cos(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

FlyingSquirrelC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sin(z)/cos(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

FnxZpZ  { ;; ebbert.frm
  ; Duplicate of built-in 'fn*z+z' type.
  ; p1, p2 same as built-in
  z = pixel:
   z = (p1 * fn1(z) + p2 ) * z,
    |z| <= 64
 }

FnZpFnPix { ;; ebbert.frm
  ; Duplicate of built-in type 'fn(z)+fn(pix).'
  ; P1 = perturbation of z(0), p2 = multiplication factor.
  z = pixel + p1, c = p2 * fn2(pixel):
   z = fn1(z) + c,
    |z| <= 64
 }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

FractalFender (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (1<x)*(z=cosh(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

FractalFenderC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=cosh(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

FractalFenderTwo (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (1<x)*(z=cos(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

FractalFenderTwoC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=cos(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

Frog (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (1<x)*(z=sinh(z)/cosh(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

FrogC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sinh(z)/cosh(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

;;
;; Lee.FRM, Lee2.FRM
;;
;; The following are from Lee Skinner, have been partially generalized
;;

Fzpcocoh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = 1. / cosh(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopch  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (cosh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopcs  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (1. / cosxx(pixel) ):
                        z = cosxx (z)  + f, |z| <= 50}

Fzpcopct  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (cosxx(pixel) / sin(pixel) ):
                        z = cosxx (z)  + f, |z|<= 50}

Fzpcophc  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (1. / cosh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcophs  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (1. / sinh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopht  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (cosh(pixel) / sinh(pixel) ):
                       z = cosxx (z)+f,|z|<= 50}

Fzpcopse  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (1. / sin(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopsh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (sinh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopsq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (sqr(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpcopta  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (sin(pixel) / cosxx(pixel) ):
                        z = cosxx (z)  + f, |z|<= 50}

Fzpcopth  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (sinh(pixel) / cosh(pixel) ):
                        z = cosxx (z)+f,|z|<= 50}

Fzpcoseh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = 1. / sinh(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzpfncoh  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = 1./cosh(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzpfnseh  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = 1./sinh(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppchco  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppchex  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = exp (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppchlo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = log (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppchsh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppchsi  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppchsq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sqr (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppcoch  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcocs  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = 1. / cosxx(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcoct  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx(pixel) / sin(pixel):
                       z = cosxx (z)  + f, |z|<= 50}

Fzppcoex  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = exp (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcohs  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcoht  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh(pixel) / sinh(pixel):
                       z = cosxx (z)+f,|z|<= 50}

Fzppcolo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = log (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcopc  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (cosxx(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcope  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (exp(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcopl  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (log(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcopo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = (pixel) ^ (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcopr  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (1. / pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcops  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = pixel ^ (sin(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcore  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = 1. / (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcos   { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcose  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = 1. / sin(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcosh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh (pixel):
                       z = cosh (z) + f, |z| <= 50}

Fzppcosi  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcosq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sqr (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcosr  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = (pixel) ^ 0.5:
                       z = cosxx (z)  + f, |z| <= 50}

Fzppcota  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin(pixel) / cosxx(pixel):
                       z = cosxx (z)  + f, |z|<= 50}

Fzppcoth  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh(pixel) / cosh(pixel):
                       z = cosxx (z)+f,|z|<= 50}

Fzppexch  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexco  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexlo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = log (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexp   { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = exp (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexsh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexsi  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppexsq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sqr (pixel):
                       z = exp (z)  + f, |z| <= 50}

Fzppfncs  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = 1./cos(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnct  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = cos(pixel)/sin(pixel):
   z = fn1(z) + f,
    |z|<= 50
  }

Fzppfnht  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = cosh(pixel)/sinh(pixel):
   z = fn1(z)+f,
    |z|<= 50
  }

Fzppfnpo  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = (pixel)^(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnre  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = 1./(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnse  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = 1./sin(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnsr  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = (pixel)^.5:
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnta  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = tan(pixel):
   z = fn1(z) + f,
    |z|<= 50
  }

Fzppfnth  { ;; Lee.FRM (Lee Skinner)
  z = pixel, f = tanh(pixel):
   z = fn1(z)+f,
    |z|<= 50
  }

Fzppshch  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppshco  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppshex  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = exp (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppshlo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = log (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppshsi  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppshsq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sqr (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppsich  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosh (pixel):
                       z = sin (z)  + f, |z| <= 50}

Fzppsico  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = sin (z)  + f, |z| <= 50}

Fzppsiex  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = exp (pixel):
                       z = sin (z)  + f, |z| <= 50}

Fzppsinh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = sinh (z) + f, |z| <= 50}

Fzppsish  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = sin (z)  + f, |z| <= 50}

Fzppsisq  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sqr (pixel):
                       z = sin (z)  + f, |z| <= 50}

Fzppsqlo  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = log (pixel):
                       z = sqr (z)  + f, |z| <= 50}

Fzppsqsh  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sinh (pixel):
                       z = sqr (z)  + f, |z| <= 50}

Fzppsqsi  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = sin (pixel):
                       z = sqr (z)  + f, |z| <= 50}

Gen_01 { ;; ebbert.frm
  ; generalized type
  ; p1=p2=0, fn1=fn2=fn3=ident, fn4=sqr gives Mandelbrot
  z=pixel, t=p1+4, q = (p2+1) * fn1(pixel):
   z=fn2(fn3(fn4(z))) + q,
    |z|<=t
  }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

IslandOfChaos (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(z=sin(z)/cos(z)+pixel),
    x=x+1, |z|<=4
}

IslandOfChaosC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=sin(z)/cos(z)+pixel)*(10<=x),
    x=x+1, |z|<=4
}

;;; tchebych.frm
;;;   JULIA TYPE FRACTALS
;;;

J_TchebychevC2 {
   c = pixel, z = P1:
   z = c*(z*z-2),
   |z|<100
}

J_TchebychevC3 {   ;
   c = pixel, z = P1:
   z = c*z*(z*z-3),
   |z|<100
}

J_TchebychevC4 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z-4)+2),
   |z|<100
}

J_TchebychevC5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z-5)+5),
   |z|<100
}

J_TchebychevC6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(z*z-6)+9)-2),
   |z|<100
}

J_TchebychevC7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(z*z-7)+14)-7),
   |z|<100
}

J_TchebychevS2 {
   c = pixel, z = P1:
   z = c*(z*z-1),
   |z|<100
}

J_TchebychevS3 {   ;
   c = pixel, z = P1:
   z = c*z*(z*z-2),
   |z|<100
}

J_TchebychevS4 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z-3)+1),
   |z|<100
}

J_TchebychevS5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z-4)+3),
   |z|<100
}

J_TchebychevS6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(z*z-5)+6)-1),
   |z|<100
}

J_TchebychevS7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(z*z-6)+10)-4),
   |z|<100
}

J_TchebychevT2 {
   c = pixel, z = P1:
   z = c*(2*z*z-1),
   |z|<100
}

J_TchebychevT3 {   ;
   c = pixel, z = P1:
   z = c*z*(4*z*z-3),
   |z|<100
}

J_TchebychevT4 {
   c = pixel, z = P1:
   z = c*(z*z*(8*z*z+8)+1),
   |z|<100
}

J_TchebychevT5 {    ;
   c = pixel, z = P1:
   z = c*(z*(z*z*(16*z*z-20)+5)),
   |z|<100
}

J_TchebychevT6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(32*z*z-48)+18)-1),
   |z|<100
}

J_TchebychevT7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(64*z*z-112)+56)-7),
   |z|<100
}

J_TchebychevU2 {
   c = pixel, z = P1:
   z = c*(4*z*z-1),
   |z|<100
}

J_TchebychevU3 {   ;
   c = pixel, z = P1:
   z = c*z*(8*z*z-4),
   |z|<100
}

J_TchebychevU4 {
   c = pixel, z = P1:
   z = c*(z*z*(16*z*z-12)+1),
   |z|<100
}

J_TchebychevU5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(32*z*z-32)+6),
   |z|<100
}

J_TchebychevU6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(64*z*z-80)+24)-1),
   |z|<100
}

J_TchebychevU7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(128*z*z-192)+80)-8),
   |z|<100
}

J_Lagandre2 {
   c = pixel, z = P1:
   z = (3 * z*z - 1) / 2 + c
   |z| < 100
}

J_Lagandre3 {
   c = pixel, z = P1:
   z = z * (5 * z*z - 3) / 2 + c
   |z| < 100
}

J_Lagandre4 {
   c = pixel, z = P1:
   z = (z*z*(35 * z*z - 30) + 3) / 8 + c
   |z| < 100
}

J_Lagandre5 {
   c = pixel, z = P1:
   z = z* (z*z*(63 * z*z - 70) + 15 ) / 8 + c
   |z| < 100
}

J_Lagandre6 {
   c = pixel, z = P1:
   z = (z*z*(z*z*(231 * z*z - 315)  + 105 ) - 5) / 16 + c
   |z| < 100
}

J_Lagandre7 {
   c = pixel, z = P1:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / 16 + c
   |z| < 100
}

J_Laguerre2 {
   c = pixel, z = P1:
   z = (z*(z - 4) +2 ) / 2 + c,
   |z| < 100

}

J_Laguerre3 {
   c = pixel, z = P1:
   z = (z*(z*(-z + 9) -18) + 6 ) / 6 + c,
   |z| < 100
}

J_Laguerre4 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z - 16)+ 72) - 96)+ 24 ) / 24 + c,
   |z| < 100
}

J_Laguerre5 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z * (-z +25) -200) +600) -600) + 120 ) / 120 + c,
   |z| < 100
}

J_Laguerre6 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z*(z*(z -36) +450) -2400) + 5400)-4320) + 720 ) / 720 + c,
   |z| < 100
}

j1 { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2,
	|z| <= 4
	}

jc { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*c,
	|z| <= 4
	}

jfnc { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*fn1(c),
	|z| <= 4
	}

jfnz { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*fn1(z),
	|z| <= 4
	}

joc { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2/c,
	|z| <= 4
	}

joz { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2/z,
	|z| <= 4
	}

jz { ;; explode.frm
	z=pixel, c=p1:
	z=sqr(z)+c,
	c=c+p2*z,
	|z| <= 4
	}

LambdaFnOrFn { ;; Ebbert.frm
   ; Duplicate of built-in 'lambda(fn||fn).'
   ; P1 = lambda, real(p2) changes shift value from default of 1,
   ;  imag(p2) changes bailout from default of 64.
  z = pixel, modz = |z|, b = imag(p2) + 64, t = real(p2) + 1:
   z = ( fn1(z) * (modz<t) + fn2(z) * (real(t)<=modz ) ) * p1,
   modz = |z|,
    modz <= b
 }

Leeze (XAXIS) = { ;; Lee2.FRM (Lee Skinner)
       s = exp(1.,0.), z = Pixel, f = Pixel ^ s:
                       z = cosxx (z) + f, |z| <= 50 }

;;
;;      ;    #: 7363 S4/Fractal Sources
        ;    08-Dec-92 18:46:48
        ;    Sb: #Chaotic Liars
        ;    Fm: Chuck Ebbert 76306,1226
        ;    To: All
        ; Chaotic Liar formulas for FRACTINT.
        ; These formulas reproduce some of the pictures in the paper
        ;  'Pattern and Chaos: New Images in the Semantics of Paradox'
        ;  by Gary Mar and Patrick Grim of the Department of Philosophy,
        ;  SUNY at Stony Brook.

        ; Formulas by Chuck Ebbert  CIS [76306,1226], from Liar.FRM
        ; "...what is being graphed within the unit square is simply
        ;  information regarding the semantic behavior for different
        ;  inputs of a pair of English sentences:"
        ; }

Liar1 { ; by Chuck Ebbert.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
   z = pixel:
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) )
  |z| <= 1 ;
 }

Liar2 { ; by Chuck Ebbert.
        ; Same as Liar1 but use sequential reasoning, calculating
        ;  new y value using new x value.
        ; x(n+1) = 1 - abs(y(n)-x(n) );
        ; y(n+1) = 1 - abs((1-x(n+1) )-y(n) );
   z = pixel:
   x = 1 - abs(imag(z)-real(z))
   z = flip(1 - abs(1-real(x)-imag(z) ) ) + real(x)
  |z| <= 1;
 }

Liar3 { ; by Chuck Ebbert.
        ; X: X is true to P1 times the extent that Y is true
        ; Y: Y is true to the extent that X is false.
        ; Sequential reasoning.  P1 usually 0 to 1.  P1=1 is Liar2 formula.
        ; x(n+1) = 1 - abs(p1*y(n)-x(n) );
        ; y(n+1) = 1 - abs((1-x(n+1) )-y(n) );
   z = pixel:
   x = 1 - abs(imag(z)*real(p1)-real(z) )
   z = flip(1 - abs(1-real(x)-imag(z) ) ) + real(x)
  |z| <= 1;
}

Liar4 { ; by Chuck Ebbert.
        ; X: X is as true as (p1+1) times Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; Real part of p1 changes probability.  Use floating point.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = pixel, p = p1 + 1:
   z = 1-abs(imag(z)*p-real(z))+flip(1-abs(1-real(z)-imag(z)));
    |z| <= 1
    }

;;; tchebych.frm
;;;   MANDELBROT TYPE FRACTALS
;;;

M_Lagandre2 {
   c = P1, z = Pixel:
   z = (3 * z*z - 1) / 2 + c
   |z| < 100
}

M_Lagandre3 {
   c = P1, z = Pixel:
   z = z * (5 * z*z - 3) / 2 + c
   |z| < 100
}

M_Lagandre4 {
   c = P1, z = Pixel:
   z = (z*z*(35 * z*z - 30) + 3) / 8 + c
   |z| < 100
}

M_Lagandre5 {
   c = P1, z = Pixel:
   z = z* (z*z*(63 * z*z - 70) + 15 ) / 8 + c
   |z| < 100
}

M_Lagandre6 {
   c = P1, z = Pixel:
   z = (z*z*(z*z*(231 * z*z - 315)  + 105 ) - 5) / 16 + c
   |z| < 100
}

M_Lagandre7 {
   c = P1, z = Pixel:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / 16 + c
   |z| < 100
}

M_Laguerre2 {
   c = P1, z = Pixel:
   z = (z*(z - 4) +2 ) / 2 + c,
   |z| < 100

}

M_Laguerre3 {
   c = P1, z = Pixel:
   z = (z*(z*(-z + 9) -18) + 6 ) / 6 + c,
   |z| < 100
}

M_Laguerre4 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z - 16)+ 72) - 96)+ 24 ) / 24 + c,
   |z| < 100
}

M_Laguerre5 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z * (-z +25) -200) +600) -600) + 120 ) / 120 + c,
   |z| < 100
}

M_Laguerre6 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z*(z*(z -36) +450) -2400) + 5400)-4320) + 720 ) / 720 + c,
   |z| < 100
}

M_TchebychevC2 {
   c = P1, z = Pixel:
   z = c*(z*z-2),
   |z|<100
}

M_TchebychevC3 {   ;
   c = P1, z = Pixel:
   z = c*z*(z*z-3),
   |z|<100
}

M_TchebychevC4 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z-4)+2),
   |z|<100
}

M_TchebychevC5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z-5)+5),
   |z|<100
}

M_TchebychevC6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(z*z-6)+9)-2),
   |z|<100
}

M_TchebychevC7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(z*z-7)+14)-7),
   |z|<100
}

M_TchebychevS2 {
   c = P1, z = Pixel:
   z = c*(z*z-1),
   |z|<100
}

M_TchebychevS3 {   ;
   c = P1, z = Pixel:
   z = c*z*(z*z-2),
   |z|<100
}

M_TchebychevS4 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z-3)+1),
   |z|<100
}

M_TchebychevS5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z-4)+3),
   |z|<100
}

M_TchebychevS6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(z*z-5)+6)-1),
   |z|<100
}

M_TchebychevS7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(z*z-6)+10)-4),
   |z|<100
}

M_TchebychevT2 {
   c = P1, z = Pixel:
   z = c*(2*z*z-1),
   |z|<100
}

M_TchebychevT3 {   ;
   c = P1, z = Pixel:
   z = c*z*(4*z*z-3),
   |z|<100
}

M_TchebychevT4 {
   c = P1, z = Pixel:
   z = c*(z*z*(8*z*z+8)+1),
   |z|<100
}

M_TchebychevT5 {    ;
   c = P1, z = Pixel:
   z = c*(z*(z*z*(16*z*z-20)+5)),
   |z|<100
}

M_TchebychevT6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(32*z*z-48)+18)-1),
   |z|<100
}

M_TchebychevT7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(64*z*z-112)+56)-7),
   |z|<100
}

M_TchebychevU2 {
   c = P1, z = Pixel:
   z = c*(4*z*z-1),
   |z|<100
}

M_TchebychevU3 {   ;
   c = P1, z = Pixel:
   z = c*z*(8*z*z-4),
   |z|<100
}

M_TchebychevU4 {
   c = P1, z = Pixel:
   z = c*(z*z*(16*z*z-12)+1),
   |z|<100
}

M_TchebychevU5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(32*z*z-32)+6),
   |z|<100
}

M_TchebychevU6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(64*z*z-80)+24)-1),
   |z|<100
}

M_TchebychevU7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(128*z*z-192)+80)-8),
   |z|<100
}

m1 { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1,
	|z| <= 4
	}

Magnet1M (XAXIS) { ;; ebbert.frm
  ; Duplicate of built-in type.
  ; P1 = initial perturbation of z(0).
  z = p1, cm1 = pixel - 1, cm2 = cm1 - 1:
   z = sqr( (z*z+cm1 ) / (z+z+cm2 ) );
    |z-1| > .000030517578 && |z| <= 100;
 }

Magnet2M (XAXIS) { ;; ebbert.frm
  ; Duplicate of built-in type.
  ; P1 = initial perturbation of z(0).
  z=p1,c1=pixel-1,c1x3=c1*3,c2x3=c1x3-3,c1c2=c1*c1-c1,c1c2p1=c1c2+1:
   z=sqr( ( (z*z+c1x3 )*z+c1c2 ) / ( (z*3+c2x3 )*z+c1c2p1 ) );
    |z-1| > .000030517578 && |z| <= 100;
 }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

ManInTheOzone (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(x<20)*(z=cos(z)+pixel),
    (20<=x)*(z=sin(z)+pixel),
    x=x+1, |z|<=4
}

ManInTheOzoneC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=cos(z)+pixel)*(10<=x)*(x<20)+(z=sin(z)+pixel)*(20<=x),
    x=x+1, |z|<=4
}

mc { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*c,
	|z| <= 4
	}

mfnc { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*fn1(c),
	|z| <= 4
	}

mfnz { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*fn1(z),
	|z| <= 4
	}

Michaelbrot (origin) {    ;; drcha.frm, based on the golden mean
    z = pixel:
    z = sqr(z) + ((sqrt 5 + 1)/2),
    |z| <= 4;
} 

moc { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1/c,
	|z| <= 4
	}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

Moth (XAXIS_NOPARM) {
    z=p1, x=1:
    (x<10)*(z=sqr(z)+pixel),
    (10<=x)*(x<20)*(z=exp(z)+pixel),
    (20<=x)*(z=log(z)+pixel),
    x=x+1, |z|<=4
}

MothC (XAXIS_NOPARM) {
    z=p1, x=1:
    (z=sqr(z)+pixel)*(x<10)+(z=exp(z)+pixel)*(10<=x)*(x<20)+(z=log(z)+pixel)*(20<=x),
    x=x+1, |z|<=4
}

moz { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1/z,
	|z| <= 4
	}

mz { ;; explode.frm
	z=0, c=pixel:
	z=sqr(z)+c,
	c=c+p1*z,
	|z| <= 4
	}

Natura (xyaxis)  { ;; drcha.frm, phi yoni
    z = pixel:
    z = z*z*z + ((sqrt 5 + 1)/2)
    |z| <= 4;
}

non-conformal { ;; flip.frm
   ; From Media Magic Calender - August
   z=x=y=x2=y2=0:
   t = x * y,
   x = x2 + t + real(pixel),  y = y2 - t + imag(pixel),
   x2 = sqr(x),  y2 = sqr(y), z=x + flip(y),
   |z| <= 4
   }

phoenix_j (XAXIS) { ;; flip.frm
   ; Use P1=0.56667/-0.5   &   .1/.8
   x=real(pixel), y=imag(pixel), z=nx=ny=x1=x2=y1=y2=0:
   x2 = sqr(x), y2 = sqr(y),
   x1 = x2 - y2 + real(p1) + imag(p1) * nx,
   y1 = 2 * x * y + imag(p1) * ny,
   nx=x, ny=y, x=x1, y=y1, z=nx + flip(ny),
   |z| <= 4
   }
phoenix_m { ;; flip.frm
   ; Mandelbrot stye map of the Phoenix curves
   z=x=y=nx=ny=x1=y1=x2=y2=0:
   x2 = sqr(x), y2 = sqr(y),
   x1 = x2 - y2 + real(pixel) + imag(pixel) * nx,
   y1 = 2 * x * y + imag(pixel) * ny,
   nx=x, ny=y, x=x1, y=y1, z=x + flip(y),
   |z| <= 4
   }
Raphaelbrot (xyaxis) {  ;; drcha.frm, based on phi
    z = pixel:
    z = sqr(z) + ((sqrt 5 - 1)/2)
    |z| <= 4;
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

SinEgg (XAXIS_NOPARM) {
    z=p1,x=|z|:(1<x)*(z=sin(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

SinEggC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sin(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

SinhEgg (XAXIS_NOPARM) {
    z=p1,x=|z|:(1<x)*(z=sinh(z)+pixel),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

SinhEggC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sinh(z)+pixel)*(1<x)+(z=z)*(x<=1),
    z=sqr(z)+pixel,x=|z|,
    x<=4
}

;;; symmicon.frm

SymmIcon {
        z = P1, x = P2, bar = (1,-1), l = real(P1), a = imag(P2),
        b = .2, g = .1, w = 0, n = 5:

        zbar = z*bar;
        z = ((l + (a * z * zbar) + (b * real(z^n))  + (w * i)) * z) + g*(zbar^(n-1)) + pixel;
        }

;;; tchebych.frm

Tchebychev-c6 (XYAXIS) {   ;Advanced Fractal Programming in C  - Stevens
   z=0:
   zsq = z*z,
   z = pixel * (zsq*zsq*zsq - 6*zsq*zsq + 9*zsq - 2),
   |z| <= 4
   }

Tchebychev-t5 (XYAXIS) {   ;Advanced Fractal Programming in C  - Stevens
   z=(0.654,0):
   zcube = z*z*z,
   z = pixel * (16*z*z*zcube - 20*zcube + 5*z),
   |z| <= 4
   }

;; drcha.frm
;; try inside=maxiter and outside=imag on this

test (xyaxis) { ;; =phi
    z = ((sqrt 5 + 1)/2)/pixel:
    z =  z*z + pixel*((sqrt 5 + 1)/2)
    |z| <= 4;
}

test1 (xyaxis) { ;; =phi
    c = pixel
    z = ((sqrt 5 + 1)/2):
    z =  z*z + pixel*((sqrt 5 + 1)/2) + c
    |z| <= 4;
}

test2 (xyaxis) { ;; =phi
    z = ((sqrt 5 + 1)/2)/pixel:
    z =  z*z*z + pixel*((sqrt 5 + 1)/2)
    |z| <= 4;
}

test3 (xyaxis) { ;; =phi
    z = ((sqrt 5 + 1)/2)/pixel:
    z =  z*z + pixel*((sqrt 5 + 1)/2)/((sqrt 5 - 1)/2)
    |z| <= 4;
}

;;; tchebych.frm

test {
  z=pixel,c=p1:
   c = P1, z = Pixel:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / (16 * (z+c))
   |z| < 100
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

;; TestSinMandC demonstrates an IF-THEN type formula as an IF-THEN-ELSE
;; without the ELSE.
;;    if |z|<1 then z=sin(z)
;;    else nothing
;;    z=sqr(z)+pixel
  
;; Verified with Testpt.c version

TestSinMandC (XAXIS_NOPARM) {
    z=p1,x=|z|:
    (z=sin(z))*(1<x)+(z=z)*(x<=1),
    (z=sqr(z)+pixel),
    x=|z|, x<=4
}

Tetrate(XAXIS) { ;; ebbert.frm
  ; duplicate of built-in type.
  ; p1=initial perturbation of z(0), p2 changes bailout from 4.
  z = pixel + p1, b = real(p2) + 4:
   z = pixel ^ z;
    |z| <= b;
 }

Tetratephi (xyaxis) { ;; drcha.frm, ?
    z  = c = ((sqrt 5 +1)/2)/pixel:
    z = c^z + ((sqrt 5 +1)/2)
    |z| <= 4;
}

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

TurtleC (XAXIS_NOPARM) {
    z=p1:
    x=real(z),
    (z=sqr(z)+pixel)*(x<0)+(z=sqr(z)-pixel)*(0<=x),
    |z|<=4
}

;;;
;;; uli.frm
;;;

   ULI_1 = {
      z = Pixel: z = fn1(1/fn2(z))
      |z| <= 4
   }

   ULI_2 = {
      z = Pixel: z = fn1(1/fn2(z+p1))
      |z| <= p2
   }

   ULI_3 = {
      z = Pixel: z = fn1(1/fn2(z+p1)+p1)
      |z| <= p2
   }

   ULI_4 = {
      z = Pixel: z = fn1(1/(z+p1))*fn2(z+p1)
      |z| <= p2
   }

   ULI_5 = {
      z = Pixel, c = fn1(pixel):
      z = fn2(1/(z+c))*fn3(z+c)
      |z| <= p1
   }

   ULI_6 = {
      z = Pixel: z = fn1(p1+z)*fn2(p2-z)
      |z| <= p2+16
   }

;; choice.frm
;; The formulas with names ending in C are the 'correct' version.
;; The floating point flag MUST be set for these.

WaldoTwinsC (XAXIS_NOPARM) {
    z=p1:
    z=cos(sin(z+pixel))+pixel,
    |z|<=4
}

Zppchco8  { ;; Lee2.FRM (Lee Skinner)
  z = pixel, f = cosxx (pixel):
                       z = cosh (z) + f, |z|<=8192}


;;
;;  Rick Hughes
;;  70461,3272
;;  22 Dec 92
;;  Fractal Sources
;;
;;   Bert,
;;    Here are 5 formulas for the .FRM file.  Note that the last 2 are
;;  Newtons and they have to run with inside=zmag to shut off periodicity
;;  checking

Legendre(XAXIS)       {   ;Advanced Fractal Programming in C  - Stevens
   z=0:
   zsq = z*z,
   z=.125*(35*zsq*zsq-30*zsq+3)+pixel,
   |z| <= 4
   }

Tchebychev-c6(XYAXIS) {   ;Advanced Fractal Programming in C  - Stevens
   z=0:
   zsq = z*z,
   z = pixel * (zsq*zsq*zsq - 6*zsq*zsq + 9*zsq - 2),
   |z| <= 4
   }

Tchebychev-t5(XYAXIS) {   ;Advanced Fractal Programming in C  - Stevens
   z=(0.654,0):
   zcube = z*z*z,
   z = pixel * (16*z*z*zcube - 20*zcube + 5*z),
   |z| <= 4
   }

z^3-1=0(XAXIS)  {         ; Advanced Fractal Programming in C  - Stevens
   ; Run with inside = ZMAG to turn off periodicity checking
   x=real(pixel), y=imag(pixel):
   x2 = x*x, y2 = y*y,
   xold = x, yold = y, xmy = x2 - y2,
   d = 3 * (xmy * xmy + 4*x2*y2),
   x = .66666667*x + xmy/d,   y = .66666667*y - 2*x*y/d,
   x != xold && y != yold
   }

z^3-2z-5=0(XAXIS)  {      ; Advanced Fractal Programming in C  - Stevens
   ; --- SLOW on a 486-33 ---  Run with inside = ZMAG
   x=real(pixel), y=imag(pixel):
   x2 = x*x, y2 = y*y, xold = x, yold = y,
   t2 = 3*x2 - 3*y2 -2,          d = t2*t2 + 36*x2*y2,
   t1 = x*x2 - 3*x*y2 - 2*x -5, t3 = 3*x2*y - y2*y - 2*y,
   x = x - (t1 * t2 - 6*x*y*t3)/d,
   y = y - (t1 * (-6*x*y) + t3 * t2)/d,
   x != xold && y != yold
   }

;;  #: 12599 S4/Fractal Sources
;;      29-Jan-93 19:30:44
;;  Sb: #Adjustable Spiders
;;  Fm: Rick Hughes 70461,3272
;;  To: All

;;  Here are 2 variations on the Spider formula.  The function were thrown
;;  in as an after thought.

a_spider1 { ; Adjustable spider - After Homer Smith of Art Matrix
            ; try p1 = (.55,0) or (0,.4) or (.4,.35)
   z=0, c=pixel:
   z = z*z + c,        z = fn1(z),
   c = c * p1 + z,     c = fn2(c),
   |z| <= 4
   }

a_spider2 { ; Adjustable spider - After Fractint's version
            ; try p1 = (.55,0) or (0,.4) or (.4,.35)
   z=c=pixel:
   z = z*z + c,        z = fn1(z),
   c = c * p1 + z,     c = fn2(c),
   |z| <= 4
   }

;; Brainy Smurf

;improved.frm
;comment {
;
; FRACTINT.DOC has instructions for adding new formulas to this file.
; There are several hard-coded restrictions in the formula interpreter:
;
; 1) The fractal name through the open curly bracket must be on a single line.
;
; 2) There is a hard-coded limit of 200 formulas per formula file, only
;    because of restrictions in the prompting routines.
;
; 3) Formulas can contain at most 250 operations (references to variables and
;    arithmetic); this is bigger than it sounds, no formula in the default
;    fractint.frm uses even 100.
;
; 3) Comment blocks can be set up using dummy formulas with no formula name
;    or with the special name "comment".
;
; The formulas are listed alphabetically.
;
; Note that the builtin "cos" function had a bug which was corrected in
; version 16.     recreate an image from a formula which used cos before
; v16, change "cos" in the formula to "cosxx" which is a new function
; provided for backward compatibility with that bug.
; }
;
{==================================================================}


AltJTet (XAXIS) {; Lee Skinner
   z = p1:
   z = (pixel ^ z) + p1,
       |z| <= (p2 + 3)
  }


{==================================================================}

AltMTet (XAXIS) {; Lee Skinner
   ; try p1 = 1.5
   z = 0:
   z = (pixel ^ z) + pixel,
       |z| <= (p1 + 3)
  }


{==================================================================}

Bogus1 {; Fractal Creations
   ; try p1 = 2 and p2 = 4
   z = 0;
   z = z + p1,
       |z| <= p2
  }


{==================================================================}

CGhalley (XYAXIS) {; Chris Green
   ; try p1 = 1, p2 = 0.0001
   ; note--use floating point
   z   = (1,1):
   z5  = z*z*z*z*z;
   z6  = z*z5;
   z7  = z*z6;
   z8  = z7 - z - pixel;
   z   = z-p1*(z8/ ((7.0*z6-1)-(42.0*z5)*z8/(14.0*z6-2))),
         p2 <= |z8|
  }


{==================================================================}

Cubic (XYAXIS) {; Lee Skinner
   ; try p1 = 2, p2 = 3
   t1 = pixel,
   t2 = t1*t1 + 1
   t3 = 3*t1,
   a  = t2/t3,
   b  = p1*a*a*a + (t2 - 2)/t3,
   d  = p2*a*a,
   z  = 0 - a:
   z  = z*z*z - d*z + b,
        |z| < p1 + 3
  }


{==================================================================}

Dragon (ORIGIN) {; Mark Peterson
   ; try p1 = (-0.74543, 0.2), p2 = 4, fn1 = sqr
   ; note p2 should not be zero
   z = pixel:
   z = fn1(z) + p1,
       |z| <= p2
  }


{==================================================================}

Daisy (ORIGIN) {; Mark Peterson
   ; try p1 = (0.11031, -0.67037) and p2 = 4
   ; note p2 should not be zero
   z = pixel:
   z = z*z + p1,
       |z| <= p2

  }


{==================================================================}

DeltaLog (XAXIS) {; Mark Peterson
   ; try p1 = 1, p2 = 4, fn1 = log, fn2 = sqr
   ; note p2 should not be zero
   z = pixel, c = fn1(pixel):
   z = fn2(z) + c/p1,
       |z| <= p2
  }


{==================================================================}

Ent {; Scott Taylor
   ; try p1 = (.5, .75), p1 = 0, p2 = 4, fn1 = exp
   z    = pixel,
   y    = fn1(z)+p1,
   base = log(p1):
   z    = y * log(z)/base,
          |z| <= p2
  }


{==================================================================}

Ent2 {; Scott Taylor
   ; try p1 = 2, fn1 = cos, fn2 = cosh
   ; try potential = 255/355
   z    = pixel,
   y    = fn1(z),
   base = log(p1):
   z    = fn2( y * log(z) / base ),
          |z| <= p1
  }


{==================================================================}

FnDog (XYAXIS)  {; Scott Taylor
   z = pixel,
   b = p1+2:
   z = fn1( z ) * pixel,
       |z| <= b
  }


{==================================================================}

Fzppfncs  {; Lee Skinner
   ; try p1 = 50, fn1 = cos, fn2 = sin
   z = pixel,
   f = 1./fn1(pixel):
   z = fn2(z) + f,
       |z| <= p1
  }

Fzppfnct  {; Lee Skinner
   ; try p1 = 50, fn1 = sin, fn2 = cos, fn3 = sin
   z = pixel,
   f = fn2(pixel)/fn3(pixel):
   z = fn1(z) + f,
       |z|<= p1
  }


Fzppfnpo  {; Lee Skinner
   ; try p1 = 50
   z = pixel,
   f = 2*(pixel)^(pixel):
   z = fn1(z) + f,
       |z| <= p1
  }

Fzppfnre  {; Lee Skinner
   ; try p1 = 50 and p2 = 1
   z = pixel,
   f = 1./(pixel):
   z = fn1(z) + f * p2,
       |z| <= p1
  }

Fzppfnse  {; Lee Skinner
   ; try p1 = 50, fn1 = sin, fn2 = sin
   z = pixel,
   f = 1./fn2(pixel):
   z = fn1(z) + f,
       |z| <= p1
  }

Fzppfnsr  {; Lee Skinner
   ; try p1 = 50
   z = pixel,
   f = (pixel)^.5:
   z = fn1(z) + f,
       |z| <= p1
  }

Fzppfnta  {; Lee Skinner
   ; try p1 = 50
   z = pixel,
   f = fn2(pixel):
   z = fn1(z) + f,
       |z|<= p1
  }


{==================================================================}

Gamma (XAXIS)={ ; Jm Richard-Collard
   ; try p1 = 6.2   ; note that p1 above is two times pi
   z = pixel:
   z = (p1*z)^(0.5)*(z^z)*exp(-z)+pixel
   |z|<=p2
  }


{===============
Halley (XYAXIS) {; Chris Green
   ; try p1 = 1.0 and p2 = 0.0001
   ; note--use floating point
   z  = pixel:
   z5 = z*z*z*z*z;
   z6 = z*z5;
   z7 = z*z6;
   z  = z-p1*((z7-z)/((7.0*z6-1)-(42.0*z5)*(z7-z)/(14.0*z6-2))),
        p2 <= |z7-z|
   }


{==================================================================}

InvMandel (XAXIS) {; Mark Peterson
   ; try p1 = 1, p2 = 4, fn1 = sqr
   ; note p2 should not be zero
   c = z = p1 / pixel:
   z = fn1(z) + c;
       |z| <= p2
  }


{==================================================================}

HalleySin (XYAXIS) {; Chris Green
   ; try p1 = 0.1, p2 = 0.0001, fn1 = sin, fn2 = cos
   ; note--use floating point
   z  = pixel:
   s  = fn1(z),
   c  = fn2(z)
   z=z-p1*(s/(c-(s*s)/(c+c))),
   p2 <= |s|
  }


{==================================================================}

HyperMandel {; Chris Green.
   ; try p1 = 1.8, p2 = 2.0, fn1 = sqr
   ; note--use floating point
   a    = (0,0),
   b    = (0,0):
   z    = z+1
   anew = fn1(a)-fn1(b)+pixel
   b    = p2*a*b+p1
   a    = anew,
          |a|+|b| <= 4
  }


{==================================================================}
{ These types are generalizations of types sent to us by the French
  mathematician Jm Richard-Collard. If we hadn't generalized them
  there would be --ahhh-- quite a few. With 11 possible values for
  each fn variable,Jm_03, for example, has 14641 variations! }

Jm_01 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = (fn1(fn2(z^pixel)))*pixel,
       |z| <= t
  }

Jm_02 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = (z^pixel)*fn1(z^pixel),
       |z| <= t
  }

Jm_03 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1((fn2(z)*pixel)*fn3(fn4(z)*pixel))*pixel,
       |z| <= t
  }

Jm_04 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1((fn2(z)*pixel)*fn3(fn4(z)*pixel)),
       |z| <= t
  }

Jm_05 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(fn2((z^pixel))),
       |z| <= t
  }

Jm_06 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(fn2(fn3((z^z)*pixel))),
       |z| <= t
  }

Jm_07 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(fn2(fn3((z^z)*pixel)))*pixel,
       |z| <= t
  }

Jm_08 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(fn2(fn3((z^z)*pixel)))+pixel,
       |z| <= t
  }

Jm_09 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(fn2(fn3(fn4(z))))+pixel,
       |z| <= t
  }

Jm_10 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(fn2(fn3(fn4(z)*pixel))),
       |z| <= t
  }

Jm_11 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(fn2(fn3(fn4(z)*pixel)))*pixel,
       |z| <= t
  }

Jm_12 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(fn2(fn3(z)*pixel)),
       |z| <= t
  }

Jm_13 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(fn2(fn3(z)*pixel))*pixel,
       |z| <= t
  }

Jm_14 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(fn2(fn3(z)*pixel))+pixel,
       |z| <= t
  }
 k
Jm_15 {; Jm Richard-Collard
   z  = pixel,
   t  = p1+4:
   f2 = fn2(z),z=fn1(f2)*fn3(fn4(f2))*pixel,
        |z| <= t
  }

Jm_16 {; Jm Richard-Collard
   z  = pixel,
   t  = p1+4:
   f2 = fn2(z),z=fn1(f2)*fn3(fn4(f2))+pixel,
        |z| <= t
  }

Jm_17 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(z)*pixel*fn2(fn3(z)),
       |z| <= t
  }

Jm_18 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(z)*pixel*fn2(fn3(z)*pixel),
       |z| <= t
  }

Jm_19 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(z)*pixel*fn2(fn3(z)+pixel),
       |z|<=t
  }

Jm_20 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(z^pixel),
       |z| <= t
  }

Jm_21 {; Jm Richard-Collard
   z= pixel,
   t= p1+4:
   z= fn1(z^pixel)*pixel,
      |z| <= t
  }

Jm_22 {; Jm Richard-Collard
   z  = pixel,
   t  = p1+4:
   sq = fn1(z),
   z  = (sq*fn2(sq)+sq)+pixel,
        |z| <= t
  }

Jm_24 {; Jm Richard-Collard
   z  = pixel,
   t  = p1+4:
   z2 = fn1(z), z=(fn2(z2*fn3(z2)+z2))+pixel,
        |z| <= t
  }

Jm_25 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(z*fn2(z)) + pixel,
       |z|<=t
  }

Jm_26 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   z = fn1(fn2(z)) + pixel,
       |z|<=t
  }

Jm_27 {; Jm Richard-Collard
   z = pixel,
   t = p1+4:
   s = fn1(z),
   z = s + 1/s + pixel,
       |z| <= t
  }

Jm_03a {; generalized Jm Richard-Collard type
   z = pixel,
   t = p1+4:
   z = fn1((fn2(z)*pixel)*fn3(fn4(z)*pixel))+pixel,
      |z|<=t
  }

Jm_11a {; generalized Jm Richard-Collard type
   z = pixel,
   t = p1+4:
   z = fn1(fn2(fn3(fn4(z)*pixel)))+pixel,
       |z|<=t
  }

Jm_23 {; generalized Jm Richard-Collard type
   z = pixel,
   t = p1+4:
   z = fn1(fn2(fn3(z)+pixel*pixel)),
       |z|<=t
  }

Jm_27a {; generalized Jm Richard-Collard type
   z = pixel,
   t = p1+4:
   sqrz = fn1(z), z=sqrz + 1/sqrz + pixel,
       |z|<=t
  }

Jm_ducks (XAXIS) {; Jm Richard-Collard
   ; try fn1 = sqr
   ; try corners=-1.178372/-0.978384/-0.751678/-0.601683
   z = pixel,
   t = 1+pixel:
   z = fn1(z)+t,
       |z| <= p1 + 4
  }


{==================================================================}

JTet (XAXIS) {; Lee Skinner
   z = pixel:
   z = (pixel ^ z) + p1,
       |z| <= (p2 + 3)
  }


{==================================================================}

LeeMandel1 (XYAXIS) {; Kevin Lee
   ; try p1 = 0, p2 = 4, fn1 = sqr, fn2 = sqr
   z = pixel + p1:
   c = fn1(pixel)/z, c=z+c, z=fn2(z),
       |z| < p2
  }

LeeMandel2 (XYAXIS) {; Kevin Lee
   ; try p1 = 0, p2 = 4, fn1 = sqr, fn2 = sqr
   z = pixel + p1:
   c = fn1(pixel)/z, c=z+c, z=fn2(c*pixel),
       |z| < p2
   }

LeeMandel3 (XAXIS) {; Kevin Lee
   ; try p1 = 0, p2 = 4, fn1 = sqr
   z = pixel + p1,
   c = pixel-fn1(z):
   c = pixel+c/z,
   z = c-z*pixel,
       |z| < p1
  }


{==================================================================}

Mandel3 {; Fractal Creations
   ; try p1 = 1, p2 = 4, fn1 = sin
   z = pixel * p1,
   c = fn1(z):
   z = (z*z) + c;
   z = z * 1/c;
       |z| <= p2;
   }


{==================================================================}

Mandelbrot (XAXIS) {; Mark Peterson
   ; try p1 = 0, p2 = 4, fn1 = sqr, fn2 = sqr
   ; note p2 should not be zero
   z = pixel,
   z = fn1(z):
   z = z + pixel + p1
   z = fn2(z)
       lastsqr <= p2
  }


{==================================================================}

MandelTangent {; Fractal Creations
   ; try p1 = 0, p2 = 32, fn1 = tan
   z = pixel + p1:
   z = pixel * fn1(z),
      |real(z)| < p2
  }


{==================================================================}

MTet (XAXIS) {; Lee Skinner
   ; try fn1 = sin, p1 = 1
   z = pixel:
   z = (pixel ^ z) + pixel,
       |z| <= (p1 + 3)
  }


{==================================================================}

MyFractal {; Fractal Creations
   ; try p1 = 0, p2 = 4
   c = z = 1/pixel + p1:
   z = fn1(z) + c;
       |z| <= p2
  }


{==================================================================}

Newton3 {; Chris Green
   ; Try p1=1.8 and p2 = 3.0
   z  = (1,1):
   z2 = z*z;
   z3 = (z*z2) - pixel;
   z  = z-p1*z3/(p2*z2),
        0.0001 < |z3|
  }


{==================================================================}

Newton4 (XYAXIS) {; Mark Peterson
    ; try p1 = 3 and p2 = 4
    z  = pixel,
    Root = 1:
    z3 = z*z*z;
    z4 = z3 * z;
    z  = (p1 * z4 + Root) / (p2 * z3);
         0.004 <= |z4 - Root|
  }


{==================================================================}

NewtonSinExp (XAXIS) {; Chris Green
   ; try fn1 = exp, fn2 = sin, fn3 = cos, p1 = 1, p2 = 0.0001
   ; note--use floating point
   z  = pixel:
   z1 = fn1(z)
   z2 = fn2(z)+z1-1
   z  = z-p1*z2/(fn3(z)+z1),
        p2 < |z2|
  }


{==================================================================}

PseudoMandel (XAXIS) {; davisl
   ; try p1 = 2.7182818, p2 = 6.2831853, fn1 = sqr
   z = pixel:
   z = ((z/p1)^z)*fn1(p2*z) + pixel,
       |z| <= 4
  }


{==================================================================}

Richard1 (XYAXIS) {; Jm Richard-Collard
   ; try p1 = 0, p2 = 50
   z   = pixel + p1:
   sq  = z*z,
   z   = (sq*fn1(sq)+sq)+pixel,
         |z| <= p2
  }

Richard2 (XYAXIS) {; Jm Richard-Collard
   ; try p1 = 0, p2 = 50, fn1 = sin
   z   = pixel + p1:
   z   = 1/(fn1(z*z+pixel*pixel)),
         |z| <= p2
  }

Richard3 (XAXIS) {; Jm Richard-Collard
   ; try p1 = 0, p2 = 50, fn1 = sinh
   z   = pixel + p1:
   sh  = fn1(z),
    z   -b1/(sh*sh))+pixel,
         |z| <= p2
  }

Richard4 (XAXIS) {; Jm Richard-Collard
   ; try p1 = 0, p2 = 50, fn1 = cos
   z   = pixel + p1:
   z2  = z*z,
   z   = (1/(z2*fn1(z2)+z2))+pixel,
         |z| <= p2
  }

Richard5 (XAXIS) {; Jm Richard-Collard
   ; try p1 = 0, p2 = 50, fn1 = sin, fn2 = sinh
   z = pixel + p1:
   z = fn1(z*fn2(z))+pixel,
       |z| <= p2
  }

Richard6 (XYAXIS) {; Jm Richard-Collard
   ; try p1 = 0, p2 = 50, fn1 = sin, fn2 = sinh
   z = pixel + p1:
   z = fn1(fn2(z))+pixel,
       |z| <= p2
  }

Richard7 (XAXIS) {; Jm Richard-Collard
   ; try p1 = 0, p2 = 50, fn1 = log
   z = pixel:
   z = fn1(z)*pixel,
       |z| <= p2
  }

Richard8 (XYAXIS) {; Jm Richard-Collard
   ; try p1 = 0, p2 = 50, fn1 = sin, fn2 = sin
   ; note--used for cover of "Fractal Creations"
   z = pixel + p1,
   z = fn1(z)+fn2(pixel),
       |z| <= p2
  }

Richard9 (XAXIS) {; Jm Richard-Collard
   ; try p1 = 0, p2 = 4
   z = pixel + p1:
   s = z*z,
   z = s + 1/s + pixel,
       |z| <= p2
  }

Richard10 (XYAXIS) {; Jm Richard-Collard
   ; try p1 = 0, p2 = 50, fn1 = sin
   z = pixel + p1:
   z = 1 / fn1(1/(z*z)),
       |z| <= p2
  }


{==================================================================}

Sterling (XAXIS) {; davisl
   ; try p1 = 2.7182818, p2 = 6.2831853
   z = pixel:
   z = ((z/p1)^z)/fn1(p2*z),
       |z| <= 4
  }

Sterling2 (XAXIS) {; davisl
   ; try p1 = 2.7182818, p2 = 6.2831853
   z = pixel:
   z = ((z/p1)^z)/fn1(p2*z) + pixel,
       |z| <= 4
  }

Sterling3 (XAXIS) {; davisl
   ; try p1 = 2.7182818, p2 = 6.2831853
   z = pixel:
   z = ((z/p1)^z)/fn1(p2*z) - pixel,
       |z| <= 4
  }


{==================================================================}

Wineglass (XAXIS) {; Pieter Branderhorst
   ; try p1 = 4 and p2 = 2
   c = z = pixel:
   z = z * z + c
   c = (1+flip(imag(c))) * real(c) / p2 + z,
       |z| <= p1
  }


{==================================================================}

ZZ (XAXIS) { ; Jm Richard-Collard
   ; try fn1 = log, p1 = 0.001
   ; note--use floating point
   z  = pixel:
   z1 = z^z;
   z2 = (fn1(z)+1)*z1;
   z  = z-(z1-1)/z2,
        p1 <= |1-z1|
  }

ZZa (XAXIS) { ; Jm Richard-Collard
   ; try p1 = 0.001, fn1 = log
   ; note--use floating point
   z  = pixel:
   z1 = z^(z-1);
   z2 = (((z-1)/z)+fn1(z))*z1;
   z  = z-((z1-1)/z2),
        p1 <= |1-z1|
  }

CGNewton3 {; Chris Green -- A variation on newton iteration.
  ; The initial guess is fixed at (1,1), but the equation solved
  ; is different at each pixel ( x^3-pixel=0 is solved).
  ; Use floating point.
  ; Try P1=1.8.
  z=(1,1):
   z2=z*z;
   z3=z*z2;
   z=z-p1*(z3-pixel)/(3.0*z2),
    0.0001 < |z3-pixel|
  }

comment {
  You should note that for the Transparent 3D fractals the x, y, z, and t
  coordinates correspond to the 2D slices and not the final 3D True Color
  image.  To relate the 2D slices to the 3D image, swap the x- and z-axis,
  i.e. a 90 degree rotation about the y-axis.
			    -Mark Peterson 6-2-91
  }

MandelXAxis(XAXIS) {	; for Transparent3D
  z = zt,		; Define Julia axes as depth/time and the
  c = xy:		;   Mandelbrot axes as width/height for each slice.
			;   This corresponds to Mandelbrot axes as
			;   height/depth and the Julia axes as width
			;   time for the 3D image.
   z = Sqr(z) + c
    LastSqr <= 4;
  }

OldJulibrot(ORIGIN) {		    ; for Transparent3D
  z = real(zt) + flip(imag(xy)),    ; These settings coorespond to the
  c = imag(zt) + flip(real(xy)):    ;	Julia axes as height/width and
				    ;	the Mandelbrot axes as time/depth
				    ;	for the 3D image.
   z = Sqr(z) + c
    LastSqr <= 4;
  }

Ajax {the Final Effort; 
z=c=2/pixel:
z =(z^(real(p1)))*(c^(real(p2))) + c,
|z| <=4
}

Bali {The difference of two squares;
z=x=1/pixel, c= fn1 (z):
z = (x+c) * (x-c); 
x=fn2(z),
|z| <=3
}

Fatso {;
z=x=1/pixel, c= fn1 (z):
z = (x^3)-(c^3); 
x=fn2(z),
|z| <=3
}

Jax {The original; 
z=c=2/pixel:
z =(z^4)*(c^4) + c,
|z| <=4
}

Bjax {; 
z=c=2/pixel:
z =(1/((z^(real(p1)))*(c^(real(p2))))*c) + c,
}

{ ****  pour les Mand ca revient a faire des rotations ! **** }


FlipConjMand_N { ; Jm Collard-Richard
c=z=pixel:
z=flip(conj(z^p1))+c,
|z|<=4         }

ConjFlipMand_N {; Jm Collard-Richard
c=z=pixel:
z=conj(flip(z^p1))+c,
|z|<=4         }

FlipConjJul_N  { ; Jm Collard-Richard
z=pixel:
z=flip(conj(z^p2))+p1,
|z|<=4         }

ConjFlipJul_N  { ;Jm Collard-Richard
z=pixel:
z=conj(flip(z^p2))+p1,
|z|<=4         }

GenMand_N      { ;Jm Collard-Richard
                 ; fn1=flip fn2=conj ... fn3=conj fn4=ident ...
                 ;                       fn3=flip fn4=ident   etc ...
c=z=pixel:
z=fn1(fn2(z^p2))+fn3(fn4(c)),
|z|<=4         }

GenJul_N       {; Jm Collard-Richard  (voir Rem de GenMand_N)
z=pixel:
z=fn1(fn2(z^p2))+fn3(fn4(p1)),
|z|<=4         }

GenInvMand_N   { ; Jm Collard-Richard (voir Rem de GenMand_N)
c=z=1/pixel:
z=fn1(fn2(z^p2))+fn3(fn4(c)),
|z|<=4         }

GenInvJul_N    { ; Jm Collard-Richard (voir Rem de GenMand_N)
z=1/pixel:
z=fn1(fn2(z^p2))+fn3(fn4(p1)),
|z|<=4         }

GenInvJmN-M    { ; Jm Collard-Richard
                 ; voir Rem de GenMand_N et InvJmN-M
c=z=1/(pixel^p2):
z=fn1(fn2(z^p2))+fn3(fn4(c)),
|z|<=4         }

GenInvJmN-J    { ;Jm Collard-Richard
                 ; Voir Rem de GenMand_N et InvJmN-J
z=1/(pixel^p2):
z=fn1(fn2(z^p2))+fn3(fn4(p1)),
|z|<=4         }

GenMand1_N     { ; Jm Collard-Richard
c=z=pixel:
z=fn1(z)*fn2(z)+fn3(fn4(c)),
|z|<=4         }

GenJul1_N      { ; Jm Collard-Richard
z=pixel:
z=fn1(z)*fn2(z)+fn3(fn4(p1)),
|z|<=4         }

GenInvMand1_N  { ; Jm Collard-Richard
c=z=1/pixel:
z=fn1(z)*fn2(z)+fn3(fn4(c)),
|z|<=4         }

GenInvJul1_N   { ; Jm Collard-Richard
z=1/pixel:
z=fn1(z)*fn2(z)+fn3(fn4(p1)),
|z|<=4         }

GenInvJm1N1-M  { ; Jm Collard-Richard
c=z=1/(pixel^p2):
z=fn1(z^p2)*fn2(z^p2)+fn3(fn4(c)),
|z|<=4         }

GenInvJm1N2-M  {; Jm Collard-Richard
c=z=1/(pixel^p2):
z=fn1(z)*fn2(z)+fn3(fn4(c)),
|z|<=4         }

GenInvJm1N1-J  { ; Jm Collard-Richard
z=1/(pixel^p2):
z=fn1(z^p2)*fn2(z^p2)+fn3(fn4(p1)),
|z|<=4         }

GenInvJm1N2-J  { ; Jm Collard-Richard
z=1/(pixel^p2):
z=fn1(z)*fn2(z)+fn3(fn4(p1)),
|z|<=4         }

{ dans les 8  precedents on peut remplacer fn3(fn4(c/p1))  par fn3(c/p1)*fn4(c/p1)}




    { TOUTE FONCTION ANALYTIQUE COMPLEXE POSSEDE UN ENSEMBLE
			     DE   JULIA                                 }




InvJm1-M(xaxis) { ; Ceci n'est *pas* InvMand2  Jm Collard-Richard
c=z=1/(pixel*pixel):
z=z*z+c       }           { 'type' Mandelbrot }

InvJm1-J        {; Jm Collard-Richard  Ceci n'est *pas* InvJulia2
z=1/(pixel*pixel):
z=z*z+p1      }           { 'type' Julia      }

InvJmN-M      {  ; Jm Collard-Richard    Ceci n'est pas InvMandelN
c=z=1/(pixel^p1):
z=z^p1+c,
|z|<=4        }

InvJmN-J      {  ; Jm Collard-Richard   Ceci n'est pas InvJuliaN
z=1/(pixel^p2):
z=z^p2+p1,
|z|<=4        }

InvJmBarN-M   { ; Jm Collard-Richard     Ceci n'est pas InvMandBar_N
c=z=1/(pixel^p1):
z=conj(z)^p1+c,
|z|<=4        }

InvJmBarN-J   {; Jm Collard-Richard   Ceci n'st pas InvJulBar_N
z=1/(pixel^p2):
z=conj(z)^p2+p1,
|z|<=4        }


InvFNJmN-M(xaxis) { ; Jm Collard-Richard
c=z=1/(pixel^p1) :
z=fn1(z^p1)+fn2(c)  }

InvFNJmN-J        {; Jm Collard-Richard
z=1/(pixel^p2):
z=fn1(z^p2)+fn2(p1) }



MandelBar_3_c(xaxis) { ; Jm Collard-Richard
z=c=pixel:
z=conj(z)^3+c,
|z|<=4               }

MandelBar_4_c(xaxis) { ; Jm Collard-Richard
z=c=pixel:
z=conj(z)^4+c,
|z|<=4               }

MandelBar_N          { ; Jm Collard-Richard
z=c=pixel:
z=conj(z)^p1+c,
|z|<=4               }

MandelBarFN(xaxis)     { ; Jm Collard-Richard
z=c=pixel:
z=c*fn1(conj(z)),
|z|<=64              }

FnMandelBar(xaxis)     {; Jm Collard-Richard
z=c=pixel :
z=c*conj(fn1(z)),
|z|<=64              }



InvMandelBar_2_c(xaxis) { ; Jm Collard-Richard
c=z=1/pixel :
z=conj(z)*conj(z)+c }

InvMandelBar_N(xaxis) { ; Jm Collard-Richard
c=z=1/pixel :
z=conj(z)^p1+c           }

InvFNMandelBar_N(xaxis) { ; Jm Collard-Richard
c=z=1/pixel :
z=fn1(conj(z)^p1)+fn2(c) }

FNInvMandelBar_N(xaxis) { ;Jm Collard-Richard
c=z=1/pixel :
z=conj(fn1(z))^p1+fn2(c)    }

     { Voir les Julia_X_c et JuliaBar_X_c   }


Julia_N                  { ; Jm Collard-Richard
                           ; rentrer p1=c et p2 la puissance
z=pixel:
z=z^p2+p1,
|z|<=4                   }

JuliaBar_2(xaxis)        { ; Jm Collard-Richard
z=pixel:
z=conj(z)^2+p1,
|z|<=4                   }

JuliaBar_N               { ; Jm Collard-Richard
z=pixel:
z=conj(z)^p2+p1,
|z|<=4                   }

InvJuliaBar_2            { ; Jm Collard-Richard
z=1/pixel:
z=conj(z)^2+p1           }

InvJuliaBar_N            { ; Jm Collard-Richard
z=1/pixel:
z=conj(z)^p2+p1          }

FnInvJuliaBar_N1          { ; Jm Collard-Richard
z=1/pixel:
z=fn1(conj(z)^p2)+fn2(p1) }

FnInvJuliaBar_N2          {; Jm Collard-Richard
z=1/pixel:
z=fn1(conj(z))^p2+fn2(p1) }

FnInvJuliaBar_N3          { ;Jm Collard-Richard
z=1/pixel:
z=(fn1(conj(z))^p2)+fn2(p1) }

FnJuliaBar_N              {; Jm Collard-Richard
z=pixel:
z=fn1(conj(z))^p2+fn2(p1) }


InvJulia_N                { ; Jm Collard-Richard
z=1/pixel:
z=z^p2+p1 ,
|z|<=4                    }


InvMand_N                 { ;  Jm Collard-Richard
z=c=1/pixel:
z=z^p1+c,
|z|<=4                    }

                     jmc@math.ethz.ch
comment {  Evidemment 0^0=1 ce qui est absolument vrai (du moins en
           theorie des ensembles).Par ailleurs ....                 }



SpNewton4(xyaxis) {; Jm Collard-Richard     (Cf M.I Hiver 93-94)
           ;float=yes .Methode de Newton appliquee au polynome
           ;f(z)=(z^2-1)*(z^2+0.16)
           ; f(z)=0 ssi z=1,-1,0.4i,-0.4i
           ; Nf(z)=z-f(z)/f'(z) les pts fixes de Nf sont les racines de f.
           ; z1=f(z) z2=f'(z) z=z-z1/z2 on cherche les pts fixes.
z=pixel:
z1=(z*z-1)*(z*z+0.16);
z2=4*z^3-1.68*z;
z=z-z1/z2 ,
0.001<=|z1|    }


Jm_01(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=(fn1(fn2(z^pixel)))*pixel,
    |z|<=t
  }

Jm_02(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=(z^pixel)*fn1(z^pixel),
    |z|<=t
  }

Jm_03(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1((fn2(z)*pixel)*fn3(fn4(z)*pixel))*pixel,
    |z|<=t
  }

Jm_04(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1((fn2(z)*pixel)*fn3(fn4(z)*pixel)),
    |z|<=t
  }

Jm_05(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2((z^pixel))),
    |z|<=t
  }

Jm_06(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3((z^z)*pixel))),
    |z|<=t
  }

Jm_07(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3((z^z)*pixel)))*pixel,
    |z|<=t
  }

Jm_08(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3((z^z)*pixel)))+pixel,
    |z|<=t
  }

Jm_09(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(fn4(z))))+pixel,
    |z|<=t
  }

Jm_10(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(fn4(z)*pixel))),
    |z|<=t
  }

Jm_11(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(fn4(z)*pixel)))*pixel,
    |z|<=t
  }

Jm_12(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)*pixel)),
    |z|<=t
  }

Jm_13(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)*pixel))*pixel,
    |z|<=t
  }

Jm_14(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)*pixel))+pixel,
    |z|<=t
  }

Jm_15(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   f2=fn2(z),z=fn1(f2)*fn3(fn4(f2))*pixel,
    |z|<=t
  }

Jm_16(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   f2=fn2(z),z=fn1(f2)*fn3(fn4(f2))+pixel,
    |z|<=t
  }

Jm_17(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(z)*pixel*fn2(fn3(z)),
    |z|<=t
  }

Jm_18(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(z)*pixel*fn2(fn3(z)*pixel),
    |z|<=t
  }

Jm_19(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(z)*pixel*fn2(fn3(z)+pixel),
    |z|<=t
  }

Jm_20(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(z^pixel),
    |z|<=t
  }

Jm_21(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(z^pixel)*pixel,
    |z|<=t
  }

Jm_22(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   sq=fn1(z), z=(sq*fn2(sq)+sq)+pixel,
    |z|<=t
  }

Jm_23(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2(fn3(z)+pixel*pixel)),
    |z|<=t
  }

Jm_24(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z2=fn1(z), z=(fn2(z2*fn3(z2)+z2))+pixel,
    |z|<=t
  }

Jm_25(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(z*fn2(z)) + pixel,
    |z|<=t
  }

Jm_26(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   z=fn1(fn2(z)) + pixel,
    |z|<=t
  }

Jm_27(xaxis) {; generalized Jm Collard-Richard type
  z=pixel,t=p1+4:
   sqrz=fn1(z), z=sqrz + 1/sqrz + pixel,
    |z|<=t
  }

Jm_ducks(XAXIS) {; Jm Collard-Richard
  ; Not so ugly at first glance and lot of corners to zoom in.
  ; try this: corners=-1.178372/-0.978384/-0.751678/-0.601683
  z=pixel,tst=p1+4,t=1+pixel:
   z=sqr(z)+t,
    |z|<=tst
  }

Gamma(XAXIS)={ ; first order gamma function from Prof. Jm
  ; "It's pretty long to generate even on a 486-33 comp but there's a lot
  ; of corners to zoom in and zoom and zoom...beautiful pictures :)"
  z=pixel,twopi=6.283185307179586,r=10:
   z=(twopi*z)^(0.5)*(z^z)*exp(-z)+pixel
    |z|<=r
  }
Gamma1(XAXIS) { ; Jm Collard-Richard
  z=pixel,twopi=6.283185307179586,r=10:
  z=(twopi*z)^(0.5)*(z^z)*exp(-z)*pixel,
    |z|<=10   }

FnGAMMA(Xaxis) { ; Jm Collard-Richard
  z=pixel,twopi=6.283185307,r=10:
  z=fn1((twopi*z)^(0.5)*(z^z)*exp(-z))+fn2(pixel),
    |z|<=r    }

ZZ(XAXIS) { ; Prof Jm using Newton-Raphson method
  ; use floating point with this one
  z=pixel,solution=1:
   z1=z^z;
   z2=(log(z)+1)*z1;
   z=z-(z1-1)/z2 ,
    0.001 <= |solution-z1|
  }

ZZa(XAXIS) { ; Prof Jm using Newton-Raphson method
  ; use floating point with this one
  z=pixel,solution=1:
   z1=z^(z-1);
   z2=(((z-1)/z)+log(z))*z1;
   z=z-((z1-1)/z2) ,
    .001 <= |solution-z1|
  }


ZExpZ(xaxis) { ; Jm Collard-Richard z=exp(z) z=(0.318..;+/- 1.337)
z=pixel:
z0=exp(z);
z1=z0-z;
z2=z0-1;
z=z-(z1/z2),
0.0001<=|z1| }

ICHZZ(XAXIS) { ; resolution  cosh(z)*z^z=1    Jm Collard-Richard
; use floating point
z=pixel:
zz=z^z;
sh=sinh(z);
ch=cosh(z);
z1=ch*zz-1;
z2=sh*zz+(log(z)+1)*ch;
z=z-(z1/z2) ,
0.001<=|z1|  }

ICHZ(XAXIS) { ; resolution  cosh(z)*exp(z)=1 sol=0  Jm Collard-Richard
; float=yes
z=pixel:
ex=exp(z);
sh=sinh(z);
ch=cosh(z);
z1=ch*ex-1;
z2=sh*ex+ch*ex;
z=z-(z1/z2) ,
0.001<=|z1| }

ICEZZ(XAXIS) { ;  cos(z)*z^z=1  Jm Collard-Richard
; float=yes
z=pixel:
zz=z^z;
s=sin(z);
c=cos(z);
z1=c*zz-1;
z2=c*(log(z)+1)-s*zz;
z=z-(z1/z2) ,
0.001<=|z1| }

ICEZ(XAXIS) {  ; Jm Collard-Richard
; float=yes
z=pixel:
ex=exp(z);
s=sin(z);
c=cos(z);
z1=c*ex-1;
z2=-s*ex+c*ex;
z=z-(z1/z2) ,
0.001<=|z1| }

SinZZ(XAXIS) {  ; Jm Collard-Richard
; float=yes
z=pixel:
zz=z^z;
szz=sin(z)^sin(z);
z1=szz-zz;
z2=(cos(z)*log(sin(z))+cos(z))*szz-(log(z)+1)*zz;
z=z-(z1/z2) ,
0.001<=|z1| }

SZZS(XAXIS) {  ; Jm Collard-Richard
; float=yes
z=pixel:
sz=sin(z)^z;
zs=z^sin(z);
z1=sz-zs;
z2=(log(sin(z))+z*(cos(z)/sin(z)))*sz-(cos(z)*log(z)+sin(z)/z)*zs;
z=z-(z1/z2) ,
0.001<=|z1| }


Exp2(XAXIS) { ; Jm Collard-Richard
z=pixel:
z1=exp(z*z)-exp(z);
z2=2*z*exp(z*z)-exp(z);
z=z-(z1/z2) ,
0.001<=|z1| }

Exp3(XAXIS) { ; Jm Collard-Richard
z=pixel:
z1=exp(z^3)-exp(z);
z2=3*z*z*exp(z^3)-exp(z);
z=z-(z1/z2) ,
0.001<=|z1| }

ExpZZ(XAXIS) { ; Jm Collard-Richard
z=pixel:
z1=exp(z*log(z))-exp(z);
z2=(log(z)+1)*exp(z*log(z))-exp(z);
z=z-(z1/z2) ,
0.001<=|z1| }

Sin2Z(XAXIS) { ; Jm Collard-Richard
z=pixel:
z1=sin(z*z)-sin(z);
z2=2*z*cos(z*z)-cos(z);
z=z-(z1/z2) ,
0.001<=|z1| }

SinZ4(XAXIS) { ; Jm Collard-Richard
z=pixel:
z1=sin(z^4)+sin(z^3)+sin(z^2)+sin(z);
z2=4*(z^3)*cos(z^4)+3*(z^2)*cos(z^3)+2*z*cos(z^2)+cos(z);
z=z-(z1/z2) ,
0.001<=|z1| }

SinE2(XAXIS) { ; Jm Collard-Richard
z=pixel:
expz2=exp(z*z);
s=sin(z);
c=cos(z);
z1=expz2-exp(z)-s;
z2=2*z*expz2-exp(z)-c;
z=z-(z1/z2) ,
0.001<=|z1| }

SinE2Z(XAXIS) { ; Jm Collard-Richard
z=pixel:
expz2=exp(z*z);
s=sin(z);
c=cos(z);
s2=sin(z*z);
c2=cos(z*z);
z1=expz2-exp(z)-s2+s;
z2=2*z*expz2-exp(z)-z*c2*2+c:
z=z-(z1/z2) ,
0.001<=|z1| }

SS2Z(XAXIS) { ; Jm Collard-Richard
z=pixel:
z1=sin(z)*sin(z)-sin(z*z);
z2=sin(2*z)-z*cos(z*z)*2;
z=z-(z1/z2) ,
0.001<=|z1| }

ShZ(XAXIS) {  ; Jm Collard-Richard
z=pixel:
z1=sinh(z);
z2=cosh(z);
z=z-(z1/z2) ,
0.001<=|z1| }

ChZZ(XAXIS) { ; Jm Collard-Richard
z=pixel:
zz=z^z;
z1=cosh(z)-zz;
z2=sinh(z)-(log(z)+1)*zz;
z=z-(z1/z2) ,
0.001<=|z1| }

TgZ(XAXIS) {  ; Jm Collard-Richard
z=pixel:
z1=sin(z)/cos(z);
z2=1+z1*z1;
z=z-(z1/z2) ,
0.001<=|z1| }

TgZz(XAXIS) { ; Jm Collard-Richard
z=pixel:
z1=sin(z)/cos(z)-z;
z2=(sin(z)/cos(z))^2;
z=z-(z1/z2) ,
0.001<=|z1| }

TgSinZ(XAXIS) { ; Jm Collard-Richard
z=pixel:
z1=sin(z)/cos(z)-sin(z);
z2=1+(sin(z)/cos(z))^2-cos(z);
z=z-(z1/z2) ,
0.001<=|z1| }

CosZZ(XAXIS) { ; Jm Collard-Richard
z=pixel:
zz=z^z;
z1=cos(z)-zz;
z2=-sin(z)-(log(z)+1)*zz;
z=z-(z1/z2) ,
0.001<=|z1| }

CshZZ(XAXIS) {  ; Jm Collard-Richard
z=pixel:
zz=z^z;
z1=cos(z)-sinh(z)-zz;
z2=-sin(z)-cosh(z)-(log(z)+1)*zz;
z=z-(z1/z2) ,
0.001<=|z1| }


CosZ1(XYAXIS) { ; Resol. cos(z)^cos(z)=1 Jm Collard-Richard
	       ; float=yes
 z=pixel:
 s=sin(z);
 c=cos(z);
 cc=c^c;
 z1=cc-1;
 z2=(-s*log(c)-s)*cc;
 z=z-(z1/z2) ,
 0.001<=|z1| }

SinZ1(XAXIS) { ; Resol. sin(z)^sin(z)=1  Jm Collard-Richard
	       ; float=yes
 z=pixel:
 s=sin(z);
 c=cos(z);
 ss=s^s;
 z1=ss-1;
 z2=(c+c*log(s))*ss;
 z=z-(z1/z2) ,
 0.001<=|z1| }

CosSinZZ(XAXIS) { ; resol. sin(z)^sin(z)=cos(z)^cos(z) Jm Collard-Richard
		  ; use float=yes
 z=pixel:
 s=sin(z) , c=cos(z) , ss=s^s , cc=c^c ,
 z1=ss-cc ,
 z2=(c+c*log(s))*ss+(s*log(c)+s)*cc ,
 z=z-(z1/z2) ,
 0.001<=|z1| }

CSZZ(XAXIS)  { ;resol. cos(sin(z))=z^z     Jm Collard-Richard
	       ; Use Float=yes
 z=pixel:
 zz=z^z;
 s=sin(z);
 c=cos(z);
 z1=cos(s)-zz;
 z2=-c*sin(s)-(log(z)+1)*zz;
 z=z-(z1/z2) ,
 0.001<=|z1| }

S2Z(XAXIS) { ; resol. sin(sin(z)=z - Jm Collard-Richard -  Use float=yes
z=pixel:
z1=sin(sin(z))-z;
z2=cos(z)*cos(sin(z))-1;
z=z-(z1/z2) ,
0.001<=|z1| }

SPCZ(xaxis) { ; resol. sin(z)^cos(z)=0 -Jm Collard-Richard - Use Float=yes
z=pixel:
s=sin(z);
c=cos(z);
co=cotan(z);
sc=s^c;
z1=sc;
z2=((c*co)-(s*log(s)))*sc;
z=z-(z1/z2) ,
0.001<=|z1| }

Jm_28(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z)^fn2(z)+pixel,
|z|<=4        }

Jm_29(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z)^fn2(z)*pixel,
|z|<=4        }

Jm_30(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z+pixel)^fn2(z+pixel),
|z|<=4        }

Jm_31(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z*pixel)^fn2(z*pixel),
|z|<=4        }

Jm_32(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z+pixel)^fn2(z*pixel),
|z|<=4        }

Jm_33(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z*pixel)^fn2(z*pixel)*pixel,
|z|<=4        }

Jm_34(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z*pixel)^fn2(z*pixel)+pixel,
|z|<=4        }

Jm_35(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z+pixel)^fn2(z+pixel)+pixel,
|z|<=4        }

Jm_36(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z+pixel)^fn2(z+pixel)*pixel,
|z|<=4        }

Jm_37(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(pixel)^fn2(z),
|z|<=4       }

Jm_38(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z)^fn2(pixel),
|z|<=4       }

Jm_39(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z)^fn2(1/z)+pixel,
|z|<=4       }

Jm_40(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z)^pixel+pixel^fn2(z),
|z|<=4       }

SZZCHZ(xaxis) { ; Jm Collard-Richard - Use FLOAT=YES
		; Resol : sin(z)+z^z=cosh(z)
z=pixel:
s=sin(z);
c=cos(z);
zz=z^z;
sz=sinh(z);
cz=cosh(z);
z1=s+zz-cz;
z2=c+(log(z)+1)*zz-sz;
z=z-(z1/z2),
0.001<=|z1| }

INVZZCZ(xaxis) { ; Jm Collard-Richard   -   use FLOAT=YES
		 ; resol : 1/z^z=cos(z)
z=pixel:
zz=z^z;
z1=(1/zz)-cos(z);
z2=((log(z)+1)*zz)*(-1)*(1/(zz*zz))+sin(z);
z=z-(z1/z2),
0.001<=|z1|   }

INVZZCHZ(Xaxis) { ; Jm Collard-Richard  - Use FLOAT=YES
		  ; resol : 1/z^z=cosh(z)
z=pixel:
zz=z^z;
z1=(1/zz)-cosh(z);
z2=((log(z)+1)*zz)*(-1)*(1/(zz*zz))-sinh(z);
z=z-(z1/z2),
0.001<=|z1|     }

LZZSZ(Xaxis)  { ; Jm Collard-Richard  - Use Float=Yes
		; resol :  log(z^z)=sin(z)
z=pixel:
s=sin(z);
c=cos(z);
zz=z^z;
z1=log(zz)-s;
z2=(((log(z)+1)*zz)/(zz))-c;
z=z-(z1/z2),
0.001<=|z1| }

LZZSHZ(Xaxis) { ; Jm Collard-Richard
		; Resol : log(z^z)=sinh(z)
z=pixel:
sh=sinh(z);
ch=cosh(z);
zz=z^z;
z1=log(zz)-sh;
z2=(((log(z)+1)*zz)/(zz))-ch;
z=z-(z1/z2),
0.001<=|z1|  }

ZZINVCZ(Xaxis) { ; Jm Collard-Richard    -  Use  Float=Yes
		 ; Resol :   z^z=1/cos(z)
z=pixel:
c=cos(z);
s=sin(z);
zz=z^z;
z1=zz-(1/c);
z2=(log(z)+1)*zz-(s/(c*c));
z=z-(z1/z2),
0.001<=|z1|  }

ZZINVCHZ(Xaxis) { ; Jm Collard-Richard   - Use Float=Yes
		  ; Resol : z^z=1/cosh(z)
z=pixel:
ch=cosh(z);
sh=sinh(z);
zz=z^z;
z1=zz-(1/ch);
z2=(log(z)+1)*zz+(sh/(ch*ch));
z=z-(z1/z2),
0.001<=|z1|  }

ZZZZ1(xaxis)  {; Jm Collard-Richard      -- Use Float=Yes
	       ; Resol : z^z=z^(z+1)+1
z=pixel:
l=log(z);
zz=z^z;
zz1=z^(z+1);
z1=zz-zz1-1;
z2=(l+1)*zz-(l+(z+1/z))*zz1;
z=z-(z1/z2) ,
0.001<=|z1|   }

Exp2Z(Xaxis) {; Jm Collard-Richard   ---- Use Float=Yes
	      ; Resol : exp(-1/(z*z))=z
z=pixel:
exp2z=exp(1/(z*(-z)));
z1=exp2z-z;
z2=(2/(z^3))*exp2z-1;
z=z-(z1/z2),
0.001<=|z1|  }

ExpZ2(xaxis)  {;Jm Collard-Richard
        ; exp(z*z)=1  float=yes
z=pixel:
z1=exp(z*z)-1;
z2=2*z*exp(z*z);
z=z-(z1/z2),
0.0001<=|z1| }

ExpZ_N(xaxis) {; Jm Collard-Richard     exp(z^n)=1 p1=n  float=yes
z=pixel:
z0=exp(z^p1);
z1=z0-1;
z2=p1*z^(p1-1)*z0;
z=z-(z1/z2),
0.0001<=|z1| }

InvExpZ_N(xaxis) {; Jm Collard-Richard
                  ; voir ExpZ_N
z=1/pixel:
z0=exp(z^p1);
z1=z0-1;
z2=p1*z^(p1-1)*z0;
z=z-(z1/z2),
0.0001<=|z1|     }


Exp2Z2(xaxis) { ; Jm Collard-Richard   --- Use Float=yes
		; Resol : exp(-1/(z*z))=z*z
z=pixel:
exp2z=exp(1/(z*(-z)));
z1=exp2z-z*z;
z2=(2/(z^3))*exp2z+z*(-2);
z=z-(z1/z2),
0.001<=|z1|    }

Exp2ZZ(Xaxis) {; Jm Collard-Richard    --- Use Float=Yes
	       ; Resol : exp(-1/(z*z))=z^z-1
z=pixel:
exp2z=exp(1/(z*(-z)));
zz=z^z;
z1=exp2z-zz-1;
z2=(2/(z^3))*exp2z-(log(z)+1)*zz;
z=z-(z1/z2),
0.001<=|z1|    }

ExpSinZ(Xaxis) { ; Jm Collard-Richard --- Use Float=Yes
		 ; Resol : exp(sin(z))=1
z=pixel:
es=exp(sin(z));
c=cos(z);
z1=es-1;
z2=c*es;
z=z-(z1/z2),
0.001<=|z1|   }

ExSiCoZ(Xaxis) { ;Jm Collard-Richard  --- Use Float=Yes
		 ; Resol : exp(sin(z))=cos(z)
z=pixel:
s=sin(z);
es=exp(s);
c=cos(z);
z1=es-c;
z2=c*es+s;
z=z-(z1/z2),
0.001<=|z1|   }



Jm_46(xaxis) {; Jm Collard-Richard
z=pixel:
z=exp(-p1*z*z*cos(p2))*cos(p1*z*z*sin(p2))+pixel,
|z|<=4  }

Jm_47(xaxis) {; Jm Collard-Richard
z=pixel:
z=fn1(p1*z)/fn2(p2*z)+pixel,
|z|<=4 }



Jm_50(xaxis) { ; Jm Collard-Richard
z=pixel:
z=fn1(z)/fn2(z)+fn3(pixel),
|z|<=P1      }

Jm_51(xaxis) {; Jm Collard-Richard
z=pixel,c=z^fn2(pixel):
z=fn1(z)+c,
|z|<=25      }

Jm_52(xaxis) {; Jm Collard-Richard    -Use FLOAT
z=pixel,c=z^fn2(pixel):
z=fn1(z)+c;
c=fn3(c)+fn4(z),
|z|<=25     }

Jm_53(xaxis) {; Jm Collard-Richard  -  Use Float
c=z=pixel:
z=fn1(z)+c;
c=fn2(c)+fn3(z),
|z|<=25     }


Jm_54(xaxis) { ;Jm Collard-Richard
               ; pouah !
z=pixel:
z=fn1(flip(z))+flip(fn2(z))+pixel
	     }


Jm_55(xaxis) {; JM Collard-Richard
z=pixel,stop=25:
f1=z^p1;
f2=z^p2;
z=fn1(f1)*fn2(f2)+pixel,
|z|<=25      }

Jm_56(xaxis) { ; Jm Collard-Richard
z=pixel,stop=25:
f1=z^p1;
f2=z^p2;
z=fn1(f1)/fn2(f2)+pixel,
|z|<=stop    }

Jm_57(xaxis) { ; Jm Collard-Richard
z=pixel,stop=25:
f1=1/(z^p1);
f2=1/(z^p2);
z=fn1(f1)*fn2(f2)+pixel,
|z|<=stop    }

Jm_58(xaxis) {; Jm Collard-Richard
z=pixel,stop=25:
f1=1/(z^p1);
f2=1/(z^p2);
z=fn1(f1)/fn2(f2)+pixel,
|z|<=stop    }

Jm_59(xaxis) {; Jm Collard-Richard
z=pixel,stop=25:
f1=1/(z^p1);
f2=1/(z^p2);
z=(fn1(f1)/fn2(f2))*pixel,
|z|<=stop    }

Jm_60(xaxis) {; Jm Collard-Richard
z=pixel,stop=25:
f1=(z^p1);
f2=(z^p2);
z=(fn1(f1)/fn2(f2))*pixel,
|z|<=stop    }

Jm_61(xaxis) {; Jm Collard-Richard
z=pixel,stop=25:
f1=1/(z^p1);
f2=1/(z^p2);
z=fn1(f1)*fn2(f2)*pixel,
|z|<=stop    }

Jm_62(xaxis) {; Jm Collard-Richard
z=pixel,stop=25:
f1=(z^p1);
f2=(z^p2);
z=fn1(f1)*fn2(f2)*pixel,
|z|<=stop    }

LogExp(xaxis) {; Jm Collard-Richard  float=yes
        ; log(z)+exp(z)=0  une solution n'est *pas* z=0  ! UNE solution: z=0.2...
z=pixel:
z1=log(z)+exp(z);
z2=1/z+exp(z);
z=z-(z1/z2),
0.001<=|z1| }


                              jmc@math.ethz.ch

comment {
These formulas - variations on a tetrate theme - work best
using a fast cpu with fp maths. Some interesting effects
can be achieved with inside=bof60. (Also applies to the standard
Fractint coded Tetrate type).

Set fn2=ident for conventional initiation.

Holes may appear in images, especially in the z^c types.
Increased setting for periodicity should cure this problem.

Any feedback on these or related fractals would be much
appreciated. I have been exploring these for some 2 years
now (on & off!).

gordon lamb - 100272,3541
}
lambtet1 { ;fn1=sin & inside=bof60 gives a striking tropical fish!
           ;see file FISHY.GIF - New Images Nov. 
           ;set fn1=fn2=ident for simple tetrate fractal.            
            z=c=fn2(pixel): z=fn1(c^z), |z|<=4}
lambtet2 {
            z=c=fn2(pixel): z=fn1(z^c), |z|<=4}
lambtet3 { ;fn1=recip will produce infinitely nested crustaceans!
            z=c=fn2(pixel): z=c^fn1(z), |z|<=4}
lambtet4 {
            z=c=fn2(pixel): z=z^fn1(c), |z|<=4}
lambtet5 { 
            z=c=fn2(pixel): z=1/fn1(c^z), |z|<=4}
lambtet6 {
            z=c=fn2(pixel): z=1/fn1(z^c), |z|<=4}
lambtet7 {
            z=c=fn2(pixel): z=c^(1/fn1(z)), |z|<=4}
lambtet8 { 
            z=c=fn2(pixel): z=z^(1/fn1(c)), |z|<=4}
lambtet9 {
            z=c=fn2(pixel): z=fn1(c^fn3(z)), |z|<=4}
                                   
{ The following are from Lee Skinner, have been partially generalized. }

Fzppfnre  {; Lee Skinner
  z = pixel, f = 1./(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnpo  {; Lee Skinner
  z = pixel, f = (pixel)^(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnsr  {; Lee Skinner
  z = pixel, f = (pixel)^.5:
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnta  {; Lee Skinner
  z = pixel, f = tan(pixel):
   z = fn1(z) + f,
    |z|<= 50
  }

Fzppfnct  {; Lee Skinner
  z = pixel, f = cos(pixel)/sin(pixel):
   z = fn1(z) + f,
    |z|<= 50
  }

Fzppfnse  {; Lee Skinner
  z = pixel, f = 1./sin(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfncs  {; Lee Skinner
  z = pixel, f = 1./cos(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzppfnth  {; Lee Skinner
  z = pixel, f = tanh(pixel):
   z = fn1(z)+f,
    |z|<= 50
  }

Fzppfnht  {; Lee Skinner
  z = pixel, f = cosh(pixel)/sinh(pixel):
   z = fn1(z)+f,
    |z|<= 50
  }

Fzpfnseh  {; Lee Skinner
  z = pixel, f = 1./sinh(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

Fzpfncoh  {; Lee Skinner
  z = pixel, f = 1./cosh(pixel):
   z = fn1(z) + f,
    |z| <= 50
  }

 Fzpcopcs  {z = pixel, f = pixel ^ (1. / cosxx(pixel) ):
                        z = cosxx (z)  + f, |z| <= 50}

 Fzpcopct  {z = pixel, f = pixel ^ (cosxx(pixel) / sin(pixel) ):
                        z = cosxx (z)  + f, |z|<= 50}

 Fzpcophc  {z = pixel, f = pixel ^ (1. / cosh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcopsh  {z = pixel, f = pixel ^ (sinh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcopsq  {z = pixel, f = pixel ^ (sqr(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcopth  {z = pixel, f = pixel ^ (sinh(pixel) / cosh(pixel) ):
                        z = cosxx (z)+f,|z|<= 50}

 Fzppcos   {z = pixel, f = cosxx (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcota  {z = pixel, f = sin(pixel) / cosxx(pixel):
                       z = cosxx (z)  + f, |z|<= 50}

 Fzppcoth  {z = pixel, f = sinh(pixel) / cosh(pixel):
                       z = cosxx (z)+f,|z|<= 50}

 Fzpcoseh  {z = pixel, f = 1. / sinh(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppchco  {z = pixel, f = cosxx (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Zppchco8  {z = pixel, f = cosxx (pixel):
                       z = cosh (z) + f, |z|<=8192}

 Fzppchex  {z = pixel, f = exp (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppchsi  {z = pixel, f = sin (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppchsq  {z = pixel, f = sqr (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppcoch  {z = pixel, f = cosh (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcocoh  {z = pixel, f = 1. / cosh(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcoct  {z = pixel, f = cosxx(pixel) / sin(pixel):
                       z = cosxx (z)  + f, |z|<= 50}

 Fzppcohs  {z = pixel, f = sinh (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcolo  {z = pixel, f = log (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppexch  {z = pixel, f = cosh (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppexsh  {z = pixel, f = sinh (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppsich  {z = pixel, f = cosh (pixel):
                       z = sin (z)  + f, |z| <= 50}

 Fzppsish  {z = pixel, f = sinh (pixel):
                       z = sin (z)  + f, |z| <= 50}

 Fzppsisq  {z = pixel, f = sqr (pixel):
                       z = sin (z)  + f, |z| <= 50}

 Fzpcopch  {z = pixel, f = pixel ^ (cosh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcope  {z = pixel, f = pixel ^ (exp(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcopr  {z = pixel, f = pixel ^ (1. / pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcophs  {z = pixel, f = pixel ^ (1. / sinh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcopta  {z = pixel, f = pixel ^ (sin(pixel) / cosxx(pixel) ):
                        z = cosxx (z)  + f, |z|<= 50}

 Fzppcoht  {z = pixel, f = cosh(pixel) / sinh(pixel):
                       z = cosxx (z)+f,|z|<= 50}

 Fzppcops  {z = pixel, f = pixel ^ (sin(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcopht  {z = pixel, f = pixel ^ (cosh(pixel) / sinh(pixel) ):
                       z = cosxx (z)+f,|z|<= 50}

 Fzpcopse  {z = pixel, f = pixel ^ (1. / sin(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppchsh  {z = pixel, f = sinh (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppcocs  {z = pixel, f = 1. / cosxx(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcoex  {z = pixel, f = exp (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcopl  {z = pixel, f = pixel ^ (log(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcopo  {z = pixel, f = (pixel) ^ (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcore  {z = pixel, f = 1. / (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcose  {z = pixel, f = 1. / sin(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcosh  {z = pixel, f = cosh (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppcosi  {z = pixel, f = sin (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcosq  {z = pixel, f = sqr (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcosr  {z = pixel, f = (pixel) ^ 0.5:
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppexp   {z = pixel, f = exp (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppexsq  {z = pixel, f = sqr (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppshex  {z = pixel, f = exp (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppsico  {z = pixel, f = cosxx (pixel):
                       z = sin (z)  + f, |z| <= 50}

 Fzppsiex  {z = pixel, f = exp (pixel):
                       z = sin (z)  + f, |z| <= 50}

 Fzppsinh  {z = pixel, f = sinh (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppcopc  {z = pixel, f = pixel ^ (cosxx(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppchlo  {z = pixel, f = log (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppexco  {z = pixel, f = cosxx (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppexlo  {z = pixel, f = log (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppexsi  {z = pixel, f = sin (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppshch  {z = pixel, f = cosh (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppshco  {z = pixel, f = cosxx (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppshlo  {z = pixel, f = log (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppshsi  {z = pixel, f = sin (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppshsq  {z = pixel, f = sqr (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppsqlo  {z = pixel, f = log (pixel):
                       z = sqr (z)  + f, |z| <= 50}

 Fzppsqsh  {z = pixel, f = sinh (pixel):
                       z = sqr (z)  + f, |z| <= 50}

 Fzppsqsi  {z = pixel, f = sin (pixel):
                       z = sqr (z)  + f, |z| <= 50}

 Leeze (XAXIS) = {     s = exp(1.,0.), z = Pixel, f = Pixel ^ s:
                       z = cosxx (z) + f, |z| <= 50 }


comment = {  ;    #: 7363 S4/Fractal Sources
        ;    08-Dec-92 18:46:48
        ;    Sb: #Chaotic Liars
        ;    Fm: Chuck Ebbert 76306,1226
        ;    To: All
        ; Chaotic Liar formulas for FRACTINT.
        ; These formulas reproduce some of the pictures in the paper
        ;  'Pattern and Chaos: New Images in the Semantics of Paradox'
        ;  by Gary Mar and Patrick Grim of the Department of Philosophy,
        ;  SUNY at Stony Brook.
        ; Formulas by Chuck Ebbert  CIS [76306,1226]
        ; "...what is being graphed within the unit square is simply
        ;  information regarding the semantic behavior for different
        ;  inputs of a pair of English sentences:"
        ; }

Liar1 { ; by Chuck Ebbert.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
   z = pixel:
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) )
  |z| <= 1 ;
 }

Liar2 { ; by Chuck Ebbert.
        ; Same as Liar1 but use sequential reasoning, calculating
        ;  new y value using new x value.
        ; x(n+1) = 1 - abs(y(n)-x(n) );
        ; y(n+1) = 1 - abs((1-x(n+1) )-y(n) );
   z = pixel:
   x = 1 - abs(imag(z)-real(z))
   z = flip(1 - abs(1-real(x)-imag(z) ) ) + real(x)
  |z| <= 1;
 }

Liar3 { ; by Chuck Ebbert.
        ; X: X is true to P1 times the extent that Y is true
        ; Y: Y is true to the extent that X is false.
        ; Sequential reasoning.  P1 usually 0 to 1.  P1=1 is Liar2 formula.
        ; x(n+1) = 1 - abs(p1*y(n)-x(n) );
        ; y(n+1) = 1 - abs((1-x(n+1) )-y(n) );
   z = pixel:
   x = 1 - abs(imag(z)*real(p1)-real(z) )
   z = flip(1 - abs(1-real(x)-imag(z) ) ) + real(x)
  |z| <= 1;
}

Liar4 { ; by Chuck Ebbert.
        ; X: X is as true as (p1+1) times Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; Real part of p1 changes probability.  Use floating point.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = pixel, p = p1 + 1:
   z = 1-abs(imag(z)*p-real(z))+flip(1-abs(1-real(z)-imag(z)));
    |z| <= 1
    }

  {==========================================================================}
  {         File originally distributed with FRAC'Cetera Vol 2 Iss 6         }
  {==========================================================================
   =  From GRAPHDEV Fractal Sources forum messages - Dec-92.                =
   =  Chaotic Liars   Author: Chuck Ebbert        CIS: 76306,1226           =
   =  F'names,  where present,  are  FRAC'Cetera  created variations or     =
   =  derivatives based, sometimes quite loosely, on the author's originals =
   ==========================================================================}

  { Chaotic Liar formulas for FRACTINT.
    These formulas reproduce some of the pictures in the paper 'Pattern and
    Chaos: New Images in the Semantics of Paradox' by Gary Mar and Patrick
    Grim of the Department of Philosophy, SUNY at Stony Brook.

    "...what is being graphed within the unit square is simply information
    regarding the semantic behavior for different inputs of a pair of English
    sentences:" }

  { Fm: Dan Farmer 70703,1632
    I tried out the Chaotic Liar formulas.  Interesting.  Liar1 is rather dull,
    Liar2 gets better, and Liar3 is really interesting.  But, best of all, run
    Liar3 with Sound = z and floating point OFF.  Press "O" for orbits.  Great
    sound and a really different orbits display.
    I did discover that these types require floating point math.  I get either
    black screen or totally different results with integer math.    }


!_Press_F2_!     {; There is text in this formula file.  Shell to DOS with
                  ; the <d> key and use a text reader to browse the file.
                 }

F'Liar1 { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = pixel:
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) );
    fn1(abs(z))<p1 }

F'Liar1A { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = fn1(pixel):
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) );
    |z| <= p1 }

F'Liar1C { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = fn1(pixel):
   z = 1 - abs(imag(z)-real(z) ) + flip(1 - abs(1-real(z)-imag(z) ) );
    fn2(abs(z))<p1 }

F'Liar1D { ; Generalization by Jon Horner of Chuck Ebbert formula.
        ; X: X is as true as Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = fn1(pixel):
   z = p1 - abs(imag(z)-real(z) ) + flip(p2 - abs(1-real(z)-imag(z) ) );
    |z| <1 }

M-SetInNewton(XAXIS) {; use float=yes
                      ; jon horner 100112,1700, 12 feb 93
  z = 0,  c = pixel,  cminusone = c-1:
  oldz = z,  nm = 3*c-2*z*cminusone, dn = 3*(3*z*z+cminusone),
  z = nm/dn+2*z/3,   |(z-oldz)|>=|0.01|
 }

F'M-SetInNewtonA(XAXIS) {; use float=yes
                      ; jon horner 100112,1700, 12 feb 93
  z = 0,  c = fn1(pixel),  cminusone = c-1:
  oldz = z, nm = p1*c-2*z*cminusone, dn = p1*(3*z*z+cminusone),
  z = nm/dn+2*z/p1, |(z-oldz)|>=|0.01|
 }

; #: 14384 S4/Fractal Sources
;    16-Feb-93 15:55:32
;Sb: #14099-Newtons Mandelbrot
;Fm: Chuck Ebbert 76306,1226
;To: Jon Horner 100112,1700 (X)

;Jon, your formula led to these:

F'M-SetInNewtonB(XAXIS) { ; use float=yes, periodicity=no
  ; set p1 >= 3, 1e-30 < p2 < .01
  z=0, c=fn1(pixel), cm1=c-1, cm1x2=cm1*2, twoop1=2/p1, p1xc=c*real(p1):
   oldz = z,
   z= (p1xc - z*cm1x2 )/( (sqr(z)*3 + cm1 ) * real(p1) ) + z*real(twoop1),
    |z - oldz| >= p2
 }

 F'M-SetInNewtonC(XAXIS) { ; same as F'M-SetInNewtonB except for bailout
  ; use float=yes, periodicity=no
  ; (3 <= p1 <= ?) and (1e-30 < p2 < .01)
  z=0, c=fn1(pixel), cm1=c-1, cm1x2=cm1*2, twoop1=2/p1, p1xc=c*real(p1):
   z = (p1xc - z*cm1x2 )/( (sqr(z)*3 + cm1 ) * real(p1) ) + z*real(twoop1),
    abs(|z| - real(lastsqr) ) >= p2
 }


comment {
  This Fractint formula file is by Bradley Beacham, (c) April 1994.
  I encourage you to copy and distribute it, but only if it is unaltered.
  If you make changes to any of these formulas, please put your changes in
  a new '.FRM' file.

  Early versions of most of these formulas have already been released in
  either BLB.FRM or MONGO.FRM.  This file collects them in an improved
  format and adds ten new formulas.

  The parameter file OVERKILL.PAR has many examples of the images I have
  created with these formulas, as well as lots of other fractal types.
  
  I welcome any comments.  Reach me at:

    CIS: 74223,2745    Internet: 74223,2745@compuserve.com

    U.S. Mail: Bradley Beacham
               1343 S. Tyler
               Salt Lake City, Utah  84105
               U.S.A.
  
  NOTE: You'll usually get more interesting results by using floating-point
        math.  
}

{-------------------------------------------------------------------------}

comment {
  Earlier versions of the formulas OK-01 to OK-22 appeared in the file
  BLB.FRM (June 1993), where they were named BLB-1 to BLB-22.  In these
  'improved' versions, I added default values for any numeric parameters
  you may supply, so you don't get a blank screen by leaving them at zero.

  These were my first attempts at inventing new formulas.  I basically used
  the 'monkey-pounding-on-the-keyboard' technique, but still got some
  interesting results.
}

OK-01 { ;TRY P1 REAL = 10000, FN1 = SQR
   z = 0, c = pixel:
   z = (c^z) + c;
   z = fn1(z),
   |z| <= (5 + p1)
  }

OK-02 { ;TRY FN1 = COTAN
   z = c = pixel, k = 1 + p1:
   z = (c^z) + c;
   z = fn1(z) * k,
   |z| <= (5 + p2)
  }

OK-03 { ;TRY P1 REAL = 500, FN1 = COS, FN2 = SQR
   z = c = pixel:
   z = fn1(z)/c;
   z = fn2(z),
   |z| <= (5 + p1)
  }

OK-04 { ;TRY FN2 = SQR, DIFFERENT FUNCTIONS FOR FN1
   z = 0, c = fn1(pixel):
   z = fn2(z) + c,
   |z| <= (5 + p1)
  }

OK-05 {
   z = pixel, k = -2,2 + p1:
   z = (z^k + z) / k,
   (1 + p2) <= |z|
  }

OK-06 { ;TRY FN1 = SQR, FN2 = SQR
   z = c = pixel, d = fn1(pixel):
   z = fn2(z / d) + c 
   |z| <= (5 + p1)
  }

OK-07 {
   z = 0, c = pixel:
   z = c * (z + c);
   z = fn1(z + c),
   |z| <= (5 + p1)
  }

OK-08 {
   z = pixel, c = fn1(pixel):
   z = z^z / fn2(z);
   z = c / z,
   |z| <= (5 + p1)
  }

OK-09 {
   z = c = pixel, d = fn1(pixel), k = 1 + p1:
   z = z^c * k;
   z = d / z,
   |z| <= (5 + p2)
  }

OK-10 {
   z = 0, c = pixel, k1 = 1 + p1, k2 = 1 + p2:
   z = (z * k1) + c;
   z = fn1(z) / (k2 + c),
   |z| <= (k2)
  }

OK-11 { ;TRY FN1 = SQR, FN2 = SQR
   z = 0, v = pixel:
   z = fn1(v) + z;
   v = fn2(z) + v,
   |z| <= (5 + p1)
  }

OK-12 { ;TRY FN1 = SQR, FN2 = SQR
   z = c = pixel:
   z = fn1(z) + c;
   z = fn2(z) / c,
   |z| <= (5 + p1)
  }

OK-13 { ;TRY FN1 = SQR, FN2 = SQR
   z = 0, c = fn1(pixel) :
   z = fn1(z) + c;
   z = fn2(z),
   |z| <= (5 + p1)
  }

OK-14 { ;FOUR FUNCTIONS TO PLAY WITH HERE.  GO CRAZY.
   z = 0, c = pixel :
   z = fn1(z+c) + c;
   z = fn2(z-c) + c;
   z = fn3(z*c) + c;
   z = fn4(z/c) + c,
   |z| <= (5 + p1)
  }

OK-15 {
   z = 0, v = pixel :
   z = fn1(v*z) + v;
   v = fn2(v/z),
   |z| <= (5 + p1)
  }

OK-16 {
   z = v = pixel :
   z = fn1(z)^v;
   v = v + z,
   |z| <= (5 + p1)
  }

OK-17 {
   z = c = pixel, r = real(pixel), i = imag(pixel):
   z = z^r + z^i + c;
   z = z + real(fn1(z)) + imag(fn2(z)),
   |z| <= (5 + p1)
  }

OK-18 {
   z = v = pixel:
   z = fn1(v) + real(z);
   v = fn2(z) + imag(v),
   |z| <= (5 + p1)
  }
  
OK-19 {
   a = b = z = pixel:
   a = fn1(b) + fn2(z);
   b = fn1(z) + fn2(a);
   z = fn1(a) + fn2(b),
   |z| <= (5 + p1)
  }

OK-20 {
   a = b = c = z = pixel:
   a = fn1(b) + c^z;
   b = fn2(a+c);
   z = z + (a * b * c),
   |z| <= (5 + p1)
  }

OK-21 {
   z = pixel, c = fn1(pixel):
   z = fn2(z) + c,
   fn3(z) <= p1
  }

OK-22 {
   z = v = pixel:
   v = fn1(v) * fn2(z);
   z = fn1(z) / fn2(v),
   |z| <= (5 + p1)
  }

{-------------------------------------------------------------------------}

comment {
  Earlier versions of the formulas OK-23 to OK-35 appeared in the file
  MONGO.FRM (August 1993), where they were named MONGO-01 to MONGO-13.  In
  these 'improved' versions, I added default values for any numeric
  parameters you may supply, so you don't get a blank screen by leaving
  them at zero.

  Most of these formulas are experiments with a crude sort of IF/ELSE
  logic (an idea I swiped from Jon Osuch's SELECT.FRM) and produce images
  with interesting discontinuities.
}

OK-23 {
   z = c = pixel, k = 1 + p1:
   z = k * fn1(z^z + c) + c/z,
   |z| <= (5 + p2)
  }

OK-24 { ;TRY P1 REAL = -2, FN1 = SQR, FN2 = RECIP
   z = 0, c = pixel, k = 1 + p1:
   z = fn2(fn1(z) + c) + (k * z),
   |z| <= (5 + p2)
  }

OK-25 {
   z = c = pixel, k = 1 + p1:
   a = (abs(z) > k)  * (fn1(z) + c);
   b = (abs(z) <= k) * (fn2(z) + c);
   z = a + b,
   |z| <= (5 + p2)
  }

OK-26 {
   z = c = pixel, k = 2 + p1, test = k/(2 + p2):
   a = fn1(z);
   b = (|z| > test)  * (a - c);
   d = (|z| <= test) * (a + c);
   z = b + d,
   |z| <= k
  }

OK-27 {
   z = pixel, c = fn1(pixel), k = 1 + p1:
   a = fn2(z);
   b = (|z| >= k) * (a - c);
   d = (|z| < k) * (a + c);
   z = a + b + d,
   |z| <= (10 + p2)
  }

OK-28 {
   z = c = pixel, d = fn1(pixel), k = p1:
   a = fn2(z);
   b = (z <= k) * (a + c + d);
   e = (z > k) * (a + c - d);
   z = z + b + e,
   |z| <= (10 + p2)
  }

OK-29 {
   z = v = pixel, k = 1 + p1:
   oldz = z;
   z = fn1(z)^k + v;
   v = oldz,
   |z| <= (5 + p2)
  }

OK-30 {
   z = v = pixel, k = .5 + p1:
   a = fn1(z);
   b = (z <= k) * (a + v);
   e = (z > k) * (a - v);
   v = z;
   z = b + e,
   |z| <= (5 + p2)
  }

OK-31 {
   z = v = pixel, k = .1 + p1:
   a = fn1(z);
   b = (a <= k) * (a + v);
   e = (a > k) * fn2(a);
   v = z;
   z = b + e,
   |z| <= (5 + p2)
  }

OK-32 {
   z = y = x = pixel, k = 1 + p1:
   a = fn1(z);
   b = (a <= y) * ((a * k) + y);
   e = (a > y) * ((a * k) + x);
   x = y;
   y = z;
   z = b + e,
   |z| <= (5 + p2)
  }

OK-33 {
   z = y = x = pixel, k = 1 + p1:
   a = (|y| <= k) * fn1(y);
   b = (|x| <= k) * fn2(x);
   x = y;
   y = z;
   z = fn3(z) + a + b,
   |z| <= (10 + p2)
  }

OK-34 {
   z = pixel, c = (fn1(pixel) * p1):
   x = abs(real(z));
   y = abs(imag(z));
   a = (x <= y) * (fn2(z) + y + c);
   b = (x > y) * (fn2(z) + x + c);
   z = a + b,
   |z| <= (10 + p2)
  }

OK-35 {
   z = pixel, k = 1 + p1:
   v = fn1(z);
   x = (z*v);
   y = (z/v);
   a = (|x| <= |y|) * ((z + y) * k);
   b = (|x| > |y|) * ((z + x) * k);
   z = fn2((a + b) * v) + v,
   |z| <= (10 + p2)
  }

{-------------------------------------------------------------------------}

comment {
  The remaining formulas, OK-36 to OK-45, are new to OVERKILL.FRM.  Some of
  these formulas use an approach I call 'disection' (for lack of a better
  term), and were inspired by a nifty CD-ROM called "Fractal Ecstasy".
  (It's made by Deep River Publishing.)

  Anyway, the idea is to calculate the real and imaginary parts of complex
  numbers separately using standard algebra.  The advantage is that
  variables and functions can be applied in ways that would be difficult
  using the conventional approach.  The disadvantage is that the formula is
  more complicated.

  Suggestion:  When you experiment with the 'disected' formulas, start by
  setting all functions to IDENT.  Then change one or two of the parameters
  at a time.
}

OK-36 { ; DISECTED MANDELBROT
  ; TO GENERATE "STANDARD" MANDELBROT, SET P1 = 0,0 & ALL FN = IDENT
  z = pixel, cx = fn1(real(z)), cy = fn2(imag(z)), k = 2 + p1:
  zx = real(z), zy = imag(z);
  x = fn3(zx*zx - zy*zy) + cx;
  y = fn4(k * zx * zy) + cy;
  z = x + flip(y),
  |z| <  (10 + p2)
}

OK-37 { ; ANOTHER DISECTED MANDELBROT
  ; TO GENERATE "STANDARD" MANDELBROT, SET P1 = 0,0 & ALL FN = IDENT
  z = pixel, c = fn1(fn2(z)), cx = real(c), cy = imag(c), k = 2 + p1:
  zx = fn3(real(z)), zy = fn4(imag(z));
  x = zx*zx - zy*zy + cx;
  y = k * zx * zy + cy;
  z = x + flip(y),
  |z| <  (10 + p2)
}

OK-38 { ; DISECTED CUBIC MANDELBROT
  ; TO GENERATE "STANDARD" CUBIC MANDELBROT, SET P1 = 0,0 & ALL FN = IDENT
  z = pixel,  cx = fn1(real(pixel)), cy = fn2(imag(pixel)), k = 3 + p1:
  zx = real(z), zy = imag(z);
  x = fn3(zx*zx*zx - k*zx*zy*zy) + cx;
  y = fn4(k*zx*zx*zy - zy*zy*zy) + cy;
  z =  x + flip(y),
  |z| <  (4 + p2)
}

OK-39 { ; JUST AN EXPERIMENT
  z = pixel, c = fn1(z), k = p1:
  z = fn2(z*c + k) + c,
  |z| <= (20 + p2)
 }

OK-40 { ; DISECTED OK-39
  ; (ASSUMING YOU USE OK-39 WITH FN1= IDENT & FN2 = SQR...)
  z = pixel, cx = fn1(real(pixel)), cy = fn2(imag(pixel)), k = 2 + p1:
  zx = real(z), zy = imag(z);
  a = zx*cx - zy*cy;
  b = cx*zy + zx*cy;
  x = fn3(a*a - b*b) + cx;
  y = fn4(k*a*b) + cy;
  z = x + flip(y),
  |z| <= (10 + p2)
}

OK-41 { ; DISECTED MANDELLAMBDA
  z = 0.5 + p1, lx = fn1(real(pixel)), ly = fn2(imag(pixel)):
  zx = real(z), zy = imag(z);
  x = fn3(lx*zx + 2*ly*zx*zy - ly*zy - lx*zx*zx + lx*zy*zy);
  y = fn4(ly*zx - 2*lx*zx*zy + lx*zy - ly*zx*zx + ly*zy*zy);
  z = x + flip(y),
  |z| <= (10 + p2)
}

OK-42 { ; MUTATION OF FN + FN
  z = pixel, p1x = real(p1)+1, p1y = imag(p1)+1,
  p2x = real(p2)+1, p2y = imag(p2)+1:
  zx = real(z), zy = imag(z);
  x = fn1(zx*p1x - zy*p1y) + fn2(zx*p2x - zy*p2y);
  y = fn3(zx*p1y + zy*p1x) + fn4(zx*p2y + zy*p2x);
  z = x + flip(y),
  |z| <= 20
}

OK-43 { ; DISECTED SPIDER
  ; TO GENERATE "STANDARD" SPIDER, SET P1 = 0,0 & ALL FN = IDENT
  z = c = pixel, k = 2 + p1:
  zx = real(z), zy = imag(z);
  cx = real(c), cy = imag(c);
  x = fn1(zx*zx - zy*zy) + cx;
  y = fn2(k*zx*zy) + cy;
  z = x + flip(y);
  c = fn3((cx + flip(cy))/k) + z,
  |z| <  (10 + p2)
}

OK-44 { ; DISECTED MANOWAR
  ; TO GENERATE "STANDARD" MANOWAR, SET P1 = 0,0 & ALL FN = IDENT
  z = pixel, z1x = cx = real(pixel), z1y = cy = imag(pixel),
  k = 2 + p1:
  oldzx = zx = real(z), oldzy = zy = imag(z);
  x = fn1(zx*zx - zy*zy) + fn2(z1x) + cx;
  y = fn3(k*zx*zy) + fn4(z1y) + cy;
  z = x + flip(y);
  z1x = oldzx, z1y = oldzy,
  |z| <= (10 + p2)
}

OK-45 { ; ANOTHER LITTLE QUICKY
  z = pixel, c = fn1(pixel), ka = 1 + p1, kb = 1 + p2:
  a = fn2(z), b = fn3(z);
  z = ka*a*a*a + kb*b*b + c,
  |z| <= 10
 }

comment = {
The formula given below generates a variation of the Phoenix curve, which    
Shigehiro Ushiki at Kyoto University first discovered.  Use it with the 
Fractint Formula Compiler.
}
   Phoenix = {
      x = pixel; y = 0.0:
      z = (x * x) + p1 + (p2 * y);
      y = x;
      x = z;
}

comment = {
The original Phoenix curve uses 0.56667 for the real part of p1, 
and -0.5 for the real part of p2.

FRACTALS IN C, by Dr. Roger Stevens, has a chapter covering the
Phoenix curve.  The author suggests trying the following for p1 and p2.

  p1                  p2

0.288732          0.5510029
0.356338          -1.209169
-0.550704         -1.255014

Kriston Scott
}
comment {
  begin pjhcon.frm
}
comment {
        This series of formulas was inspired by a reference in Pickover's
        Computers, Chaos, Patterns and Beauty to a conjugate Mandelbrot set.
        I did not have access to the book he referred to, but I figured you 
        just substituted conj(z) for z in the formula for the Mandelbrot set.
        
 }
MandelConj(XAXIS) {; Paul J. Horn , this was mentioned in Pickover's book 
; Compurers, Chaos, Patterns and Beauty.  He didn't give the forumula, so  
; I came up with this
  z = c = Pixel:  ; 
  z = Sqr(conj(z)) + Pixel ,
   |z| <= 4          ; 
  }

MandConj01(XAXIS) {; Paul J. Horn, see MandelConj.  
; This is a variation on a theme.
  z = c = Pixel:  ; 
  z = Sqr(z) + Conj(Pixel) ,
   |z| <= 4          ; 
  }

MandConj02(XAXIS) {; Paul J. Horn, see MandelConj. 
; Another variation on the theme. 
  z = c = Pixel:  ; 
  z = Sqr(Conj(z)) + Conj(Pixel) ,
   |z| <= 4          ; 
  }

MandConj03(XAXIS) {; Paul J. Horn 
; yet another variation on the theme 
  z = c = Pixel:  ; 
  z = Sqr(conj(z))*conj(z) + Pixel ,
   |z| <= 4          ; 
  }

MandConj04(XAXIS) {; Paul J. Horn 
; yet another variation on the theme 
  z = c = Pixel:  ; 
  z = Sqr((z))*(z) + Conj(Pixel) ,
   |z| <= 4          ; 
  }

MandConj05(XAXIS) {; Paul J. Horn 
; yet another variation on the theme 
  z = c = Pixel:  ; 
  z = Sqr(conj(z))*conj(z) + Conj(Pixel) ,
   |z| <= 4          ; 
  }

MandConj06(XAXIS) {; Paul J. Horn 
; yet another variation on the theme 
  z = c = Pixel:  ; 
  z = Sqr(Sqr(conj(z))) + Pixel ,
   |z| <= 4          ; 
  }

MandConj07(XAXIS) {; Paul J. Horn 
; yet another variation on the theme 
  z = c = Pixel:  ; 
  z = Sqr(Sqr((z))) + Conj(Pixel) ,
   |z| <= 4          ; 
  }

MandConj08(XAXIS) {; Paul J. Horn 
; yet another variation on the theme 
  z = c = Pixel:  ; 
  z = Sqr(Sqr(conj(z))) + Conj(Pixel) ,
   |z| <= 4          ; 
  }

MandConj09  {; Paul J. Horn 
; yet another variation on the theme 
  z = c = Pixel:  ; 
  z = (conj(z))^p1 + Pixel ,
   |z| <= 4          ; 
  }

MandConj10  {; Paul J. Horn 
; yet another variation on the theme 
  z = c = Pixel:  ; 
  z = z^p1 + Conj(Pixel) ,
   |z| <= 4          ; 
  }

MandConj11 {; Paul J. Horn 
; yet another variation on the theme 
  z = c = Pixel:  ; 
  z = (conj(z))^p1 + Conj(Pixel) ,
   |z| <= 4          ; 
  }

ConjMandelbrot(XAXIS) { ; Paul J. Horn
; This uses the last square function and should be the same as
; MandelConj, but with inside=bof60 and outside=summ and zooms
; it does not.
  z = Pixel, z = Sqr(conj(z)):
  z = z + Pixel
  z = Sqr(conj(z))
  LastSqr <= 4
  }

JuliaConj(Origin) {; Paul J. Horn - a conjugate Julia (I think)
  ; try real part of p1 = -1.1 and imag part of p1 = .09
  z = pixel:  ; 
   z = Sqr(conj(z)) + P1 ,
   |z| <= 4          ; 
  }

JuliConj01(Origin) {; Paul J. Horn - a conjugate Julia (I think)
  ; Try real(p1) = -.93, imag(p1) = .3, map = blues
  z = pixel:  ; 
   z = Sqr(z) + Conj(P1) ,
   |z| <= 4          ; 
  }

JuliConj02(Origin) {; Paul J. Horn - a conjugate Julia (I think)
  ; Try real(p1) = .3, imag(p1) = .25, map = neon
  z = pixel:  ; 
   z = Sqr(Conj(z)) + Conj(P1) ,
   |z| <= 4          ; 
  }

JuliConj03 {; Paul J. Horn - a conjugate Julia (I think)
  ; Try real(p1) = .40, imag(p1) = 0, map = glasses2
  z = pixel:  ; 
   z = Sqr(conj(z))*conj(z) + P1 ,
   |z| <= 4          ; 
  }

JuliConj04 {; Paul J. Horn - a conjugate Julia (I think)
  ;Try real(p1) = .53, imag(p1) = .63, map = volcano 
  z = pixel:  ; 
   z = Sqr(z)*z + Conj(P1) ,
   |z| <= 4          ; 
  }

JuliConj05 {; Paul J. Horn - a conjugate Julia (I think)
  ; Try real(p1) = .6, imag(p1) = .4, map = chroma
  z = pixel:  ; 
   z = Sqr(conj(z))*conj(z) + Conj(P1) ,
   |z| <= 4          ; 
  }

JuliConj06(Origin) {; Paul J. Horn - a conjugate Julia (I think)
  ; Try real(p1) = .99, imag(p1) = .72
  z = pixel:  ; 
   z = Sqr(Sqr((conj(z)))) + P1 ,
   |z| <= 4          ; 
  }

JuliConj07(Origin) {; Paul J. Horn - a conjugate Julia (I think)
  ; Try real(p1) = -.245, imag(p1) = .44, map = royal
  z = pixel:  ; 
   z = Sqr(Sqr(z)) + Conj(P1) ,
   |z| <= 4          ; 
  }

JuliConj08(Origin) {; Paul J. Horn - a conjugate Julia (I think)
  ; Try real(p1) = -1, imag(p1) = .11, map = blues
  z = pixel:  ; 
   z = Sqr(Sqr((conj(z)))) + Conj(P1) ,
   |z| <= 4          ; 
  }

JuliConj09 {; Paul J. Horn - a conjugate Julia (I think)
  ; Try real(p1) = -.677, imag(p1) = .333, real(p2) = 9, map = blues
  z = pixel:  ; 
   z = (conj(z))^P2 + P1 ,
   |z| <= 4          ; 
  }

JuliConj10 {; Paul J. Horn - a conjugate Julia (I think)
  ; Try real(p1) = .1005, imag(p1) = .68, real(p2) = 5, map = chroma
  z = pixel:  ; 
   z = (z)^P2 + Conj(P1) ,
   |z| <= 4          ; 
  }

JuliConj11 {; Paul J. Horn - a conjugate Julia (I think)
  ; Try real(p1) = -.37, imag(p1) = .6, real(p2) = 6, map = volcano
  z = pixel:  ; 
   z = (conj(z))^P2 + Conj(P1) ,
   |z| <= 4          ; 
  }

comment {
  end pjhcon.frm
}
The picture 'quad.gif' is a fractal created with Fractint that shows
some of the weirder things that can be done inside Fractint's type=
formula option.  It's based on this formula:

    test { 
        z = 0, c=pixel: 
        z = sqr(z)+c, 
        c=c+p1/z, 
        |z| <= 4 
        } 

wherein the value of c is changed each iteration by adding p1/z.  Dan
Farmer introduced Boolean arithmetic into this system with:

    testm { 
        z = 0, c=pixel: 
        z = sqr(z)+c, 
        c=c+(p1 * (|z| <= p2)) 
        |z| <= 4 
        } 

Now, the value of c is altered depending on whether or not |z| is less
than the parameter p2.  To expand on this idea, I made quad.gif using
this formula:

quadrants {
	z=0, c=pixel,
	r1=(0.0,1.0), r2=(-1.0,0.0), r3=(0.0,-1.0), r4=1:
	z=sqr(z)+c,
	x=real(z), y=imag(z),
	xp=(0 < x), xn=(x < 0), yp=(0 < y), yn=(y < 0),
	k1=xp*yp, k2=xn*yp, k3=xn*yn, k4=xp*yn,
	k=k1*r1+k2*r2+k3*r3+k4*r4,
	c=c+k*p1/z,
	|z| <= 4
	}

What happens is that there are 4 coefficients, r1 through r4,
corresponding to i, i^2, i^3, and i^4, where i*i = -1.  For each
iteration, z is split into its real and imaginary parts x and y.
The xp, xn, yp, and yn are used to determine whether x and y are
positive or negative.  These are combined into k1 through k4.  Only
one of these 4 will equal 1:  k1 = 1 if z is in the first quadrant
(x > 0, y > 0); k2 = 1 if z is in the second quadrant, etc.  The other
3 k's will all be 0.  The k's are incorporated into one coefficient
k.  If z lies in the first quadrant, k = i.  If z lies in the second
quadrant, k = -1.  Similarly for the third and fourth quadrants.
Finally, c is adjusted by k*p1/z, giving a different type of adjustment
to c each iteration, depending on the quadrant of z.

The results are shown in quad.gif, which is 320 x 200 x 256 colors.

Kerry Mitchell
comment {
The fractals in this file are some of my first attempts
at using the formula complier.  (At least those I was willing
to show others <G>).  Comments are welcome as always!
The accompanying parameter file (RCL.PAR) provides a simple
example generated from each formula.

Ron Lewen
CIS: 76376,2567 
 }

RCL_Cross1  { ; Ron Lewen
  ; Try p1=(0,1), fn1=sin and fn2=sqr.  Set corners at
  ; -10/10/-7.5/7.5 to see a cross shape.  The larger 
  ; lakes at the center of the cross have good detail
  ; to zoom in on.
  ; Use floating point.
  ;
  z=pixel:
    z=p1*fn1(fn2(z+p1)),
      |z| <= 4
  }

RCL_Cross2 { ; Ron Lewen
  ; Try p1=(0,1), fn1=sin and fn2=sqr.  Set corners at
  ; -10/10/-7.5/7.5 to see a deformed cross shape. 
  ; The larger lakes at the center of the cross have
  ; good detail to zoom in on.
  ; Try corner=-1.58172/.976279/-1.21088/-.756799 to see
  ; a deformed mandelbrot set.
  ; Use floating point.
  ;
  z=pixel:
    z=pixel*fn1(fn2(z+p1)),
      |z| <= 4
  }

RCL_Mandel (XAXIS) { ; Ron Lewen
  ; The traditional Mandelbrot formula with a different
  ; escape condition.  Try p1=(1,0).  This is basically the M-Set
  ; with more chaos outside.  p1=(0,0) yields a distorted M-set.
  ; Use floating point
  ;
  z=pixel:
    z=sqr(z) + pixel,
      sin(z) <= p1
  }

RCL_Logistic_1 (XAXIS) { ; Ron Lewen
  ; Based on logistic equation  x -> c(x)(1-x) used
  ; to model animal populations.  Try p1=(3,0.1) to
  ; see a family of spiders out for a walk <G>!
  ;
  z=pixel:
    z=p1*z*(1-z),
      |z| <= 1
  }

RCL_Pick1 (XAXIS) { ; Ron Lewen
  ; Try corners=2.008874/-3.811126/-3.980167/3.779833/
  ; -3.811126/3.779833 to see Figure 9.7 (P. 123) in 
  ; Pickover's Computers, Pattern, Chaos and Beauty.
  ; Figures 9.9 - 9.13 can be found by zooming.
  ; Use floating point
  ;
  z=0:
    z=cosh(z) + pixel,
      abs(z) < 40
  }

RCL_Pick2_M (XAXIS) { ; Ron Lewen
  ; Generates a biomorph of a Pseudo-Mandelbrot set with
  ; extra tails.  Part of Pickover's Biomorph Zoo Collection
  ; Formula is adapted from Pickover's book, Figure 8.9
  ; (p. 105) but the result is different.  Set corners=
  ; -2.640801/1.359199/-1.5/1.5 to center image.  I use the
  ; color map that comes as default in WINFRACT. (I guess I
  ; like purple <G>).
  ; Use floating point
  ;
  z=pixel:
    z=sin(z) + z^2 + pixel,
      |real(z)| < 100 || |imag(z)| < 100
  }
 
RCL_Pick2_J { ; Ron Lewen
  ;  A julia set based on the formula in Figure 8.9
  ;  (p. 105) of Pickover's book.  Very similar to 
  ;  the Frontpiece for Appendix A.
  ;
  z=pixel:
    z=sin(z) + z^2 + p1,
      abs(real(z)) < 100 || abs(imag(z)) < 100
  }

RCL_Pick3 (XAXIS) { ; Ron Lewen
  ; Generates Figure 9.18 (p. 134) from Pickover's book.
  ; Set maxiter >= 1000 to see good detail in the spirals
  ; in the three large lakes.  Also set inside=0.
  ;
  z=0.5:
    z=z*pixel-pixel/sqr(z),
      abs(z) < 8
  }

RCL_Pick4 (XAXIS) { ; Ron Lewen
  ; Variation of formula for Figure 9.18 (p. 134) from Pickover's
  ; book.
  ; Set inside=0 to see three large lakes around a blue "core".
  ;
  z=pixel:
    z=z*pixel-pixel/sqr(z),
      |z| <= 4
  }

RCL_Pick5 (XAXIS) { ; Ron Lewen
  ;
  ; Adapted from Pickover's Biomorph Zoo Collection in
  ; Figure 8.7 (p. 102).
  ;
  z=pixel:
    z=z^z + z^5 + pixel,
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_Pick6 (XAXIS) { ; Ron Lewen
  ;
  ; Adapted from Pickover's Biomorph Zoo Collection in
  ; Figure 8.7 (p. 102).
  ;
  z=pixel:
    z=z^z + z^6 + pixel,
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_Pick7 (XAXIS) { ; Ron Lewen
  ;
  ; Adapted from Pickover's Biomorph Zoo Collection in
  ; Figure 8.7 (p. 102).
  ;
  z=pixel:
    z=z^5 + pixel,
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_Pick8 (XAXIS) { ; Ron Lewen
  ;
  ; Adapted from Pickover's Biomorph Zoo Collection in
  ; Figure 8.7 (p. 102).
  ;
  z=pixel:
    z=z^3 + pixel,
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_Pick9 (XAXIS) { ; Ron Lewen
  ;
  ; Adapted from Pickover's Biomorph Zoo Collection in
  ; Figure 8.7 (p. 102).
  ;
  z=pixel:
    z=sin(z) + 2.71828^z + pixel,
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_Pick10 (XAXIS) { ; Ron Lewen
  ;
  ;  Variation of Figure 9.18 (p.134) from Pickover's
  ;  Book.  Generates an interesting Biomorph.
  ;
  z=pixel:
    z=z/pixel-pixel*sqr(z),
      abs(z) < 8
  }

RCL_Pick11 (XAXIS) { ; Ron Lewen
  ;
  ;  Formula from Figure 8.3 (p. 98) of Pickover's
  ;  book.  Generates a biomorph.  Figure 8.3 is a
  ;  zoom on one of the shapes at the corner of the
  ;  biomorph.
  ;
  ;  Use Floating Point
  ;
  z=pixel:
    z=z^2+0.5
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_Pick12 { ; Ron Lewen
  ;
  ;  Formula from Figure 12.7 (p. 202) of Pickover's
  ;  book.
  ;
  ;  Use Floating Point
  ;
  z=pixel:
    z=(2.71828^(p1)) * z * (1-z),
      abs(real(z)) < 10 || abs(imag(z)) < 10
  }

RCL_Pick13 { ; Ron Lewen
  ;
  ;  Formula from Frontpiece for Appendix C 
  ;  and Credits in Pickover's book.
  ;  Set p1=(3,0) to generate the Frontpiece
  ;  for Appendix C and to (2,0) for Credits
  ;
  ;  Use Floating Point
  ;
  z=.001:
    z=z^p1+(1/pixel)^p1,
      |z| <= 100
  }

RCL_1 (XAXIS) { ; Ron Lewen
  ;
  ;  An interesting Biomorph inspired by Pickover's
  ;  Computers, Pattern, Choas and Beauty.
  ;
  ;  Use Floating Point
  ;
  z=pixel:
    z=pixel/z-z^2,
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_2 (XAXIS) { ; Ron Lewen
  ;
  ;  A biomorph flower?  Simply a change in initial
  ;  conditions from RCL_1 above
  ;
  ;  Use Floating Point
  ;
  z=1/pixel:
    z=pixel/z-z^2
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_3 (XAXIS) { ; Ron Lewen
  ;
  ;  A seemingly endless vertical pattern.  The most activity
  ;  is around the center of the image.
  ;
  ;  Use Floating Point
  ;
  z=pixel:
    z=pixel^z+z^pixel,
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_Quaternion_J (ORIGIN) { ; Ron Lewen
  ;
  ;  From Pseudocode 10.5 (p. 169) of Pickover's book.
  ;  Looks at Julia set for a0,a2 plane.  p1 selects
  ;  slice in to look at.
  ;  p2 correspondes to a point on the Quaternion
  ;  Mandelbrot set (see below).
  ;  Try (-.745,.113) as a starting point.
  ;
    a0=real(pixel), a2=imag(pixel), a1=real(p1), a3=imag(p1):
    savea0=a0^2-a1^2-a2^2-a3^2+p2
    savea2=2*a0*a2+p2
    a0=savea0
    a2=savea2
      (a0^2+a1^2+a2^2+a3^2) <= 2
  }

RCL_Quaternion_M (XAXIS) { ; Ron Lewen
  ;
  ;  From Pseudocode 10.5 (p. 169) of Pickover's book.
  ;  Looks at Mandelbrot set for a0,a2 plane.
  ;  p1 selects slice in to look at.  p1 should
  ;  not be (0,0) (this yields a blank screen!).
  ;
    a0=a2=pixel, a1=real(p1), a3=imag(p1):
    savea0=a0^2-a1^2-a2^2-a3^2+pixel
    savea2=2*a0*a2+pixel
    a0=savea0
    a2=savea2
      (a0^2+a1^2+a2^2+a3^2) <= 2
  }

comment {
This file includes the formulas required to support the file
RCLPAR.PAR.

In addition, I have included a number of additional formulas
for your enjoyment <G>.

Ron Lewen
CIS: 76376,2567

  }

RCL_Cosh (XAXIS) { ; Ron Lewen, 76376,2567
  ; Try corners=2.008874/-3.811126/-3.980167/3.779833/
  ; -3.811126/3.779833 to see Figure 9.7 (P. 123) in
  ; Pickover's Computers, Pattern, Chaos and Beauty.
  ; Figures 9.9 - 9.13 can be found by zooming.
  ; Use floating point
  ;
  z=0:
    z=cosh(z) + pixel,
      abs(z) < 40
  }

Mothra (XAXIS) { ; Ron Lewen, 76376,2567
  ; Remember Mothra, the giant Japanese-eating moth?
  ; Well... here he (she?) is as a fractal!
  ;
  z=pixel:
    a=z^5 + z^3 + z + pixel
    b=z^4 + z^2 + pixel
    z=b^2/a,
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_11 { ; Ron Lewen, 76376,2567
  ; A variation on the formula used to generate
  ; Figure 9.18 (p. 134) from Pickover's book.
  ; P1 sets the initial value for z.
  ; Try p1=.75, or p1=2, or just experiment!
  ;
  z=real(p1):
    z=z*pixel-pixel/sqr(z)
    z=flip(z),
      abs(z) < 8
  }

RCL_4_M (XAXIS) { ; Ron Lewen, 76376,2567
  ; A Mandelbrot-style variation on Pickover's book,
  ; Figure 8.9 (p. 105).
  ;
  ; Use floating point
  ;
  z=pixel:
    z=sin(z^2) + sin(z) + sin(pixel),
      |z| <= 4
  }

RCL_4_J { ; Ron Lewen, 76376,2567
  ;  A julia-style variation of the formula in Figure 8.9
  ;  (p. 105) of Pickover's book.
  ;
  z=pixel:
    z=sin(z^2) + sin(z) + sin(p1),
   |z| <= 4
  }

RCL_5_M (XAXIS) { Ron Lewen, 76376,2567
  ;
  ;  A variation on the classical Mandelbrot set
  ;  formula.
  ;
  ;  Use floating point
  ;
  z=pixel:
    z=sin(z^2+pixel),
      |z| <= 4
  }

RCL_5_J (ORIGIN) { Ron Lewen, 76376,2567
  ;
  ;  A variation on the classical Julia set.
  ;
  ;  Use floating point
  ;
  z=pixel:
    z=sin(z^2+p1),
      |z| <= 4
  }

RCL_6_M (XAXIS) { ; Ron Lewen, 76376,2567
  ;
  ;  A variation on the classic Mandelbrot formula
  ;
  ;  Use floating point
  ;
  z=pixel:
    z=sin(z)^2 + pixel,
      |z| <= 4
  }

RCL_6_J (ORIGIN) { ; Ron Lewen, 76376,2567
  ;
  ;  A variation on the classic Julia formula
  ;
  ;  use floating point
  ;
  z=pixel:
    z=sin(z)^2 + p1,
      |z| <= 4
  }

RCL_7 (XAXIS) { ; Ron Lewen, 76376,2567
  ; Inspired by the Spider
  ; fractal type included with Fractint
  ;
  z=c=pixel:
    z=z^2+pixel+c
    c=c^2+pixel+z
      |z| <= 4
  }

RCL_8_M { ; Ron Lewen, 76376,2567
  ;
  ;  Another variation on the classic Mandelbrot
  ;  set.
  ;
  z=pixel:
    z=z^2+flip(pixel)
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_8_J (ORIGIN) { ; Ron Lewen, 76376,2567
  ;
  ;
  ;
  z=pixel:
    z=z^2+flip(p1)
      |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_9 (XAXIS) { ; Ron Lewen, 76376,2567
  ;
  ;
  ;
  z=pixel:
    z=(z^2+pixel)/(pixel^2+z)
      |z| <= 4
  }

RCL_10 { ; Ron Lewen, 76376,2567
  ;
  ;
  ;
  z=pixel:
    z=flip((z^2+pixel)/(pixel^2+z))
      |z| <= 4
  }

RCL_Cosh_Flip (XAXIS) { ; Ron Lewen, 76376,2567
  ;
  ; A FLIPed version of RCL_Cosh.
  ; An interesting repeating pattern with lots
  ; of detail.
  ;
  ; Use floating point
  ;
  z=0:
    z=flip(cosh(z) + pixel),
      abs(z) < 40
  }

RCL_Cosh_J { ; Ron Lewen, 76376,2567
  ;
  ; A julia-style version of RCL_Cosh above.
  ; Lots of interesting detail to zoom in on.
  ;
  ; Use floating point
  ;
  z=pixel:
    z=cosh(z) + p1,
      abs(z) < 40
  }

RCL_12 (XAXIS) { ; Ron Lewen, 76376,2567
  ;
  z=pxel:
    z=(z^2+3z+pixel)/(z^2-3z-pixel)
      |z| <= 10
  }

RCL_13 (XAXIS) { ; Ron Lewen, 76376,2567
  ;
  z=pixel:
    z=(z^2+2z+pixel)/(z^2-2z+pixel)
      |z| <= 100
  }

RCL_14 (XAXIS) { ; Ron Lewen, 76376,2567
  ;
  z=pixel:
    z=z^pixel+pixel^z
      |z| <= 96
  }

RCL_15 (XAXIS) { ; Ron Lewen, 76376,2567
  ;
  ; Adapted from Pickover's Biomorph Zoo Collection in
  ; Figure 8.7 (p. 102).
  ;
  z=pixel:
    z=z^2.71828 + pixel,     |real(z)| <= 100 || |imag(z)| <= 100
  }

RCL_16 (XAXIS) { ; Ron Lewen, 76376,2567
  ;
  ; Set fn1 to sqr to generate Figure 9.18 (p. 134)
  ; from Pickover's book.
  ; Set maxiter >= 1000 to see good detail in the spirals
  ; in the three large lakes.  Also set inside=0.
  ;
  z=0.5:
    z=z*pixel-pixel/fn1(z),
      abs(z) < 8
  }


;------------------------------------------------;
; REB001.FRM                                     ;
; Ron Barnett 70153,1233                         ;
;------------------------------------------------; 

   IkenagaMap(XAXIS) = {; Ron Barnett, 1993
			; based upon the Ikenaga function described
      ; in Dewdneys's The Armchair Universe.
      ; The initial starting point allows the function to provide a
      ; "map" for the corresponding Julia function (Julike ) 
      z = ((1-pixel)/3)^0.5: 
      z = z*z*z + (pixel-1)*z - pixel, |z| <= 4
   }

   Julike = {	; Ron Barnett, 1993
		; a Julia function based upon the Ikenaga function
      z = Pixel:
      z = z*z*z + (P1-1)*z - P1, |z| <= 4
   }

   Mask = {	; Ron Barnett, 1993
		; try fn1 = log, fn2 = sinh, fn3 = cosh
      ;P1 = (0,1), P2 = (0,1)
      ;Use floating point
      z = fn1(pixel):
      z = P1*fn2(z)^2 + P2*fn3(z)^2 + pixel, |z| <= 4
   }

   JMask = {	; Ron Barnett, 1993      
      z = fn1(pixel):
      z = P1*fn2(z)^2 + P2, |z| <= 4
   }

   PseudoZeePi = {; Ron Barnett, 1993
      z = pixel:
      x = 1-z^p1;
      z = z*((1-x)/(1+x))^(1/p1) + p2, |z| <= 4
   }

   ZeePi = {	; Ron Barnett, 1993
		; This Julia function is based upon Ramanujan's iterative
      ; function for calculating pi
      z = pixel:
      x = (1-z^p1)^(1/p1);
      z = z*(1-x)/(1+x) + p2, |z| <= 4
   }

   IkeNewtMand = {; Ron Barnett, 1993
   z = c = pixel:
   zf = z*z*z + (c-1)*z - c;
   zd = 3*z*z + c-1;
   z = z - p1*zf/zd, 0.001 <= |zf|
   }

   IkeNewtJul = {; Ron Barnett, 1993
   z =  pixel:
   zf = z*z*z + (p2-1)*z - p2;
   zd = 3*z*z + p2-1;
   z = z - p1*zf/zd, 0.001 <= |zf|
   }

   RecipIke = {; Ron Barnett, 1993
   z = pixel:
   z = 1/(z*z*z + (p1-1)*z - p1), |z| <= 4
   }

   Frame-RbtM(XAXIS) = {; Ron Barnett, 1993
			; from Mazes for the Mind by Pickover
   z = c = pixel:
   z = z*z*z/5 + z*z + c, |z| <= 100
   }

   Frame-RbtJ = {	; Ron Barnett, 1993
   z = pixel:
   z = z*z*z/5 + z*z + p1, |z| <= 100
   }
;------------------------------------------------;
; REB002.FRM                                     ;
; Ron Barnett 70153,1233                         ;
;------------------------------------------------; 

   IkeGenM = {	; Ron Barnett, 1993
   z = ((1-pixel)/(3*p1))^0.5:
   z =p1*z*z*z + (pixel-1)*z - pixel, |z| <= 100
   }

   IkeGenJ = {	; Ron Barnett, 1993
   z = pixel:
   z =p1*z*z*z + (p2-1)*z - p2, |z| <= 100
   }

   FrRbtGenM = {; Ron Barnett, 1993
   z = pixel:
   z = p1*z*z*z + z*z + pixel, |z| <= 100
   }   

   FrRbtGenJ = {; Ron Barnett, 1993
   z = pixel:
   z = p1*z*z*z + z*z + p2, |z| <= 100
   }   
   
   IkeFrRbtGenM = {; Ron Barnett, 1993
   z = 2*(1-pixel)/(3*p1):
   z = p1*z*z*z + (pixel-1)*z*z - pixel, |z| <= 100
   }

   IkeFrRbtGenJ = {; Ron Barnett, 1993
   z = pixel:
   z = p1*z*z*z + (p2-1)*z*z - p2, |z| <= 100
   }

   PolyGen = {	; Ron Barnett, 1993
		;p1 must not be zero
   		;zero can be simulated with a small
   		;value for p1
   		;use floating point
   z=(-p2+(p2*p2+(1-pixel)*3*p1)^0.5)/(3*p1):
   z=p1*z*z*z+p2*z*z+(pixel-1)*z-pixel,|z| <= 100
   }

FlipProbM1 = {	; Ron Barnett, 1993
   z = pixel:
   z = flip(z)*(1-z) + pixel, |z| <= 100
   }

FlipProbJ1 = {	; Ron Barnett, 1993
   z = pixel:
   z = flip(z)*(1-z) + p1, |z| <= 100
   }

FlipProbM2 = {	; Ron Barnett, 1993
   z = pixel:
   z = z*(pixel-flip(z)) + pixel, |z| <= 100
   }

FlipProbJ2 = {	; Ron Barnett, 1993
   z = pixel:
   z = z*(p1-flip(z)) + p1, |z| <= 100
   }

FlipLambdaM = {	; Ron Barnett, 1993
   z = 0.5:
   z = pixel*z*(1-flip(z)*flip(z)), |z| <= 100
   }

FlipLambdaJ = {	; Ron Barnett, 1993
   z = pixel:
   z = p1*z*(1-flip(z)*flip(z)), |z| <= 100
   }

REBRefInd1 = {	; Ron Barnett, 1993
		; Use floating point
   z = pixel:
   z = (z*z-p1)/(z*z+p2)*fn1(z)*fn2(z) + pixel, |z| <= 100
   }

REBRefInd2 = {	; Ron Barnett, 1993
		; Use floating point
   z = pixel:
   z = (z*z-1)/(z*z+2)*fn1(z)*fn2(z) + p1, |z| <= 100
   }

REBRefInd3 = {	; Ron Barnett, 1993
		; Use floating point
   z = pixel:
   z = (z*z-1)/(z*z+2)*fn1(z) + p1, |z| <= 100
   }

REBRefInd4 = {	; Ron Barnett, 1993
		; Use floating point
   z = pixel:
   z = flip(z);
   z = (z*z-p1)/(z*z+p2)*fn1(z)*fn2(z) + pixel, |z| <= 100
   }

REBRefInd5 = {	; Ron Barnett, 1993
		; Use floating point
   z = pixel:
   z = flip(z);
   z = (z*z-1)/(z*z+2)*fn1(z)*fn2(z) + p1, |z| <= 100
   }   Gopalsamy1 {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = -2*x*y + p1,
   y = y*y - x*x,
   z = x1 + flip(y), |z| <= 4
   }

   Foam {
   z = 0.5:
   x = pixel*(z - 1/z) + p1,
   z = pixel*(x - 1/sqr(x) + p2), |z| <= 100
   }

   Gopalsamy2 {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = -4*x*y + p1,
   y = 4*y*y - x*x,
   z = x1 + flip(y), |z| <= 4
   }

   Gopalsamy3 {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = 3*x*y*y - x*x*x + p1,
   y = y*y*y - 3*x*x*y,
   z = x1 + flip(y), |z| <= 4
   }

   Gopalsamy4 {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = -x*y + p1,
   y = 2*y*y - 3*x*x,
   z = x1 + flip(y), |z| <= 4
   }

   Gopalsamy5 {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = 2*x*y,
   y1 = x*x - y*y,
   x2 = -2*x1*y1 + p1,
   y = y1*y1 - x1*x1,
   z = x2 + flip(y), |z| <= 4
   }

   GopalsamySin2 {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = sin(x)*cosh(y),
   y1 = cos(x)*sinh(y),
   x2 = -2*x1*y1 + p1,
   y = y1*y1 - x1*x1,
   z = x2 + flip(y), |z| <= 100
   }

   GopalsamySin {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = -sin(x)*cosh(y) + p1,
   y = -cos(x)*sinh(y),
   z = x1 + flip(y), |z| <= 100
   }

   GopalsamyExp {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = -exp(x)*cos(y) + p1,
   y = -exp(x)*sin(y),
   z = x1 + flip(y), |z| <= 100
   }

   GopalsamyExp2 {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = exp(x)*cos(y),
   y1 = exp(x)*sin(y),
   x2 = -2*x1*y1 + p1,
   y = y1*y1 - x1*x1,
   z = x2 + flip(y), |z| <= 100
   }

   GopalsamySinh2 {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = sinh(x)*cos(y),
   y1 = cosh(x)*sin(y),
   x2 = -2*x1*y1 + p1,
   y = y1*y1 - x1*x1,
   z = x2 + flip(y), |z| <= 100
   }

   GopalsamySinh {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = -sin(x)*cosh(y) + p1,
   y = -cos(x)*sinh(y),
   z = x1 + flip(y), |z| <= 100
   }

   GopalsamyFn {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = fn1(x)*fn2(y),
   y1 = fn3(x)*fn4(y),
   x2 = -2*x1*y1 + p1,
   y = y1*y1 - x1*x1,
   z = x2 + flip(y), |z| <= 100
   }

   MandellambdaPwr {; This provide a "map" for LambdaPwr
   z = (1/(p1+1))^(1/p1): 
   z = pixel*z*(1 - z^p1), |z| <= 100
   }

   LambdaPwr {
   z = pixel:
   z = p1*z*(1 - z^p2), |z| <= 100
   }  

   PseudoLambda {
   z = pixel:
   x = real(z), y = imag(z),
   x1 = -p1*(x - x*x + y*y) + p2,
   y = -p1*(y - 2*x*y),
   z = x1 + flip(y), |z| <= 100
   }

   PseudoMandelLambda {
   z = 0.5, c = pixel:
   x = real(z), y = imag(z),
   x1 = -c*(x - x*x + y*y) + p1,
   y = -c*(y - 2*x*y),
   z = x1 + flip(y), |z| <= 100
   };------------------------------------------------;
; REB004.FRM                                     ;
; Ron Barnett 70153,1233                         ;
;------------------------------------------------; 

   REB004A = {; Ron Barnett, 1993
   z = pixel:
   z =p1*fn1(z) + p1*p1*fn2(p2*z) + pixel, |z| <= 100
   }

   REB004B = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   z = pixel + p1*(z/2 + z*z/6 + z*z*z/12), |z| <= 100
   }

   REB004C = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   z = p2 + p1*(z/2 + z*z/6 + z*z*Z/12), |z| <= 100
   }

   REB004D = {; Ron Barnett, 1993
   z = pixel:
   z = pixel + fn1(2*z+1)/(2*z+p1), |z| <= 100
   }

   REB004E = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   z = pixel + fn1(2*z+1)/(2*z+p1); 
   z = z + fn2(4*z+1)/(4*z+p2), |z| <= 100
   }

   REB004F = {; Ron Barnett, 1993
   z = pixel:
   z = p2 + fn1(2*z+1)/(2*z+p1), |z| <= 100
   }

   REB004G = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   z = p2 + fn1(2*z+1)/(2*z+p1); 
   z = z + fn2(4*z+1)/(4*z+p1), |z| <= 100
   }

   REB004H = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   z = pixel + fn1(3/z - z/4), |z| <= 100
   }

   REB004I = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   z = p1 + fn1(3/z - z/4), |z| <= 100
   }

   REB004J = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = flip(pixel + fn1(3/z - z/4));
   z = x*z + pixel, |z| <= 100
   }

   REB004K = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = flip(pixel + fn1(3/z - z/4));
   z = x*z + p1, |z| <= 100
   }

   REB004L = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = flip(pixel + fn1(p1/z - z/(p2+1)));
   z = x*z + pixel, |z| <= 100
   }

   REB004M = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1(const - 12*x)*x/(4*const);
   y1 = -fn2(const + 12*x)*y/(4*const);
   x2 = x1*x1 - y1*y1 + p1;
   y2 = 2*x*y;
   z = x2 + flip(y2), |z| <= 100
   }   ;------------------------------------------------;
; REB005.FRM                                     ;
; Ron Barnett 70153,1233                         ;
; The last six FRM's in this file were inspired  ;
; by 4DFRACT.FRM of Gordon Lamb                  ;
;------------------------------------------------; 

REB005A	= {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1(const - 12*x)*x/(4*const);
   y1 = -fn2(const + 12*y)*y/(4*const);
   x2 = x1*x1 - y1*y1 + p1;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   } 

REB005B = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1(const - x)*x/const;
   y1 = -fn2(const + y)*y/const;
   x2 = x1*x1 - y1*y1 + p1;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   }

REB005C = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1(const + p1*x)*x/const;
   y1 = -fn2(const + y)*y/const;
   x2 = x1*x1 - y1*y1 + p2;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   } 

REB005D = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1((const + p1*x)*x/const);
   y1 = -fn2((const + y)*y/const);
   x2 = x1*x1 - y1*y1 + p2;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   }

REB005E = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1((const - x)*x/const);
   y1 = -fn2((const + y)*y/const);
   x2 = x1*x1 - y1*y1 + p1;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   }

REB005F = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1((const - 12*x)*x/(4*const));
   y1 = -fn2((const + 12*y)*y/(4*const));
   x2 = x1*x1 - y1*y1 + p1;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   } 

REB005G = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1(const + p1*x)*y/const;
   y1 = -fn2(const + y)*x/const;
   x2 = x1*x1 - y1*y1 + p2;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   }

SJIKENAGA01 {; Ron Barnett, 1994
              ; floating point required
	z=real(pixel)+flip(imag(pixel)*p1),
	c=p2+p1*real(pixel)+flip(imag(pixel)):
	z=z*z*z+(c-1)*z-c, |z|<=100}

3RDIMIKENAGA01 {; Ron Barnett, 1994
              ; floating point required
	z=p1*real(pixel)+flip(imag(pixel)),
	c=p2+real(pixel)+flip(imag(pixel)*p1):
	z=z*z*z+(c-1)*z-c, |z|<=100}

SJIKENAGA02 {; Ron Barnett, 1994
              ; floating point required
	z=real(pixel)+flip(imag(pixel)*p1),
	c=p2+p1*real(pixel)+flip(imag(pixel)),
	z=conj(z),c=conj(c):
	z=z*z*z+(c-1)*z-c, |z|<100}

3RDIMIKENAGA02 {; Ron Barnett, 1994
              ; floating point required
	z=p1*real(pixel)+flip(imag(pixel)),
	c=p2+real(pixel)+flip(imag(pixel)*p1),
	z=conj(z),c=conj(c):
	z=z*z*z+(c-1)*z-c, |z|<=100}

SJFRAME-ROBERT {; Ron Barnett, 1994
              ; floating point required
	z=real(pixel)+flip(imag(pixel)*p1),
	c=p2+p1*real(pixel)+flip(imag(pixel)):
	z=z*z*z/5+z*z+c, |z|<=100}

3RDIMFRAME-ROBERT {; Ron Barnett, 1994
              ; floating point required
	z=p1*real(pixel)+flip(imag(pixel)),
	c=p2+real(pixel)+flip(imag(pixel)*p1):
	z=z*z*z/5+z*z+c, |z|<=100}

SJSPIDER01 {; Ron Barnett, 1994
              ; floating point required
	z=real(pixel)+flip(imag(pixel)*p1),
	c=p2+p1*real(pixel)+flip(imag(pixel)):
	z=z*z+c,
        c=c/2+z, |z|<=100}

3RDIMSPIDER01 {; Ron Barnett, 1994
              ; floating point required
	z=p1*real(pixel)+flip(imag(pixel)),
	c=p2+real(pixel)+flip(imag(pixel)*p1):
	z=z*z+c,
        c=c/2+z, |z|<=100}

SJMANOWAR01 {; Ron Barnett, 1994
              ; floating point required
	z=z1=real(pixel)+flip(imag(pixel)*p1),
	c=p2+p1*real(pixel)+flip(imag(pixel)):
	z=z*z+z1+c,
        z1=z, |z|<=100}

3RDIMMANOWAR01 {; Ron Barnett, 1994
              ; floating point required
	z=z1=p1*real(pixel)+flip(imag(pixel)),
	c=p2+real(pixel)+flip(imag(pixel)*p1):
	z=z*z+z1+c,
        z1=z, |z|<=100}

SJIKENAGA03 {; Ron Barnett, 1994
              ; floating point required
	z=real(pixel)-flip(imag(pixel)*p1),
	c=p2+p1*real(pixel)-flip(imag(pixel)):
	z=z*z*z+(c-1)*z-c, |z|<=100}

 
;========================================================================
;Date:    Wed, 12 Feb 1992 12:32:27 EST
;From: "Bruno"
;Subject: sam.frm
;X-Topic: Entry #3191 of LISTS.FRAC-L
;To: "LISTS.FRAC-L.3191"
;
;Posted on 12 Feb 1992 at 03:29:01 by BrownVM Mailer (103837)
;
;sam.frm
;
;Date:         Wed, 12 Feb 1992 09:10:56 MEZ
;Reply-To:     'FRACTAL' discussion list <FRAC-L@GITVM1.BITNET>
;From:         QOC62@DMSWWU1A.BITNET
;
;to whom it may concern
;sam.frm:            (does anybody know the source of this formulafile?)
;

   Sam_0(XAXIS) = {
      z = Pixel:  z = z^z - pixel
   }

   Sam_1(XAXIS) = {
      z = Pixel: z = z^(-z) - pixel
   }

   Sam_2(XAXIS) = {
      z = Pixel: z = z^(1/z) - pixel
   }

   Sam_3(XAXIS) = {
      z = Pixel: z = z^z^z - pixel
   }

   Sam_4(XAXIS) = {
      z = Pixel: z = z^(z^(1/z)) - pixel
   }
   Sam_5(XAXIS) = {
      z = Pixel: z = z^2.718281828 + pixel
   }

   Sam_6(XYAXIS) = {
      z = Pixel: z = z*cos(z) - pixel
   }

   Sam_7(XAXIS) = {
      z = Pixel: z = z*sin(z) - pixel
   }

   Sam_8 = {
      z = Pixel: z = z^c
   }

   Sam_9(XYAXIS) = {
      z = Pixel: z = z*tanh(z)
   }

   Sam_10(XYAXIS) = {
      z = Pixel: z = sin(1/z)
   }

   Sam_11(XAXIS) = {;Try this with periodicity=none command line
      z = Pixel: z = sinh(1/z)
   }comment {
  begin select.frm
}

              { Formulae created by:  Jon Osuch  [73277,1432] }

{=========================================================================}

BirdOfPrey(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=cosxx
    z   = p1,
    x   = 1:
   (x  <  10) * (z=fn1(z)+pixel),
   (10 <= x)  * (z=fn2(z)+pixel),
    x   = x+1,
   |z| <=p2
   }

{=========================================================================}

DeepSpaceProbe(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sin, fn3=cosxx
    z   = p1,
    x   = 1:
   (x  <  10) * (z=fn1(z) + pixel),
   (10 <= x)  * (x<20)    * (z=fn2(z)+pixel),
   (20 <= x)  * (z=fn3(z) + pixel),
    x   = x+1,
   |z| <= p2
   }

DeepSpaceProbeC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=10, p2=20, fn1=sqr, fn2=sin, fn3=cosxx
    ; Note:  use floating point
    z  = p1,
    x  = 1:
(z=fn1(z)+pixel)*(x<10)+(z=fn2(z)+pixel)*(10<=x)*(x<20)+(z=fn3(z)+pixel)*(20<=x)
,
    x  = x+1,
   |z| <= 4
   }

DpSpaceProbeTwoC(XAXIS_NOPARM) {; Jon Osuch
   ; Try p1=0, p2=4, fn1=sqr, fn2=exp, fn3=cosxx
    ; Note:  use floating point
   z    = p1,
   x    = 1:
(z=fn1(z)+pixel)*(x<10)+(z=fn2(z)+pixel)*(10<=x)*(x<20)+(z=fn3(z)+pixel)*(20<=x)
,
    x   = x+1,
   |z| <= p2
   }

{=========================================================================}

EvilEyeC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=1, p2=4, fn1=sin, fn2=cosxx
    ; Note:  use floating point
    z  =  p1,
    x  = |z|:
   (z  = fn1(z)+pixel) * (1<x)  +  (z=fn2(z) + pixel)*(x<=1),
    x  = |z|,
    x <= p2
  }

{=========================================================================}

Eyeball(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sinh
    z    = p1,
    x    = 1:
    (x  <  10) * (z=fn1(z) + pixel),
    (10 <= x)  * (z=fn2(z) + pixel),
    x    = x+1,
   |z|  <= p2
   }

{=========================================================================}

FlyingSquirrel(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sin, fn2=cosxx, fn3=sqr
    z  = p1,
    x  = |z|:  (1<x) * (z=fn1(z) / fn2(z) + pixel),
    z  = fn3(z)+pixel,
    x  = |z|,
    x <= p2
   }

{=========================================================================}

FractalFender(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=cosh, fn2=sqr
    z  = p1,
    x  = |z|:  (1<x) * (z=fn1(z)+pixel),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

FractalFenderC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=cosh, fn2=sqr
    ; Note:  use floating point
    ; Spectacular!
    z  = p1, 
    x  = |z|:
   (z  = fn1(z)+pixel) * (1<x)+(z=z) * (x<=1),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

FractalFender2(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=cosxx, fn2=sqr
    z  = p1,
    x  = |z|:  (1<x) * (z=fn1(z)+pixel),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

FractalFender2C(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=cosxx, fn2=sqr
    ; Note:  use floating point
    z  = p1,
    x  = |z|:
   (z  = fn1(z)+pixel) * (1<x) + (z=z) * (x<=1),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

{=========================================================================}

Frog(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=tanh, fn2=sqr
    z  = p1,
    x  = |z|:     (1<x) * (z=fn1(z) + pixel),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

FrogC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=tanh, fn2=sqr
    ; Note:  use floating point
    z  = p1,
    x  = |z|:
   (z  = fn1(z)+pixel) * (1<x) + (z=z) * (x<=1),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

{=========================================================================}

Fly(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sqr
    z   = p1:
    x   = real(z),
   (x  <  0)  * (z=fn1(z) + pixel),
   (0  <= x)  * (z=fn2(z) - pixel),
   |z| <= p2
   }

{=========================================================================}

IfThenfn1fn2(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sin, fn2=cos
    z  = p1,
    x  = |z|:
   (z  = fn1(z)) * (1<x)+(z=z)*(x<=1),
   (z  = fn2(z)  + pixel),
    x  = |z|,
    x <= p2
   }

IfThenElsefn1fn2(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sin
    z  = p1,
    x  = |z|:
   (z  = fn1(z)+pixel) * (1<x)+(z=fn2(z)+pixel) * (x<=1),
    x  = |z|,
    x <= p2
   }

IfElsefn1fn2fn3(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1,2,3=whatever
    z   = p1,
    x   = 1:
(z=fn1(z)+pixel)*(x<10)+(z=fn2(z)+pixel)*(10<=x)*(x<20)+(z=fn3(z)+pixel)*(20<=x)
,
    x   = x+1,
   |z| <= p2
    }

{=========================================================================}

IslandOfChaos(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sin, fn3=cosxx
    z   =  p1,
    x   =  1:
   (x  <  10)  * (z=fn1(z) + pixel),
   (10 <=  x)  * (z=fn2(z) / fn3(z) + pixel),
    x   = x+1,
   |z| <= p2
   }


{=========================================================================}

ManInTheOzone(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=cosxx, fn3=sin
    z    = p1,
    x    = 1:
    (x  < 10)  * (z=fn1(z) + pixel),
    (10 <= x)  * (x<20)    * (z=fn2(z)+pixel),
    (20 <= x)  * (z=fn3(z) + pixel),
    x    =  x+1,
   |z|  <= p2
   }

{=========================================================================}

Moth(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=exp, fn3=log
    z    = p1,
    x    = 1:
    (x  <  10) * (z=fn1(z)  +  pixel),
    (10 <= x)  * (x<20)     *  (z=fn2(z)+pixel),
    (20 <= x)  * (z=fn3(z)  +  pixel),
    x    = x+1,
   |z|  <= p2
   }

{=========================================================================}

SinhEgg(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sinh, fn2=sqr
    z  = p1,
    x  = |z|:
    (1 < x) * (z=fn1(z) + pixel),
    z  = fn2(z)+pixel,
    x  = |z|,
    x <= p2
   }

{=========================================================================}

TestSinMandC(XAXIS_NOPARM) {;Jon Osuch
     ; Try: p1=4, fn1=sin, fn2=sqr    
     z  = p1,
     x  = |z|:
    (z  = fn1(z)) * (1<x)+(z=z) * (x<=1),
    (z  = fn2(z)+pixel),
     x  = |z|,
     x <= p1
  }

{=========================================================================}

TurtleC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=sqr, fn2=sqr
    ; Note:  use floating point
    z   = p1:
    x   = real(z),
   (z   = fn1(z)+pixel) * (x<0) + (z=fn2(z)-pixel) * (0<=x),
   |z| <= p2
   }


{=========================================================================}

WaldoTwinsC(XAXIS_NOPARM) {; Jon Osuch
    ; Try p1=0, p2=4, fn1=cosxx, fn2=sin
    ; Note:  use floating point
    z   = p1:
    z   = fn1(fn2(z+pixel)) + pixel,
   |z| <= p2
   }

comment {
  end select.frm
}
This file contains the SMURF2.PAR file that has some more Smurf discoveries.
Since the advent of my 486-33 my sense of time has been blown to Hades.  Every
thing runs fast on this machine so it is hard to say how fast these batches
will run on someone else's machine.  I hope they are not too slow.

The file FLIP.FRM contains formulas utilizing the FLIP function.  There are 3
fliped Mandelbrot formulas and their respective Julia style formulas.

Another formula is a "Non-conformal" depicted in the 1992 Fractal Universe
Calender (August) from Media Magic.  The inside=zmag has some very interesting
structure.  Non-conformals are those where the parts of the Mandelbrot
quadratic equation are added/subtracted in different ways from the standard
solution of the formula.  The flip0 is considered a non-conformal.  Note
how the intergers are converted to a complex number (z = x + flip(y)).

BTW this calender is incredibly beautiful.

Two other formulas are included, PHOENIX_J and PHOENIX_M.  The Phoenix_j curve
was discovered by Shigehiro Ushiki at Kyoto University.  The creation of
the map version was done by Roger Stevens in his "Fractal Programming in C".
The interesting aspect of this formula is that the Phoenix doesn't lie at any
interesting point on the map.  It is at co-ordinates 0.56667 / -0.5 which is
off the lower right side in a very boring section.  One that I found is at
0.1 / 0.8 off the top right hand side; which is also a very boring place on
the map. There are probably several more Phoenixes waiting to be found.  BTW,
it was while trying to devise a better map that I discovered the zmag coloring
scheme for Mandelbrots.

Included also is the testpt.c for the Phoenix for those with the Fractint
source.  I feel it would be a great addition to the Fractint stable of hard
coded fractals.  But since I couldn't figure out how to do it before and since
I no longer have the Fractint source, I guess it will have to remain for
some one else to accomplish this.

Brainy Smurf
SJMAND01 {; Mandelbrot    
          ; from 4dFRACT.FRM by Gordon Lamb (CIS: 100272,3541) 
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=z*z+c, |z|<=64}


 comment = { SKINNER.FRM }

 Zexpe (XAXIS) = {
      s = exp(1.,0.), z = Pixel:
      z = z ^ s + pixel, |z| <= 100
   }

 Zexpe2 (XAXIS) = {
      s = exp(1.,0.), z = Pixel:
      z = z ^ s + z ^ (s * pixel), |z| <= 100
   }

 Ze2 (XAXIS) = {
      s1 = exp(1.,0.),
      s = s1 * s1,
      z = Pixel:
      z = z ^ s + pixel, |z| <= 100
   }

 comment = {  s = log(-1.,0.) / (0.,1.)   is   (3.14159265358979, 0.0 }

 Exipi (XAXIS) = {
      s = log(-1.,0.) / (0.,1.), z = Pixel:
      z = z ^ s + pixel, |z| <= 100
   }

 Fzpcopcs  {z = pixel, f = pixel ^ (1. / cosxx(pixel) ):
                        z = cosxx (z)  + f, |z| <= 50}

 Fzpcopct  {z = pixel, f = pixel ^ (cosxx(pixel) / sin(pixel) ):
                        z = cosxx (z)  + f, |z|<= 50}

 Fzpcophc  {z = pixel, f = pixel ^ (1. / cosh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcopsh  {z = pixel, f = pixel ^ (sinh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcopsq  {z = pixel, f = pixel ^ (sqr(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcopth  {z = pixel, f = pixel ^ (sinh(pixel) / cosh(pixel) ):
                        z = cosxx (z)+f,|z|<= 50}

 Fzppcos   {z = pixel, f = cosxx (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcota  {z = pixel, f = sin(pixel) / cosxx(pixel):
                       z = cosxx (z)  + f, |z|<= 50}

 Fzppcoth  {z = pixel, f = sinh(pixel) / cosh(pixel):
                       z = cosxx (z)+f,|z|<= 50}

 Fzpcoseh  {z = pixel, f = 1. / sinh(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppchco  {z = pixel, f = cosxx (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Zppchco8  {z = pixel, f = cosxx (pixel):
                       z = cosh (z) + f, |z|<=8192}

 Fzppchex  {z = pixel, f = exp (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppchsi  {z = pixel, f = sin (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppchsq  {z = pixel, f = sqr (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppcoch  {z = pixel, f = cosh (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcocoh  {z = pixel, f = 1. / cosh(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcoct  {z = pixel, f = cosxx(pixel) / sin(pixel):
                       z = cosxx (z)  + f, |z|<= 50}

 Fzppcohs  {z = pixel, f = sinh (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcolo  {z = pixel, f = log (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppexch  {z = pixel, f = cosh (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppexsh  {z = pixel, f = sinh (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppsich  {z = pixel, f = cosh (pixel):
                       z = sin (z)  + f, |z| <= 50}

 Fzppsish  {z = pixel, f = sinh (pixel):
                       z = sin (z)  + f, |z| <= 50}

 Fzppsisq  {z = pixel, f = sqr (pixel):
                       z = sin (z)  + f, |z| <= 50}

 Fzpcopch  {z = pixel, f = pixel ^ (cosh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcope  {z = pixel, f = pixel ^ (exp(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcopr  {z = pixel, f = pixel ^ (1. / pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcophs  {z = pixel, f = pixel ^ (1. / sinh(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcopta  {z = pixel, f = pixel ^ (sin(pixel) / cosxx(pixel) ):
                        z = cosxx (z)  + f, |z|<= 50}

 Fzppcoht  {z = pixel, f = cosh(pixel) / sinh(pixel):
                       z = cosxx (z)+f,|z|<= 50}

 Fzppcops  {z = pixel, f = pixel ^ (sin(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzpcopht  {z = pixel, f = pixel ^ (cosh(pixel) / sinh(pixel) ):
                       z = cosxx (z)+f,|z|<= 50}

 Fzpcopse  {z = pixel, f = pixel ^ (1. / sin(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppchsh  {z = pixel, f = sinh (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppcocs  {z = pixel, f = 1. / cosxx(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcoex  {z = pixel, f = exp (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcopl  {z = pixel, f = pixel ^ (log(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcopo  {z = pixel, f = (pixel) ^ (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcore  {z = pixel, f = 1. / (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcose  {z = pixel, f = 1. / sin(pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcosh  {z = pixel, f = cosh (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppcosi  {z = pixel, f = sin (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcosq  {z = pixel, f = sqr (pixel):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppcosr  {z = pixel, f = (pixel) ^ 0.5:
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppexp   {z = pixel, f = exp (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppexsq  {z = pixel, f = sqr (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppshex  {z = pixel, f = exp (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppsico  {z = pixel, f = cosxx (pixel):
                       z = sin (z)  + f, |z| <= 50}

 Fzppsiex  {z = pixel, f = exp (pixel):
                       z = sin (z)  + f, |z| <= 50}

 Fzppsinh  {z = pixel, f = sinh (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppcopc  {z = pixel, f = pixel ^ (cosxx(pixel) ):
                       z = cosxx (z)  + f, |z| <= 50}

 Fzppchlo  {z = pixel, f = log (pixel):
                       z = cosh (z) + f, |z| <= 50}

 Fzppexco  {z = pixel, f = cosxx (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppexlo  {z = pixel, f = log (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppexsi  {z = pixel, f = sin (pixel):
                       z = exp (z)  + f, |z| <= 50}

 Fzppshch  {z = pixel, f = cosh (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppshco  {z = pixel, f = cosxx (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppshlo  {z = pixel, f = log (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppshsi  {z = pixel, f = sin (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppshsq  {z = pixel, f = sqr (pixel):
                       z = sinh (z) + f, |z| <= 50}

 Fzppsqlo  {z = pixel, f = log (pixel):
                       z = sqr (z)  + f, |z| <= 50}

 Fzppsqsh  {z = pixel, f = sinh (pixel):
                       z = sqr (z)  + f, |z| <= 50}

 Fzppsqsi  {z = pixel, f = sin (pixel):
                       z = sqr (z)  + f, |z| <= 50}

 Leeze (XAXIS) = {     s = exp(1.,0.), z = Pixel, f = Pixel ^ s:
                       z = cosxx (z) + f, |z| <= 50 }

 comment { version 13.0:}
 LambdaLog(XAXIS) {
      z = pixel, c = log(pixel):  
         z = c * sqr(z) + pixel, 
      |z| <= 4 
   }

 comment { version 15.1:}
 CGNewtonSinExp (XAXIS) {
        z=pixel:
        z1=exp(z);
        z2=sin(z)+z1-z;
        z=z-p1*z2/(cos(z)+z1), .0001 < |z2|
   }

 OldManowar (XAXIS) {
           z0 = 0,
           z1 = 0,
         test = p1 + 3,
           c = pixel :
               z = z1*z1 + z0 + c;
               z0 = z1;
               z1 = z,  |z| < test }

 comment { version 15.1:}
 OldHalleySin (XYAXIS) {
        z=pixel:
        s=sin(z);
        c=cosxx(z);
        z=z-p1*(s/(c-(s*s)/(c+c))),
        0.0001 <= |s|
   }

 comment { version 15.1:}
 OldCGNewtonSinExp (XAXIS) {
        z=pixel:
        z1=exp(z);
        z2=sin(z)+z1-z;
        z=z-p1*z2/(cosxx(z)+z1), .0001 < |z2|
   }

 comment { version 15.1:}
 OldNewtonSinExp (XAXIS) {; Chris Green
  ; Newton's formula applied to sin(x)+exp(x)-1=0.
  ; Use floating point.
  z=pixel:
   z1=exp(z)
   z2=sin(z)+z1-1
   z=z-p1*z2/(cosxx(z)+z1),
    .0001 < |z2|
  }

 comment { some of the following are included here because
           BAILOUT=3 is still not supported}

 ScottLPC(XAXIS) { z = pixel, TEST = (p1+3): z = log(z)+cosxx(z), |z|<TEST }

 ScottLPS(XAXIS) { z = pixel, TEST = (p1+3): z = log(z)+sin(z), |z|<TEST }

 ScottLTC(XAXIS) { z = pixel, TEST = (p1+3): z = log(z)*cosxx(z), |z|<TEST }

 ScottLTS(XAXIS) { z = pixel, TEST = (p1+3): z = log(z)*sin(z), |z|<TEST }

 ScottSIC(XYAXIS) { z = pixel, TEST = (p1+3): z = sqr(1/cosxx(z)), |z|<TEST }

 ScSkCosH(XYAXIS) { z = pixel, TEST = (p1+3): z = cosh(z) - sqr(z), |z|<TEST }

 ScSkLMS(XAXIS) { z = pixel, TEST = (p1+3): z = log(z) - sin(z), |z|<TEST }

 ScSkZCZZ(XYAXIS) { z = pixel, TEST = (p1+3): z = (z*cosxx(z)) - z, |z|<TEST }

{ Spectacular! }
   FractalFenderC(XAXIS_NOPARM) {z=p1,x=|z|:
       (z=cosh(z)+pixel)*(1<x)+(z=z)*(x<=1),
       z=sqr(z)+pixel,x=|z|,
       x<=4 }

   SpecC(XAXIS_NOPARM) {z=p1,x=|z|:
       (z=fn1(z)+pixel)*(1<x)+(z=z)*(x<=1),
       z=fn2(z)+pixel,x=|z|,
       x<=4 }

 Silverado(XAXIS) {; Rollo Silver
  ; Select p1 such that 0. <= p1 <= 1.
  z = Pixel, zz=z*z, zzz=zz*z, z = (1.-p1)*zz + (p1*zzz), test = (p2+4)*(p2+4): ;
   z = z + Pixel
   zsq = z*z
   zcu = zsq*z
   z = (1.-p1)*zsq + p1*zcu,
   |z| <= test
  }

 comment = { Moire Tetrated Log - Improper Bailout }

 TLog (XAXIS) = {
        z = c = log(pixel):
                z = c ^ z,
                    z <= (p1 + 3)
        }

 comment = { Tetrated Hyperbolic Sine - Improper Bailout }

 TSinh (XAXIS) = {
        z = c = sinh(pixel):
                z = c ^ z,
                    z <= (p1 + 3)
        }

 DrChaosbrot2(xyaxis)   { ;more phi

 z = c = pixel:
 z = sqr(z) + (((sqrt 5 + 1)/2)+c)
 |z| <= 4;
 }

phoenix_m { ; Mandelbrot stye map of the Phoenix curves
   z=x=y=nx=ny=x1=y1=x2=y2=0:
   x2 = sqr(x), y2 = sqr(y),
   x1 = x2 - y2 + real(pixel) + imag(pixel) * nx,
   y1 = 2 * x * y + imag(pixel) * ny,
   nx=x, ny=y, x=x1, y=y1, z=x + flip(y),
   |z| <= 4
   }

 ScottSIS(XYAXIS) { z = pixel, TEST = (p1+3): z = sqr(1/sin(z)), |z|<TEST }

M-SetInNewton(XAXIS) {; use float=yes
                      ; jon horner 100112,1700, 12 feb 93
  z = 0,  c = pixel,  cminusone = c-1:
  oldz = z,  nm = 3*c-2*z*cminusone, dn = 3*(3*z*z+cminusone),
  z = nm/dn+2*z/3,   |(z-oldz)|>=|0.01|
 }


SymmIcon {
	z = P1,
	x = P2,
	bar = (1,-1),
	l = real(P1),
	a = imag(P2),
	b = .2,
	g = .1,
	w = 0,
        n = 5:

	zbar = z*bar;
	z = ((l + (a * z * zbar) + (b * real(z^n))  + (w * i)) * z) + g*(zbar^(n-1)) + pixel;
	}
	;========================================================================
;Date:    Mon, 10 Feb 1992 13:10:12 EST
;From: "Bruno"
;Subject: MORE .par and .frm
;X-Topic: Entry #3185 of LISTS.FRAC-L
;To: "LISTS.FRAC-L.3185"
;
;Posted on 10 Feb 1992 at 12:24:22 by BrownVM Mailer (103837)
;
;MORE .par and .frm
;
;Date:         Mon, 10 Feb 1992 08:18:36 GMT
;Reply-To:     'FRACTAL' discussion list <FRAC-L@GITVM1.BITNET>
;From:         Rob den Braasem <rdb@KTIBV.UUCP>
;
;Here are a group of files with formulas derived from a book of Roger Stevens
;

Tchebychev-c6(XYAXIS) {   ;Advanced Fractal Programming in C  - Stevens
   z=0:
   zsq = z*z,
   z = pixel * (zsq*zsq*zsq - 6*zsq*zsq + 9*zsq - 2),
   |z| <= 4
   }

Tchebychev-t5(XYAXIS) {   ;Advanced Fractal Programming in C  - Stevens
   z=(0.654,0):
   zcube = z*z*z,
   z = pixel * (16*z*z*zcube - 20*zcube + 5*z),
   |z| <= 4
   }

;First the formats file and then the par file.
;
;
;--------------------------------------------------------------------
;{
;  ADVANCE FRACTAL PROGRAMMING IN C
;  by Roger Stevens.
;
;  I changed them in a Julia and Mandelbrot type fractal generatoren.
;  The Graphical Gnome (rdb@ktibv)
;
;}
;
;{
;   JULIA TYPE FRACTALS
;}
;

J_TchebychevT2 {
   c = pixel, z = P1:
   z = c*(2*z*z-1),
   |z|<100
}

J_TchebychevT3 {   ;
   c = pixel, z = P1:
   z = c*z*(4*z*z-3),
   |z|<100
}

J_TchebychevT4 {
   c = pixel, z = P1:
   z = c*(z*z*(8*z*z+8)+1),
   |z|<100
}

J_TchebychevT5 {    ;
   c = pixel, z = P1:
   z = c*(z*(z*z*(16*z*z-20)+5)),
   |z|<100
}

J_TchebychevT6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(32*z*z-48)+18)-1),
   |z|<100
}

J_TchebychevT7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(64*z*z-112)+56)-7),
   |z|<100
}

J_TchebychevC2 {
   c = pixel, z = P1:
   z = c*(z*z-2),
   |z|<100
}

J_TchebychevC3 {   ;
   c = pixel, z = P1:
   z = c*z*(z*z-3),
   |z|<100
}

J_TchebychevC4 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z-4)+2),
   |z|<100
}

J_TchebychevC5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z-5)+5),
   |z|<100
}

J_TchebychevC6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(z*z-6)+9)-2),
   |z|<100
}

J_TchebychevC7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(z*z-7)+14)-7),
   |z|<100
}


J_TchebychevU2 {
   c = pixel, z = P1:
   z = c*(4*z*z-1),
   |z|<100
}

J_TchebychevU3 {   ;
   c = pixel, z = P1:
   z = c*z*(8*z*z-4),
   |z|<100
}

J_TchebychevU4 {
   c = pixel, z = P1:
   z = c*(z*z*(16*z*z-12)+1),
   |z|<100
}

J_TchebychevU5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(32*z*z-32)+6),
   |z|<100
}

J_TchebychevU6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(64*z*z-80)+24)-1),
   |z|<100
}

J_TchebychevU7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(128*z*z-192)+80)-8),
   |z|<100
}

J_TchebychevS2 {
   c = pixel, z = P1:
   z = c*(z*z-1),
   |z|<100
}

J_TchebychevS3 {   ;
   c = pixel, z = P1:
   z = c*z*(z*z-2),
   |z|<100
}

J_TchebychevS4 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z-3)+1),
   |z|<100
}

J_TchebychevS5 {    ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z-4)+3),
   |z|<100
}

J_TchebychevS6 {
   c = pixel, z = P1:
   z = c*(z*z*(z*z*(z*z-5)+6)-1),
   |z|<100
}

J_TchebychevS7 {     ;
   c = pixel, z = P1:
   z = c*z*(z*z*(z*z*(z*z-6)+10)-4),
   |z|<100
}

J_Laguerre2 {
   c = pixel, z = P1:
   z = (z*(z - 4) +2 ) / 2 + c,
   |z| < 100

}

J_Laguerre3 {
   c = pixel, z = P1:
   z = (z*(z*(-z + 9) -18) + 6 ) / 6 + c,
   |z| < 100
}

J_Laguerre4 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z - 16)+ 72) - 96)+ 24 ) / 24 + c,
   |z| < 100
}

J_Laguerre5 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z * (-z +25) -200) +600) -600) + 120 ) / 120 + c,
   |z| < 100
}

J_Laguerre6 {
   c = pixel, z = P1:
   z = (z * ( z * ( z * ( z*(z*(z -36) +450) -2400) + 5400)-4320) + 720 ) / 720
+ c,
   |z| < 100
}

J_Lagandre2 {
   c = pixel, z = P1:
   z = (3 * z*z - 1) / 2 + c
   |z| < 100
}

J_Lagandre3 {
   c = pixel, z = P1:
   z = z * (5 * z*z - 3) / 2 + c
   |z| < 100
}

J_Lagandre4 {
   c = pixel, z = P1:
   z = (z*z*(35 * z*z - 30) + 3) / 8 + c
   |z| < 100
}

J_Lagandre5 {
   c = pixel, z = P1:
   z = z* (z*z*(63 * z*z - 70) + 15 ) / 8 + c
   |z| < 100
}

J_Lagandre6 {
   c = pixel, z = P1:
   z = (z*z*(z*z*(231 * z*z - 315)  + 105 ) - 5) / 16 + c
   |z| < 100
}

J_Lagandre7 {
   c = pixel, z = P1:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / 16 + c
   |z| < 100
}

{
 MANDELBROT TYPE FRACTALS
}

M_TchebychevT2 {
   c = P1, z = Pixel:
   z = c*(2*z*z-1),
   |z|<100
}

M_TchebychevT3 {   ;
   c = P1, z = Pixel:
   z = c*z*(4*z*z-3),
   |z|<100
}

M_TchebychevT4 {
   c = P1, z = Pixel:
   z = c*(z*z*(8*z*z+8)+1),
   |z|<100
}

M_TchebychevT5 {    ;
   c = P1, z = Pixel:
   z = c*(z*(z*z*(16*z*z-20)+5)),
   |z|<100
}

M_TchebychevT6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(32*z*z-48)+18)-1),
   |z|<100
}

M_TchebychevT7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(64*z*z-112)+56)-7),
   |z|<100
}

M_TchebychevC2 {
   c = P1, z = Pixel:
   z = c*(z*z-2),
   |z|<100
}

M_TchebychevC3 {   ;
   c = P1, z = Pixel:
   z = c*z*(z*z-3),
   |z|<100
}

M_TchebychevC4 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z-4)+2),
   |z|<100
}

M_TchebychevC5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z-5)+5),
   |z|<100
}

M_TchebychevC6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(z*z-6)+9)-2),
   |z|<100
}

M_TchebychevC7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(z*z-7)+14)-7),
   |z|<100
}


M_TchebychevU2 {
   c = P1, z = Pixel:
   z = c*(4*z*z-1),
   |z|<100
}

M_TchebychevU3 {   ;
   c = P1, z = Pixel:
   z = c*z*(8*z*z-4),
   |z|<100
}

M_TchebychevU4 {
   c = P1, z = Pixel:
   z = c*(z*z*(16*z*z-12)+1),
   |z|<100
}

M_TchebychevU5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(32*z*z-32)+6),
   |z|<100
}

M_TchebychevU6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(64*z*z-80)+24)-1),
   |z|<100
}

M_TchebychevU7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(128*z*z-192)+80)-8),
   |z|<100
}

M_TchebychevS2 {
   c = P1, z = Pixel:
   z = c*(z*z-1),
   |z|<100
}

M_TchebychevS3 {   ;
   c = P1, z = Pixel:
   z = c*z*(z*z-2),
   |z|<100
}

M_TchebychevS4 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z-3)+1),
   |z|<100
}

M_TchebychevS5 {    ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z-4)+3),
   |z|<100
}

M_TchebychevS6 {
   c = P1, z = Pixel:
   z = c*(z*z*(z*z*(z*z-5)+6)-1),
   |z|<100
}

M_TchebychevS7 {     ;
   c = P1, z = Pixel:
   z = c*z*(z*z*(z*z*(z*z-6)+10)-4),
   |z|<100
}

M_Laguerre2 {
   c = P1, z = Pixel:
   z = (z*(z - 4) +2 ) / 2 + c,
   |z| < 100

}

M_Laguerre3 {
   c = P1, z = Pixel:
   z = (z*(z*(-z + 9) -18) + 6 ) / 6 + c,
   |z| < 100
}

M_Laguerre4 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z - 16)+ 72) - 96)+ 24 ) / 24 + c,
   |z| < 100
}

M_Laguerre5 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z * (-z +25) -200) +600) -600) + 120 ) / 120 + c,
   |z| < 100
}

M_Laguerre6 {
   c = P1, z = Pixel:
   z = (z * ( z * ( z * ( z*(z*(z -36) +450) -2400) + 5400)-4320) + 720 ) / 720
+ c,
   |z| < 100
}

M_Lagandre2 {
   c = P1, z = Pixel:
   z = (3 * z*z - 1) / 2 + c
   |z| < 100
}

M_Lagandre3 {
   c = P1, z = Pixel:
   z = z * (5 * z*z - 3) / 2 + c
   |z| < 100
}

M_Lagandre4 {
   c = P1, z = Pixel:
   z = (z*z*(35 * z*z - 30) + 3) / 8 + c
   |z| < 100
}

M_Lagandre5 {
   c = P1, z = Pixel:
   z = z* (z*z*(63 * z*z - 70) + 15 ) / 8 + c
   |z| < 100
}

M_Lagandre6 {
   c = P1, z = Pixel:
   z = (z*z*(z*z*(231 * z*z - 315)  + 105 ) - 5) / 16 + c
   |z| < 100
}

M_Lagandre7 {
   c = P1, z = Pixel:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / 16 + c
   |z| < 100
}

test{
  z=pixel,c=p1:
   c = P1, z = Pixel:
   z = z* (z*z*(z*z*(429 * z*z - 693) + 315) - 35 ) / (16 * (z+c))
   |z| < 100
}


Newton_poly2 { ; Tim Wegner - use float=yes
   ; fractal generated by Newton formula z^3 + (c-1)z - c
   ; p1 is c in above formula
   z = pixel, z2 = z*z, z3 = z*z2:
   z = (2*z3 + p1) / (3*z2 + (p1 - 1));
   z2 = z*z;
   z3 = z*z2,
  .004 <= |z3 + (p1-1)*z - p1|
  }

;========================================================================
;Date:    Mon, 10 Feb 1992 13:08:59 EST
;From: "Bruno"
;Subject: PAR-File
;X-Topic: Entry #3182 of LISTS.FRAC-L
;To: "LISTS.FRAC-L.3182"
;
;Posted on 10 Feb 1992 at 08:26:57 by BrownVM Mailer (103837)
;
;PAR-File
;
;Date:         Mon, 10 Feb 1992 13:06:54 MEZ
;Reply-To:     'FRACTAL' discussion list <FRAC-L@GITVM1.BITNET>
;From:         QOC62@DMSWWU1A.BITNET
;
;Dear Fragglers !
;We 've got PAR-Files for fractint from FRAC-L (thank you Rodrigo) and want to
;contribute too. Our Parameter- and Formulafiles are following:
;uli.frm
;uli.par
;(I think you will need sam.frm published in FRAC-L (i hope !?) before )
;Interested in YOUR Parameter- or formulafiles.!
;
;Our E-MAIL:
;ULI:  QOC62@DMSWWU1A.BITNET
;TOM:  QOC71@DMSWWU1A.BITNET
;
;Happy fraggling !
;Greetings from Muenster
;


   ULI_1 = {
      z = Pixel: z = fn1(1/fn2(z))
      |z| <= 4
   }

   ULI_2 = {
      z = Pixel: z = fn1(1/fn2(z+p1))
      |z| <= p2
   }

   ULI_3 = {
      z = Pixel: z = fn1(1/fn2(z+p1)+p1)
      |z| <= p2
   }

   ULI_4 = {
      z = Pixel: z = fn1(1/(z+p1))*fn2(z+p1)
      |z| <= p2
   }

   ULI_5 = {
      z = Pixel, c = fn1(pixel):
      z = fn2(1/(z+c))*fn3(z+c)
      |z| <= p1
   }

   ULI_6 = {
      z = Pixel: z = fn1(p1+z)*fn2(p2-z)
      |z| <= p2+16
   }


#: 73884 S4/Fractal Sources  [GRAPHDEV]
    06-Jul-94  16:33:00
Sb: #73847-#Another Newton - reprise
Fm: Timothy Wegner 71320,675
To: Jon Horner 100112,1700 (X)

>Any joy with the Newton query I sent you on 26 Jun?<g>.

Original post:

>>I have access to a computer graphics magazine called Computers and
>>Graphics,in it Clifford Pickover edits a section called Chaos and
>>Graphics.  One of the articles discusses elliptic functions such as :
>>z = sqr(z^3 + c*z^2 +1).

I assume this means f(z) = sqr(z^3 + cz^2 +1)

>>Now I wrote the Newton's method formula for
>>this equation but must have done something wrong.  Do you know what the
>>derivative of this equation would be?

Derivative is 2*(z^3 + cz^2 +1)*(3z^2 + 2cz)

Oops! first I didn't read carefully and thought "sqr" was "sqrt". Since I
did this, might as well give the result to posterity. Enjoy! As payment,
send me some PARS you get from these. Hey - sign up for a calculus course
and you can do these yourself<g!>

Newt_ellipt_oops { ; Tim Wegner - use float=yes and periodicity=0
   ; fractal generated by Newton formula  (z^3 + c*z^2 +1)^.5
   ; try p1 = 1 and p2 = .1
   ; if p2 is small (say .001), converges very slowly so need large maxit
   ; another "tim's error" - mistook sqr for sqrt (see next)
   z = pixel, z2 = z*z, z3 = z*z2:
   num = (z3 + p1*z2 + 1)^.5      ; f(z)
   denom = (1.5*z2 + p1*z)/num    ; f'(z)
   z = z - (num/denom)            ; z - f(z)/f'(z)
   z2 = z*z
   z3 = z*z2,
   p2 <= |z3 + p1*z2 + 1|         ; no need for sqrt because sqrt(z)==0 iff z==0
  }

I'm using z = z - f/f' below but you might not recognize it - some terms
cancelled. This is the right formula - I think!

Newton_elliptic { ; Tim Wegner - use float=yes and periodicity=0
   ; fractal generated by Newton formula f(z) = (z^3 + c*z^2 +1)^2
   ; try p1 = 1 and p2 = .0001
   z = pixel, z2 = z*z, z3 = z*z2:
   z = z - (z3 + p1*z2 + 1)/(6*z2 + 4*p1*z)      ; z - f(z)/f'(z)
   z2 = z*z
   z3 = z*z2,
   p2 <= |z3 + p1*z2 + 1|  ; no need for sqr because sqr(z)==0 iff z==0
  }

Tim

There is 1 Reply.

comment {
  This Fractint formula file is by Bradley Beacham, (c) May 1994, and may
  not be used for commercial purposes without my consent.  I encourage you
  to copy and distribute it, but only if it is unaltered.  If you make
  changes to any of these formulas, please put your changes in a new
  '.FRM' file.  If you want to merge one or more of these formulas into
  another .FRM file, please leave the formula and its credits intact.

  The following formulas are mutations of other formulas by other people.
  As with genetic mutations, changes are not necessarily improvements.
  I DID have fun, though...

  A big thank-you to Chuck Ebbert (CIS 76306,1226) for posting BUILTN.FRM,
  which showed me a better way to set up default values for numeric
  parameters.  If you're trying to teach yourself how to write formulas, I
  would highly recommend that you get BUILTN.FRM and study it.

  The parameter file FUBAR.PAR has many examples of the images I have
  created with these formulas.
  
  I welcome any comments.  Reach me at:

    CIS: 74223,2745    Internet: 74223,2745@compuserve.com

    U.S. Mail: Bradley Beacham
               1343 S. Tyler
               Salt Lake City, Utah  84105
               U.S.A.
  
  NOTE: Most of these formulas REQUIRE floating-point math.  Sorry.

}


Larry { ; Mutation of 'Michaelbrot' and 'Element'
  ; Mutated by Bradley Beacham [74223,2745]
  ; Original formulas by Michael Theroux [71673,2767]
  ; For 'Michaelbrot', set FN1 & FN2 =IDENT and P1 & P2 = default
  ; For 'Element', set FN1=IDENT & FN2=SQR and P1 & P2 = default
  ; p1 = Parameter (default 0.5,0), real(p2) = Bailout (default 4)
  z = pixel
  ; The next line sets c=default if p1=0, else c=p1
  c = ((0.5,0) * (|p1|<=0) + p1)
  ; The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2)):
    z = fn1(fn2(z*z)) + c
    |z| <= test
}

Curly { ; Mutation of 'Natura'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Michael Theroux [71673,2767]
  ; For 'Natura', set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 = Parameter (default 0.5,0), real(p2) = Bailout (default 4)
  z = pixel
  ; The next line sets c=default if p1=0, else c=p1
  c = ((0.5,0) * (|p1|<=0) + p1)
  ; The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2)):
    z = fn1(fn2(z*z*z)) + c
    |z| <= test
}

Moe { ; Mutation of 'Zexpe'.  Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Lee Skinner [75450,3631]
  ; For 'Zexpe', set FN1 & FN2 =IDENT and P1 = default
  ; real(p1) = Bailout (default 100)
  s = exp(1.,0.), z = pixel, c = fn1(pixel)
  ; The next line sets test=100 if real(p1)<=0, else test=real(p1)
  test = (100 * (real(p1)<=0) + real(p1) * (0<p1)):
    z = fn2(z)^s + c
    |z| <= test
}

Harpo { ; Mutation of 'Gopalsamy3'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Ron Barnett [70153,1233]
  ; For 'Gopalsamy3' with Ron's suggested parameters,
  ; set FN1 & FN2 = IDENT and P1 & P2 = default
  ; p1 = Parameter (default 1.099,0), real(p2) = Bailout (default 4)
  z = pixel
  ; The next line sets c=default if p1=0, else c=p1
  c = ((1.099,0) * (|p1|<=0) + p1)
  ; The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2)):
    x = real(z), y = imag(z)
    x1 = fn1(3*x*y*y - x*x*x) + c
    y = fn2(y*y*y - 3*x*x*y)
    z = x1 + flip(y)
    |z| <= test
}

Groucho { ; Mutation of 'Fish2'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Dave Oliver via Tim Wegner
  ; For 'Fish2', set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 = Parameter (default 1,0), real(p2) = Bailout (default 4)
  z = c = pixel
  ; The next line sets k=default if p1=0, else k=p1
  k = ((1,0) * (|p1|<=0) + p1)
  ; The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2)):
    z1 = c^(fn1(z)-k)
    z = fn2(((c*z1)-k)*(z1))
    |z| <= test
}

Chico { ; Mutation of 'M-SetInNewton'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Jon Horner [100112,1700]
  ; For 'M-SetInNewton' set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 & p2 = Parameters (default 3,0 and 0,0)
  z = 0,  c = fn1(pixel),  cminusone = c-1
  ; The next line sets k=default if p1=0, else k=p1
  k = (3 * (|p1|<=0) + p1)
  kminusone = k - 1:
    oldz = z
    nm = k*c-kminusone*z*cminusone
    dn = k*(k*z*z+cminusone)
    z = fn2(nm/dn)+kminusone*z/k + p2
    0.01 <= |(z-oldz)|
}

Zeppo { ; Mutation of 'Liar4'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Chuck Ebbert [76306,1226]
  ; For 'Liar4' set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 & p2 = Parameters (default 1,0 and 0,0)
  z = pixel
  ; The next line sets p=default if p1=0, else p=p1
  p = (1 * (|p1|<=0) + p1):
    z =fn1(1-abs(imag(z)*p-real(z)))+flip(fn2(1-abs(1-real(z)-imag(z))))-p2
    |z| <= 1
}

Primal {; Rollo Silver
  ; Select p1 such that 0. <= p1 <= 1.
  z = c = Pixel, t = real(p1), test = (p2+10)*(p2+10):
   zsq = z*z
   zcu = zsq*z
   z = (1.-t)*zsq + t*zcu + c
   |z| <= test
  }

;Music for the eyes
;the premise is "layering" themes, then varying them
;start with all the same function (i.e. cotanh,etc) then change one at a time
;I welcome any and all coments
;look for "vp001.par"
;Verne Pence [75271,3111]

FUGUE_01{;11/29/94
 z=pixel,x=1,y=1,a=p1,b=p2:
 z=fn1(z)+a*b
 |z|<=4
 a=fn1(x*z)
 |a|<=8
 b=fn1(y*z)
 |b|<=16
 }

FUGUE_02{;11/29/94
 z=pixel,a=p1,b=p2:
 z=fn1(z)+a*b
 |z|<=4
 a=fn2(z)
 |a|<=8
 b=fn3(z)
 |b|<=16
 }

FUGUE_03{;11/29/94
 z=pixel,a=p1,b=p2:
 z=fn1(z)*(a+b)
 |z|<=4
 a=fn2(z)
 |a|<=8
 b=fn3(z)
 |b|<=16
 }

FUGUE_04{;11/29/94
 z=pixel,c=1,a=p1,b=p2:
 z=fn1(z)*(a+b+c)
 |z|<=4
 a=fn2(z)
 |a|<=8
 b=fn3(z)
 |b|<=16
 c=fn4(z)
 |c|<=32
 }

FUGUE_05{;11/29/94
 z=pixel,c=1,a=p1,b=p2:
 z=fn1(z)+(a*b*c)
 |z|<=4
 a=fn2(z)
 |a|<=8
 b=fn3(z)
 |b|<=16
 c=fn4(z)
 |c|<=32
 }  

FUGUE_06{;11/29/94
 z=pixel,c=1,a=p1,b=p2:
 z=fn1(z)+(a*b*c)
 |z|<=4
 a=fn2(z)+a
 |a|<=8
 b=fn3(z)+b
 |b|<=16
 c=fn4(z)+c
 |c|<=32
 }

FUGUE_07{;11/29/94
 z=pixel,c=1,a=p1,b=p2:
 z=fn1(z)+(a*b*c)
 |z|<=4
 a=fn2(z)+a
 |a|<=8
 b=fn3(z)+b
 |b|<=16
 c=fn4(z)+c
 |c|<=32
 z=fn1(z)*(a*b*c)
 |z|<=64
 a=fn2(z)*a
 |a|<=128
 b=fn3(z)*b
 |b|<=256
 c=fn4(z)*c
 |c|<=512
 }

FUGUE_08{;11/29/94
 z=pixel,c=1,a=p1,b=p2:
 z=fn1(z)*(a*b*c)
 |z|<=4
 a=fn2(z)*a
 |z|<=8
 b=fn3(z)*b
 |z|<=16
 c=fn4(z)*c
 |z|<=32
 z=fn1(z)*(a*b*c)
 |z|<=64
 a=fn2(z)*a
 |z|<=128
 b=fn3(z)*b
 |z|<=256
 c=fn4(z)*c
 |z|<=512
 }

FUGUE_09{;11/29/94
 z=pixel,c=1,a=p1,b=p2:
 z=fn1(z)+(a*b*c)
 |z|<=4
 a=fn2(z)+a
 |z|<=8
 b=fn3(z)+b
 |z|<=16
 c=fn4(z)+c
 |z|<=32
 z=fn1(z)+(a*b*c)
 |z|<=64
 a=fn2(z)+a
 |z|<=128
 b=fn3(z)+b
 |z|<=256
 c=fn4(z)+c
 |z|<=512
 }
FUGUE_10{;11/29/94
 z=pixel,c=1,a=p1,b=p2:
 z=fn1(z)+(a*b*c)
 |z|<=4
 a=fn2(z)+a
 |z|<=8
 b=fn3(z)+b
 |z|<=16
 c=fn4(z)+c
 |z|<=32
 z=fn1(z)*(a*b*c)
 |z|<=64
 a=fn2(z)*a
 |z|<=128
 b=fn3(z)*b
 |z|<=256
 c=fn4(z)*c
 |z|<=512
 }
FUGUE_11{;12/01/94
 z=pixel,c=1,a=p1,b=p2:
 z=fn1(z)+(a*b*c)
 |z|<=4
 a=fn2(z)+a
 |z|<=8
 b=fn3(z)+b
 |z|<=16
 c=fn4(z)+c
 |z|<=32
 z=fn1(z)+(a*b*c)/2
 |z|<=64
 a=fn2(z)+a/2
 |z|<=128
 b=fn3(z)+b/2
 |z|<=256
 c=fn4(z)+c/2
 |z|<=512
 }
 
CANON1{;12/2/94 a,b,c are modified by fn(), z value is bailout
 z=pixel,c=1,a=p1,b=p2:
 z=fn1(z)+(a*b*c)
 |z|<=4
 a=(fn2(z)+a)/2
 |z|<=8
 b=(fn3(z)+b)/4
 |z|<=16
 c=(fn4(z)+c)/8
 |z|<=32
 }

CANON2{;12/2/94 z is modified by fn()
 z=pixel,c=1,a=p1,b=p2:
 z=fn1(z)+(a*b*c)
 |z|<=4
 z=(fn2(z)+a)/2
 |z|<=8
 z=(fn3(z)+b)/4
 |z|<=16
 z=(fn4(z)+c)/8
 |z|<=32
 }

CANON3{;12/2/94
 z=pixel,c=1,a=p1,b=p2:
 z=fn1(z)+(a*b*c)
 |z|<=4
 a=(fn2(z)*a)/2
 |z|<=8
 b=(fn3(z)*b)/4
 |z|<=16
 c=(fn4(z)*c)/8
 |z|<=32
 }

CANON4{;12/3/94
 z=pixel,c=z^2,a=p1,b=p2:
 z=fn1(z)+(a*b*c)
 |z|<=4
 a=(fn2(z)*a)/2
 |z|<=8
 b=(fn3(z)*b)/4
 |z|<=16
 c=(fn4(z)*c)/8
 |z|<=32
 }

CANON5{;12/3/94
 z=pixel,c=z^2,a=p1,b=p2:
 z=fn1(z)+(a*b*c)
 |z|<=4
 z=(fn2(z)*a)/2
 |z|<=8
 z=(fn3(z)*b)/4
 |z|<=16
 z=(fn4(z)*c)/8
 |z|<=32
 a=z/2
 b=z/4
 c=z/8
 }

CANON6{;12/3/94
 z=pixel,c=z^2,a=p1,b=p2:
 z=fn1(z)-(a*b*c)
 |z|<=4
 a=(fn2(z)-a)/2
 |z|<=8
 b=(fn3(z)-b)/4
 |z|<=16
 c=(fn4(z)-c)/8
 |z|<=32
 }

