
#: 61642 S4/Fractal Sources  [GRAPHDEV]
    18-Apr-94  12:01:30
Sb: Fish
Fm: Timothy Wegner 71320,675
To: ALL

Here's a fractal that looks like a fish. I've listed the formula in
Fractint's FRM format that was just sent to me from the UK. I've added
comments for non-fractint folks who want to code this up themselves. You'll
need a complex number exponent function to do it.

The formula doesn't really have exact xaxis symmetry, but it looks
reasonably similar with symmetry turned off. I guess if this makes it into
FRACTINT.FRM the symmetry could be removed -- symmetry=xaxis could be in
the Fish PAR entry. IMHO symmetry should be used in a FRM entry only if the
formula is really symmetrical.

To see the fish, use corners=-4/4/-3/3.
The second version is faster because one of the exponentiations is avoided.

Fish (xaxis) {; Dave Oliver   >INTERNET:D.E.Oliver@soton.ac.uk
   z=pixel:                       ; initialize z to coordinates at pixel
   z=((pixel^z)-1)*(pixel^(z-1))  ; the "^" means complex exponentiation
   |z|<=4                         ; escape radius is 2 (|z| is sqr(x)+sqr(y))
}

Fish2 (xaxis) {; Dave Oliver   >INTERNET:D.E.Oliver@soton.ac.uk
               ; (sped up 20% by T. Wegner)
   z=pixel:
   z1 = pixel^(z-1)
   z=((pixel*z1)-1)*(z1)
   |z|<=4
}

