
;;  #: 15473 S4/Fractal Sources
;;      26-Feb-93 16:42:16
;;  Sb: #15349-#Good News/Bad News
;;  Fm: Chuck Ebbert 76306,1226
;;  To: Jon Horner 100112,1700 (X)
;;
;;  Jon, try these.  I learned a lot when I figured out the magnet2m
;;  formula:

Tetrate(XAXIS) { ; duplicate of built-in type.
  ; p1=initial perturbation of z(0), p2 changes bailout from 4.
  z = pixel + p1, b = real(p2) + 4:
   z = pixel ^ z;
    |z| <= b;
 }

FnxZpZ  {
  ; Duplicate of built-in 'fn*z+z' type.
  ; p1, p2 same as built-in
  z = pixel:
   z = (p1 * fn1(z) + p2 ) * z,
    |z| <= 64
 }

FnZpFnPix {
  ; Duplicate of built-in type 'fn(z)+fn(pix).'
  ; P1 = perturbation of z(0), p2 = multiplication factor.
  z = pixel + p1, c = p2 * fn2(pixel):
   z = fn1(z) + c,
    |z| <= 64
 }

LambdaFnOrFn { ; Chuck Ebbert
   ; Duplicate of built-in 'lambda(fn||fn).'
   ; P1 = lambda, real(p2) changes shift value from default of 1,
   ;  imag(p2) changes bailout from default of 64.
  z = pixel, modz = |z|, b = imag(p2) + 64, t = real(p2) + 1:
   z = ( fn1(z) * (modz<t) + fn2(z) * (real(t)<=modz ) ) * p1,
   modz = |z|,
    modz <= b
 }

Magnet1M(XAXIS) {
  ; Duplicate of built-in type.
  ; P1 = initial perturbation of z(0).
  z = p1, cm1 = pixel - 1, cm2 = cm1 - 1:
   z = sqr( (z*z+cm1 ) / (z+z+cm2 ) );
    |z-1| > .000030517578 && |z| <= 100;
 }

Magnet2M(XAXIS) {
  ; Duplicate of built-in type.
  ; P1 = initial perturbation of z(0).
  z=p1,c1=pixel-1,c1x3=c1*3,c2x3=c1x3-3,c1c2=c1*c1-c1,c1c2p1=c1c2+1:
   z=sqr( ( (z*z+c1x3 )*z+c1c2 ) / ( (z*3+c2x3 )*z+c1c2p1 ) );
    |z-1| > .000030517578 && |z| <= 100;
 }

Gen_01 {; generalized type
  ; p1=p2=0, fn1=fn2=fn3=ident, fn4=sqr gives Mandelbrot
  z=pixel, t=p1+4, q = (p2+1) * fn1(pixel):
   z=fn2(fn3(fn4(z))) + q,
    |z|<=t
  }

